/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.configurations.PathEnvironmentVariableUtil;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresReadLockAbsence;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.DetectedShellInfo;
import org.jetbrains.plugins.terminal.runner.LocalTerminalStartCommandBuilder;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0007J\u000e\u0010\n\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002J\u000e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002J\u000e\u0010\f\u001a\b\u0012\u0004\u0012\u00020\t0\u0005H\u0002J(\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u00062\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalShellsDetector;", "", "<init>", "()V", "UNIX_BINARIES_DIRECTORIES", "", "", "UNIX_SHELL_NAMES", "detectShells", "Lorg/jetbrains/plugins/terminal/DetectedShellInfo;", "detectUnixShells", "detectWindowsShells", "detectWsl", "createShellInfo", "shellName", "shellPath", "options", "intellij.terminal"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nTerminalShellsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TerminalShellsDetector.kt\norg/jetbrains/plugins/terminal/TerminalShellsDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,130:1\n1586#2:131\n1661#2,3:132\n*S KotlinDebug\n*F\n+ 1 TerminalShellsDetector.kt\norg/jetbrains/plugins/terminal/TerminalShellsDetector\n*L\n106#1:131\n106#1:132,3\n*E\n"})
public final class TerminalShellsDetector {
    @NotNull
    public static final TerminalShellsDetector INSTANCE = new TerminalShellsDetector();
    @NotNull
    private static final List<String> UNIX_BINARIES_DIRECTORIES;
    @NotNull
    private static final List<String> UNIX_SHELL_NAMES;

    private TerminalShellsDetector() {
    }

    @JvmStatic
    @RequiresBackgroundThread
    @RequiresReadLockAbsence
    @NotNull
    public static final List<DetectedShellInfo> detectShells() {
        return SystemInfo.isUnix ? INSTANCE.detectUnixShells() : (SystemInfo.isWindows ? CollectionsKt.plus((Collection)INSTANCE.detectWindowsShells(), (Iterable)INSTANCE.detectWsl()) : CollectionsKt.emptyList());
    }

    private final List<DetectedShellInfo> detectUnixShells() {
        List shells = new ArrayList();
        for (String shellName : UNIX_SHELL_NAMES) {
            for (String parentPath : UNIX_BINARIES_DIRECTORIES) {
                String[] stringArray = new String[]{shellName};
                Path shellPath2 = Path.of(parentPath, stringArray);
                Intrinsics.checkNotNull((Object)shellPath2);
                LinkOption[] linkOptionArray = new LinkOption[]{};
                if (!Files.exists(shellPath2, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) continue;
                shells.add(TerminalShellsDetector.createShellInfo$default(this, shellName, ((Object)shellPath2.toAbsolutePath()).toString(), null, 4, null));
            }
        }
        return shells;
    }

    private final List<DetectedShellInfo> detectWindowsShells() {
        String cmderRoot;
        File gitBash;
        File pwsh;
        File cmd;
        List shells = new ArrayList();
        String systemRoot = EnvironmentUtil.getValue((String)"SystemRoot");
        String programFiles = EnvironmentUtil.getValue((String)"ProgramFiles");
        String localAppData = EnvironmentUtil.getValue((String)"LocalAppData");
        File powershell = PathEnvironmentVariableUtil.findInPath((String)"powershell.exe");
        if (powershell != null) {
            String string = powershell.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            if (StringsKt.startsWith((String)string, (String)(systemRoot + "\\System32\\WindowsPowerShell\\"), (boolean)true)) {
                String string2 = powershell.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAbsolutePath(...)");
                shells.add(TerminalShellsDetector.createShellInfo$default(this, "Windows PowerShell", string2, null, 4, null));
            }
        }
        if ((cmd = PathEnvironmentVariableUtil.findInPath((String)"cmd.exe")) != null) {
            String string = cmd.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            if (StringsKt.startsWith((String)string, (String)(systemRoot + "\\System32\\"), (boolean)true)) {
                String string3 = cmd.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getAbsolutePath(...)");
                shells.add(TerminalShellsDetector.createShellInfo$default(this, "Command Prompt", string3, null, 4, null));
            }
        }
        if ((pwsh = PathEnvironmentVariableUtil.findInPath((String)"pwsh.exe")) != null) {
            String string = pwsh.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            if (StringsKt.startsWith((String)string, (String)(programFiles + "\\PowerShell\\"), (boolean)true)) {
                String string4 = pwsh.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getAbsolutePath(...)");
                shells.add(TerminalShellsDetector.createShellInfo$default(this, "PowerShell", string4, null, 4, null));
            }
        }
        File gitBashGlobal = new File(programFiles + "\\Git\\bin\\bash.exe");
        File gitBashLocal = new File(localAppData + "\\Programs\\Git\\bin\\bash.exe");
        File file = gitBashLocal.isFile() ? gitBashLocal : (gitBash = gitBashGlobal.isFile() ? gitBashGlobal : null);
        if (gitBash != null) {
            String string = gitBash.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            shells.add(TerminalShellsDetector.createShellInfo$default(this, "Git Bash", string, null, 4, null));
        }
        if ((cmderRoot = EnvironmentUtil.getValue((String)"CMDER_ROOT")) != null && cmd != null) {
            File cmderInitBat;
            String string = cmd.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            if (StringsKt.startsWith((String)string, (String)(systemRoot + "\\System32\\"), (boolean)true) && (cmderInitBat = new File(cmderRoot, "vendor\\init.bat")).isFile()) {
                String string5 = cmd.getAbsolutePath();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"getAbsolutePath(...)");
                Object[] objectArray = new String[]{"/k", cmderInitBat.getAbsolutePath()};
                shells.add(this.createShellInfo("Cmder", string5, CollectionsKt.listOf((Object[])objectArray)));
            }
        }
        return shells;
    }

    /*
     * WARNING - void declaration
     */
    private final List<DetectedShellInfo> detectWsl() {
        if (WSLDistribution.findWslExe() != null) {
            void $this$mapTo$iv$iv;
            List list = WslDistributionManager.getInstance().getInstalledDistributions();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstalledDistributions(...)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                WSLDistribution wSLDistribution = (WSLDistribution)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String string = it.getMsId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"<get-msId>(...)");
                Object[] objectArray = new String[2];
                objectArray[0] = "-d";
                Intrinsics.checkNotNullExpressionValue((Object)it.getMsId(), (String)"<get-msId>(...)");
                collection.add(INSTANCE.createShellInfo(string, "wsl.exe", CollectionsKt.listOf((Object[])objectArray)));
            }
            return (List)destination$iv$iv;
        }
        return CollectionsKt.emptyList();
    }

    private final DetectedShellInfo createShellInfo(String shellName, String shellPath2, List<String> options) {
        List<String> list = LocalTerminalStartCommandBuilder.convertShellPathToCommand(shellPath2);
        Intrinsics.checkNotNullExpressionValue(list, (String)"convertShellPathToCommand(...)");
        List<String> shellCommand = list;
        List addedOptions = CollectionsKt.drop((Iterable)shellCommand, (int)1);
        List adjustedOptions = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)addedOptions, (Iterable)options));
        return new DetectedShellInfo(shellName, shellPath2, adjustedOptions);
    }

    static /* synthetic */ DetectedShellInfo createShellInfo$default(TerminalShellsDetector terminalShellsDetector, String string, String string2, List list, int n, Object object) {
        if ((n & 4) != 0) {
            list = CollectionsKt.emptyList();
        }
        return terminalShellsDetector.createShellInfo(string, string2, list);
    }

    static {
        Object[] objectArray = new String[]{"/bin", "/usr/bin", "/usr/local/bin", "/opt/homebrew/bin"};
        UNIX_BINARIES_DIRECTORIES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new String[]{"bash", "zsh", "fish", "pwsh"};
        UNIX_SHELL_NAMES = CollectionsKt.listOf((Object[])objectArray);
    }
}

