/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jupyter.execution.kernel;

import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.jupyter.core.jupyter.connections.execution.core.JupyterKernelId;
import com.intellij.jupyter.execution.kernel.KernelOsProcessHandler;
import com.intellij.jupyter.execution.kernel.KernelStateMachine;
import com.intellij.jupyter.execution.listeners.KernelProcessListener;
import com.intellij.jupyter.execution.listeners.events.KernelInternalErrorEvent;
import com.intellij.jupyter.execution.listeners.events.KernelInternalErrorEventType;
import com.intellij.jupyter.execution.listeners.events.KernelProcessEventImpl;
import com.intellij.jupyter.execution.util.LoggingKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.util.EventDispatcher;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001c\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\n\u0010\u0013\u001a\u0006\u0012\u0002\b\u00030\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0017H\u0016J\u0010\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0019\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001b"}, d2={"Lcom/intellij/jupyter/execution/kernel/KernelOsProcessMonitor;", "Lcom/intellij/execution/process/ProcessListener;", "handler", "Lcom/intellij/jupyter/execution/kernel/KernelOsProcessHandler;", "<init>", "(Lcom/intellij/jupyter/execution/kernel/KernelOsProcessHandler;)V", "stateMachine", "Lcom/intellij/jupyter/execution/kernel/KernelStateMachine;", "getStateMachine", "()Lcom/intellij/jupyter/execution/kernel/KernelStateMachine;", "eventDispatcher", "Lcom/intellij/util/EventDispatcher;", "Lcom/intellij/jupyter/execution/listeners/KernelProcessListener;", "getEventDispatcher", "()Lcom/intellij/util/EventDispatcher;", "onTextAvailable", "", "event", "Lcom/intellij/execution/process/ProcessEvent;", "outputType", "Lcom/intellij/openapi/util/Key;", "processWillTerminate", "willBeDestroyed", "", "processTerminated", "reportOutOfSyncError", "Companion", "intellij.jupyter.execution"})
@SourceDebugExtension(value={"SMAP\nKernelOsProcessMonitor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 KernelOsProcessMonitor.kt\ncom/intellij/jupyter/execution/kernel/KernelOsProcessMonitor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,54:1\n23#2:55\n23#2:56\n23#2:57\n23#2:58\n*S KotlinDebug\n*F\n+ 1 KernelOsProcessMonitor.kt\ncom/intellij/jupyter/execution/kernel/KernelOsProcessMonitor\n*L\n20#1:55\n30#1:56\n37#1:57\n38#1:58\n*E\n"})
public final class KernelOsProcessMonitor
implements ProcessListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final KernelOsProcessHandler handler;
    @NotNull
    private static final String OUT_OF_SYNC_ERROR_TEMPLATE = "ValueError: DELIM not in msg_list";

    public KernelOsProcessMonitor(@NotNull KernelOsProcessHandler handler) {
        Intrinsics.checkNotNullParameter((Object)((Object)handler), (String)"handler");
        this.handler = handler;
    }

    private final KernelStateMachine getStateMachine() {
        return this.handler.getStateMachine();
    }

    private final EventDispatcher<KernelProcessListener> getEventDispatcher() {
        return this.handler.getEventDispatcher();
    }

    public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key<?> outputType) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Intrinsics.checkNotNullParameter(outputType, (String)"outputType");
        String string = event.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        char[] cArray = new char[]{'\r', '\n'};
        String line = StringsKt.trimStart((String)((Object)StringsKt.trimEnd((CharSequence)string)).toString(), (char[])cArray);
        KernelOsProcessMonitor $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(KernelOsProcessMonitor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug(line);
        if (StringsKt.contains$default((CharSequence)line, (CharSequence)OUT_OF_SYNC_ERROR_TEMPLATE, (boolean)false, (int)2, null)) {
            this.reportOutOfSyncError(event);
        }
    }

    public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.getStateMachine().terminating()) {
            ((KernelProcessListener)this.getEventDispatcher().getMulticaster()).kernelWillTerminate(new KernelProcessEventImpl(event));
            KernelOsProcessMonitor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(KernelOsProcessMonitor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Kernel process is going to be terminated (will " + (willBeDestroyed ? "" : "not ") + "be destroyed): " + event);
        }
    }

    public void processTerminated(@NotNull ProcessEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        if (this.getStateMachine().terminated()) {
            ((KernelProcessListener)this.getEventDispatcher().getMulticaster()).kernelTerminated(new KernelProcessEventImpl(event));
            KernelOsProcessMonitor $this$thisLogger$iv = this;
            boolean $i$f$thisLogger = false;
            Logger logger = Logger.getInstance(KernelOsProcessMonitor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.info("Kernel process terminated with code " + event.getExitCode() + " (" + event.getText() + ")");
            $this$thisLogger$iv = this;
            $i$f$thisLogger = false;
            Logger logger2 = Logger.getInstance(KernelOsProcessMonitor.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            LoggingKt.warnInTests(logger2, (Function0<String>)((Function0)() -> KernelOsProcessMonitor.processTerminated$lambda$0(this)));
        }
        this.getEventDispatcher().getListeners().clear();
    }

    private final void reportOutOfSyncError(ProcessEvent event) {
        KernelProcessListener kernelProcessListener = (KernelProcessListener)this.getEventDispatcher().getMulticaster();
        ProcessHandler processHandler = event.getProcessHandler();
        Intrinsics.checkNotNull((Object)processHandler, (String)"null cannot be cast to non-null type com.intellij.jupyter.execution.kernel.KernelOsProcessHandler");
        kernelProcessListener.kernelErrorOccurred(new KernelInternalErrorEvent(((KernelOsProcessHandler)processHandler).getRunnableHandler(), KernelInternalErrorEventType.OUT_OF_SYNC));
    }

    private static final String processTerminated$lambda$0(KernelOsProcessMonitor this$0) {
        return "Destroyed Notebook kernel " + JupyterKernelId.toString-impl((String)this$0.handler.getRunnableHandler().getKernelId-qftoVCA());
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/intellij/jupyter/execution/kernel/KernelOsProcessMonitor$Companion;", "", "<init>", "()V", "OUT_OF_SYNC_ERROR_TEMPLATE", "", "intellij.jupyter.execution"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

