/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.config;

import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.source.PsiPlainTextFileImpl;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u0012\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/idea/maven/config/MavenConfigAnnotator;", "Lcom/intellij/lang/annotation/Annotator;", "<init>", "()V", "annotate", "", "element", "Lcom/intellij/psi/PsiElement;", "holder", "Lcom/intellij/lang/annotation/AnnotationHolder;", "isConfigFile", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenConfigAnnotator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenConfigAnnotator.kt\norg/jetbrains/idea/maven/config/MavenConfigAnnotator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,33:1\n296#2,2:34\n*S KotlinDebug\n*F\n+ 1 MavenConfigAnnotator.kt\norg/jetbrains/idea/maven/config/MavenConfigAnnotator\n*L\n23#1:34,2\n*E\n"})
public final class MavenConfigAnnotator
implements Annotator {
    public void annotate(@NotNull PsiElement element, @NotNull AnnotationHolder holder2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)holder2, (String)"holder");
        if (element instanceof PsiPlainTextFileImpl) {
            Object v2;
            block6: {
                VirtualFile elementFile = ((PsiPlainTextFileImpl)element).getContainingFile().getVirtualFile();
                if (!this.isConfigFile(elementFile)) {
                    return;
                }
                MavenProjectsManager manager = MavenProjectsManager.getInstance(((PsiPlainTextFileImpl)element).getProject());
                if (!manager.isMavenizedProject()) {
                    return;
                }
                List<MavenProject> list = manager.getRootProjects();
                Intrinsics.checkNotNullExpressionValue(list, (String)"getRootProjects(...)");
                Iterable $this$firstOrNull$iv = list;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    MavenProject it = (MavenProject)element$iv;
                    boolean bl = false;
                    VirtualFile virtualFile = elementFile.getParent();
                    if (!Intrinsics.areEqual((Object)it.getDirectoryFile(), (Object)(virtualFile != null ? virtualFile.getParent() : null))) continue;
                    v2 = element$iv;
                    break block6;
                }
                v2 = null;
            }
            MavenProject mavenProject = v2;
            if (mavenProject == null) {
                return;
            }
            MavenProject mavenProject2 = mavenProject;
            String string = mavenProject2.getConfigFileError();
            if (string == null) {
                return;
            }
            String error = string;
            holder2.newAnnotation(HighlightSeverity.ERROR, error).create();
        }
    }

    private final boolean isConfigFile(VirtualFile file2) {
        VirtualFile virtualFile = file2;
        if (virtualFile == null || (virtualFile = virtualFile.getParent()) == null) {
            return false;
        }
        VirtualFile parent = virtualFile;
        return Intrinsics.areEqual((Object)file2.getName(), (Object)"maven.config") && Intrinsics.areEqual((Object)parent.getName(), (Object)".mvn");
    }
}

