/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.platform.workspace.jps.entities.ModuleEntity;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Consumer;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.Function;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jdom.Element;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorConfiguratorKt;
import org.jetbrains.idea.maven.importing.MavenAnnotationProcessorConfiguratorUtil;
import org.jetbrains.idea.maven.importing.MavenApplicableConfigurator;
import org.jetbrains.idea.maven.importing.MavenImportUtil;
import org.jetbrains.idea.maven.importing.MavenModuleType;
import org.jetbrains.idea.maven.importing.MavenWorkspaceConfigurator;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenArtifactInfo;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.utils.MavenJDOMUtil;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;
import org.jetbrains.jps.model.java.impl.compiler.ProcessorConfigProfileImpl;
import org.jetbrains.jps.util.JpsPathUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001c\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0010!\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0014\b\u0007\u0018\u00002\u00020\u00012\u00020\u0002:\u0001<B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016JL\u0010\r\u001a\u00020\n2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\b0\u000f2\u001a\u0010\u0010\u001a\u0016\u0012\u0004\u0012\u00020\u0012\u0012\f\u0012\n\u0012\u0004\u0012\u00020\u0014\u0018\u00010\u00130\u00112\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00170\u0016H\u0002J\u0010\u0010\u0018\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0019H\u0016J<\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\f\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020 0\u000f2\u0014\u0010!\u001a\u0010\u0012\u0004\u0012\u00020\u0014\u0012\u0006\u0012\u0004\u0018\u00010\"0\u0011H\u0002J<\u0010#\u001a\u0010\u0012\u0004\u0012\u00020%\u0012\u0004\u0012\u00020\u0006\u0018\u00010$2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010&\u001a\u00020\"2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u00132\u0006\u0010(\u001a\u00020)H\u0002JB\u0010*\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\"2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\u0006\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u00062\u0006\u0010-\u001a\u00020\u00142\u0006\u0010.\u001a\u00020\u0014H\u0002J\u0010\u0010/\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\"H\u0002J\u001e\u00100\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\"0\u0013H\u0002J2\u00101\u001a\u00020\n2\u0006\u00102\u001a\u00020\b2\u0006\u0010(\u001a\u00020)2\b\u00103\u001a\u0004\u0018\u00010%2\u0006\u00104\u001a\u00020\u00062\u0006\u0010&\u001a\u00020\"H\u0002J\u001c\u00105\u001a\u00020\u00062\b\u00106\u001a\u0004\u0018\u00010%2\b\u00107\u001a\u0004\u0018\u00010%H\u0002J \u00108\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u00109\u001a\u00020\u00062\u0006\u0010:\u001a\u00020\u0014H\u0002J\u0010\u0010;\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006="}, d2={"Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenApplicableConfigurator;", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator;", "<init>", "()V", "isApplicable", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "beforeModelApplied", "", "context", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$MutableModelContext;", "collectProcessorModuleNames", "projects", "", "moduleNameByProjectId", "Ljava/util/function/Function;", "Lorg/jetbrains/idea/maven/model/MavenId;", "", "", "result", "", "", "afterModelApplied", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$AppliedModelContext;", "configureProfiles", "project", "Lcom/intellij/openapi/project/Project;", "tree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "projectsWithModules", "Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator$MavenProjectWithProcessorModules;", "moduleByName", "Lcom/intellij/openapi/module/Module;", "createOrUpdateProfile", "Lcom/intellij/openapi/util/Pair;", "Lorg/jetbrains/jps/model/java/compiler/ProcessorConfigProfile;", "module", "processorModules", "compilerConfiguration", "Lcom/intellij/compiler/CompilerConfigurationImpl;", "getModuleProfile", "moduleProfileName", "outputRelativeToContentRoot", "annotationProcessorDirectory", "testAnnotationProcessorDirectory", "isLevelMoreThan6", "getAnnotationProcessorPath", "cleanAndMergeModuleProfiles", "rootProject", "moduleProfile", "isDefault", "isSimilarProfiles", "profile1", "profile2", "getAnnotationsDirectoryRelativeTo", "isTest", "relativeTo", "shouldEnableAnnotationProcessors", "MavenProjectWithProcessorModules", "intellij.maven"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nMavenAnnotationProcessorConfigurator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenAnnotationProcessorConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,438:1\n1642#2,10:439\n1915#2:449\n1916#2:451\n1652#2:452\n1642#2,10:453\n1915#2:463\n1916#2:465\n1652#2:466\n1915#2,2:467\n1642#2,10:469\n1915#2:479\n1916#2:481\n1652#2:482\n1#3:450\n1#3:464\n1#3:480\n*S KotlinDebug\n*F\n+ 1 MavenAnnotationProcessorConfigurator.kt\norg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator\n*L\n68#1:439,10\n68#1:449\n68#1:451\n68#1:452\n92#1:453,10\n92#1:463\n92#1:465\n92#1:466\n93#1:467,2\n158#1:469,10\n158#1:479\n158#1:481\n158#1:482\n68#1:450\n92#1:464\n158#1:480\n*E\n"})
public final class MavenAnnotationProcessorConfigurator
extends MavenApplicableConfigurator
implements MavenWorkspaceConfigurator {
    public MavenAnnotationProcessorConfigurator() {
        super("org.apache.maven.plugins", "maven-compiler-plugin");
    }

    @Override
    public boolean isApplicable(@NotNull MavenProject mavenProject) {
        Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void beforeModelApplied(@NotNull MavenWorkspaceConfigurator.MutableModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map mavenProjectToModuleNamesCache = new HashMap();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules each : SequencesKt.asIterable(context2.getMavenProjectsWithModules())) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = each.getModules();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                MavenWorkspaceConfigurator.ModuleWithType it = (MavenWorkspaceConfigurator.ModuleWithType)element$iv$iv;
                boolean bl2 = false;
                if ((it.getType().getContainsCode() ? ((ModuleEntity)it.getModule()).getName() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List moduleNames = (List)destination$iv$iv;
            mavenProjectToModuleNamesCache.put(each.getMavenProject().getMavenId(), moduleNames);
        }
        Sequence changedOnlyProjects = SequencesKt.mapNotNull(context2.getMavenProjectsWithModules(), MavenAnnotationProcessorConfigurator::beforeModelApplied$lambda$1);
        HashMap map = new HashMap();
        this.collectProcessorModuleNames(SequencesKt.asIterable((Sequence)changedOnlyProjects), arg_0 -> MavenAnnotationProcessorConfigurator.beforeModelApplied$lambda$2(mavenProjectToModuleNamesCache, arg_0), map);
        MavenAnnotationProcessorConfiguratorKt.access$getANNOTATION_PROCESSOR_MODULE_NAMES$p().set((UserDataHolder)context2, map);
    }

    /*
     * WARNING - void declaration
     */
    private final void collectProcessorModuleNames(Iterable<MavenProject> projects2, Function<MavenId, List<String>> moduleNameByProjectId, Map<MavenProject, List<String>> result) {
        for (MavenProject mavenProject : projects2) {
            void $this$forEach$iv;
            Iterator $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv;
            if (!this.shouldEnableAnnotationProcessors(mavenProject)) continue;
            ArrayList infos = new ArrayList();
            Object object = MavenImportUtil.INSTANCE.compilerConfigsForCompilePhase$intellij_maven(mavenProject);
            boolean $i$f$mapNotNull = false;
            void var9_10 = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                Element it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Element it = (Element)element$iv$iv;
                boolean bl2 = false;
                if (MavenJDOMUtil.findChildByPath(it, "annotationProcessorPaths") == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            $this$mapNotNull$iv = (List)destination$iv$iv;
            boolean $i$f$forEach2 = false;
            $this$mapNotNullTo$iv$iv = $this$forEach$iv.iterator();
            while ($this$mapNotNullTo$iv$iv.hasNext()) {
                Object element$iv = $this$mapNotNullTo$iv$iv.next();
                Element it = (Element)element$iv;
                boolean bl = false;
                infos.addAll(MavenAnnotationProcessorConfiguratorUtil.INSTANCE.getProcessorArtifactInfos(it, mavenProject));
            }
            Iterator iterator2 = infos.iterator();
            Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
            object = iterator2;
            while (object.hasNext()) {
                Object e = object.next();
                Intrinsics.checkNotNullExpressionValue(e, (String)"next(...)");
                MavenArtifactInfo info = (MavenArtifactInfo)e;
                MavenId mavenId = new MavenId(info.getGroupId(), info.getArtifactId(), info.getVersion());
                List<String> processorModuleNames = moduleNameByProjectId.apply(mavenId);
                if (processorModuleNames == null) continue;
                result.computeIfAbsent(mavenProject, arg_0 -> MavenAnnotationProcessorConfigurator.collectProcessorModuleNames$lambda$3(MavenAnnotationProcessorConfigurator::collectProcessorModuleNames$lambda$2, arg_0)).addAll((Collection)processorModuleNames);
            }
        }
    }

    @Override
    public void afterModelApplied(@NotNull MavenWorkspaceConfigurator.AppliedModelContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Map nameToModuleCache = new HashMap();
        for (MavenWorkspaceConfigurator.MavenProjectWithModules each : SequencesKt.asIterable(context2.getMavenProjectsWithModules())) {
            for (MavenWorkspaceConfigurator.ModuleWithType moduleWithType : each.getModules()) {
                Module module = (Module)moduleWithType.getModule();
                nameToModuleCache.put(module.getName(), module);
            }
        }
        Function<String, Module> moduleByName = arg_0 -> MavenAnnotationProcessorConfigurator.afterModelApplied$lambda$0(nameToModuleCache, arg_0);
        Object object = MavenAnnotationProcessorConfiguratorKt.access$getANNOTATION_PROCESSOR_MODULE_NAMES$p().get((UserDataHolder)context2, Map.of());
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        Map perProjectProcessorModuleNames = (Map)object;
        Sequence changedOnly = SequencesKt.filter(context2.getMavenProjectsWithModules(), MavenAnnotationProcessorConfigurator::afterModelApplied$lambda$1);
        Sequence projectWithModules = SequencesKt.map((Sequence)changedOnly, arg_0 -> MavenAnnotationProcessorConfigurator.afterModelApplied$lambda$2(perProjectProcessorModuleNames, arg_0));
        this.configureProfiles(context2.getProject(), context2.getMavenProjectsTree(), SequencesKt.asIterable((Sequence)projectWithModules), moduleByName);
    }

    /*
     * WARNING - void declaration
     */
    private final void configureProfiles(Project project, MavenProjectsTree tree, Iterable<MavenProjectWithProcessorModules> projectsWithModules, Function<String, Module> moduleByName) {
        CompilerConfiguration compilerConfiguration = CompilerConfiguration.getInstance((Project)project);
        Intrinsics.checkNotNull((Object)compilerConfiguration, (String)"null cannot be cast to non-null type com.intellij.compiler.CompilerConfigurationImpl");
        CompilerConfigurationImpl compilerConfiguration2 = (CompilerConfigurationImpl)compilerConfiguration;
        for (MavenProjectWithProcessorModules it : projectsWithModules) {
            MavenProject rootProject = tree.findRootProject(it.getMavenProject());
            for (MavenWorkspaceConfigurator.ModuleWithType<Module> moduleWithType : it.getMavenProjectModules()) {
                Module module = moduleWithType.getModule();
                MavenModuleType moduleType = moduleWithType.getType();
                if (!this.isLevelMoreThan6(module)) continue;
                if (this.shouldEnableAnnotationProcessors(it.getMavenProject()) && moduleType.getContainsCode()) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = it.getProcessorModuleNames();
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        Module it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl = false;
                        String it2 = (String)element$iv$iv;
                        boolean bl2 = false;
                        if (moduleByName.apply(it2) == null) continue;
                        boolean bl3 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List processorModules = (List)destination$iv$iv;
                    Pair<ProcessorConfigProfile, Boolean> profileIsDefault = this.createOrUpdateProfile(it.getMavenProject(), module, processorModules, compilerConfiguration2);
                    if (profileIsDefault == null) continue;
                    ProcessorConfigProfile processorConfigProfile = (ProcessorConfigProfile)profileIsDefault.first;
                    Object object = profileIsDefault.second;
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"second");
                    this.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration2, processorConfigProfile, (Boolean)object, module);
                    continue;
                }
                this.cleanAndMergeModuleProfiles(rootProject, compilerConfiguration2, null, false, module);
            }
        }
    }

    private final Pair<ProcessorConfigProfile, Boolean> createOrUpdateProfile(MavenProject mavenProject, Module module, List<? extends Module> processorModules, CompilerConfigurationImpl compilerConfiguration) {
        boolean isDefaultSettings;
        List<String> processors = MavenImportUtil.INSTANCE.getDeclaredAnnotationProcessors$intellij_maven(mavenProject);
        Map<String, String> options = MavenImportUtil.INSTANCE.getAnnotationProcessorOptions$intellij_maven(mavenProject);
        boolean outputRelativeToContentRoot = false;
        String annotationProcessorDirectory = null;
        String testAnnotationProcessorDirectory = null;
        if (MavenImportUtil.INSTANCE.isMainOrTestModule$intellij_maven(module)) {
            outputRelativeToContentRoot = false;
            annotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject, false, mavenProject.getOutputDirectory());
            testAnnotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject, true, mavenProject.getTestOutputDirectory());
        } else {
            String mavenProjectDirectory = mavenProject.getDirectory();
            outputRelativeToContentRoot = true;
            annotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject, false, mavenProjectDirectory);
            testAnnotationProcessorDirectory = this.getAnnotationsDirectoryRelativeTo(mavenProject, true, mavenProjectDirectory);
        }
        String annotationProcessorPath = this.getAnnotationProcessorPath(mavenProject, processorModules);
        boolean isDefault = false;
        String moduleProfileName = null;
        boolean bl = isDefaultSettings = ContainerUtil.isEmpty((Collection)processors) && options.isEmpty() && StringUtil.isEmpty((String)annotationProcessorPath);
        if (isDefaultSettings && Intrinsics.areEqual((Object)"target/generated-sources/annotations", (Object)FileUtil.toSystemIndependentName((String)annotationProcessorDirectory)) && Intrinsics.areEqual((Object)"target/generated-test-sources/test-annotations", (Object)FileUtil.toSystemIndependentName((String)testAnnotationProcessorDirectory))) {
            moduleProfileName = "Maven default annotation processors profile";
            isDefault = true;
        } else if (isDefaultSettings && Intrinsics.areEqual((Object)"target/generated-sources/apt", (Object)FileUtil.toSystemIndependentName((String)annotationProcessorDirectory)) && Intrinsics.areEqual((Object)"target/generated-sources/apt-test", (Object)FileUtil.toSystemIndependentName((String)testAnnotationProcessorDirectory))) {
            moduleProfileName = MavenAnnotationProcessorConfiguratorKt.getMAVEN_BSC_DEFAULT_ANNOTATION_PROFILE();
            isDefault = true;
        } else {
            String string = module.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            moduleProfileName = MavenAnnotationProcessorConfiguratorUtil.INSTANCE.getModuleProfileName(string);
            isDefault = false;
        }
        ProcessorConfigProfile moduleProfile = this.getModuleProfile(module, mavenProject, compilerConfiguration, moduleProfileName, outputRelativeToContentRoot, annotationProcessorDirectory, testAnnotationProcessorDirectory);
        if (moduleProfile == null) {
            return null;
        }
        if (StringUtil.isNotEmpty((String)annotationProcessorPath)) {
            moduleProfile.setObtainProcessorsFromClasspath(false);
            moduleProfile.setProcessorPath(annotationProcessorPath);
        }
        return Pair.pair((Object)moduleProfile, (Object)isDefault);
    }

    private final ProcessorConfigProfile getModuleProfile(Module module, MavenProject mavenProject, CompilerConfigurationImpl compilerConfiguration, String moduleProfileName, boolean outputRelativeToContentRoot, String annotationProcessorDirectory, String testAnnotationProcessorDirectory) {
        ProcessorConfigProfile moduleProfile = compilerConfiguration.findModuleProcessorProfile(moduleProfileName);
        if (moduleProfile == null) {
            moduleProfile = compilerConfiguration.addNewProcessorProfile(moduleProfileName);
            moduleProfile.setEnabled(true);
        }
        if (!moduleProfile.isEnabled()) {
            return null;
        }
        moduleProfile.setObtainProcessorsFromClasspath(true);
        moduleProfile.setOutputRelativeToContentRoot(outputRelativeToContentRoot);
        moduleProfile.setGeneratedSourcesDirectoryName(annotationProcessorDirectory, false);
        moduleProfile.setGeneratedSourcesDirectoryName(testAnnotationProcessorDirectory, true);
        moduleProfile.clearProcessorOptions();
        for (Map.Entry<String, String> object : MavenImportUtil.INSTANCE.getAnnotationProcessorOptions$intellij_maven(mavenProject).entrySet()) {
            String key = object.getKey();
            String value = object.getValue();
            moduleProfile.setOption(key, value);
        }
        moduleProfile.clearProcessors();
        List<String> processors = MavenImportUtil.INSTANCE.getDeclaredAnnotationProcessors$intellij_maven(mavenProject);
        for (String processor : processors) {
            moduleProfile.addProcessor(processor);
        }
        moduleProfile.addModuleName(module.getName());
        return moduleProfile;
    }

    private final boolean isLevelMoreThan6(Module module) {
        String versionString;
        LanguageLevel languageLevel;
        Sdk sdk = (Sdk)ReadAction.compute(() -> MavenAnnotationProcessorConfigurator.isLevelMoreThan6$lambda$0(module));
        return sdk == null || (languageLevel = LanguageLevel.Companion.parse(versionString = sdk.getVersionString())) == null || !languageLevel.isLessThan(LanguageLevel.JDK_1_6);
    }

    private final String getAnnotationProcessorPath(MavenProject mavenProject, List<? extends Module> processorModules) {
        StringJoiner annotationProcessorPath = new StringJoiner(File.pathSeparator);
        Consumer resultAppender = arg_0 -> MavenAnnotationProcessorConfigurator.getAnnotationProcessorPath$lambda$0(annotationProcessorPath, arg_0);
        for (MavenArtifact mavenArtifact : mavenProject.getExternalAnnotationProcessors()) {
            resultAppender.consume((Object)mavenArtifact.getPath());
        }
        for (Module module : processorModules) {
            String[] stringArray;
            OrderEnumerator enumerator;
            Intrinsics.checkNotNullExpressionValue((Object)OrderEnumerator.orderEntries((Module)module).withoutSdk().productionOnly().runtimeOnly().recursively(), (String)"recursively(...)");
            Intrinsics.checkNotNullExpressionValue((Object)enumerator.classes().getUrls(), (String)"getUrls(...)");
            for (String url : stringArray) {
                resultAppender.consume((Object)JpsPathUtil.urlToPath((String)url));
            }
        }
        String string = annotationProcessorPath.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final void cleanAndMergeModuleProfiles(MavenProject rootProject, CompilerConfigurationImpl compilerConfiguration, ProcessorConfigProfile moduleProfile, boolean isDefault, Module module) {
        List profiles2 = new ArrayList(compilerConfiguration.getModuleProcessorProfiles());
        for (ProcessorConfigProfile p : profiles2) {
            if (p != moduleProfile) {
                p.removeModuleName(module.getName());
                if (p.getModuleNames().isEmpty()) {
                    String string = p.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    if (StringsKt.startsWith$default((String)string, (String)"Annotation profile for ", (boolean)false, (int)2, null)) {
                        compilerConfiguration.removeModuleProcessorProfile(p);
                    }
                }
            }
            if (isDefault || moduleProfile == null || !this.isSimilarProfiles(p, moduleProfile)) continue;
            moduleProfile.setEnabled(p.isEnabled());
            String mavenProjectRootProfileName = MavenAnnotationProcessorConfiguratorUtil.INSTANCE.getModuleProfileName(rootProject.getDisplayName());
            ProcessorConfigProfile mergedProfile = compilerConfiguration.findModuleProcessorProfile(mavenProjectRootProfileName);
            if (mergedProfile == null) {
                mergedProfile = (ProcessorConfigProfile)new ProcessorConfigProfileImpl(moduleProfile);
                ((ProcessorConfigProfileImpl)mergedProfile).setName(mavenProjectRootProfileName);
                compilerConfiguration.addModuleProcessorProfile(mergedProfile);
                ((ProcessorConfigProfileImpl)mergedProfile).addModuleNames((Collection)p.getModuleNames());
                p.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(p);
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
                continue;
            }
            if (p != mergedProfile && !this.isSimilarProfiles(mergedProfile, moduleProfile)) continue;
            if (moduleProfile != mergedProfile) {
                mergedProfile.addModuleNames((Collection)moduleProfile.getModuleNames());
                moduleProfile.clearModuleNames();
                compilerConfiguration.removeModuleProcessorProfile(moduleProfile);
            }
            if (p == mergedProfile) continue;
            mergedProfile.addModuleNames((Collection)p.getModuleNames());
            p.clearModuleNames();
            compilerConfiguration.removeModuleProcessorProfile(p);
        }
    }

    private final boolean isSimilarProfiles(ProcessorConfigProfile profile1, ProcessorConfigProfile profile2) {
        if (profile1 == null || profile2 == null) {
            return false;
        }
        ProcessorConfigProfileImpl p1 = new ProcessorConfigProfileImpl(profile1);
        p1.setName("tmp");
        p1.setEnabled(true);
        p1.clearModuleNames();
        ProcessorConfigProfileImpl p2 = new ProcessorConfigProfileImpl(profile2);
        p2.setName("tmp");
        p2.setEnabled(true);
        p2.clearModuleNames();
        return Intrinsics.areEqual((Object)p1, (Object)p2);
    }

    private final String getAnnotationsDirectoryRelativeTo(MavenProject mavenProject, boolean isTest, String relativeTo) {
        String string;
        String annotationProcessorDirectory = MavenImportUtil.INSTANCE.getAnnotationProcessorDirectory$intellij_maven(mavenProject, isTest);
        Path path = Path.of(annotationProcessorDirectory, new String[0]);
        if (!path.isAbsolute()) {
            return annotationProcessorDirectory;
        }
        try {
            string = ((Object)Path.of(relativeTo, new String[0]).relativize(path)).toString();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            string = isTest ? "target/generated-test-sources/test-annotations" : "target/generated-sources/annotations";
        }
        return string;
    }

    private final boolean shouldEnableAnnotationProcessors(MavenProject mavenProject) {
        if (Intrinsics.areEqual((Object)"pom", (Object)mavenProject.getPackaging())) {
            return false;
        }
        return MavenImportUtil.INSTANCE.getProcMode$intellij_maven(mavenProject) != MavenProject.ProcMode.NONE || MavenProject.findPlugin$default(mavenProject, "org.bsc.maven", "maven-processor-plugin", false, 4, null) != null;
    }

    private static final MavenProject beforeModelApplied$lambda$1(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHasChanges() ? it.getMavenProject() : null;
    }

    private static final List beforeModelApplied$lambda$2(Map $mavenProjectToModuleNamesCache, MavenId moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return (List)$mavenProjectToModuleNamesCache.get(moduleName);
    }

    private static final List collectProcessorModuleNames$lambda$2(MavenProject mavenProject) {
        return new ArrayList();
    }

    private static final List collectProcessorModuleNames$lambda$3(Function1 $tmp0, Object p0) {
        return (List)$tmp0.invoke(p0);
    }

    private static final Module afterModelApplied$lambda$0(Map $nameToModuleCache, String moduleName) {
        Intrinsics.checkNotNullParameter((Object)moduleName, (String)"moduleName");
        return (Module)$nameToModuleCache.get(moduleName);
    }

    private static final boolean afterModelApplied$lambda$1(MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getHasChanges();
    }

    private static final MavenProjectWithProcessorModules afterModelApplied$lambda$2(Map $perProjectProcessorModuleNames, MavenWorkspaceConfigurator.MavenProjectWithModules it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        List processorModuleNames = $perProjectProcessorModuleNames.getOrDefault(it.getMavenProject(), CollectionsKt.emptyList());
        return new MavenProjectWithProcessorModules(it.getMavenProject(), it.getModules(), processorModuleNames);
    }

    private static final Sdk isLevelMoreThan6$lambda$0(Module $module) {
        return ModuleRootManager.getInstance((Module)$module).getSdk();
    }

    private static final void getAnnotationProcessorPath$lambda$0(StringJoiner $annotationProcessorPath, String path) {
        String string = path;
        Intrinsics.checkNotNull((Object)string);
        $annotationProcessorPath.add(FileUtil.toSystemDependentName((String)string));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000f\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/idea/maven/importing/MavenAnnotationProcessorConfigurator$MavenProjectWithProcessorModules;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "mavenProjectModules", "", "Lorg/jetbrains/idea/maven/importing/MavenWorkspaceConfigurator$ModuleWithType;", "Lcom/intellij/openapi/module/Module;", "processorModuleNames", "", "<init>", "(Lorg/jetbrains/idea/maven/project/MavenProject;Ljava/util/List;Ljava/util/List;)V", "getMavenProject", "()Lorg/jetbrains/idea/maven/project/MavenProject;", "getMavenProjectModules", "()Ljava/util/List;", "getProcessorModuleNames", "intellij.maven"})
    private static final class MavenProjectWithProcessorModules {
        @NotNull
        private final MavenProject mavenProject;
        @NotNull
        private final List<MavenWorkspaceConfigurator.ModuleWithType<Module>> mavenProjectModules;
        @NotNull
        private final List<String> processorModuleNames;

        public MavenProjectWithProcessorModules(@NotNull MavenProject mavenProject, @NotNull List<? extends MavenWorkspaceConfigurator.ModuleWithType<Module>> mavenProjectModules, @NotNull List<String> processorModuleNames) {
            Intrinsics.checkNotNullParameter((Object)mavenProject, (String)"mavenProject");
            Intrinsics.checkNotNullParameter(mavenProjectModules, (String)"mavenProjectModules");
            Intrinsics.checkNotNullParameter(processorModuleNames, (String)"processorModuleNames");
            this.mavenProject = mavenProject;
            this.mavenProjectModules = mavenProjectModules;
            this.processorModuleNames = processorModuleNames;
        }

        @NotNull
        public final MavenProject getMavenProject() {
            return this.mavenProject;
        }

        @NotNull
        public final List<MavenWorkspaceConfigurator.ModuleWithType<Module>> getMavenProjectModules() {
            return this.mavenProjectModules;
        }

        @NotNull
        public final List<String> getProcessorModuleNames() {
            return this.processorModuleNames;
        }
    }
}

