/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator.structure;

import com.intellij.ide.plugins.DynamicPluginListener;
import com.intellij.ide.plugins.IdeaPluginDescriptor;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.awt.event.InputEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.swing.JTree;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.model.MavenProfileKind;
import org.jetbrains.idea.maven.navigator.MavenProjectsNavigator;
import org.jetbrains.idea.maven.navigator.structure.MavenSimpleNode;
import org.jetbrains.idea.maven.navigator.structure.PluginNode;
import org.jetbrains.idea.maven.navigator.structure.PluginsNode;
import org.jetbrains.idea.maven.navigator.structure.ProfileNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectNode;
import org.jetbrains.idea.maven.navigator.structure.ProjectsGroupNode;
import org.jetbrains.idea.maven.navigator.structure.RootNode;
import org.jetbrains.idea.maven.project.MavenPluginWithArtifact;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.server.MavenIndexUpdateState;
import org.jetbrains.idea.maven.tasks.MavenShortcutsManager;
import org.jetbrains.idea.maven.tasks.MavenTasksManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;
import org.jetbrains.idea.maven.utils.MavenPluginInfo;
import org.jetbrains.idea.maven.utils.MavenUIUtil;

public final class MavenProjectsStructure
extends SimpleTreeStructure {
    private final ExecutorService boundedUpdateService;
    private final Project myProject;
    private final MavenStructureDisplayMode myDisplayMode;
    private final MavenProjectsManager myProjectsManager;
    private final MavenTasksManager myTasksManager;
    private final MavenShortcutsManager myShortcutsManager;
    private final MavenProjectsNavigator myProjectsNavigator;
    private final RootNode myRoot;
    private final StructureTreeModel<MavenProjectsStructure> myModel;
    private final SimpleTree myTree;
    private volatile boolean isUnloading = false;
    private final Map<MavenProject, ProjectNode> myProjectToNodeMapping = new HashMap<MavenProject, ProjectNode>();

    public MavenProjectsStructure(Project project, MavenStructureDisplayMode displayMode, MavenProjectsManager projectsManager, MavenTasksManager tasksManager, MavenShortcutsManager shortcutsManager, MavenProjectsNavigator projectsNavigator, SimpleTree tree) {
        this.myProject = project;
        this.myDisplayMode = displayMode;
        this.myRoot = new RootNode(this);
        this.myProjectsManager = projectsManager;
        this.myTasksManager = tasksManager;
        this.myShortcutsManager = shortcutsManager;
        this.myProjectsNavigator = projectsNavigator;
        this.boundedUpdateService = AppExecutorUtil.createBoundedApplicationPoolExecutor((String)"Maven Plugin Updater", (int)1);
        project.getMessageBus().simpleConnect().subscribe(DynamicPluginListener.TOPIC, (Object)new DynamicPluginListener(){

            public void beforePluginUnload(@NotNull IdeaPluginDescriptor pluginDescriptor, boolean isUpdate) {
                if (pluginDescriptor == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("org.jetbrains.idea.maven".equals(pluginDescriptor.getPluginId().getIdString())) {
                    MavenProjectsStructure.this.isUnloading = true;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pluginDescriptor", "org/jetbrains/idea/maven/navigator/structure/MavenProjectsStructure$1", "beforePluginUnload"));
            }
        });
        this.myTree = tree;
        MavenProjectsStructure.configureTree(this.myTree);
        this.myModel = new StructureTreeModel((AbstractTreeStructure)this, (Disposable)projectsNavigator);
        tree.setModel((TreeModel)new AsyncTreeModel(this.myModel, (Disposable)projectsNavigator));
    }

    Project getProject() {
        return this.myProject;
    }

    MavenProjectsManager getProjectsManager() {
        return this.myProjectsManager;
    }

    MavenProjectsNavigator getProjectsNavigator() {
        return this.myProjectsNavigator;
    }

    public MavenTasksManager getTasksManager() {
        return this.myTasksManager;
    }

    public MavenShortcutsManager getShortcutsManager() {
        return this.myShortcutsManager;
    }

    MavenStructureDisplayMode getDisplayMode() {
        return this.myDisplayMode;
    }

    private static void configureTree(final SimpleTree tree) {
        tree.setRootVisible(false);
        tree.setShowsRootHandles(true);
        MavenUIUtil.installCheckboxRenderer(tree, new MavenUIUtil.CheckboxHandler(){

            @Override
            public void toggle(TreePath treePath, InputEvent e) {
                SimpleNode node = tree.getNodeFor(treePath);
                if (node != null) {
                    node.handleDoubleClickOrEnter(tree, e);
                }
            }

            @Override
            public boolean isVisible(Object userObject) {
                return userObject instanceof ProfileNode;
            }

            @Override
            public MavenUIUtil.CheckBoxState getState(Object userObject) {
                MavenProfileKind state = ((ProfileNode)userObject).getState();
                return switch (state) {
                    default -> throw new MatchException(null, null);
                    case MavenProfileKind.NONE -> MavenUIUtil.CheckBoxState.UNCHECKED;
                    case MavenProfileKind.EXPLICIT -> MavenUIUtil.CheckBoxState.CHECKED;
                    case MavenProfileKind.IMPLICIT -> MavenUIUtil.CheckBoxState.PARTIAL;
                };
            }
        });
    }

    @NotNull
    public RootNode getRootElement() {
        RootNode rootNode = this.myRoot;
        if (rootNode == null) {
            MavenProjectsStructure.$$$reportNull$$$0(0);
        }
        return rootNode;
    }

    public void update() {
        List<MavenProject> projects2 = this.getProjectsManager().getProjects();
        HashSet<MavenProject> deleted = new HashSet<MavenProject>(this.myProjectToNodeMapping.keySet());
        deleted.removeAll(projects2);
        this.updateProjects(projects2, deleted);
    }

    void updateFrom(SimpleNode node) {
        if (node != null) {
            this.myModel.invalidate((Object)node, true);
        }
    }

    void updateUpTo(SimpleNode node) {
        for (SimpleNode each = node; each != null; each = each.getParent()) {
            this.updateFrom(each);
        }
    }

    public void updateProjects(List<MavenProject> updated, Collection<MavenProject> deleted) {
        ProjectNode node;
        for (MavenProject each : updated) {
            node = this.findNodeFor(each);
            if (node == null) {
                node = new ProjectNode(this, each);
                this.myProjectToNodeMapping.put(each, node);
            }
            this.doUpdateProject(node);
        }
        for (MavenProject each : deleted) {
            node = this.myProjectToNodeMapping.remove(each);
            if (node == null) continue;
            ProjectsGroupNode parent = node.getGroup();
            parent.remove(node);
        }
        this.myRoot.updateProfiles();
    }

    private void doUpdateProject(ProjectNode node) {
        ProjectNode aggregatorNode;
        MavenProject aggregator;
        MavenProject project = node.getMavenProject();
        ProjectsGroupNode newParentNode = this.myRoot;
        if (this.getProjectsNavigator().getGroupModules() && (aggregator = this.getProjectsManager().findAggregator(project)) != null && (aggregatorNode = this.findNodeFor(aggregator)) != null && aggregatorNode.isVisible()) {
            newParentNode = aggregatorNode;
        }
        node.updateProject();
        MavenProjectsStructure.reconnectNode(node, newParentNode);
        RootNode newModulesParentNode = this.getProjectsNavigator().getGroupModules() && node.isVisible() ? node : this.myRoot;
        for (MavenProject each : this.getProjectsManager().getModules(project)) {
            ProjectNode moduleNode = this.findNodeFor(each);
            if (moduleNode == null || moduleNode.getParent().equals((Object)newModulesParentNode)) continue;
            MavenProjectsStructure.reconnectNode(moduleNode, newModulesParentNode);
        }
    }

    private static void reconnectNode(ProjectNode node, ProjectsGroupNode newParentNode) {
        ProjectsGroupNode oldParentNode = node.getGroup();
        if (oldParentNode == null || !oldParentNode.equals(newParentNode)) {
            if (oldParentNode != null) {
                oldParentNode.remove(node);
            }
            newParentNode.add(node);
        } else {
            newParentNode.sortProjects();
        }
    }

    public void updateProfiles() {
        this.myRoot.updateProfiles();
    }

    public void updateIgnored(List<MavenProject> projects2) {
        for (MavenProject each : projects2) {
            ProjectNode node = this.findNodeFor(each);
            if (node == null) continue;
            node.updateIgnored();
        }
    }

    public void accept(@NotNull TreeVisitor visitor) {
        if (visitor == null) {
            MavenProjectsStructure.$$$reportNull$$$0(1);
        }
        ((TreeVisitor.Acceptor)this.myTree.getModel()).accept(visitor);
    }

    public void updateGoals() {
        for (ProjectNode each : this.myProjectToNodeMapping.values()) {
            each.updateGoals();
        }
    }

    public void updateRunConfigurations() {
        for (ProjectNode each : this.myProjectToNodeMapping.values()) {
            each.updateRunConfigurations();
        }
    }

    public void select(MavenProject project) {
        ProjectNode node = this.findNodeFor(project);
        if (node != null) {
            this.select((SimpleNode)node);
        }
    }

    public void select(SimpleNode node) {
        this.myModel.select((Object)node, (JTree)this.myTree, treePath -> {});
    }

    private ProjectNode findNodeFor(MavenProject project) {
        return this.myProjectToNodeMapping.get(project);
    }

    boolean showOnlyBasicPhases() {
        if (this.getDisplayMode() == MavenStructureDisplayMode.SHOW_GOALS) {
            return false;
        }
        return this.getProjectsNavigator().getShowBasicPhasesOnly();
    }

    public static <T extends MavenSimpleNode> List<T> getSelectedNodes(SimpleTree tree, Class<T> nodeClass) {
        ArrayList<MavenSimpleNode> filtered = new ArrayList<MavenSimpleNode>();
        for (SimpleNode node : MavenProjectsStructure.getSelectedNodes(tree)) {
            if (nodeClass != null && !nodeClass.isInstance(node)) {
                filtered.clear();
                break;
            }
            filtered.add((MavenSimpleNode)node);
        }
        return filtered;
    }

    private static List<SimpleNode> getSelectedNodes(SimpleTree tree) {
        ArrayList<SimpleNode> nodes = new ArrayList<SimpleNode>();
        TreePath[] treePaths = tree.getSelectionPaths();
        if (treePaths != null) {
            for (TreePath treePath : treePaths) {
                nodes.add(tree.getNodeFor(treePath));
            }
        }
        return nodes;
    }

    void updatePluginsTree(PluginsNode pluginsNode, List<MavenPluginWithArtifact> pluginInfos) {
        this.boundedUpdateService.execute(new UpdatePluginsTreeTask(pluginsNode, pluginInfos));
    }

    public void updateRepositoryStatus(@NotNull MavenIndexUpdateState state) {
        if (state == null) {
            MavenProjectsStructure.$$$reportNull$$$0(2);
        }
        this.myProjectToNodeMapping.values().forEach(pn -> pn.getRepositoriesNode().updateStatus(state));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/navigator/structure/MavenProjectsStructure";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "visitor";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/navigator/structure/MavenProjectsStructure";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "accept";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "updateRepositoryStatus";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2 -> new IllegalArgumentException(string);
        };
    }

    public static enum MavenStructureDisplayMode {
        SHOW_ALL,
        SHOW_PROJECTS,
        SHOW_GOALS;

    }

    private class UpdatePluginsTreeTask
    implements Runnable {
        @NotNull
        private final PluginsNode myParentNode;
        private final List<MavenPluginWithArtifact> myPluginInfos;

        UpdatePluginsTreeTask(PluginsNode parentNode, List<MavenPluginWithArtifact> pluginInfos) {
            if (parentNode == null) {
                UpdatePluginsTreeTask.$$$reportNull$$$0(0);
            }
            this.myParentNode = parentNode;
            this.myPluginInfos = pluginInfos;
        }

        @Override
        public void run() {
            ArrayList<PluginNode> pluginInfos = new ArrayList<PluginNode>();
            Iterator<MavenPluginWithArtifact> iterator = this.myPluginInfos.iterator();
            while (!MavenProjectsStructure.this.isUnloading && iterator.hasNext()) {
                MavenPluginWithArtifact next = iterator.next();
                MavenPluginInfo pluginInfo = MavenArtifactUtil.readPluginInfo(next.getArtifact());
                PluginNode pluginNode = new PluginNode(MavenProjectsStructure.this, this.myParentNode, next.getPlugin(), pluginInfo);
                pluginInfos.add(pluginNode);
            }
            this.updateNodesInEDT(pluginInfos);
        }

        private void updateNodesInEDT(List<PluginNode> pluginNodes) {
            ApplicationManager.getApplication().invokeLater(() -> {
                this.myParentNode.getPluginNodes().clear();
                if (MavenProjectsStructure.this.isUnloading) {
                    return;
                }
                this.myParentNode.getPluginNodes().addAll(pluginNodes);
                this.myParentNode.sort(this.myParentNode.getPluginNodes());
                this.myParentNode.childrenChanged();
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parentNode", "org/jetbrains/idea/maven/navigator/structure/MavenProjectsStructure$UpdatePluginsTreeTask", "<init>"));
        }
    }

    public static enum ErrorLevel {
        NONE,
        ERROR;

    }

    @ApiStatus.Internal
    public static enum DisplayKind {
        ALWAYS,
        NEVER,
        NORMAL;

    }
}

