/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.model.MavenModel;
import org.jetbrains.idea.maven.model.MavenParent;
import org.jetbrains.idea.maven.project.MavenProjectModelReadHelper;
import org.jetbrains.idea.maven.server.MavenServerConfigUtil;
import org.jetbrains.idea.maven.utils.MavenLog;
import org.jetbrains.idea.maven.utils.MavenUtil;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J$\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u0002J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\nH\u0002J$\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\n2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0015H\u0002JC\u0010\u0016\u001a\u0004\u0018\u00010\u00112\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u0015H\u0002\u0082\u0002\u0018\n\b\b\u0002\u001a\u0004\b\u0003\u0010\u0001\n\f\b\u0000\u0012\u0002\u0018\u0002\u001a\u0004\b\u0002\u0010\u0001J\u001e\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u0018H\u0096@\u00a2\u0006\u0002\u0010\u001aJ&\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u001c\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u00182\u0006\u0010\u001d\u001a\u00020\rH\u0096@\u00a2\u0006\u0002\u0010\u001eR\u0014\u0010\u0002\u001a\u00020\u0003X\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/idea/maven/project/MavenProjectModelServerModelReadHelper;", "Lorg/jetbrains/idea/maven/project/MavenProjectModelReadHelper;", "myProject", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getMyProject", "()Lcom/intellij/openapi/project/Project;", "filterModules", "", "", "modules", "mavenModuleFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "needInterpolate", "", "mavenId", "Lorg/jetbrains/idea/maven/model/MavenId;", "interpolateString", "property", "properties", "Ljava/util/HashMap;", "interpolateMavenId", "interpolate", "Lorg/jetbrains/idea/maven/model/MavenModel;", "model", "(Lcom/intellij/openapi/vfs/VirtualFile;Lorg/jetbrains/idea/maven/model/MavenModel;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "assembleInheritance", "parentModel", "file", "(Lorg/jetbrains/idea/maven/model/MavenModel;Lorg/jetbrains/idea/maven/model/MavenModel;Lcom/intellij/openapi/vfs/VirtualFile;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.maven"})
@SourceDebugExtension(value={"SMAP\nMavenProjectModelServerModelReadHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MavenProjectModelServerModelReadHelper.kt\norg/jetbrains/idea/maven/project/MavenProjectModelServerModelReadHelper\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,95:1\n1#2:96\n1915#3,2:97\n*S KotlinDebug\n*F\n+ 1 MavenProjectModelServerModelReadHelper.kt\norg/jetbrains/idea/maven/project/MavenProjectModelServerModelReadHelper\n*L\n74#1:97,2\n*E\n"})
public class MavenProjectModelServerModelReadHelper
implements MavenProjectModelReadHelper {
    @NotNull
    private final Project myProject;

    public MavenProjectModelServerModelReadHelper(@NotNull Project myProject) {
        Intrinsics.checkNotNullParameter((Object)myProject, (String)"myProject");
        this.myProject = myProject;
    }

    @NotNull
    protected final Project getMyProject() {
        return this.myProject;
    }

    @Override
    @NotNull
    public List<String> filterModules(@NotNull List<String> modules, @NotNull VirtualFile mavenModuleFile) {
        Intrinsics.checkNotNullParameter(modules, (String)"modules");
        Intrinsics.checkNotNullParameter((Object)mavenModuleFile, (String)"mavenModuleFile");
        return modules;
    }

    private final boolean needInterpolate(MavenId mavenId) {
        if (mavenId == null) {
            return false;
        }
        return this.needInterpolate(mavenId.getArtifactId()) || this.needInterpolate(mavenId.getGroupId()) || this.needInterpolate(mavenId.getVersion());
    }

    private final boolean needInterpolate(String mavenId) {
        String string = mavenId;
        return string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)"${", (boolean)false, (int)2, null) : false;
    }

    private final String interpolateString(String property, HashMap<String, String> properties) {
        String resolved = MavenProjectModelReadHelper.Companion.resolveProperty(property, properties);
        if (resolved == null) {
            if (MavenLog.LOG.isDebugEnabled()) {
                MavenLog.LOG.debug("Cannot resolve property " + property + ", collected properties: " + properties);
            } else {
                MavenLog.LOG.warn("Cannot resolve property " + property);
            }
            return property;
        }
        return resolved;
    }

    private final MavenId interpolateMavenId(MavenId mavenId, HashMap<String, String> properties) {
        String string;
        String string2;
        String string3;
        String string4;
        String it;
        if (mavenId == null) {
            return null;
        }
        String string5 = mavenId.getGroupId();
        if (string5 != null) {
            it = string5;
            boolean bl = false;
            string4 = this.interpolateString(it, properties);
        } else {
            string4 = null;
        }
        String string6 = mavenId.getArtifactId();
        if (string6 != null) {
            it = string6;
            string3 = string4;
            boolean bl = false;
            string2 = this.interpolateString(it, properties);
            string4 = string3;
        } else {
            string2 = null;
        }
        String string7 = mavenId.getVersion();
        if (string7 != null) {
            it = string7;
            String string8 = string2;
            string3 = string4;
            boolean bl = false;
            String string9 = this.interpolateString(it, properties);
            string4 = string3;
            string2 = string8;
            string = string9;
        } else {
            string = null;
        }
        String string10 = string;
        String string11 = string2;
        String string12 = string4;
        return new MavenId(string12, string11, string10);
    }

    @Override
    @Nullable
    public Object interpolate(@NotNull VirtualFile mavenModuleFile, @NotNull MavenModel model, @NotNull Continuation<? super MavenModel> $completion) {
        return MavenProjectModelServerModelReadHelper.interpolate$suspendImpl(this, mavenModuleFile, model, $completion);
    }

    static /* synthetic */ Object interpolate$suspendImpl(MavenProjectModelServerModelReadHelper $this, VirtualFile mavenModuleFile, MavenModel model, Continuation<? super MavenModel> $completion) {
        MavenModel mavenModel;
        if (!$this.needInterpolate(model.getMavenId())) {
            MavenParent mavenParent = model.getParent();
            if (!$this.needInterpolate((MavenId)(mavenParent != null ? mavenParent.getMavenId() : null))) {
                return model;
            }
        }
        HashMap<String, String> properties = new HashMap<String, String>();
        Path basedir = MavenUtil.getBaseDir(mavenModuleFile);
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isRegularFile(basedir, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            properties.putAll(MavenServerConfigUtil.getMavenAndJvmConfigPropertiesForBaseDir((Path)basedir));
        }
        Set<Object> set = model.getProperties().keySet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object k = element$iv = iterator.next();
            boolean bl = false;
            ((Map)properties).put(k.toString(), model.getProperties().getProperty(k.toString()));
        }
        MavenModel $this$interpolate_u24lambda_u241 = mavenModel = model.copy();
        boolean bl = false;
        $this$interpolate_u24lambda_u241.setMavenId($this.interpolateMavenId(model.getMavenId(), properties));
        MavenParent mavenParent = model.getParent();
        MavenParent mavenParent2 = $this$interpolate_u24lambda_u241.getParent();
        $this$interpolate_u24lambda_u241.setParent(new MavenParent($this.interpolateMavenId((MavenId)(mavenParent != null ? mavenParent.getMavenId() : null), properties), mavenParent2 != null ? mavenParent2.getRelativePath() : null));
        MavenModel mavenModel2 = mavenModel;
        Intrinsics.checkNotNullExpressionValue((Object)mavenModel2, (String)"apply(...)");
        return mavenModel2;
    }

    @Override
    @Nullable
    public Object assembleInheritance(@NotNull MavenModel parentModel, @NotNull MavenModel model, @NotNull VirtualFile file2, @NotNull Continuation<? super MavenModel> $completion) {
        return MavenProjectModelServerModelReadHelper.assembleInheritance$suspendImpl(this, parentModel, model, file2, $completion);
    }

    static /* synthetic */ Object assembleInheritance$suspendImpl(MavenProjectModelServerModelReadHelper $this, MavenModel parentModel, MavenModel model, VirtualFile file2, Continuation<? super MavenModel> $completion) {
        Properties properties = new Properties();
        properties.putAll((Map<?, ?>)parentModel.getProperties());
        properties.putAll((Map<?, ?>)model.getProperties());
        model.setProperties(properties);
        return model;
    }
}

