/*
 * Decompiled with CFR 0.152.
 */
package liquibase.command.core.helpers;

import java.util.Collections;
import java.util.List;
import liquibase.Beta;
import liquibase.Scope;
import liquibase.command.CleanUpCommandStep;
import liquibase.command.CommandArgumentDefinition;
import liquibase.command.CommandBuilder;
import liquibase.command.CommandResultsBuilder;
import liquibase.command.CommandScope;
import liquibase.command.CommonArgumentNames;
import liquibase.command.core.helpers.AbstractDatabaseConnectionCommandStep;
import liquibase.configuration.ConfigurationValueObfuscator;
import liquibase.database.Database;
import liquibase.exception.DatabaseException;

public class DbUrlConnectionCommandStep
extends AbstractDatabaseConnectionCommandStep
implements CleanUpCommandStep {
    protected static final String[] COMMAND_NAME = new String[]{"dbUrlConnectionCommandStep"};
    public static final CommandArgumentDefinition<Database> DATABASE_ARG;
    public static final CommandArgumentDefinition<String> URL_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_SCHEMA_NAME_ARG;
    public static final CommandArgumentDefinition<String> DEFAULT_CATALOG_NAME_ARG;
    public static final CommandArgumentDefinition<String> USERNAME_ARG;
    public static final CommandArgumentDefinition<String> PASSWORD_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_ARG;
    public static final CommandArgumentDefinition<String> DRIVER_PROPERTIES_FILE_ARG;
    @Deprecated
    @Beta
    public static final CommandArgumentDefinition<Boolean> SKIP_DATABASE_STEP_ARG;

    @Override
    public void run(CommandResultsBuilder resultsBuilder) throws Exception {
        CommandScope commandScope = resultsBuilder.getCommandScope();
        if (commandScope.getArgumentValue(SKIP_DATABASE_STEP_ARG).booleanValue()) {
            return;
        }
        commandScope.provideDependency(Database.class, this.obtainDatabase(commandScope));
    }

    @Override
    public List<Class<?>> providedDependencies() {
        return Collections.singletonList(Database.class);
    }

    public Database obtainDatabase(CommandScope commandScope) throws DatabaseException {
        if (commandScope.getArgumentValue(DATABASE_ARG) == null) {
            String url = commandScope.getArgumentValue(URL_ARG);
            String username = commandScope.getArgumentValue(USERNAME_ARG);
            String password = commandScope.getArgumentValue(PASSWORD_ARG);
            String defaultSchemaName = commandScope.getArgumentValue(DEFAULT_SCHEMA_NAME_ARG);
            String defaultCatalogName = commandScope.getArgumentValue(DEFAULT_CATALOG_NAME_ARG);
            String driver = commandScope.getArgumentValue(DRIVER_ARG);
            String driverPropertiesFile = commandScope.getArgumentValue(DRIVER_PROPERTIES_FILE_ARG);
            Database database = this.createDatabaseObject(url, username, password, defaultSchemaName, defaultCatalogName, driver, driverPropertiesFile);
            DbUrlConnectionCommandStep.logMdc(url, database);
            return database;
        }
        return commandScope.getArgumentValue(DATABASE_ARG);
    }

    public static void logMdc(String url, Database database) {
        Scope.getCurrentScope().addMdcValue("liquibaseTargetUrl", url);
        Scope.getCurrentScope().addMdcValue("liquibaseCatalogName", database.getLiquibaseCatalogName());
        Scope.getCurrentScope().addMdcValue("liquibaseSchemaName", database.getLiquibaseSchemaName());
    }

    @Override
    public String[][] defineCommandNames() {
        return new String[][]{COMMAND_NAME};
    }

    static {
        CommandBuilder builder = new CommandBuilder(new String[][]{COMMAND_NAME});
        DEFAULT_SCHEMA_NAME_ARG = builder.argument("defaultSchemaName", String.class).description("The default schema name to use for the database connection").build();
        DEFAULT_CATALOG_NAME_ARG = builder.argument("defaultCatalogName", String.class).description("The default catalog name to use for the database connection").build();
        DRIVER_ARG = builder.argument("driver", String.class).description("The JDBC driver class").build();
        DRIVER_PROPERTIES_FILE_ARG = builder.argument("driverPropertiesFile", String.class).description("The JDBC driver properties file").build();
        USERNAME_ARG = builder.argument(CommonArgumentNames.USERNAME, String.class).description("Username to use to connect to the database").build();
        PASSWORD_ARG = builder.argument(CommonArgumentNames.PASSWORD, String.class).description("Password to use to connect to the database").setValueObfuscator(ConfigurationValueObfuscator.STANDARD).build();
        DATABASE_ARG = builder.argument("database", Database.class).hidden().build();
        URL_ARG = builder.argument(CommonArgumentNames.URL, String.class).required().supersededBy(DATABASE_ARG).description("The JDBC database connection URL").build();
        DATABASE_ARG.setSupersededBy(URL_ARG);
        SKIP_DATABASE_STEP_ARG = builder.argument("skipDatabaseStep", Boolean.class).hidden().defaultValue(false).build();
    }
}

