/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.runners;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.ExecutionTargetManager;
import com.intellij.execution.Executor;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationPerRunnerSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionEnvironmentProvider;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 +2\u00020\u0001:\u0001+B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0006\u0010\nJ\u0010\u0010\r\u001a\u00020\u00002\b\u0010\r\u001a\u0004\u0018\u00010\u000eJ\u0006\u0010#\u001a\u00020\u0000J\u001a\u0010$\u001a\u00020\u00002\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u00192\u0006\u0010%\u001a\u00020\u0017J\u0010\u0010\u0010\u001a\u00020\u00002\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u0010\u0010\u0014\u001a\u00020\u00002\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015J\u000e\u0010\u000b\u001a\u00020\u00002\u0006\u0010\u000b\u001a\u00020\fJ\u0012\u0010\u0018\u001a\u00020\u00002\n\u0010\u0018\u001a\u0006\u0012\u0002\b\u00030\u0019J\u0010\u0010\u001d\u001a\u00020\u00002\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u000e\u0010\u0004\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u000e\u0010\u001a\u001a\u00020\u00002\u0006\u0010\u001a\u001a\u00020\u001bJ\u000e\u0010!\u001a\u00020\u00002\u0006\u0010!\u001a\u00020\"J\u0014\u0010&\u001a\u00020\t2\n\b\u0002\u0010'\u001a\u0004\u0018\u00010(H\u0007J\u0006\u0010)\u001a\u00020*R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\r\u001a\n \u000f*\u0004\u0018\u00010\u000e0\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0019X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u001bX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u001cR\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006,"}, d2={"Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder;", "", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Lcom/intellij/execution/Executor;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/execution/Executor;)V", "env", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "(Lcom/intellij/execution/runners/ExecutionEnvironment;)V", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "target", "Lcom/intellij/execution/ExecutionTarget;", "kotlin.jvm.PlatformType", "runnerSettings", "Lcom/intellij/execution/configurations/RunnerSettings;", "configurationSettings", "Lcom/intellij/execution/configurations/ConfigurationPerRunnerSettings;", "contentToReuse", "Lcom/intellij/execution/ui/RunContentDescriptor;", "runnerAndConfigurationSettings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "runner", "Lcom/intellij/execution/runners/ProgramRunner;", "executionId", "", "Ljava/lang/Long;", "dataContext", "Lcom/intellij/openapi/actionSystem/DataContext;", "userData", "Lcom/intellij/openapi/util/UserDataHolderBase;", "modulePath", "", "activeTarget", "runnerAndSettings", "settings", "build", "callback", "Lcom/intellij/execution/runners/ProgramRunner$Callback;", "buildAndExecute", "", "Companion", "intellij.platform.execution"})
public final class ExecutionEnvironmentBuilder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Project project;
    @NotNull
    private Executor executor;
    @Nullable
    private RunProfile runProfile;
    private ExecutionTarget target;
    @Nullable
    private RunnerSettings runnerSettings;
    @Nullable
    private ConfigurationPerRunnerSettings configurationSettings;
    @Nullable
    private RunContentDescriptor contentToReuse;
    @Nullable
    private RunnerAndConfigurationSettings runnerAndConfigurationSettings;
    @Nullable
    private ProgramRunner<?> runner;
    @Nullable
    private Long executionId;
    @Nullable
    private DataContext dataContext;
    @NotNull
    private final UserDataHolderBase userData;
    @Nullable
    private String modulePath;

    public ExecutionEnvironmentBuilder(@NotNull Project project, @NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.project = project;
        this.executor = executor;
        this.target = DefaultExecutionTarget.INSTANCE;
        this.userData = new UserDataHolderBase();
    }

    public ExecutionEnvironmentBuilder(@NotNull ExecutionEnvironment env) {
        Intrinsics.checkNotNullParameter((Object)((Object)env), (String)"env");
        Project project = env.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Executor executor = env.getExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor, (String)"getExecutor(...)");
        this(project, executor);
        this.target = env.getExecutionTarget();
        this.runnerAndConfigurationSettings = env.getRunnerAndConfigurationSettings();
        this.runProfile = env.getRunProfile();
        this.runnerSettings = env.getRunnerSettings();
        this.configurationSettings = env.getConfigurationSettings();
        this.runner = env.getRunner();
        this.contentToReuse = env.getContentToReuse();
        env.copyUserDataTo(this.userData);
    }

    @NotNull
    public final ExecutionEnvironmentBuilder target(@Nullable ExecutionTarget target) {
        if (target != null) {
            this.target = target;
        }
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder activeTarget() {
        this.target = ExecutionTargetManager.getActiveTarget(this.project);
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runnerAndSettings(@NotNull ProgramRunner<?> runner, @NotNull RunnerAndConfigurationSettings settings) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.runnerAndConfigurationSettings = settings;
        this.runProfile = settings.getConfiguration();
        this.runnerSettings = settings.getRunnerSettings(runner);
        this.configurationSettings = settings.getConfigurationSettings(runner);
        this.runner = runner;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runnerSettings(@Nullable RunnerSettings runnerSettings) {
        this.runnerSettings = runnerSettings;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder contentToReuse(@Nullable RunContentDescriptor contentToReuse) {
        this.contentToReuse = contentToReuse;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runProfile(@NotNull RunProfile runProfile) {
        Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
        this.runProfile = runProfile;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder runner(@NotNull ProgramRunner<?> runner) {
        Intrinsics.checkNotNullParameter(runner, (String)"runner");
        this.runner = runner;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder dataContext(@Nullable DataContext dataContext) {
        this.dataContext = dataContext;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder executor(@NotNull Executor executor) {
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        this.executor = executor;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder executionId(long executionId) {
        this.executionId = executionId;
        return this;
    }

    @NotNull
    public final ExecutionEnvironmentBuilder modulePath(@NotNull String modulePath) {
        Intrinsics.checkNotNullParameter((Object)modulePath, (String)"modulePath");
        this.modulePath = modulePath;
        return this;
    }

    @JvmOverloads
    @NotNull
    public final ExecutionEnvironment build(@Nullable ProgramRunner.Callback callback) {
        ExecutionEnvironment environment = null;
        ExecutionEnvironmentProvider environmentProvider = (ExecutionEnvironmentProvider)this.project.getService(ExecutionEnvironmentProvider.class);
        if (environmentProvider != null) {
            RunProfile runProfile = this.runProfile;
            Intrinsics.checkNotNull((Object)runProfile);
            environment = environmentProvider.createExecutionEnvironment(this.project, runProfile, this.executor, this.target, this.runnerSettings, this.configurationSettings, this.runnerAndConfigurationSettings);
        }
        if (environment == null && this.runner == null) {
            String string = this.executor.getId();
            RunProfile runProfile = this.runProfile;
            Intrinsics.checkNotNull((Object)runProfile);
            this.runner = ProgramRunner.getRunner(string, runProfile);
        }
        if (environment == null && this.runner == null) {
            throw new IllegalStateException("Runner must be specified");
        }
        if (environment == null) {
            RunProfile runProfile = this.runProfile;
            Intrinsics.checkNotNull((Object)runProfile);
            ProgramRunner<?> programRunner = this.runner;
            Intrinsics.checkNotNull(programRunner);
            environment = new ExecutionEnvironment(runProfile, this.executor, this.target, this.project, this.runnerSettings, this.configurationSettings, this.contentToReuse, this.runnerAndConfigurationSettings, programRunner, callback);
        }
        if (this.executionId != null) {
            Long l = this.executionId;
            Intrinsics.checkNotNull((Object)l);
            environment.setExecutionId(l);
        }
        if (this.dataContext != null) {
            DataContext dataContext = this.dataContext;
            Intrinsics.checkNotNull((Object)dataContext);
            environment.setDataContext(dataContext);
        }
        if (this.modulePath != null) {
            String string = this.modulePath;
            Intrinsics.checkNotNull((Object)string);
            environment.setModulePath(string);
        }
        this.userData.copyUserDataTo((UserDataHolderBase)environment);
        return environment;
    }

    public static /* synthetic */ ExecutionEnvironment build$default(ExecutionEnvironmentBuilder executionEnvironmentBuilder, ProgramRunner.Callback callback, int n, Object object) {
        if ((n & 1) != 0) {
            callback = null;
        }
        return executionEnvironmentBuilder.build(callback);
    }

    public final void buildAndExecute() throws ExecutionException {
        ExecutionEnvironment environment = ExecutionEnvironmentBuilder.build$default(this, null, 1, null);
        ProgramRunner<?> programRunner = this.runner;
        Intrinsics.checkNotNull(programRunner);
        programRunner.execute(environment);
    }

    @JvmOverloads
    @NotNull
    public final ExecutionEnvironment build() {
        return ExecutionEnvironmentBuilder.build$default(this, null, 1, null);
    }

    @JvmStatic
    @NotNull
    public static final ExecutionEnvironmentBuilder create(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) throws ExecutionException {
        return Companion.create(project, executor, runProfile);
    }

    @JvmStatic
    @Nullable
    public static final ExecutionEnvironmentBuilder createOrNull(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) {
        return Companion.createOrNull(project, executor, runProfile);
    }

    @JvmStatic
    @Nullable
    public static final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
        return Companion.createOrNull(executor, settings);
    }

    @JvmStatic
    @Nullable
    public static final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        return Companion.createOrNull(executor, configuration);
    }

    @JvmStatic
    @NotNull
    public static final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) throws ExecutionException {
        return Companion.create(executor, settings);
    }

    @JvmStatic
    @NotNull
    public static final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
        return Companion.create(executor, configuration);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\"\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007\u00a8\u0006\u0011"}, d2={"Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder$Companion;", "", "<init>", "()V", "create", "Lcom/intellij/execution/runners/ExecutionEnvironmentBuilder;", "project", "Lcom/intellij/openapi/project/Project;", "executor", "Lcom/intellij/execution/Executor;", "runProfile", "Lcom/intellij/execution/configurations/RunProfile;", "createOrNull", "settings", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "configuration", "Lcom/intellij/execution/configurations/RunConfiguration;", "intellij.platform.execution"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExecutionEnvironmentBuilder create(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
            ExecutionEnvironmentBuilder executionEnvironmentBuilder = this.createOrNull(project, executor, runProfile);
            if (executionEnvironmentBuilder == null) {
                Object[] objectArray = new Object[]{runProfile.getName()};
                throw new ExecutionException(ExecutionBundle.message("dialog.message.cannot.find.runner", objectArray));
            }
            return executionEnvironmentBuilder;
        }

        @JvmStatic
        @Nullable
        public final ExecutionEnvironmentBuilder createOrNull(@NotNull Project project, @NotNull Executor executor, @NotNull RunProfile runProfile) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)runProfile, (String)"runProfile");
            ProgramRunner<RunnerSettings> programRunner = ProgramRunner.getRunner(executor.getId(), runProfile);
            if (programRunner == null) {
                return null;
            }
            ProgramRunner<RunnerSettings> runner = programRunner;
            return new ExecutionEnvironmentBuilder(project, executor).runner(runner).runProfile(runProfile);
        }

        @JvmStatic
        @Nullable
        public final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) {
            ExecutionEnvironmentBuilder executionEnvironmentBuilder;
            ExecutionEnvironmentBuilder builder;
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            ExecutionEnvironmentBuilder executionEnvironmentBuilder2 = builder = this.createOrNull(executor, runConfiguration);
            if (executionEnvironmentBuilder2 != null) {
                ProgramRunner programRunner = builder.runner;
                Intrinsics.checkNotNull((Object)programRunner);
                executionEnvironmentBuilder = executionEnvironmentBuilder2.runnerAndSettings(programRunner, settings);
            } else {
                executionEnvironmentBuilder = null;
            }
            return executionEnvironmentBuilder;
        }

        @JvmStatic
        @Nullable
        public final ExecutionEnvironmentBuilder createOrNull(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
            ExecutionEnvironmentBuilder builder;
            block0: {
                Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
                Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
                Project project = configuration.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                ExecutionEnvironmentBuilder executionEnvironmentBuilder = builder = this.createOrNull(project, executor, configuration);
                if (executionEnvironmentBuilder == null) break block0;
                executionEnvironmentBuilder.runProfile(configuration);
            }
            return builder;
        }

        @JvmStatic
        @NotNull
        public final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunnerAndConfigurationSettings settings) throws ExecutionException {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            RunConfiguration runConfiguration = settings.getConfiguration();
            Intrinsics.checkNotNullExpressionValue((Object)runConfiguration, (String)"getConfiguration(...)");
            RunConfiguration configuration = runConfiguration;
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            ExecutionEnvironmentBuilder builder = this.create(project, executor, configuration);
            ProgramRunner programRunner = builder.runner;
            Intrinsics.checkNotNull((Object)programRunner);
            return builder.runnerAndSettings(programRunner, settings);
        }

        @JvmStatic
        @NotNull
        public final ExecutionEnvironmentBuilder create(@NotNull Executor executor, @NotNull RunConfiguration configuration) {
            Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
            Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
            Project project = configuration.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
            return new ExecutionEnvironmentBuilder(project, executor).runProfile(configuration);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

