/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.wsl;

import com.intellij.execution.wsl.AbstractWslDistribution;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.Disposer;
import java.nio.file.Path;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\"\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0004\u001a\u0012\u0010\u0005\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u0001\u001a\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u00012\u0006\u0010\n\u001a\u00020\u000bH\u0007\"\u0010\u0010\u0007\u001a\u0004\u0018\u00010\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"getWslPathSafe", "", "Lcom/intellij/execution/wsl/AbstractWslDistribution;", "path", "Ljava/nio/file/Path;", "getToolLinuxPath", "toolName", "testOverrideWslToolRoot", "", "linuxPath", "disposable", "Lcom/intellij/openapi/Disposable;", "intellij.platform.execution"})
public final class AbstractWslDistributionKt {
    @Nullable
    private static String testOverrideWslToolRoot;

    @NotNull
    public static final String getWslPathSafe(@NotNull AbstractWslDistribution $this$getWslPathSafe, @NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)$this$getWslPathSafe, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String string = $this$getWslPathSafe.getWslPath(path);
        if (string == null) {
            throw new Exception("Can't access from Linux: " + path);
        }
        return string;
    }

    @NotNull
    public static final String getToolLinuxPath(@NotNull AbstractWslDistribution $this$getToolLinuxPath, @NotNull String toolName) {
        Intrinsics.checkNotNullParameter((Object)$this$getToolLinuxPath, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)toolName, (String)"toolName");
        Object object = testOverrideWslToolRoot;
        if (object == null || (object = (String)object + "/" + toolName) == null) {
            Path path = PathManager.findBinFileWithException((String)toolName);
            Intrinsics.checkNotNullExpressionValue((Object)path, (String)"findBinFileWithException(...)");
            object = AbstractWslDistributionKt.getWslPathSafe($this$getToolLinuxPath, path);
        }
        return object;
    }

    @TestOnly
    public static final void testOverrideWslToolRoot(@NotNull String linuxPath, @NotNull Disposable disposable) {
        Intrinsics.checkNotNullParameter((Object)linuxPath, (String)"linuxPath");
        Intrinsics.checkNotNullParameter((Object)disposable, (String)"disposable");
        if (!(!StringsKt.endsWith$default((String)linuxPath, (String)"/", (boolean)false, (int)2, null))) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        Disposer.register((Disposable)disposable, AbstractWslDistributionKt::testOverrideWslToolRoot$lambda$0);
        testOverrideWslToolRoot = linuxPath;
    }

    private static final void testOverrideWslToolRoot$lambda$0() {
        testOverrideWslToolRoot = null;
    }
}

