/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.Formatter;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class Indent {
    @NotNull
    public abstract Type getType();

    public static Indent getNormalIndent() {
        return Formatter.getInstance().getNormalIndent(false);
    }

    public static Indent getNormalIndent(boolean relativeToDirectParent) {
        return Formatter.getInstance().getNormalIndent(relativeToDirectParent);
    }

    public static Indent getNoneIndent() {
        return Formatter.getInstance().getNoneIndent();
    }

    public static Indent getAbsoluteNoneIndent() {
        return Formatter.getInstance().getAbsoluteNoneIndent();
    }

    public static Indent getAbsoluteLabelIndent() {
        return Formatter.getInstance().getAbsoluteLabelIndent();
    }

    public static Indent getLabelIndent() {
        return Formatter.getInstance().getLabelIndent();
    }

    public static Indent getContinuationIndent() {
        return Formatter.getInstance().getContinuationIndent(false);
    }

    public static Indent getContinuationIndent(boolean relativeToDirectParent) {
        return Formatter.getInstance().getContinuationIndent(relativeToDirectParent);
    }

    public static Indent getContinuationWithoutFirstIndent() {
        return Formatter.getInstance().getContinuationWithoutFirstIndent(false);
    }

    public static Indent getContinuationWithoutFirstIndent(boolean relativeToDirectParent) {
        return Formatter.getInstance().getContinuationWithoutFirstIndent(relativeToDirectParent);
    }

    public static Indent getSpaceIndent(int spaces) {
        return Formatter.getInstance().getSpaceIndent(spaces, false);
    }

    public static Indent getSpaceIndent(int spaces, boolean relativeToDirectParent) {
        return Formatter.getInstance().getSpaceIndent(spaces, relativeToDirectParent);
    }

    public static Indent getIndent(@NotNull Type type, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            Indent.$$$reportNull$$$0(0);
        }
        return Formatter.getInstance().getIndent(type, relativeToDirectParent, enforceIndentToChildren);
    }

    public static Indent getIndent(@NotNull Type type, int spaces, boolean relativeToDirectParent, boolean enforceIndentToChildren) {
        if (type == null) {
            Indent.$$$reportNull$$$0(1);
        }
        return Formatter.getInstance().getIndent(type, spaces, relativeToDirectParent, enforceIndentToChildren);
    }

    public static Indent getSmartIndent(Type type) {
        return Formatter.getInstance().getSmartIndent(type);
    }

    public static Indent getSmartIndent(Type type, boolean relativeToDirectParent) {
        return Formatter.getInstance().getSmartIndent(type, relativeToDirectParent);
    }

    @ApiStatus.Experimental
    public static Indent getIndentEnforcedToChildrenToBeRelativeToMe(@NotNull Type type, int spaces) {
        if (type == null) {
            Indent.$$$reportNull$$$0(2);
        }
        return Formatter.getInstance().getIndentEnforcedToChildrenToBeRelativeToMe(type, spaces);
    }

    @ApiStatus.Experimental
    public static Indent getIndentEnforcedToChildrenToBeRelativeToMe() {
        return Formatter.getInstance().getIndentEnforcedToChildrenToBeRelativeToMe(Type.NONE, 0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "type";
        objectArray2[1] = "com/intellij/formatting/Indent";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndent";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getIndentEnforcedToChildrenToBeRelativeToMe";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static final class Type {
        private final String myName;
        public static final Type SPACES = new Type("SPACES");
        public static final Type NONE = new Type("NONE");
        public static final Type LABEL = new Type("LABEL");
        public static final Type NORMAL = new Type("NORMAL");
        public static final Type CONTINUATION = new Type("CONTINUATION");
        public static final Type CONTINUATION_WITHOUT_FIRST = new Type("CONTINUATION_WITHOUT_FIRST");
        @ApiStatus.Experimental
        public static final Type OUTDENT_NORMAL = new Type("OUTDENT_NORMAL");
        @ApiStatus.Experimental
        public static final Type OUTDENT_SPACES = new Type("OUTDENT_SPACES");

        private Type(@NonNls String name) {
            this.myName = name;
        }

        public String toString() {
            return this.myName;
        }
    }
}

