/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkOccurrence;
import com.intellij.ide.bookmark.BookmarksListener;
import com.intellij.ide.bookmark.ui.BookmarksView;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J!\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00100\u0012H\u0000\u00a2\u0006\u0002\b\u0014J\u001c\u0010\u001c\u001a\u00020\u00102\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u00020\u00100\u0012H\u0002J\b\u0010\u001e\u001a\u00020\u0010H\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010#\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010$\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!H\u0016J\u0018\u0010%\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010(\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\u0018\u0010)\u001a\u00020\u00102\u0006\u0010 \u001a\u00020!2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010&\u001a\u00020'H\u0016J\u001c\u0010+\u001a\u00020\u00102\b\u0010,\u001a\u0004\u0018\u00010!2\b\u0010-\u001a\u0004\u0018\u00010!H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\u0004\u0018\u00010\u00018BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\"\u0010\u0015\u001a\n\u0012\u0004\u0012\u00020\u0017\u0018\u00010\u0016X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0018\u0010\u0019\"\u0004\b\u001a\u0010\u001b\u00a8\u0006."}, d2={"Lcom/intellij/ide/bookmark/ModificationNotifier;", "Lcom/intellij/ide/bookmark/BookmarksListener;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "modification", "Ljava/util/concurrent/atomic/AtomicLong;", "count", "", "getCount", "()J", "publisher", "getPublisher", "()Lcom/intellij/ide/bookmark/BookmarksListener;", "selectLater", "", "select", "Lkotlin/Function1;", "Lcom/intellij/ide/bookmark/ui/BookmarksView;", "selectLater$intellij_platform_bookmarks", "snapshot", "", "Lcom/intellij/ide/bookmark/BookmarkOccurrence;", "getSnapshot$intellij_platform_bookmarks", "()Ljava/util/List;", "setSnapshot$intellij_platform_bookmarks", "(Ljava/util/List;)V", "notifyLater", "notify", "groupsSorted", "groupAdded", "group", "Lcom/intellij/ide/bookmark/BookmarkGroup;", "groupRemoved", "groupRenamed", "bookmarksSorted", "bookmarkAdded", "bookmark", "Lcom/intellij/ide/bookmark/Bookmark;", "bookmarkRemoved", "bookmarkChanged", "bookmarkTypeChanged", "defaultGroupChanged", "old", "new", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nModificationNotifier.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ModificationNotifier.kt\ncom/intellij/ide/bookmark/ModificationNotifier\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,48:1\n1#2:49\n*E\n"})
public final class ModificationNotifier
implements BookmarksListener {
    @NotNull
    private final Project project;
    @NotNull
    private final AtomicLong modification;
    @Nullable
    private List<BookmarkOccurrence> snapshot;

    public ModificationNotifier(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
        this.modification = new AtomicLong();
    }

    public final long getCount() {
        return this.modification.get();
    }

    private final BookmarksListener getPublisher() {
        BookmarksListener bookmarksListener;
        if (!this.project.isOpen() || this.project.isDisposed()) {
            bookmarksListener = null;
        } else {
            MessageBus messageBus = this.project.getMessageBus();
            Topic topic = BookmarksListener.TOPIC;
            Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
            bookmarksListener = (BookmarksListener)messageBus.syncPublisher(topic);
        }
        return bookmarksListener;
    }

    public final void selectLater$intellij_platform_bookmarks(@NotNull Function1<? super BookmarksView, Unit> select) {
        Intrinsics.checkNotNullParameter(select, (String)"select");
        ActionsKt.invokeLater$default(null, () -> ModificationNotifier.selectLater$lambda$0(this, select), (int)1, null);
    }

    @Nullable
    public final List<BookmarkOccurrence> getSnapshot$intellij_platform_bookmarks() {
        return this.snapshot;
    }

    public final void setSnapshot$intellij_platform_bookmarks(@Nullable List<BookmarkOccurrence> list2) {
        this.snapshot = list2;
    }

    private final void notifyLater(Function1<? super BookmarksListener, Unit> notify) {
        this.snapshot = null;
        this.modification.incrementAndGet();
        ActionsKt.invokeLater$default(null, () -> ModificationNotifier.notifyLater$lambda$0(this, notify), (int)1, null);
    }

    public void groupsSorted() {
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)ModificationNotifier::groupsSorted$lambda$0));
    }

    public void groupAdded(@NotNull BookmarkGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.groupAdded$lambda$0(group, arg_0)));
    }

    public void groupRemoved(@NotNull BookmarkGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.groupRemoved$lambda$0(group, arg_0)));
    }

    public void groupRenamed(@NotNull BookmarkGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.groupRenamed$lambda$0(group, arg_0)));
    }

    public void bookmarksSorted(@NotNull BookmarkGroup group) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.bookmarksSorted$lambda$0(group, arg_0)));
    }

    public void bookmarkAdded(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.bookmarkAdded$lambda$0(group, bookmark, arg_0)));
    }

    public void bookmarkRemoved(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.bookmarkRemoved$lambda$0(group, bookmark, arg_0)));
    }

    public void bookmarkChanged(@NotNull BookmarkGroup group, @NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)group, (String)"group");
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.bookmarkChanged$lambda$0(group, bookmark, arg_0)));
    }

    public void bookmarkTypeChanged(@NotNull Bookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.bookmarkTypeChanged$lambda$0(bookmark, arg_0)));
    }

    public void defaultGroupChanged(@Nullable BookmarkGroup old, @Nullable BookmarkGroup bookmarkGroup) {
        this.notifyLater((Function1<? super BookmarksListener, Unit>)((Function1)arg_0 -> ModificationNotifier.defaultGroupChanged$lambda$0(old, bookmarkGroup, arg_0)));
    }

    private static final Unit selectLater$lambda$0(ModificationNotifier this$0, Function1 $select) {
        block1: {
            BookmarksView view;
            ToolWindow window = this$0.project.isDisposed() ? null : ToolWindowManager.Companion.getInstance(this$0.project).getToolWindow("Bookmarks");
            ToolWindow window1 = window;
            ToolWindow toolWindow = window1;
            JComponent jComponent = toolWindow != null && (toolWindow = toolWindow.getContentManagerIfCreated()) != null && (toolWindow = toolWindow.getSelectedContent()) != null ? toolWindow.getComponent() : null;
            BookmarksView bookmarksView = view = jComponent instanceof BookmarksView ? (BookmarksView)((Object)jComponent) : null;
            if (bookmarksView == null) break block1;
            BookmarksView it = bookmarksView;
            boolean bl = false;
            if (it.isShowing()) {
                $select.invoke((Object)it);
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit notifyLater$lambda$0(ModificationNotifier this$0, Function1 $notify) {
        block0: {
            BookmarksListener bookmarksListener = this$0.getPublisher();
            if (bookmarksListener == null) break block0;
            $notify.invoke((Object)bookmarksListener);
        }
        return Unit.INSTANCE;
    }

    private static final Unit groupsSorted$lambda$0(BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.groupsSorted();
        return Unit.INSTANCE;
    }

    private static final Unit groupAdded$lambda$0(BookmarkGroup $group, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.groupAdded($group);
        return Unit.INSTANCE;
    }

    private static final Unit groupRemoved$lambda$0(BookmarkGroup $group, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.groupRemoved($group);
        return Unit.INSTANCE;
    }

    private static final Unit groupRenamed$lambda$0(BookmarkGroup $group, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.groupRenamed($group);
        return Unit.INSTANCE;
    }

    private static final Unit bookmarksSorted$lambda$0(BookmarkGroup $group, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.bookmarksSorted($group);
        return Unit.INSTANCE;
    }

    private static final Unit bookmarkAdded$lambda$0(BookmarkGroup $group, Bookmark $bookmark, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.bookmarkAdded($group, $bookmark);
        return Unit.INSTANCE;
    }

    private static final Unit bookmarkRemoved$lambda$0(BookmarkGroup $group, Bookmark $bookmark, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.bookmarkRemoved($group, $bookmark);
        return Unit.INSTANCE;
    }

    private static final Unit bookmarkChanged$lambda$0(BookmarkGroup $group, Bookmark $bookmark, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.bookmarkChanged($group, $bookmark);
        return Unit.INSTANCE;
    }

    private static final Unit bookmarkTypeChanged$lambda$0(Bookmark $bookmark, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.bookmarkTypeChanged($bookmark);
        return Unit.INSTANCE;
    }

    private static final Unit defaultGroupChanged$lambda$0(BookmarkGroup $old, BookmarkGroup $new, BookmarksListener it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        it.defaultGroupChanged($old, $new);
        return Unit.INSTANCE;
    }
}

