/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils.doc;

import com.intellij.lang.Language;
import com.intellij.markdown.utils.doc.impl.DocFlavourDescriptor;
import com.intellij.markdown.utils.doc.impl.DocTagRenderer;
import com.intellij.openapi.diagnostic.ControlFlowException;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ColorUtil;
import com.intellij.util.concurrency.annotations.RequiresReadLock;
import com.intellij.util.containers.CollectionFactory;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.flavours.MarkdownFlavourDescriptor;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.parser.MarkdownParser;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0010#\n\u0002\u0010\r\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J+\u0010\u001a\u001a\u00070\u000f\u00a2\u0006\u0002\b\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\b\b\u0001\u0010\u001e\u001a\u00020\u000f2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 H\u0007J\u0010\u0010!\u001a\u00020\u000f2\u0006\u0010\"\u001a\u00020\u000fH\u0002J\u001e\u0010#\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u000f0$H\u0002J\u0016\u0010&\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0$H\u0002J\u0010\u0010)\u001a\u00020'2\u0006\u0010*\u001a\u00020\u000fH\u0002J\u0016\u0010+\u001a\b\u0012\u0004\u0012\u00020\u000f0$2\u0006\u0010,\u001a\u00020\u000fH\u0002J@\u0010-\u001a\u00020\u000f2\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010.\u001a\u00020'2\f\u0010(\u001a\b\u0012\u0004\u0012\u00020\u000f0$2\u000e\u0010/\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010$H\u0002J \u00100\u001a\u00020\u000f2\u0006\u00101\u001a\u0002022\u000e\u00103\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010$H\u0002J\u0010\u00104\u001a\u00020\u000f2\u0006\u00105\u001a\u00020\u000fH\u0002J.\u00108\u001a\t\u0018\u00010\u000f\u00a2\u0006\u0002\b92\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010\u001f\u001a\u0004\u0018\u00010 2\u000b\u0010:\u001a\u00070\u000f\u00a2\u0006\u0002\b\u001bH\u0002J#\u0010;\u001a\u00070\u000f\u00a2\u0006\u0002\b92\u0006\u0010<\u001a\u00020\u000f2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020>0$H\u0002J\u0010\u0010?\u001a\u00020\u000f2\u0006\u0010@\u001a\u00020\u000fH\u0003R\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\u00020\bX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0010\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0016R\u000e\u00106\u001a\u000207X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010A\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\bB\u0010C\u00a8\u0006D"}, d2={"Lcom/intellij/markdown/utils/doc/DocMarkdownToHtmlConverter;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "TAG_START_OR_CLOSE_PATTERN", "Ljava/util/regex/Pattern;", "TAG_PATTERN", "getTAG_PATTERN$intellij_platform_markdown_utils", "()Ljava/util/regex/Pattern;", "FENCE_PATTERN", "Lkotlin/text/Regex;", "FENCED_CODE_BLOCK", "", "HTML_DOC_SUBSTITUTIONS", "", "ACCEPTABLE_BLOCK_TAGS", "", "", "getACCEPTABLE_BLOCK_TAGS$intellij_platform_markdown_utils", "()Ljava/util/Set;", "ACCEPTABLE_TAGS", "", "getACCEPTABLE_TAGS$intellij_platform_markdown_utils", "convert", "Lorg/jetbrains/annotations/Nls;", "project", "Lcom/intellij/openapi/project/Project;", "markdownText", "defaultLanguage", "Lcom/intellij/lang/Language;", "convertNewLinePlaceholdersToTags", "generatedDoc", "parseTableFormats", "", "cols", "isTableHeaderSeparator", "", "parts", "isHeaderSeparator", "s", "splitTableCols", "processedLine", "getProcessedRow", "isInTable", "tableFormats", "getAlign", "index", "", "formats", "parseFormat", "format", "embeddedHtmlType", "Lorg/intellij/markdown/IElementType;", "performConversion", "Lcom/intellij/openapi/util/NlsSafe;", "text", "replaceProhibitedTags", "line", "skipRanges", "Lcom/intellij/openapi/util/TextRange;", "adjustHtml", "html", "border", "getBorder", "()Ljava/lang/String;", "intellij.platform.markdown.utils"})
@SourceDebugExtension(value={"SMAP\nDocMarkdownToHtmlConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DocMarkdownToHtmlConverter.kt\ncom/intellij/markdown/utils/doc/DocMarkdownToHtmlConverter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n+ 5 Strings.kt\nkotlin/text/StringsKt__StringsKt\n*L\n1#1,272:1\n777#2:273\n873#2,2:274\n1786#2,3:329\n1#3:276\n161#4,6:277\n106#5:283\n78#5,22:284\n106#5:306\n78#5,22:307\n106#5:332\n78#5,22:333\n106#5:355\n78#5,22:356\n106#5:378\n78#5,22:379\n*S KotlinDebug\n*F\n+ 1 DocMarkdownToHtmlConverter.kt\ncom/intellij/markdown/utils/doc/DocMarkdownToHtmlConverter\n*L\n95#1:273\n95#1:274,2\n159#1:329,3\n96#1:277,6\n109#1:283\n109#1:284,22\n153#1:306\n153#1:307,22\n162#1:332\n162#1:333,22\n190#1:355\n190#1:356,22\n264#1:378\n264#1:379,22\n*E\n"})
public final class DocMarkdownToHtmlConverter {
    @NotNull
    public static final DocMarkdownToHtmlConverter INSTANCE;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Pattern TAG_START_OR_CLOSE_PATTERN;
    @NotNull
    private static final Pattern TAG_PATTERN;
    @NotNull
    private static final Regex FENCE_PATTERN;
    @NotNull
    private static final String FENCED_CODE_BLOCK = "```";
    @NotNull
    private static final Map<String, String> HTML_DOC_SUBSTITUTIONS;
    @NotNull
    private static final Set<CharSequence> ACCEPTABLE_BLOCK_TAGS;
    @NotNull
    private static final Set<CharSequence> ACCEPTABLE_TAGS;
    @NotNull
    private static final IElementType embeddedHtmlType;

    private DocMarkdownToHtmlConverter() {
    }

    @NotNull
    public final Pattern getTAG_PATTERN$intellij_platform_markdown_utils() {
        return TAG_PATTERN;
    }

    @NotNull
    public final Set<CharSequence> getACCEPTABLE_BLOCK_TAGS$intellij_platform_markdown_utils() {
        return ACCEPTABLE_BLOCK_TAGS;
    }

    @NotNull
    public final Set<CharSequence> getACCEPTABLE_TAGS$intellij_platform_markdown_utils() {
        return ACCEPTABLE_TAGS;
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @Contract(pure=true)
    @RequiresReadLock
    @JvmOverloads
    @NotNull
    public static final String convert(@NotNull Project project, @Nls @NotNull String markdownText, @Nullable Language defaultLanguage) {
        String string;
        Object object;
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        List lines = StringsKt.lines((CharSequence)markdownText);
        Iterable iterable = lines;
        boolean $i$f$filter22 = false;
        void var8_9 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            String p0 = (String)element$iv$iv;
            boolean bl = false;
            boolean bl2 = !StringsKt.isBlank((CharSequence)p0);
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterator $i$f$filter22 = ((Iterable)((List)destination$iv$iv)).iterator();
        if (!$i$f$filter22.hasNext()) {
            object = null;
        } else {
            int n;
            int it;
            Object line;
            block24: {
                line = (String)$i$f$filter22.next();
                boolean bl = false;
                CharSequence $this$indexOfFirst$iv = (CharSequence)line;
                boolean $i$f$indexOfFirst = false;
                int p0 = $this$indexOfFirst$iv.length();
                for (int index$iv = 0; index$iv < p0; ++index$iv) {
                    it = $this$indexOfFirst$iv.charAt(index$iv);
                    boolean bl3 = false;
                    if (!(!CharsKt.isWhitespace((char)it))) continue;
                    n = index$iv;
                    break block24;
                }
                n = -1;
            }
            int it2 = n;
            boolean bl = false;
            line = it2 == -1 ? ((String)line).length() : it2;
            while ($i$f$filter22.hasNext()) {
                int n2;
                Object line2;
                block25: {
                    line2 = (String)$i$f$filter22.next();
                    boolean bl4 = false;
                    CharSequence $this$indexOfFirst$iv = (CharSequence)line2;
                    boolean $i$f$indexOfFirst = false;
                    it = $this$indexOfFirst$iv.length();
                    for (int index$iv = 0; index$iv < it; ++index$iv) {
                        char it3 = $this$indexOfFirst$iv.charAt(index$iv);
                        boolean bl5 = false;
                        if (!(!CharsKt.isWhitespace((char)it3))) continue;
                        n2 = index$iv;
                        break block25;
                    }
                    n2 = -1;
                }
                int it4 = n2;
                $i$a$-let-DocMarkdownToHtmlConverter$convert$minCommonIndent$2$2 = false;
                line2 = it4 == -1 ? ((String)line2).length() : it4;
                if (line.compareTo(line2) <= 0) continue;
                line = line2;
            }
            object = line;
        }
        Integer n = (Integer)object;
        int minCommonIndent = n != null ? n : 0;
        ArrayList<String> processedLines = new ArrayList<String>(lines.size());
        boolean isInCode = false;
        boolean isInTable = false;
        List<String> tableFormats = null;
        int n3 = ((Collection)lines).size();
        for (int i = 0; i < n3; ++i) {
            String string2;
            CharSequence it = (String)lines.get(i);
            boolean bl = false;
            if (it.length() <= minCommonIndent) {
                string2 = "";
            } else {
                String string3 = it.substring(minCommonIndent);
                string2 = string3;
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
            }
            Object processedLine = string2;
            processedLine = ((Object)StringsKt.trimEnd((CharSequence)((CharSequence)processedLine))).toString();
            int count = StringUtil.getOccurrenceCount((String)processedLine, (String)FENCED_CODE_BLOCK);
            if (count > 0) {
                isInCode = count % 2 == 0 ? isInCode : !isInCode;
                it = (CharSequence)processedLine;
                if (FENCE_PATTERN.matches(it)) {
                    String $this$trim$iv = processedLine;
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it5 = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl6 = false;
                        boolean bl7 = match$iv$iv = Intrinsics.compare((int)it5, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    processedLine = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
            } else if (!isInCode) {
                int tableDelimiterIndex = StringsKt.indexOf$default((CharSequence)((CharSequence)processedLine), (char)'|', (int)0, (boolean)false, (int)6, null);
                if (tableDelimiterIndex != -1) {
                    if (!isInTable && i + 1 < lines.size()) {
                        tableFormats = INSTANCE.parseTableFormats(INSTANCE.splitTableCols((String)lines.get(i + 1)));
                    }
                    if (!ContainerUtil.isEmpty((Collection)tableFormats)) {
                        List<String> parts = INSTANCE.splitTableCols((String)processedLine);
                        if (INSTANCE.isTableHeaderSeparator(parts)) continue;
                        processedLine = INSTANCE.getProcessedRow(project, defaultLanguage, isInTable, parts, tableFormats);
                        if (!isInTable) {
                            processedLine = "<table style=\"border: 0px;\" cellspacing=\"0\">" + (String)processedLine;
                        }
                        isInTable = true;
                    }
                } else {
                    if (isInTable) {
                        processedLine = (String)processedLine + "</table>";
                    }
                    isInTable = false;
                    tableFormats = null;
                }
            }
            processedLines.add((String)processedLine);
        }
        String string4 = StringUtil.join((Collection)processedLines, (String)"\n");
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"join(...)");
        Object normalizedMarkdown = string4;
        if (isInTable) {
            normalizedMarkdown = (String)normalizedMarkdown + "</table>";
        }
        if ((string = INSTANCE.performConversion(project, defaultLanguage, (String)normalizedMarkdown)) == null || (string = ((Object)StringsKt.trimEnd((CharSequence)string)).toString()) == null) {
            String string5 = INSTANCE.convertNewLinePlaceholdersToTags(markdownText);
            List list2 = ContainerUtil.emptyList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"emptyList(...)");
            string = INSTANCE.adjustHtml(INSTANCE.replaceProhibitedTags(string5, list2));
        }
        return string;
    }

    public static /* synthetic */ String convert$default(Project project, String string, Language language, int n, Object object) {
        if ((n & 4) != 0) {
            language = null;
        }
        return DocMarkdownToHtmlConverter.convert(project, string, language);
    }

    private final String convertNewLinePlaceholdersToTags(String generatedDoc) {
        String string = StringUtil.replace((String)generatedDoc, (String)"\n", (String)"\n<p>");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"replace(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> parseTableFormats(List<String> cols) {
        ArrayList<String> formats = new ArrayList<String>();
        for (String col : cols) {
            void $this$trim$iv;
            if (!this.isHeaderSeparator(col)) {
                return null;
            }
            String string = col;
            DocMarkdownToHtmlConverter docMarkdownToHtmlConverter = this;
            ArrayList<String> arrayList = formats;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            arrayList.add(docMarkdownToHtmlConverter.parseFormat(string2));
        }
        return formats;
    }

    private final boolean isTableHeaderSeparator(List<String> parts) {
        boolean bl;
        block3: {
            Iterable $this$all$iv = parts;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    String it = (String)element$iv;
                    boolean bl2 = false;
                    if (INSTANCE.isHeaderSeparator(it)) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private final boolean isHeaderSeparator(String s) {
        String $this$trim$iv = s;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return StringsKt.removeSuffix((String)StringsKt.removePrefix((String)((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString(), (CharSequence)":"), (CharSequence)":").chars().allMatch(DocMarkdownToHtmlConverter::isHeaderSeparator$lambda$1);
    }

    private final List<String> splitTableCols(String processedLine) {
        ArrayList parts = new ArrayList(StringUtil.split((String)processedLine, (String)"|"));
        if (parts.isEmpty()) {
            return parts;
        }
        CharSequence charSequence = (CharSequence)parts.get(0);
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            parts.remove(0);
        }
        if (!parts.isEmpty() && ((charSequence = (CharSequence)parts.get(parts.size() - 1)) == null || StringsKt.isBlank((CharSequence)charSequence))) {
            parts.remove(parts.size() - 1);
        }
        return parts;
    }

    /*
     * WARNING - void declaration
     */
    private final String getProcessedRow(Project project, Language defaultLanguage, boolean isInTable, List<String> parts, List<String> tableFormats) {
        String openingTagStart = isInTable ? "<td style=\"" + this.getBorder() + "\" " : "<th style=\"" + this.getBorder() + "\" ";
        String closingTag = isInTable ? "</td>" : "</th>";
        StringBuilder resultBuilder = new StringBuilder("<tr style=\"" + this.getBorder() + "\">" + openingTagStart);
        resultBuilder.append("align=\"").append(this.getAlign(0, tableFormats)).append("\">");
        int n = ((Collection)parts).size();
        for (int i = 0; i < n; ++i) {
            void $this$trim$iv;
            if (i > 0) {
                resultBuilder.append(closingTag).append(openingTagStart).append("align=\"").append(this.getAlign(i, tableFormats)).append("\">");
            }
            String string = parts.get(i);
            Language language = defaultLanguage;
            Project project2 = project;
            DocMarkdownToHtmlConverter docMarkdownToHtmlConverter = this;
            StringBuilder stringBuilder = resultBuilder;
            boolean $i$f$trim = false;
            CharSequence $this$trim$iv$iv = (CharSequence)$this$trim$iv;
            boolean $i$f$trim2 = false;
            int startIndex$iv$iv = 0;
            int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
            boolean startFound$iv$iv = false;
            while (startIndex$iv$iv <= endIndex$iv$iv) {
                boolean match$iv$iv;
                int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                char it = $this$trim$iv$iv.charAt(index$iv$iv);
                boolean bl = false;
                boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                if (!startFound$iv$iv) {
                    if (!match$iv$iv) {
                        startFound$iv$iv = true;
                        continue;
                    }
                    ++startIndex$iv$iv;
                    continue;
                }
                if (!match$iv$iv) break;
                --endIndex$iv$iv;
            }
            String string2 = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
            stringBuilder.append(docMarkdownToHtmlConverter.performConversion(project2, language, string2));
        }
        resultBuilder.append(closingTag).append("</tr>");
        String string = resultBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getAlign(int index, List<String> formats) {
        return formats == null || index >= formats.size() ? "left" : formats.get(index);
    }

    private final String parseFormat(String format) {
        if (format.length() <= 1) {
            return "left";
        }
        char c0 = format.charAt(0);
        char cE = format.charAt(format.length() - 1);
        return c0 == ':' && cE == ':' ? "center" : (cE == ':' ? "right" : "left");
    }

    private final String performConversion(Project project, Language defaultLanguage, String text2) {
        try {
            DocFlavourDescriptor flavour = new DocFlavourDescriptor(project, defaultLanguage);
            ASTNode parsedTree = new MarkdownParser((MarkdownFlavourDescriptor)flavour).parse(embeddedHtmlType, text2, true);
            return new HtmlGenerator(text2, parsedTree, (MarkdownFlavourDescriptor)flavour, false).generateHtml((HtmlGenerator.TagRenderer)new DocTagRenderer(text2));
        }
        catch (Exception e) {
            if (e instanceof ControlFlowException) {
                throw e;
            }
            LOG.warn(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private final String replaceProhibitedTags(String line, List<? extends TextRange> skipRanges) {
        Matcher matcher = TAG_START_OR_CLOSE_PATTERN.matcher(line);
        StringBuilder builder = new StringBuilder(line);
        int diff = 0;
        block0: while (matcher.find()) {
            String tagName = matcher.group(2);
            if (ACCEPTABLE_TAGS.contains(tagName)) continue;
            int startOfTag = matcher.start(2);
            for (TextRange textRange : skipRanges) {
                if (!textRange.contains(startOfTag)) continue;
                continue block0;
            }
            int start = matcher.start(1) + diff;
            if (Intrinsics.areEqual((Object)StringUtil.toLowerCase((String)tagName), (Object)"div")) {
                String string = matcher.group(0);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
                boolean bl = !StringsKt.contains$default((CharSequence)string, (CharSequence)"/", (boolean)false, (int)2, null);
                int end = start + (bl ? 5 : 6);
                String replacement = bl ? "<span>" : "</span>";
                builder.replace(start, end, replacement);
                ++diff;
                continue;
            }
            builder.replace(start, start + 1, "&lt;");
            diff += 3;
        }
        String string = builder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Contract(pure=true)
    private final String adjustHtml(String html) {
        String str = html;
        for (Map.Entry<String, String> entry : HTML_DOC_SUBSTITUTIONS.entrySet()) {
            String key = entry.getKey();
            String value = entry.getValue();
            if (StringsKt.indexOf$default((CharSequence)str, (String)key, (int)0, (boolean)false, (int)6, null) <= 0) continue;
            str = StringsKt.replace$default((String)str, (String)key, (String)value, (boolean)false, (int)4, null);
        }
        String $this$trim$iv = str;
        boolean $i$f$trim = false;
        CharSequence $this$trim$iv$iv = $this$trim$iv;
        boolean $i$f$trim2 = false;
        int startIndex$iv$iv = 0;
        int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
        boolean startFound$iv$iv = false;
        while (startIndex$iv$iv <= endIndex$iv$iv) {
            boolean match$iv$iv;
            int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
            char it = $this$trim$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
            if (!startFound$iv$iv) {
                if (!match$iv$iv) {
                    startFound$iv$iv = true;
                    continue;
                }
                ++startIndex$iv$iv;
                continue;
            }
            if (!match$iv$iv) break;
            --endIndex$iv$iv;
        }
        return ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
    }

    private final String getBorder() {
        return "margin: 0; border: 1px solid; border-color: #" + ColorUtil.toHex((Color)UIUtil.getTooltipSeparatorColor()) + "; border-spacing: 0; border-collapse: collapse;vertical-align: baseline;";
    }

    @JvmStatic
    @Contract(pure=true)
    @RequiresReadLock
    @JvmOverloads
    @NotNull
    public static final String convert(@NotNull Project project, @Nls @NotNull String markdownText) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)markdownText, (String)"markdownText");
        return DocMarkdownToHtmlConverter.convert$default(project, markdownText, null, 4, null);
    }

    private static final boolean isHeaderSeparator$lambda$1(int it) {
        return it == 45;
    }

    static {
        Set set;
        INSTANCE = new DocMarkdownToHtmlConverter();
        Logger logger = Logger.getInstance(DocMarkdownToHtmlConverter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Pattern pattern = Pattern.compile("(<)/?(\\w+)[> ]");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        TAG_START_OR_CLOSE_PATTERN = pattern;
        Pattern pattern2 = Pattern.compile("^</?([a-z][a-z-_0-9]*)[^>]*>$", 2);
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        TAG_PATTERN = pattern2;
        FENCE_PATTERN = new Regex("\\s+```.*");
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"<em>", (Object)"<i>"), TuplesKt.to((Object)"</em>", (Object)"</i>"), TuplesKt.to((Object)"<strong>", (Object)"<b>"), TuplesKt.to((Object)"</strong>", (Object)"</b>"), TuplesKt.to((Object)": //", (Object)"://"), TuplesKt.to((Object)"<p></p>", (Object)""), TuplesKt.to((Object)"</p>", (Object)""), TuplesKt.to((Object)"<br  />", (Object)"")};
        HTML_DOC_SUBSTITUTIONS = MapsKt.mapOf((Pair[])pairArray);
        Set $this$ACCEPTABLE_BLOCK_TAGS_u24lambda_u240 = set = CollectionFactory.createCharSequenceSet((boolean)false);
        boolean bl = false;
        Object[] objectArray = new String[]{"blockquote", "dd", "dl", "dt", "hr", "li", "ol", "ul", "pre", "p", "caption", "col", "colgroup", "table", "tbody", "td", "tfoot", "th", "thead", "tr", "details", "summary"};
        $this$ACCEPTABLE_BLOCK_TAGS_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        Set set2 = set;
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"apply(...)");
        ACCEPTABLE_BLOCK_TAGS = set2;
        Set $this$ACCEPTABLE_TAGS_u24lambda_u240 = set = CollectionFactory.createCharSequenceSet((boolean)false);
        boolean bl2 = false;
        $this$ACCEPTABLE_TAGS_u24lambda_u240.addAll((Collection)ACCEPTABLE_BLOCK_TAGS);
        objectArray = new String[]{"h1", "h2", "h3", "h4", "h5", "h6", "a", "b", "br", "code", "em", "i", "s", "span", "strong", "u", "wbr", "kbd", "samp", "img", "svg", "tt", "shortcut", "icon"};
        $this$ACCEPTABLE_TAGS_u24lambda_u240.addAll(CollectionsKt.listOf((Object[])objectArray));
        Set set3 = set;
        Intrinsics.checkNotNullExpressionValue((Object)set3, (String)"apply(...)");
        ACCEPTABLE_TAGS = set3;
        embeddedHtmlType = new IElementType("ROOT");
    }
}

