/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.feedback.localization;

import com.intellij.codeWithMe.ClientId;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.platform.feedback.impl.notification.RequestFeedbackNotification;
import com.intellij.platform.feedback.localization.LocalizationFeedbackBundle;
import com.intellij.platform.feedback.localization.LocalizationFeedbackDialog;
import com.intellij.platform.feedback.localization.LocalizationFeedbackService;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Service(value={Service.Level.APP})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0007\u001a\u00020\bJ\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u00020\u00062\u0012\u0010\f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\b0\rH\u0002R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/platform/feedback/localization/LocalizationFeedbackNotificationService;", "", "<init>", "()V", "notifications", "", "Lcom/intellij/notification/Notification;", "showNotification", "", "project", "Lcom/intellij/openapi/project/Project;", "buildNotification", "action", "Lkotlin/Function1;", "Companion", "intellij.platform.feedback"})
@SourceDebugExtension(value={"SMAP\nLocalizationFeedbackNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationFeedbackNotificationService.kt\ncom/intellij/platform/feedback/localization/LocalizationFeedbackNotificationService\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,62:1\n14060#2,2:63\n1915#3,2:65\n1915#3,2:67\n*S KotlinDebug\n*F\n+ 1 LocalizationFeedbackNotificationService.kt\ncom/intellij/platform/feedback/localization/LocalizationFeedbackNotificationService\n*L\n22#1:63,2\n50#1:65,2\n55#1:67,2\n*E\n"})
public final class LocalizationFeedbackNotificationService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<Notification> notifications = new ArrayList();

    public final void showNotification() {
        Project[] projectArray = ProjectManager.getInstance().getOpenProjects();
        Intrinsics.checkNotNullExpressionValue((Object)projectArray, (String)"getOpenProjects(...)");
        Object[] $this$forEach$iv = projectArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Project it = (Project)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            this.showNotification(it);
        }
    }

    private final void showNotification(Project project) {
        Notification notification = this.buildNotification((Function1<? super Project, Unit>)((Function1)LocalizationFeedbackNotificationService::showNotification$lambda$1));
        this.notifications.add(notification);
        Disposer.register((Disposable)((Disposable)project), () -> LocalizationFeedbackNotificationService.showNotification$lambda$2(this, notification));
        notification.notify(project);
    }

    private final Notification buildNotification(Function1<? super Project, Unit> action) {
        RequestFeedbackNotification notification = new RequestFeedbackNotification("Feedback In IDE", LocalizationFeedbackBundle.INSTANCE.message("notification.title", new Object[0]), LocalizationFeedbackBundle.INSTANCE.message("notification.text", new Object[0]));
        notification.addAction((AnAction)NotificationAction.createExpiring((String)LocalizationFeedbackBundle.INSTANCE.message("notification.respond.button", new Object[0]), (arg_0, arg_1) -> LocalizationFeedbackNotificationService.buildNotification$lambda$1((arg_0, arg_1) -> LocalizationFeedbackNotificationService.buildNotification$lambda$0(action, this, arg_0, arg_1), arg_0, arg_1)));
        notification.addAction((AnAction)NotificationAction.createSimpleExpiring((String)LocalizationFeedbackBundle.INSTANCE.message("notification.dotNotShow.button", new Object[0]), () -> LocalizationFeedbackNotificationService.buildNotification$lambda$2(this)));
        return notification;
    }

    private static final Unit showNotification$lambda$1(Project it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        new LocalizationFeedbackDialog(it, LocalizationFeedbackService.Companion.isTesting()).show();
        return Unit.INSTANCE;
    }

    private static final void showNotification$lambda$2(LocalizationFeedbackNotificationService this$0, Notification $notification) {
        this$0.notifications.remove($notification);
    }

    private static final boolean buildNotification$lambda$0$1(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final boolean buildNotification$lambda$2$1(Notification it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return true;
    }

    private static final Unit buildNotification$lambda$0(Function1 $action, LocalizationFeedbackNotificationService this$0, AnActionEvent e, Notification notification) {
        Project project = e.getProject();
        if (project == null) {
            return Unit.INSTANCE;
        }
        Project project2 = project;
        LocalizationFeedbackService.Companion.getInstance().setInteraction();
        $action.invoke((Object)project2);
        Iterable $this$forEach$iv = this$0.notifications;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Notification it = (Notification)element$iv;
            boolean bl = false;
            it.expire();
        }
        CollectionsKt.removeAll(this$0.notifications, LocalizationFeedbackNotificationService::buildNotification$lambda$0$1);
        return Unit.INSTANCE;
    }

    private static final void buildNotification$lambda$1(Function2 $tmp0, Object p0, Object p1) {
        $tmp0.invoke(p0, p1);
    }

    private static final void buildNotification$lambda$2(LocalizationFeedbackNotificationService this$0) {
        Iterable $this$forEach$iv = this$0.notifications;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Notification it = (Notification)element$iv;
            boolean bl = false;
            it.expire();
        }
        CollectionsKt.removeAll(this$0.notifications, LocalizationFeedbackNotificationService::buildNotification$lambda$2$1);
        LocalizationFeedbackService.Companion.getInstance().setInteraction();
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005\u00a8\u0006\u0006"}, d2={"Lcom/intellij/platform/feedback/localization/LocalizationFeedbackNotificationService$Companion;", "", "<init>", "()V", "getInstance", "Lcom/intellij/platform/feedback/localization/LocalizationFeedbackNotificationService;", "intellij.platform.feedback"})
    @SourceDebugExtension(value={"SMAP\nLocalizationFeedbackNotificationService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalizationFeedbackNotificationService.kt\ncom/intellij/platform/feedback/localization/LocalizationFeedbackNotificationService$Companion\n+ 2 service.kt\ncom/intellij/openapi/components/ServiceKt\n*L\n1#1,62:1\n42#2,3:63\n*S KotlinDebug\n*F\n+ 1 LocalizationFeedbackNotificationService.kt\ncom/intellij/platform/feedback/localization/LocalizationFeedbackNotificationService$Companion\n*L\n16#1:63,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalizationFeedbackNotificationService getInstance() {
            boolean $i$f$service = false;
            Class<LocalizationFeedbackNotificationService> serviceClass$iv = LocalizationFeedbackNotificationService.class;
            Object object = ApplicationManager.getApplication().getService(serviceClass$iv);
            if (object == null) {
                throw new RuntimeException("Cannot find service " + serviceClass$iv.getName() + " (classloader=" + serviceClass$iv.getClassLoader() + ", client=" + ClientId.Companion.getCurrentOrNull() + ')');
            }
            return (LocalizationFeedbackNotificationService)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

