/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.codeStyle.arrangement.match;

import com.intellij.psi.codeStyle.arrangement.ArrangementEntry;
import com.intellij.psi.codeStyle.arrangement.match.ArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByModifierArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNameArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByNamespaceArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTextArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.ByTypeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.match.CompositeArrangementEntryMatcher;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementAtomMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementCompositeMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchCondition;
import com.intellij.psi.codeStyle.arrangement.model.ArrangementMatchConditionVisitor;
import com.intellij.psi.codeStyle.arrangement.std.ArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementSettingsToken;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokenType;
import com.intellij.psi.codeStyle.arrangement.std.StdArrangementTokens;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public final class StdArrangementEntryMatcher
implements ArrangementEntryMatcher {
    @NotNull
    private final ArrangementMatchCondition myCondition;
    @NotNull
    private final ArrangementEntryMatcher myDelegate;

    public StdArrangementEntryMatcher(@NotNull ArrangementMatchCondition condition) {
        if (condition == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(0);
        }
        this(condition, new StdMatcherBuilderImpl());
    }

    public StdArrangementEntryMatcher(@NotNull ArrangementMatchCondition condition, @NotNull StdMatcherBuilder builder) {
        if (condition == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(1);
        }
        if (builder == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(2);
        }
        this.myCondition = condition;
        this.myDelegate = StdArrangementEntryMatcher.doBuildMatcher(condition, builder);
    }

    @NotNull
    public ArrangementMatchCondition getCondition() {
        ArrangementMatchCondition arrangementMatchCondition = this.myCondition;
        if (arrangementMatchCondition == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(3);
        }
        return arrangementMatchCondition;
    }

    @Override
    public boolean isMatched(@NotNull ArrangementEntry entry) {
        if (entry == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(4);
        }
        return this.myDelegate.isMatched(entry);
    }

    public int hashCode() {
        return this.myCondition.hashCode();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StdArrangementEntryMatcher matcher = (StdArrangementEntryMatcher)o;
        return this.myCondition.equals(matcher.myCondition);
    }

    public String toString() {
        return this.myCondition.toString();
    }

    @NotNull
    private static ArrangementEntryMatcher doBuildMatcher(@NotNull ArrangementMatchCondition condition, @NotNull StdMatcherBuilder builder) {
        if (condition == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(5);
        }
        if (builder == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(6);
        }
        MyVisitor visitor = new MyVisitor(builder);
        condition.invite(visitor);
        ArrangementEntryMatcher arrangementEntryMatcher = visitor.getMatcher();
        if (arrangementEntryMatcher == null) {
            StdArrangementEntryMatcher.$$$reportNull$$$0(7);
        }
        return arrangementEntryMatcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 7 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "condition";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entry";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getCondition";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "doBuildMatcher";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isMatched";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "doBuildMatcher";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 7 -> new IllegalStateException(string);
        };
    }

    public static class StdMatcherBuilderImpl
    implements StdMatcherBuilder {
        @NotNull
        private final List<ArrangementEntryMatcher> myMatchers = new ArrayList<ArrangementEntryMatcher>();
        @NotNull
        protected final MultiMap<StdArrangementTokenType, ArrangementAtomMatchCondition> context = new MultiMap();
        @Nullable
        private String myNamePattern;
        @Nullable
        private String myNamespacePattern;
        @Nullable
        private String myText;

        protected void addToContext(@NotNull StdArrangementSettingsToken token, @NotNull ArrangementAtomMatchCondition condition) {
            if (token == null) {
                StdMatcherBuilderImpl.$$$reportNull$$$0(0);
            }
            if (condition == null) {
                StdMatcherBuilderImpl.$$$reportNull$$$0(1);
            }
            StdArrangementTokenType tokenType = token.getTokenType();
            this.context.putValue((Object)tokenType, (Object)condition);
        }

        @Override
        public void onCondition(@NotNull ArrangementAtomMatchCondition condition) {
            if (condition == null) {
                StdMatcherBuilderImpl.$$$reportNull$$$0(2);
            }
            if (StdArrangementTokens.Regexp.NAME.equals(condition.getType())) {
                this.myNamePattern = condition.getValue().toString();
                return;
            }
            if (StdArrangementTokens.Regexp.XML_NAMESPACE.equals(condition.getType())) {
                this.myNamespacePattern = condition.getValue().toString();
            } else if (StdArrangementTokens.Regexp.TEXT.equals(condition.getType())) {
                this.myText = condition.getValue().toString();
            }
            Object v = condition.getValue();
            ArrangementSettingsToken type = condition.getType();
            if (type instanceof StdArrangementSettingsToken) {
                this.addToContext((StdArrangementSettingsToken)type, condition);
            }
        }

        @Override
        @Nullable
        public @Unmodifiable Collection<ArrangementEntryMatcher> buildMatchers() {
            Collection modifierTokens;
            ArrayList<ArrangementEntryMatcher> result2 = new ArrayList<ArrangementEntryMatcher>(this.myMatchers);
            Collection entryTokens = this.context.get((Object)StdArrangementTokenType.ENTRY_TYPE);
            if (!entryTokens.isEmpty()) {
                result2.add(new ByTypeArrangementEntryMatcher(entryTokens));
            }
            if (!(modifierTokens = this.context.get((Object)StdArrangementTokenType.MODIFIER)).isEmpty()) {
                result2.add(new ByModifierArrangementEntryMatcher(modifierTokens));
            }
            if (this.myNamePattern != null) {
                result2.add(new ByNameArrangementEntryMatcher(this.myNamePattern));
            }
            if (this.myNamespacePattern != null) {
                result2.add(new ByNamespaceArrangementEntryMatcher(this.myNamespacePattern));
            }
            if (this.myText != null) {
                result2.add(new ByTextArrangementEntryMatcher(this.myText));
            }
            return result2;
        }

        @Override
        public void addMatcher(@NotNull ArrangementEntryMatcher matcher) {
            if (matcher == null) {
                StdMatcherBuilderImpl.$$$reportNull$$$0(3);
            }
            this.myMatchers.add(matcher);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "token";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcher";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$StdMatcherBuilderImpl";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addToContext";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onCondition";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "addMatcher";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface StdMatcherBuilder {
        public void onCondition(@NotNull ArrangementAtomMatchCondition var1);

        @Nullable
        public @Unmodifiable Collection<ArrangementEntryMatcher> buildMatchers();

        public void addMatcher(@NotNull ArrangementEntryMatcher var1);
    }

    private static final class MyVisitor
    implements ArrangementMatchConditionVisitor {
        @NotNull
        private final StdMatcherBuilder myMatcherBuilder;
        private boolean nestedComposite;

        private MyVisitor(@NotNull StdMatcherBuilder matcherBuilder) {
            if (matcherBuilder == null) {
                MyVisitor.$$$reportNull$$$0(0);
            }
            this.myMatcherBuilder = matcherBuilder;
        }

        @Override
        public void visit(@NotNull ArrangementAtomMatchCondition condition) {
            if (condition == null) {
                MyVisitor.$$$reportNull$$$0(1);
            }
            this.myMatcherBuilder.onCondition(condition);
        }

        @Override
        public void visit(@NotNull ArrangementCompositeMatchCondition condition) {
            if (condition == null) {
                MyVisitor.$$$reportNull$$$0(2);
            }
            if (!this.nestedComposite) {
                this.nestedComposite = true;
                for (ArrangementMatchCondition c : condition.getOperands()) {
                    c.invite(this);
                }
            } else {
                this.myMatcherBuilder.addMatcher(StdArrangementEntryMatcher.doBuildMatcher(condition, this.myMatcherBuilder));
            }
        }

        @NotNull
        public ArrangementEntryMatcher getMatcher() {
            Collection<ArrangementEntryMatcher> matchers = this.myMatcherBuilder.buildMatchers();
            if (matchers.size() == 1) {
                ArrangementEntryMatcher arrangementEntryMatcher = matchers.iterator().next();
                if (arrangementEntryMatcher == null) {
                    MyVisitor.$$$reportNull$$$0(3);
                }
                return arrangementEntryMatcher;
            }
            CompositeArrangementEntryMatcher result2 = new CompositeArrangementEntryMatcher(new ArrangementEntryMatcher[0]);
            for (ArrangementEntryMatcher matcher : matchers) {
                result2.addMatcher(matcher);
            }
            CompositeArrangementEntryMatcher compositeArrangementEntryMatcher = result2;
            if (compositeArrangementEntryMatcher == null) {
                MyVisitor.$$$reportNull$$$0(4);
            }
            return compositeArrangementEntryMatcher;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 3, 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "matcherBuilder";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "condition";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$MyVisitor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/psi/codeStyle/arrangement/match/StdArrangementEntryMatcher$MyVisitor";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMatcher";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "visit";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 3, 4 -> new IllegalStateException(string);
            };
        }
    }
}

