/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import java.util.List;
import org.jetbrains.annotations.NotNull;

final class IndexPatternOccurrenceImpl
implements IndexPatternOccurrence {
    private final PsiFile myPsiFile;
    private final int myStartOffset;
    private final int myEndOffset;
    private final IndexPattern myPattern;
    private final List<TextRange> myAdditionalRanges;

    IndexPatternOccurrenceImpl(@NotNull PsiFile psiFile, int startOffset, int endOffset, @NotNull IndexPattern pattern, @NotNull List<TextRange> additionalRanges) {
        if (psiFile == null) {
            IndexPatternOccurrenceImpl.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            IndexPatternOccurrenceImpl.$$$reportNull$$$0(1);
        }
        if (additionalRanges == null) {
            IndexPatternOccurrenceImpl.$$$reportNull$$$0(2);
        }
        this.myPsiFile = psiFile;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
        this.myPattern = pattern;
        this.myAdditionalRanges = additionalRanges;
    }

    @NotNull
    public PsiFile getFile() {
        PsiFile psiFile = this.myPsiFile;
        if (psiFile == null) {
            IndexPatternOccurrenceImpl.$$$reportNull$$$0(3);
        }
        return psiFile;
    }

    @NotNull
    public TextRange getTextRange() {
        return new TextRange(this.myStartOffset, this.myEndOffset);
    }

    @NotNull
    public List<TextRange> getAdditionalTextRanges() {
        List<TextRange> list2 = this.myAdditionalRanges;
        if (list2 == null) {
            IndexPatternOccurrenceImpl.$$$reportNull$$$0(4);
        }
        return list2;
    }

    @NotNull
    public IndexPattern getPattern() {
        IndexPattern indexPattern = this.myPattern;
        if (indexPattern == null) {
            IndexPatternOccurrenceImpl.$$$reportNull$$$0(5);
        }
        return indexPattern;
    }

    public int hashCode() {
        return this.myPsiFile.hashCode() + this.myStartOffset + this.myEndOffset + this.myPattern.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof IndexPatternOccurrenceImpl)) {
            return false;
        }
        IndexPatternOccurrenceImpl todoItem = (IndexPatternOccurrenceImpl)obj;
        return this.myPsiFile.equals((Object)todoItem.myPsiFile) && this.myStartOffset == todoItem.myStartOffset && this.myEndOffset == todoItem.myEndOffset && this.myPattern.equals((Object)todoItem.myPattern);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "additionalRanges";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/impl/search/IndexPatternOccurrenceImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/impl/search/IndexPatternOccurrenceImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getAdditionalTextRanges";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getPattern";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

