/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Factory;
import com.intellij.psi.PsiElement;
import com.intellij.usages.FindUsagesProcessPresentation;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageSearcher;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.util.containers.ContainerUtil;
import java.util.function.Supplier;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class UsageViewManager {
    public static UsageViewManager getInstance(Project project) {
        return (UsageViewManager)project.getService(UsageViewManager.class);
    }

    @NotNull
    public abstract UsageView createUsageView(UsageTarget @NotNull [] var1, Usage @NotNull [] var2, @NotNull UsageViewPresentation var3, @Nullable Factory<? extends UsageSearcher> var4);

    @NotNull
    public abstract UsageView showUsages(UsageTarget @NotNull [] var1, Usage @NotNull [] var2, @NotNull UsageViewPresentation var3, @Nullable Factory<? extends UsageSearcher> var4);

    @NotNull
    public abstract UsageView showUsages(UsageTarget @NotNull [] var1, Usage @NotNull [] var2, @NotNull UsageViewPresentation var3);

    @Nullable(value="returns null in case of no usages found or usage view not shown for one usage")
    public abstract @Nullable(value="returns null in case of no usages found or usage view not shown for one usage") UsageView searchAndShowUsages(UsageTarget @NotNull [] var1, @NotNull Supplier<? extends UsageSearcher> var2, boolean var3, boolean var4, @NotNull UsageViewPresentation var5, @Nullable UsageViewStateListener var6);

    public abstract void searchAndShowUsages(UsageTarget @NotNull [] var1, @NotNull Factory<? extends UsageSearcher> var2, @NotNull FindUsagesProcessPresentation var3, @NotNull UsageViewPresentation var4, @Nullable UsageViewStateListener var5);

    @Nullable
    public abstract UsageView getSelectedUsageView();

    public static boolean isSelfUsage(@NotNull Usage usage, UsageTarget @NotNull [] searchForTargets) {
        if (usage == null) {
            UsageViewManager.$$$reportNull$$$0(0);
        }
        if (searchForTargets == null) {
            UsageViewManager.$$$reportNull$$$0(1);
        }
        if (!(usage instanceof PsiElementUsage)) {
            return false;
        }
        PsiElementUsage elementUsage = (PsiElementUsage)usage;
        return (Boolean)ReadAction.compute(() -> {
            PsiElement element = elementUsage.getElement();
            if (element == null) {
                return false;
            }
            PsiElement parent = element.getParent();
            if (parent == null) {
                return false;
            }
            int offset = element.getTextOffset();
            return ContainerUtil.exists((Object[])searchForTargets, ut -> {
                if (!(ut instanceof PsiElementUsageTarget)) {
                    return false;
                }
                PsiElementUsageTarget t = (PsiElementUsageTarget)ut;
                PsiElement targetElement = t.getElement();
                return parent == targetElement && offset == targetElement.getTextOffset();
            });
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "usage";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "searchForTargets";
                break;
            }
        }
        objectArray[1] = "com/intellij/usages/UsageViewManager";
        objectArray[2] = "isSelfUsage";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static interface UsageViewStateListener {
        public void usageViewCreated(@NotNull UsageView var1);

        public void findingUsagesFinished(@Nullable UsageView var1);
    }
}

