/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.intellij.bazelEnvironment;

import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\u000e\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J'\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0003H\u00c6\u0001J\u0014\u0010\u0012\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0015\u001a\u00020\u0016H\u00d6\u0081\u0004J\n\u0010\u0017\u001a\u00020\u0003H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\tR\u0011\u0010\f\u001a\u00020\u00038F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\t\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/intellij/bazelEnvironment/BazelLabel;", "", "repo", "", "packageName", "target", "<init>", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "getRepo", "()Ljava/lang/String;", "getPackageName", "getTarget", "asLabel", "getAsLabel", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "toString", "Companion", "intellij.platform.buildScripts.downloader"})
@ApiStatus.Experimental
public final class BazelLabel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String repo;
    @NotNull
    private final String packageName;
    @NotNull
    private final String target;
    @NotNull
    private static final Regex regex = new Regex("(@[a-zA-Z0-9_-]+)?//([a-zA-Z0-9_./-]+)?:([/a-zA-Z0-9._-]+)");

    public BazelLabel(@NotNull String repo, @NotNull String packageName, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.repo = repo;
        this.packageName = packageName;
        this.target = target;
    }

    @NotNull
    public final String getRepo() {
        return this.repo;
    }

    @NotNull
    public final String getPackageName() {
        return this.packageName;
    }

    @NotNull
    public final String getTarget() {
        return this.target;
    }

    @NotNull
    public final String getAsLabel() {
        return (((CharSequence)this.repo).length() == 0 ? "" : "@") + this.repo + "//" + this.packageName + ":" + this.target;
    }

    @NotNull
    public final String component1() {
        return this.repo;
    }

    @NotNull
    public final String component2() {
        return this.packageName;
    }

    @NotNull
    public final String component3() {
        return this.target;
    }

    @NotNull
    public final BazelLabel copy(@NotNull String repo, @NotNull String packageName, @NotNull String target) {
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)packageName, (String)"packageName");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return new BazelLabel(repo, packageName, target);
    }

    public static /* synthetic */ BazelLabel copy$default(BazelLabel bazelLabel, String string, String string2, String string3, int n, Object object) {
        if ((n & 1) != 0) {
            string = bazelLabel.repo;
        }
        if ((n & 2) != 0) {
            string2 = bazelLabel.packageName;
        }
        if ((n & 4) != 0) {
            string3 = bazelLabel.target;
        }
        return bazelLabel.copy(string, string2, string3);
    }

    @NotNull
    public String toString() {
        return "BazelLabel(repo=" + this.repo + ", packageName=" + this.packageName + ", target=" + this.target + ")";
    }

    public int hashCode() {
        int result2 = this.repo.hashCode();
        result2 = result2 * 31 + this.packageName.hashCode();
        result2 = result2 * 31 + this.target.hashCode();
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof BazelLabel)) {
            return false;
        }
        BazelLabel bazelLabel = (BazelLabel)other;
        if (!Intrinsics.areEqual((Object)this.repo, (Object)bazelLabel.repo)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.packageName, (Object)bazelLabel.packageName)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.target, (Object)bazelLabel.target);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lorg/jetbrains/intellij/bazelEnvironment/BazelLabel$Companion;", "", "<init>", "()V", "regex", "Lkotlin/text/Regex;", "fromString", "Lorg/jetbrains/intellij/bazelEnvironment/BazelLabel;", "label", "", "intellij.platform.buildScripts.downloader"})
    @SourceDebugExtension(value={"SMAP\nBazelLabel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BazelLabel.kt\norg/jetbrains/intellij/bazelEnvironment/BazelLabel$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,29:1\n1#2:30\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final BazelLabel fromString(@NotNull String label) {
            Intrinsics.checkNotNullParameter((Object)label, (String)"label");
            MatchResult matchResult = regex.matchEntire((CharSequence)label);
            if (matchResult == null) {
                throw new IllegalStateException(("Bazel label must match '" + regex.getPattern() + "': " + label).toString());
            }
            MatchResult match = matchResult;
            char[] cArray = new char[]{'@'};
            BazelLabel bazelLabel = new BazelLabel(StringsKt.trimStart((String)((String)match.getGroupValues().get(1)), (char[])cArray), (String)match.getGroupValues().get(2), (String)match.getGroupValues().get(3));
            if (!Intrinsics.areEqual((Object)bazelLabel.getAsLabel(), (Object)label)) {
                boolean bl = false;
                String string = "Label from BazelLabel.asLabel must be equal to parsed label (roundtrip) '" + label + "': " + bazelLabel.getAsLabel();
                throw new IllegalStateException(string.toString());
            }
            return bazelLabel;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

