/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.messaging.providers;

import com.intellij.microservices.jvm.callsites.ArgumentCallSite;
import com.intellij.microservices.jvm.callsites.ArgumentCallSiteCollector;
import com.intellij.microservices.jvm.mq.CallSiteMQTargetInfo;
import com.intellij.microservices.jvm.mq.MQAccessType;
import com.intellij.microservices.jvm.mq.MQAccessTypes;
import com.intellij.microservices.jvm.mq.MQResolver;
import com.intellij.microservices.jvm.mq.MQResolverFactory;
import com.intellij.microservices.jvm.mq.MQTargetInfo;
import com.intellij.microservices.jvm.mq.MQType;
import com.intellij.microservices.jvm.mq.MQTypes;
import com.intellij.microservices.jvm.mq.UnknownMQProviderType;
import com.intellij.openapi.project.Project;
import com.intellij.spring.messaging.SpringMessagingConstants;
import com.intellij.spring.messaging.providers.SpringMQUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00122\u00020\u0001:\u0002\u0012\u0013B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00050\u000bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0014"}, d2={"Lcom/intellij/spring/messaging/providers/SpringJmsTemplateMQResolver;", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "type", "Lcom/intellij/microservices/jvm/mq/MQType;", "collector", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/microservices/jvm/mq/MQType;Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;)V", "supportedTypes", "", "getSupportedTypes", "()Ljava/util/List;", "getVariants", "", "Lcom/intellij/microservices/jvm/mq/MQTargetInfo;", "typeHint", "Companion", "Factory", "intellij.spring.messaging"})
public final class SpringJmsTemplateMQResolver
implements MQResolver {
    @NotNull
    public static final Companion Companion;
    @NotNull
    private final Project project;
    @NotNull
    private final MQType type;
    @NotNull
    private final ArgumentCallSiteCollector collector;
    @NotNull
    private final List<MQType> supportedTypes;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_SEND_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_RECEIVE_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_OPERATIONS_QUEUE_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_MESSAGE_SEND_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_MESSAGE_RECEIVE_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR;
    @NotNull
    private static final ArgumentCallSiteCollector JMS_MESSAGING_TEMPLATE_COLLECTOR;

    public SpringJmsTemplateMQResolver(@NotNull Project project, @NotNull MQType type, @NotNull ArgumentCallSiteCollector collector) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)collector, (String)"collector");
        this.project = project;
        this.type = type;
        this.collector = collector;
        this.supportedTypes = CollectionsKt.listOf((Object)this.type);
    }

    @NotNull
    public List<MQType> getSupportedTypes() {
        return this.supportedTypes;
    }

    @NotNull
    public Iterable<MQTargetInfo> getVariants(@NotNull MQType typeHint) {
        Intrinsics.checkNotNullParameter((Object)typeHint, (String)"typeHint");
        return SequencesKt.asIterable((Sequence)SequencesKt.map((Sequence)this.collector.getCallSitesSequence(this.project), arg_0 -> SpringJmsTemplateMQResolver.getVariants$lambda$0(this, arg_0)));
    }

    private static final CallSiteMQTargetInfo getVariants$lambda$0(SpringJmsTemplateMQResolver this$0, ArgumentCallSite it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        MQType mQType = this$0.type;
        Object object = this$0.collector.getUserData(MQAccessType.KEY);
        Intrinsics.checkNotNull((Object)object);
        return new CallSiteMQTargetInfo(it, mQType, (MQAccessType)object);
    }

    static {
        ArgumentCallSiteCollector argumentCallSiteCollector;
        Companion = new Companion(null);
        List<String> list = SpringMessagingConstants.JMS_SEND_OPERATIONS_DESTINATION_METHODS;
        Intrinsics.checkNotNullExpressionValue(list, (String)"JMS_SEND_OPERATIONS_DESTINATION_METHODS");
        ArgumentCallSiteCollector $this$JMS_SEND_OPERATIONS_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_SEND_OPERATIONS_DESTINATION", "org.springframework.jms.core.JmsOperations", list, 0, 0, 16, null);
        boolean bl = false;
        $this$JMS_SEND_OPERATIONS_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_TYPE);
        JMS_SEND_OPERATIONS_COLLECTOR = argumentCallSiteCollector;
        List<String> list2 = SpringMessagingConstants.JMS_RECEIVE_OPERATIONS_DESTINATION_METHODS;
        Intrinsics.checkNotNullExpressionValue(list2, (String)"JMS_RECEIVE_OPERATIONS_DESTINATION_METHODS");
        ArgumentCallSiteCollector $this$JMS_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_RECEIVE_OPERATIONS_DESTINATION", "org.springframework.jms.core.JmsOperations", list2, 0, 0, 16, null);
        boolean bl2 = false;
        $this$JMS_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.RECEIVE_TYPE);
        JMS_RECEIVE_OPERATIONS_COLLECTOR = argumentCallSiteCollector;
        List<String> list3 = SpringMessagingConstants.JMS_SEND_AND_RECEIVE_OPERATIONS_DESTINATION_METHODS;
        Intrinsics.checkNotNullExpressionValue(list3, (String)"JMS_SEND_AND_RECEIVE_OPE\u2026TIONS_DESTINATION_METHODS");
        ArgumentCallSiteCollector $this$JMS_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_SEND_AND_RECEIVE_OPERATIONS_DESTINATION", "org.springframework.jms.core.JmsOperations", list3, 0, 0, 16, null);
        boolean bl3 = false;
        $this$JMS_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_AND_RECEIVE_TYPE);
        JMS_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR = argumentCallSiteCollector;
        List<String> list4 = SpringMessagingConstants.JMS_OPERATIONS_QUEUE_METHODS;
        Intrinsics.checkNotNullExpressionValue(list4, (String)"JMS_OPERATIONS_QUEUE_METHODS");
        ArgumentCallSiteCollector $this$JMS_OPERATIONS_QUEUE_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_OPERATIONS_QUEUE", "org.springframework.jms.core.JmsOperations", list4, 0, 0, 16, null);
        boolean bl4 = false;
        $this$JMS_OPERATIONS_QUEUE_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.UNKNOWN_TYPE);
        JMS_OPERATIONS_QUEUE_COLLECTOR = argumentCallSiteCollector;
        List<String> list5 = SpringMessagingConstants.JMS_MESSAGE_SEND_OPERATIONS_METHODS;
        Intrinsics.checkNotNullExpressionValue(list5, (String)"JMS_MESSAGE_SEND_OPERATIONS_METHODS");
        ArgumentCallSiteCollector $this$JMS_MESSAGE_SEND_OPERATIONS_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_MESSAGE_SEND_OPERATIONS_DESTINATION", "org.springframework.jms.core.JmsMessageOperations", list5, 0, 0, 16, null);
        boolean bl5 = false;
        $this$JMS_MESSAGE_SEND_OPERATIONS_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_TYPE);
        JMS_MESSAGE_SEND_OPERATIONS_COLLECTOR = argumentCallSiteCollector;
        List<String> list6 = SpringMessagingConstants.JMS_MESSAGE_RECEIVE_OPERATIONS_METHODS;
        Intrinsics.checkNotNullExpressionValue(list6, (String)"JMS_MESSAGE_RECEIVE_OPERATIONS_METHODS");
        ArgumentCallSiteCollector $this$JMS_MESSAGE_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_MESSAGE_RECEIVE_OPERATIONS_DESTINATION", "org.springframework.jms.core.JmsMessageOperations", list6, 0, 0, 16, null);
        boolean bl6 = false;
        $this$JMS_MESSAGE_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.RECEIVE_TYPE);
        JMS_MESSAGE_RECEIVE_OPERATIONS_COLLECTOR = argumentCallSiteCollector;
        List<String> list7 = SpringMessagingConstants.JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_METHODS;
        Intrinsics.checkNotNullExpressionValue(list7, (String)"JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_METHODS");
        ArgumentCallSiteCollector $this$JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_DESTINATION", "org.springframework.jms.core.JmsMessageOperations", list7, 0, 0, 16, null);
        boolean bl7 = false;
        $this$JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.SEND_AND_RECEIVE_TYPE);
        JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR = argumentCallSiteCollector;
        List<String> list8 = SpringMessagingConstants.JMS_MESSAGING_TEMPLATE_METHODS;
        Intrinsics.checkNotNullExpressionValue(list8, (String)"JMS_MESSAGING_TEMPLATE_METHODS");
        ArgumentCallSiteCollector $this$JMS_MESSAGING_TEMPLATE_COLLECTOR_u24lambda_u240 = argumentCallSiteCollector = new ArgumentCallSiteCollector("SPRING_JMS_MESSAGING_TEMPLATE_DESTINATION", "org.springframework.jms.core.JmsMessagingTemplate", list8, 0, 0, 16, null);
        boolean bl8 = false;
        $this$JMS_MESSAGING_TEMPLATE_COLLECTOR_u24lambda_u240.putUserData(MQAccessType.KEY, (Object)MQAccessTypes.UNKNOWN_TYPE);
        JMS_MESSAGING_TEMPLATE_COLLECTOR = argumentCallSiteCollector;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spring/messaging/providers/SpringJmsTemplateMQResolver$Companion;", "", "<init>", "()V", "JMS_SEND_OPERATIONS_COLLECTOR", "Lcom/intellij/microservices/jvm/callsites/ArgumentCallSiteCollector;", "JMS_RECEIVE_OPERATIONS_COLLECTOR", "JMS_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR", "JMS_OPERATIONS_QUEUE_COLLECTOR", "JMS_MESSAGE_SEND_OPERATIONS_COLLECTOR", "JMS_MESSAGE_RECEIVE_OPERATIONS_COLLECTOR", "JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR", "JMS_MESSAGING_TEMPLATE_COLLECTOR", "intellij.spring.messaging"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\t"}, d2={"Lcom/intellij/spring/messaging/providers/SpringJmsTemplateMQResolver$Factory;", "Lcom/intellij/microservices/jvm/mq/MQResolverFactory;", "<init>", "()V", "forProject", "", "Lcom/intellij/microservices/jvm/mq/MQResolver;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.spring.messaging"})
    public static final class Factory
    implements MQResolverFactory {
        @NotNull
        public List<MQResolver> forProject(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            if (!SpringMQUtils.INSTANCE.hasSpringJmsLibrary(project)) {
                return CollectionsKt.emptyList();
            }
            Object[] objectArray = new SpringJmsTemplateMQResolver[]{new SpringJmsTemplateMQResolver(project, (MQType)UnknownMQProviderType.INSTANCE, JMS_SEND_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)UnknownMQProviderType.INSTANCE, JMS_RECEIVE_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)UnknownMQProviderType.INSTANCE, JMS_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)MQTypes.QUEUE_EXCHANGE_TYPE, JMS_OPERATIONS_QUEUE_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)UnknownMQProviderType.INSTANCE, JMS_MESSAGE_SEND_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)UnknownMQProviderType.INSTANCE, JMS_MESSAGE_RECEIVE_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)UnknownMQProviderType.INSTANCE, JMS_MESSAGE_SEND_AND_RECEIVE_OPERATIONS_COLLECTOR), new SpringJmsTemplateMQResolver(project, (MQType)UnknownMQProviderType.INSTANCE, JMS_MESSAGING_TEMPLATE_COLLECTOR)};
            return CollectionsKt.listOf((Object[])objectArray);
        }
    }
}

