/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rml.dfa.ir.ast;

import com.intellij.rml.dfa.ir.IrLocation;
import com.intellij.rml.dfa.ir.ast.IrCloner;
import com.intellij.rml.dfa.ir.ast.IrExpr;
import com.intellij.rml.dfa.ir.ast.IrFieldID;
import com.intellij.rml.dfa.ir.ast.IrRecordID;
import com.intellij.rml.dfa.ir.ast.IrStatement;
import com.intellij.rml.dfa.ir.ast.IrStatementsVisitor;
import com.intellij.rml.dfa.ir.ast.IrVarID;
import com.intellij.rml.dfa.ir.ast.IrVisitor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0010\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\n\u0010\u001f\u001a\u00020 H\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006!"}, d2={"Lcom/intellij/rml/dfa/ir/ast/IrStoreStmt;", "Lcom/intellij/rml/dfa/ir/ast/IrStatement;", "receiver", "Lcom/intellij/rml/dfa/ir/ast/IrVarID;", "receiverDeclaredRecord", "Lcom/intellij/rml/dfa/ir/ast/IrRecordID;", "field", "Lcom/intellij/rml/dfa/ir/ast/IrFieldID;", "value", "Lcom/intellij/rml/dfa/ir/ast/IrExpr;", "loc", "Lcom/intellij/rml/dfa/ir/IrLocation;", "<init>", "(Lcom/intellij/rml/dfa/ir/ast/IrVarID;Lcom/intellij/rml/dfa/ir/ast/IrRecordID;Lcom/intellij/rml/dfa/ir/ast/IrFieldID;Lcom/intellij/rml/dfa/ir/ast/IrExpr;Lcom/intellij/rml/dfa/ir/IrLocation;)V", "getReceiver", "()Lcom/intellij/rml/dfa/ir/ast/IrVarID;", "getReceiverDeclaredRecord", "()Lcom/intellij/rml/dfa/ir/ast/IrRecordID;", "getField", "()Lcom/intellij/rml/dfa/ir/ast/IrFieldID;", "getValue", "()Lcom/intellij/rml/dfa/ir/ast/IrExpr;", "accept", "", "visitor", "Lcom/intellij/rml/dfa/ir/ast/IrStatementsVisitor;", "acceptChildren", "Lcom/intellij/rml/dfa/ir/ast/IrVisitor;", "clone", "cloner", "Lcom/intellij/rml/dfa/ir/ast/IrCloner;", "toString", "", "intellij.rml.dfa"})
public final class IrStoreStmt
extends IrStatement {
    @NotNull
    private final IrVarID receiver;
    @Nullable
    private final IrRecordID receiverDeclaredRecord;
    @NotNull
    private final IrFieldID field;
    @NotNull
    private final IrExpr value;

    public IrStoreStmt(@NotNull IrVarID receiver, @Nullable IrRecordID receiverDeclaredRecord, @NotNull IrFieldID field, @NotNull IrExpr value, @NotNull IrLocation loc) {
        Intrinsics.checkNotNullParameter((Object)receiver, (String)"receiver");
        Intrinsics.checkNotNullParameter((Object)field, (String)"field");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)loc, (String)"loc");
        super(loc);
        this.receiver = receiver;
        this.receiverDeclaredRecord = receiverDeclaredRecord;
        this.field = field;
        this.value = value;
    }

    @NotNull
    public final IrVarID getReceiver() {
        return this.receiver;
    }

    @Nullable
    public final IrRecordID getReceiverDeclaredRecord() {
        return this.receiverDeclaredRecord;
    }

    @NotNull
    public final IrFieldID getField() {
        return this.field;
    }

    @NotNull
    public final IrExpr getValue() {
        return this.value;
    }

    @Override
    public void accept(@NotNull IrStatementsVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        visitor.visitStoreStmt(this);
    }

    @Override
    public void acceptChildren(@NotNull IrVisitor visitor) {
        Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
        super.acceptChildren(visitor);
        this.receiver.accept(visitor);
        IrRecordID irRecordID = this.receiverDeclaredRecord;
        if (irRecordID != null) {
            irRecordID.accept(visitor);
        }
        this.field.accept(visitor);
        this.value.accept(visitor);
    }

    @Override
    @NotNull
    public IrStatement clone(@NotNull IrCloner cloner) {
        Intrinsics.checkNotNullParameter((Object)cloner, (String)"cloner");
        return cloner.cloneStoreStmt(this);
    }

    @NotNull
    public String toString() {
        return this.receiver + "<" + this.receiverDeclaredRecord + ">." + this.field + " = " + this.value;
    }
}

