/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.sqlite;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.NioFiles;
import com.intellij.util.ResourceUtil;
import com.intellij.util.io.DigestUtilKt;
import com.intellij.util.system.CpuArch;
import java.io.Closeable;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.sqlite.SqliteCodes;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\b\u0010\u0004\u001a\u00020\u0005H\u0000\u001a\b\u0010\u0006\u001a\u00020\u0005H\u0002\u001a\n\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u0002\u001a \u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u00032\u0006\u0010\u000b\u001a\u00020\fH\u0002\u001a\b\u0010\r\u001a\u00020\u0003H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u000e\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0003X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"extracted", "", "VERSION", "", "loadNativeDb", "", "loadSqliteNativeLibrary", "getLibPath", "extractAndLoadLibraryFile", "libFolderForCurrentOS", "libraryFileName", "tempDir", "Ljava/nio/file/Path;", "osNameToDirName", "intellij.platform.sqlite"})
public final class SqliteLibLoaderKt {
    private static boolean extracted;
    @NotNull
    private static final String VERSION = "3.42.0-jb.0";

    public static final synchronized void loadNativeDb() {
        if (extracted) {
            return;
        }
        SqliteLibLoaderKt.loadSqliteNativeLibrary();
        extracted = true;
    }

    private static final void loadSqliteNativeLibrary() {
        Path path;
        boolean hasNativeLib;
        String[] stringArray;
        Path nativeLibFile;
        String string = System.mapLibraryName("sqliteij");
        String string2 = string != null ? StringsKt.replace$default((String)string, (String)".dylib", (String)".jnilib", (boolean)false, (int)4, null) : null;
        Intrinsics.checkNotNull(string2);
        String nativeLibraryName = string2;
        String relativeDirName = SqliteLibLoaderKt.osNameToDirName() + "-" + (CpuArch.isArm64() ? "aarch64" : "x86_64");
        String libPath = SqliteLibLoaderKt.getLibPath();
        if (libPath != null && Files.exists(nativeLibFile = Path.of(libPath, stringArray = new String[]{"native", relativeDirName, nativeLibraryName}).toAbsolutePath().normalize(), new LinkOption[0])) {
            System.load(((Object)nativeLibFile).toString());
            return;
        }
        String nativeLibraryPath = "sqlite/" + relativeDirName;
        ClassLoader classLoader = SqliteCodes.class.getClassLoader();
        boolean bl = hasNativeLib = classLoader.getResource(nativeLibraryPath + "/" + nativeLibraryName) != null;
        if (hasNativeLib) {
            if (libPath == null) {
                Path dir = Files.createTempDirectory("sqlite-", new FileAttribute[0]);
                Runtime.getRuntime().addShutdownHook(new Thread(() -> SqliteLibLoaderKt.loadSqliteNativeLibrary$lambda$0(dir), "remove sqlite native temp dir"));
                path = dir;
            } else {
                path = Path.of(PathManager.getTempPath(), new String[0]);
            }
        } else {
            throw new Exception("No native library found for os.name=" + SystemInfoRt.OS_NAME + ", os.arch=" + CpuArch.CURRENT);
        }
        Path tempDir = path;
        Intrinsics.checkNotNull((Object)tempDir);
        SqliteLibLoaderKt.extractAndLoadLibraryFile(nativeLibraryPath, nativeLibraryName, tempDir);
    }

    private static final String getLibPath() {
        String string;
        if (Intrinsics.areEqual((Object)System.getProperty("sqlite.use.path.manager"), (Object)"false")) {
            return null;
        }
        try {
            string = PathManager.getLibPath();
        }
        catch (RuntimeException ignore) {
            string = null;
        }
        String libPath = string;
        return libPath;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void extractAndLoadLibraryFile(String libFolderForCurrentOS, String libraryFileName, Path tempDir) {
        Path extractedLibFile;
        block9: {
            Path targetDir;
            String expectedHash;
            ClassLoader classLoader;
            String nativeLibraryFilePath;
            block8: {
                nativeLibraryFilePath = libFolderForCurrentOS + "/" + libraryFileName;
                classLoader = SqliteCodes.class.getClassLoader();
                byte[] byArray = ResourceUtil.getResourceAsBytes((String)(nativeLibraryFilePath + ".sha256"), (ClassLoader)classLoader);
                Intrinsics.checkNotNull((Object)byArray);
                expectedHash = StringsKt.decodeToString((byte[])byArray);
                String extractedLibFileName = "sqlite-3.42.0-jb.0-" + libraryFileName;
                targetDir = tempDir.resolve("sqlite-native").toAbsolutePath().normalize();
                extractedLibFile = targetDir.resolve(extractedLibFileName);
                if (!Files.exists(extractedLibFile, new LinkOption[0])) break block8;
                Intrinsics.checkNotNull((Object)extractedLibFile);
                if (Intrinsics.areEqual((Object)expectedHash, (Object)DigestUtilKt.sha256Hex((Path)extractedLibFile))) break block9;
            }
            Files.createDirectories(targetDir, new FileAttribute[0]);
            InputStream inputStream = classLoader.getResourceAsStream(nativeLibraryFilePath);
            Intrinsics.checkNotNull((Object)inputStream);
            Closeable closeable = inputStream;
            Throwable throwable = null;
            try {
                InputStream reader = (InputStream)closeable;
                boolean bl = false;
                CopyOption[] copyOptionArray = new CopyOption[]{StandardCopyOption.REPLACE_EXISTING};
                long l = Files.copy(reader, extractedLibFile, copyOptionArray);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
            Intrinsics.checkNotNull((Object)extractedLibFile);
            String actualHash = DigestUtilKt.sha256Hex((Path)extractedLibFile);
            if (!Intrinsics.areEqual((Object)expectedHash, (Object)actualHash)) {
                throw new RuntimeException("Failed to write a native library file at " + extractedLibFile);
            }
        }
        System.load(((Object)extractedLibFile).toString());
    }

    private static final String osNameToDirName() {
        return SystemInfoRt.isWindows ? "win" : (SystemInfoRt.isMac ? "mac" : "linux");
    }

    private static final void loadSqliteNativeLibrary$lambda$0(Path $dir) {
        NioFiles.deleteRecursively((Path)$dir);
    }
}

