/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.editor;

import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.client.DatabaseSessionClientWithFile;
import com.intellij.database.console.session.DatabaseSessionViewService;
import com.intellij.database.editor.DatabaseEditorHelper;
import com.intellij.database.editor.DatabaseEditorNotifications;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbPsiFacade;
import com.intellij.database.run.session.LogView;
import com.intellij.database.util.DataSourceUtil;
import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.ProjectActivity;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.Topic;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096@\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\t\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0002\u00a8\u0006\n"}, d2={"Lcom/intellij/database/editor/DatabaseStartupActivity;", "Lcom/intellij/openapi/startup/ProjectActivity;", "<init>", "()V", "execute", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "configureConsole", "intellij.database.impl"})
public final class DatabaseStartupActivity
implements ProjectActivity {
    @Nullable
    public Object execute(@NotNull Project project, @NotNull Continuation<? super Unit> $completion) {
        this.configureConsole(project);
        Object object = BuildersKt.withContext((CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, null){
            int label;
            final /* synthetic */ Project $project;
            {
                this.$project = $project;
                super(2, $completion);
            }

            public final Object invokeSuspend(Object $result) {
                IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        DatabaseSessionViewService.Companion.getInstance().databaseSessionContributorListenSessions();
                        DatabaseEditorHelper.installEditorFactoryListener(this.$project);
                        DatabaseEditorNotifications.registerListeners(this.$project);
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    private final void configureConsole(Project project) {
        MessageBusConnection messageBusConnection = project.getMessageBus().connect();
        Topic topic = DbPsiFacade.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        messageBusConnection.subscribe(topic, arg_0 -> DatabaseStartupActivity.configureConsole$lambda$0(project, arg_0));
    }

    private static final void configureConsole$lambda$0(Project $project, DbDataSource dbDataSource) {
        DbPsiFacade dbPsiFacade = DbPsiFacade.getInstance((Project)$project);
        Intrinsics.checkNotNullExpressionValue((Object)dbPsiFacade, (String)"getInstance(...)");
        DbPsiFacade dbFacade = dbPsiFacade;
        List<JdbcConsole> list = JdbcConsole.getActiveConsoles(dbFacade.getProject());
        Intrinsics.checkNotNullExpressionValue(list, (String)"getActiveConsoles(...)");
        List<JdbcConsole> allProjectConsoles = list;
        for (JdbcConsole console : allProjectConsoles) {
            String title;
            DatabaseSessionViewService databaseSessionViewService = DatabaseSessionViewService.Companion.getInstance();
            Intrinsics.checkNotNull((Object)((Object)console));
            LogView view = databaseSessionViewService.getClientViewIfAny((DatabaseSessionClientWithFile)console);
            if (view == null || !console.isValid() || !DataSourceUtil.isDataSourceValid((DbPsiFacade)dbFacade, (DasDataSource)((DasDataSource)console.getDataSource()))) continue;
            Intrinsics.checkNotNullExpressionValue((Object)console.getDisplayName(), (String)"getDisplayName(...)");
            view.setConsoleTitle(title);
            view.getContent().setDisplayName(title);
        }
    }
}

