/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.actions;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.DatabaseDataKeys;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.session.SessionsUtil;
import com.intellij.database.dataSource.connection.DGDepartment;
import com.intellij.database.dataSource.connection.DatabaseDepartment;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DatabaseTableGridDataHookUp;
import com.intellij.database.datagrid.DbGridDataHookUpUtil;
import com.intellij.database.datagrid.GridColumn;
import com.intellij.database.datagrid.GridDataHookUp;
import com.intellij.database.datagrid.GridDataHookUpManager;
import com.intellij.database.datagrid.GridRequestSource;
import com.intellij.database.datagrid.GridRow;
import com.intellij.database.diff.TableDiffTool;
import com.intellij.database.editor.DataHookupContainer;
import com.intellij.database.model.DasDataSource;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.basic.BasicElement;
import com.intellij.database.model.basic.BasicNode;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.run.ScriptingClientDataConsumer;
import com.intellij.database.util.DbImplUtilCore;
import com.intellij.database.util.DbUIUtil;
import com.intellij.database.util.DbeTierUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.database.view.DatabaseContextFun;
import com.intellij.database.view.DatabaseNodeWrappingService;
import com.intellij.diff.DiffManager;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerUtil;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompareWithGroup
extends ActionGroup
implements DumbAware {
    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            CompareWithGroup.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public CompareWithGroup() {
        this.getTemplatePresentation().setPerformGroup(true);
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareWithGroup.$$$reportNull$$$0(1);
        }
        super.update(e);
        DbeTierUtil.adjustPaidTier(e);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            CompareWithGroup.$$$reportNull$$$0(2);
        }
        ListPopup popup2 = JBPopupFactory.getInstance().createActionGroupPopup(DatabaseBundle.message((String)"popup.title.data.grids", (Object[])new Object[0]), (ActionGroup)this, e.getDataContext(), JBPopupFactory.ActionSelectionAid.SPEEDSEARCH, false, null, 20);
        DbUIUtil.showPopup((JBPopup)popup2, null, e);
    }

    public AnAction @NotNull [] getChildren(@Nullable AnActionEvent e) {
        if (e == null) {
            if (EMPTY_ARRAY == null) {
                CompareWithGroup.$$$reportNull$$$0(3);
            }
            return EMPTY_ARRAY;
        }
        Pair<@Nls String, // Could not load outer class - annotation placement on inner may be incorrect
        GridDataHookUpManager.HookUpHandle> current = CompareWithGroup.getCurrentHookUp(e.getDataContext());
        if (current == null) {
            if (EMPTY_ARRAY == null) {
                CompareWithGroup.$$$reportNull$$$0(4);
            }
            return EMPTY_ARRAY;
        }
        ArrayList<AnAction> result2 = new ArrayList<AnAction>();
        result2.add((AnAction)new MyDiffAction((String)current.getFirst(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond(), (GridDataHookUpManager.HookUpHandle)current.getSecond()));
        CompareWithGroup.appendConsoles(result2, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        CompareWithGroup.appendEditors(result2, e.getDataContext(), (String)current.getFirst(), (GridDataHookUpManager.HookUpHandle)current.getSecond());
        AnAction[] anActionArray = result2.isEmpty() ? EMPTY_ARRAY : result2.toArray(AnAction.EMPTY_ARRAY);
        if (anActionArray == null) {
            CompareWithGroup.$$$reportNull$$$0(5);
        }
        return anActionArray;
    }

    private static void appendConsoles(@NotNull List<AnAction> result2, @NotNull DataContext ctx, @NlsContexts.Label @NotNull String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        Project project;
        if (result2 == null) {
            CompareWithGroup.$$$reportNull$$$0(6);
        }
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(7);
        }
        if (curName == null) {
            CompareWithGroup.$$$reportNull$$$0(8);
        }
        if (curHandle == null) {
            CompareWithGroup.$$$reportNull$$$0(9);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(ctx)) == null) {
            return;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance((Project)project);
        for (JdbcConsole console : JdbcConsole.getActiveConsoles(project)) {
            for (Content content : console.getContents()) {
                GridDataHookUpManager.HookUpHandle handle;
                DataGrid grid = ScriptingClientDataConsumer.getDataGrid(content);
                if (grid == null || (handle = hookUpManager.getHandle(grid.getDataHookup())).equals((Object)curHandle)) continue;
                result2.add((AnAction)new MyDiffAction(curName, content.getTabName(), curHandle, handle));
            }
        }
    }

    private static void appendEditors(@NotNull List<AnAction> result2, @NotNull DataContext ctx, @NlsContexts.Label @NotNull String curName, @NotNull GridDataHookUpManager.HookUpHandle curHandle) {
        Project project;
        if (result2 == null) {
            CompareWithGroup.$$$reportNull$$$0(10);
        }
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(11);
        }
        if (curName == null) {
            CompareWithGroup.$$$reportNull$$$0(12);
        }
        if (curHandle == null) {
            CompareWithGroup.$$$reportNull$$$0(13);
        }
        if ((project = (Project)CommonDataKeys.PROJECT.getData(ctx)) == null) {
            return;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance((Project)project);
        for (FileEditor editor2 : editorManager.getAllEditors()) {
            GridDataHookUpManager.HookUpHandle handle;
            DataHookupContainer tableEditor = (DataHookupContainer)ObjectUtils.tryCast((Object)editor2, DataHookupContainer.class);
            if (tableEditor == null || (handle = hookUpManager.getHandle(tableEditor.getDataHookup())).equals((Object)curHandle)) continue;
            result2.add((AnAction)new MyDiffAction(curName, CompareWithGroup.getEditorTitle(editor2), curHandle, handle));
        }
    }

    private static @Nullable Pair<@Nls String, // Could not load outer class - annotation placement on inner may be incorrect
    GridDataHookUpManager.HookUpHandle> getCurrentHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(14);
        }
        return (Pair)ObjectUtils.chooseNotNull(CompareWithGroup.getCurrentConsoleHookUp(ctx), CompareWithGroup.getCurrentEditorHookUp(ctx));
    }

    private static @Nullable Pair<@Nls String, // Could not load outer class - annotation placement on inner may be incorrect
    GridDataHookUpManager.HookUpHandle> getCurrentConsoleHookUp(@NotNull DataContext ctx) {
        DataGrid currentGrid;
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(15);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        ContentManager contentManager = ContentManagerUtil.getContentManagerFromContext((DataContext)ctx, (boolean)false);
        if (contentManager == null || project == null) {
            return null;
        }
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance((Project)project);
        DataGrid gridFromContext = (DataGrid)ctx.getData(DatabaseDataKeys.DATA_GRID_KEY);
        Content currentContent = (Content)ContainerUtil.find((Object[])contentManager.getContents(), content -> content != null && ScriptingClientDataConsumer.getDataGrid(content) == gridFromContext);
        if (currentContent == null) {
            currentContent = contentManager.getSelectedContent();
        }
        DataGrid dataGrid = currentGrid = currentContent != null ? ScriptingClientDataConsumer.getDataGrid(currentContent) : null;
        if (currentGrid == null || gridFromContext != null && currentGrid != gridFromContext) {
            return null;
        }
        return Pair.create((Object)currentContent.getTabName(), (Object)hookUpManager.getHandle(currentGrid.getDataHookup()));
    }

    private static @Nullable Pair<@Nls String, // Could not load outer class - annotation placement on inner may be incorrect
    GridDataHookUpManager.HookUpHandle> getCurrentEditorHookUp(@NotNull DataContext ctx) {
        if (ctx == null) {
            CompareWithGroup.$$$reportNull$$$0(16);
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(ctx);
        VirtualFile file = (VirtualFile)CommonDataKeys.VIRTUAL_FILE.getData(ctx);
        if (project == null || file == null) {
            return null;
        }
        FileEditorManager editorManager = FileEditorManager.getInstance((Project)project);
        GridDataHookUpManager hookUpManager = GridDataHookUpManager.getInstance((Project)project);
        FileEditor selectedEditor = editorManager.getSelectedEditor(file);
        DataHookupContainer editor2 = (DataHookupContainer)ObjectUtils.tryCast((Object)selectedEditor, DataHookupContainer.class);
        if (editor2 == null) {
            return null;
        }
        return Pair.create((Object)CompareWithGroup.getEditorTitle(selectedEditor), (Object)hookUpManager.getHandle(editor2.getDataHookup()));
    }

    @NlsContexts.Label
    private static String getEditorTitle(@NotNull FileEditor editor2) {
        if (editor2 == null) {
            CompareWithGroup.$$$reportNull$$$0(17);
        }
        return editor2.getFile().getPresentableName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/database/run/actions/CompareWithGroup";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 7: 
            case 11: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ctx";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curName";
                break;
            }
            case 9: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "curHandle";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/database/run/actions/CompareWithGroup";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "appendConsoles";
                break;
            }
            case 10: 
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "appendEditors";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentHookUp";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentConsoleHookUp";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEditorHookUp";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getEditorTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17 -> new IllegalArgumentException(string);
        };
    }

    private static class MyDiffAction
    extends DumbAwareAction {
        private final @NlsContexts.Label String myName1;
        private final @NlsContexts.Label String myName2;
        GridDataHookUpManager.HookUpHandle myHandle1;
        GridDataHookUpManager.HookUpHandle myHandle2;

        MyDiffAction(@NlsContexts.Label @NotNull String name1, @NlsContexts.Label @NotNull String name2, @NotNull GridDataHookUpManager.HookUpHandle handle1, @NotNull GridDataHookUpManager.HookUpHandle handle2) {
            if (name1 == null) {
                MyDiffAction.$$$reportNull$$$0(0);
            }
            if (name2 == null) {
                MyDiffAction.$$$reportNull$$$0(1);
            }
            if (handle1 == null) {
                MyDiffAction.$$$reportNull$$$0(2);
            }
            if (handle2 == null) {
                MyDiffAction.$$$reportNull$$$0(3);
            }
            super((handle1 == handle2 ? "*" : "") + StringUtil.escapeMnemonics((String)name2));
            this.myName1 = name1;
            this.myName2 = name2;
            this.myHandle1 = handle1;
            this.myHandle2 = handle2;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project;
            if (e == null) {
                MyDiffAction.$$$reportNull$$$0(4);
            }
            if ((project = e.getProject()) == null) {
                return;
            }
            SimpleDiffRequest dr = new SimpleDiffRequest(this.myName1 + " vs " + this.myName2, (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle1, project), (DiffContent)new TableDiffTool.TableDiffContent(this.myHandle2, project), this.myName1, this.myName2);
            DiffManager.getInstance().showDiff(project, (DiffRequest)dr);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name1";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name2";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handle1";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handle2";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/database/run/actions/CompareWithGroup$MyDiffAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "actionPerformed";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static class DiffTablesAction
    extends DumbAwareAction {
        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                DiffTablesAction.$$$reportNull$$$0(0);
            }
            return actionUpdateThread;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffTablesAction.$$$reportNull$$$0(1);
            }
            Couple<BasicElement> pair = DiffTablesAction.getDiffElements(e);
            Project project = e.getProject();
            if (pair == null || project == null) {
                return;
            }
            DatabaseElementVirtualFileImpl table1 = DatabaseElementVirtualFileImpl.findFile((DbElement)DiffTablesAction.getDbElement(project, (BasicNode)pair.first), (boolean)false);
            DatabaseElementVirtualFileImpl table2 = DatabaseElementVirtualFileImpl.findFile((DbElement)DiffTablesAction.getDbElement(project, (BasicNode)pair.second), (boolean)false);
            if (table1 == null || table2 == null) {
                return;
            }
            String name1 = table1.getPresentableName();
            String name2 = table2.getPresentableName();
            SimpleDiffRequest dr = new SimpleDiffRequest(name1 + " vs " + name2, (DiffContent)new TableDiffTool.TableDiffContent((Function<Disposable, GridDataHookUp<GridRow, GridColumn>>)((Function)d -> DiffTablesAction.createHookup(project, table1, d))), (DiffContent)new TableDiffTool.TableDiffContent((Function<Disposable, GridDataHookUp<GridRow, GridColumn>>)((Function)d -> DiffTablesAction.createHookup(project, table2, d))), name1, name2);
            DiffManager.getInstance().showDiff(project, (DiffRequest)dr);
        }

        @Nullable
        private static DbElement getDbElement(@NotNull Project project, @NotNull BasicNode from) {
            if (project == null) {
                DiffTablesAction.$$$reportNull$$$0(2);
            }
            if (from == null) {
                DiffTablesAction.$$$reportNull$$$0(3);
            }
            return (DbElement)((DatabaseNodeWrappingService)project.getService(DatabaseNodeWrappingService.class)).wrap(from);
        }

        @NotNull
        private static DatabaseTableGridDataHookUp createHookup(Project project, DatabaseElementVirtualFileImpl table1, Disposable d) {
            DbDataSource dataSource = table1.findDataSource(project);
            DatabaseTableGridDataHookUp grid = DbGridDataHookUpUtil.getOrCreateLightweight(project, (VirtualFile)table1, d, (DatabaseDepartment)new DGDepartment.DataEditor(SessionsUtil.getQualifiedClientTitle((Project)project, (DasDataSource)dataSource, (VirtualFile)table1)));
            grid.getLoader().loadFirstPage(new GridRequestSource((GridRequestSource.RequestPlace)new DiffTablesRequestPlace()));
            DatabaseTableGridDataHookUp databaseTableGridDataHookUp = grid;
            if (databaseTableGridDataHookUp == null) {
                DiffTablesAction.$$$reportNull$$$0(4);
            }
            return databaseTableGridDataHookUp;
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                DiffTablesAction.$$$reportNull$$$0(5);
            }
            e.getPresentation().setEnabledAndVisible(DiffTablesAction.getDiffElements(e) != null);
            DbeTierUtil.adjustPaidTier(e);
        }

        @Nullable
        private static Couple<BasicElement> getDiffElements(@NotNull AnActionEvent e) {
            BasicNode[] elements;
            if (e == null) {
                DiffTablesAction.$$$reportNull$$$0(6);
            }
            if ((elements = DatabaseContextFun.getSelectedNodesArray(e.getDataContext())).length != 2) {
                return null;
            }
            BasicElement e1 = (BasicElement)ObjectUtils.tryCast((Object)elements[0], BasicElement.class);
            if (e1 == null || !DbImplUtilCore.isDataTable((ObjectKind)e1.getKind())) {
                return null;
            }
            BasicElement e2 = (BasicElement)ObjectUtils.tryCast((Object)elements[1], BasicElement.class);
            if (e2 == null || !DbImplUtilCore.isDataTable((ObjectKind)e2.getKind())) {
                return null;
            }
            return Couple.of((Object)e1, (Object)e2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 2, 3, 5, 6 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/database/run/actions/CompareWithGroup$DiffTablesAction";
                    break;
                }
                case 1: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "from";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
                case 1: 
                case 2: 
                case 3: 
                case 5: 
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/database/run/actions/CompareWithGroup$DiffTablesAction";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createHookup";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "getDbElement";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getDiffElements";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 2, 3, 5, 6 -> new IllegalArgumentException(string);
            };
        }

        public static class DiffTablesRequestPlace
        implements GridRequestSource.RequestPlace {
            @NotNull
            public GridRequestSource.RequestPlace.RowIdPolicy rowIdPolicy() {
                GridRequestSource.RequestPlace.RowIdPolicy rowIdPolicy = GridRequestSource.RequestPlace.RowIdPolicy.EXCLUDE;
                if (rowIdPolicy == null) {
                    DiffTablesRequestPlace.$$$reportNull$$$0(0);
                }
                return rowIdPolicy;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/actions/CompareWithGroup$DiffTablesAction$DiffTablesRequestPlace", "rowIdPolicy"));
            }
        }
    }
}

