/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.script.generator.ui;

import com.intellij.database.Dbms;
import com.intellij.database.script.generator.CustomScriptingOptions;
import com.intellij.database.script.generator.ScriptCategory;
import com.intellij.database.script.generator.ui.ScriptingSettingsState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.Service;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diagnostic.LoggerKt;
import java.util.Map;
import java.util.concurrent.ConcurrentSkipListMap;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Service(value={Service.Level.PROJECT})
@State(name="SQLScriptSettings", storages={@Storage(value="$WORKSPACE_FILE$")})
@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\b\b\u0007\u0018\u0000 \"2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\"B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J#\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0018\u001a\u0004\u0018\u00010\bH\u0086\u0002J\u001b\u0010\u0019\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0086\u0002J\b\u0010\u001d\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u0002H\u0016J\b\u0010 \u001a\u00020\u0017H\u0016J\n\u0010!\u001a\u00020\u0007H\u0096\u0080\u0004R\u001a\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001c\u0010\u000e\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\rR\u0011\u0010\u001a\u001a\u00020\u001b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u001c\u00a8\u0006#"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings;", "Lcom/intellij/openapi/components/PersistentStateComponent;", "Lcom/intellij/database/script/generator/ui/ScriptingSettingsState;", "<init>", "()V", "matrix", "Ljava/util/concurrent/ConcurrentSkipListMap;", "", "Lcom/intellij/database/script/generator/CustomScriptingOptions;", "outputPath", "getOutputPath", "()Ljava/lang/String;", "setOutputPath", "(Ljava/lang/String;)V", "outputLayout", "getOutputLayout", "setOutputLayout", "keyOf", "dbms", "Lcom/intellij/database/Dbms;", "category", "Lcom/intellij/database/script/generator/ScriptCategory;", "set", "", "options", "get", "isEmpty", "", "()Z", "getState", "loadState", "state", "noStateLoaded", "toString", "Companion", "intellij.database.impl"})
@SourceDebugExtension(value={"SMAP\nScriptGeneratorSettings.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ScriptGeneratorSettings.kt\ncom/intellij/database/script/generator/ui/ScriptGeneratorSettings\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,120:1\n82#2,3:121\n*S KotlinDebug\n*F\n+ 1 ScriptGeneratorSettings.kt\ncom/intellij/database/script/generator/ui/ScriptGeneratorSettings\n*L\n71#1:121,3\n*E\n"})
public final class ScriptGeneratorSettings
implements PersistentStateComponent<ScriptingSettingsState> {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final ConcurrentSkipListMap<String, CustomScriptingOptions> matrix = new ConcurrentSkipListMap(StringsKt.getCASE_INSENSITIVE_ORDER((StringCompanionObject)StringCompanionObject.INSTANCE));
    @Nullable
    private volatile String outputPath;
    @Nullable
    private volatile String outputLayout;
    @NotNull
    private static final Logger log;

    @Nullable
    public final String getOutputPath() {
        return this.outputPath;
    }

    public final void setOutputPath(@Nullable String string) {
        this.outputPath = string;
    }

    @Nullable
    public final String getOutputLayout() {
        return this.outputLayout;
    }

    public final void setOutputLayout(@Nullable String string) {
        this.outputLayout = string;
    }

    private final String keyOf(Dbms dbms, ScriptCategory category) {
        return dbms.getName() + "." + category.getCode();
    }

    public final void set(@NotNull Dbms dbms, @NotNull ScriptCategory category, @Nullable CustomScriptingOptions options) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        String key = this.keyOf(dbms, category);
        if (options != null) {
            ((Map)this.matrix).put(key, options);
        } else {
            this.matrix.remove(key);
        }
    }

    @Nullable
    public final CustomScriptingOptions get(@NotNull Dbms dbms, @NotNull ScriptCategory category) {
        Intrinsics.checkNotNullParameter((Object)dbms, (String)"dbms");
        Intrinsics.checkNotNullParameter((Object)category, (String)"category");
        String key = this.keyOf(dbms, category);
        return this.matrix.get(key);
    }

    public final boolean isEmpty() {
        return this.matrix.isEmpty();
    }

    @NotNull
    public ScriptingSettingsState getState() {
        ScriptingSettingsState state = new ScriptingSettingsState();
        for (Map.Entry entry : ((Map)this.matrix).entrySet()) {
            String k = (String)entry.getKey();
            CustomScriptingOptions o = (CustomScriptingOptions)entry.getValue();
            String string = o.export();
            ((Map)state.getMatrix()).put(k, string);
        }
        state.setOutputPath(this.outputPath);
        state.setOutputLayout(this.outputLayout);
        return state;
    }

    public void loadState(@NotNull ScriptingSettingsState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        this.matrix.clear();
        this.outputLayout = state.getOutputLayout();
        this.outputPath = state.getOutputPath();
        for (Map.Entry entry : ((Map)state.getMatrix()).entrySet()) {
            Object object;
            String k = (String)entry.getKey();
            String s = (String)entry.getValue();
            Logger $this$runAndLogException$iv = log;
            boolean $i$f$runAndLogException = false;
            Logger logger = $this$runAndLogException$iv;
            try {
                Logger $this$runAndLogException_u24lambda_u240$iv = logger;
                boolean bl = false;
                boolean bl2 = false;
                Intrinsics.checkNotNull((Object)s);
                CustomScriptingOptions o = new CustomScriptingOptions(s);
                ((Map)this.matrix).put(k, o);
                object = Result.constructor-impl((Object)Unit.INSTANCE);
            }
            catch (Throwable throwable) {
                object = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            LoggerKt.getOrLogException((Object)object, (Logger)$this$runAndLogException$iv);
        }
    }

    public void noStateLoaded() {
        this.matrix.clear();
    }

    @NotNull
    public String toString() {
        StringBuilder b = new StringBuilder();
        for (Map.Entry entry : ((Map)this.matrix).entrySet()) {
            String k = (String)entry.getKey();
            CustomScriptingOptions v = (CustomScriptingOptions)entry.getValue();
            b.append(k).append(" -> ").append(v.export()).append('\n');
        }
        String string = b.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    static {
        Logger logger = Logger.getInstance(ScriptGeneratorSettings.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        log = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u00068\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0003\u00a8\u0006\b"}, d2={"Lcom/intellij/database/script/generator/ui/ScriptGeneratorSettings$Companion;", "", "<init>", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getLog$annotations", "intellij.database.impl"})
    private static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getLog$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

