/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.actions.timestamps;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.util.TextRange;
import com.intellij.util.ApplicationKt;
import com.jetbrains.rd.ide.document.DocumentSynchronizer;
import com.jetbrains.rd.ide.model.DocumentTimestampModel;
import com.jetbrains.rd.ide.model.LogicalLineTimestampModel;
import com.jetbrains.rd.ide.model.RangeMarkerTimestampModel;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.UpgradableActionTimestampModel;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.actions.ActionTimestamp;
import com.jetbrains.rdserver.actions.ActionTimestampKey;
import com.jetbrains.rdserver.actions.ActionTimestampSet;
import com.jetbrains.rdserver.actions.TimestampUpgradeResult;
import com.jetbrains.rdserver.actions.UpgradableTimestamp;
import com.jetbrains.rdserver.actions.timestamps.ProjectTimestamp;
import com.jetbrains.rdserver.actions.timestamps.RangeMarkerTimestamp;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u000f2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\u000fB\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/LogicalLineTimestamp;", "Lcom/jetbrains/rdserver/actions/UpgradableTimestamp;", "Lcom/jetbrains/rd/ide/model/LogicalLineTimestampModel;", "lineNumber", "", "rangeMarkerTimestamp", "Lcom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp;", "<init>", "(ILcom/jetbrains/rdserver/actions/timestamps/RangeMarkerTimestamp;)V", "getData", "()Ljava/lang/Integer;", "upgrade", "Lcom/jetbrains/rdserver/actions/TimestampUpgradeResult;", "actualSet", "Lcom/jetbrains/rdserver/actions/ActionTimestampSet;", "Companion", "intellij.platform.backend.split"})
public final class LogicalLineTimestamp
extends UpgradableTimestamp<LogicalLineTimestampModel> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int lineNumber;
    @NotNull
    private final RangeMarkerTimestamp rangeMarkerTimestamp;
    @NotNull
    private static final String NAME = EditorGutterComponentEx.LOGICAL_LINE_AT_CURSOR.getName();
    @NotNull
    private static final ActionTimestampKey<LogicalLineTimestamp, LogicalLineTimestampModel> KEY = new ActionTimestampKey(NAME);

    public LogicalLineTimestamp(int lineNumber, @NotNull RangeMarkerTimestamp rangeMarkerTimestamp) {
        Intrinsics.checkNotNullParameter((Object)rangeMarkerTimestamp, (String)"rangeMarkerTimestamp");
        super(KEY, (UpgradableActionTimestampModel)new LogicalLineTimestampModel(lineNumber, (RangeMarkerTimestampModel)rangeMarkerTimestamp.getModel()));
        this.lineNumber = lineNumber;
        this.rangeMarkerTimestamp = rangeMarkerTimestamp;
    }

    @Override
    @NotNull
    public Integer getData() {
        return this.lineNumber;
    }

    @Override
    @NotNull
    public TimestampUpgradeResult upgrade(@NotNull ActionTimestampSet actualSet) {
        Intrinsics.checkNotNullParameter((Object)actualSet, (String)"actualSet");
        TimestampUpgradeResult rangeMarkerUpgradeResult = this.rangeMarkerTimestamp.upgrade(actualSet);
        if (!(rangeMarkerUpgradeResult instanceof TimestampUpgradeResult.Success)) {
            return rangeMarkerUpgradeResult;
        }
        ActionTimestamp actionTimestamp = ((TimestampUpgradeResult.Success)rangeMarkerUpgradeResult).getTimestamp();
        Intrinsics.checkNotNull(actionTimestamp, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.actions.timestamps.RangeMarkerTimestamp");
        RangeMarkerTimestamp upgradedRange = (RangeMarkerTimestamp)actionTimestamp;
        DocumentTimestampModel documentTimestampModel = ((LogicalLineTimestampModel)this.getModel()).getRangeMarkerTimestampModel().getDocument();
        RdDocumentId documentId = documentTimestampModel.getDocumentId();
        ProjectTimestamp projectTimestamp = actualSet.getTimestamp(ProjectTimestamp.Companion.getNAME());
        if (projectTimestamp == null || (projectTimestamp = projectTimestamp.getData()) == null) {
            return new TimestampUpgradeResult.Failure("No Project");
        }
        ProjectTimestamp project = projectTimestamp;
        BackendDocumentHost documentHost = BackendDocumentHost.Companion.getInstance(ClientSessionsUtil.getCurrentSession((Application)ApplicationKt.getApplication()));
        DocumentSynchronizer documentSynchronizer = documentHost.tryGetSynchronizer(documentId);
        if (documentSynchronizer == null) {
            return new TimestampUpgradeResult.Failure("No Document Synchronizer");
        }
        DocumentSynchronizer synchronizer = documentSynchronizer;
        Document document = synchronizer.getDocument();
        TextRange range = ProtocolConversionsKt.toTextRange(((RangeMarkerTimestampModel)upgradedRange.getModel()).getRange());
        if (range.getStartOffset() < 0 || range.getEndOffset() > document.getTextLength()) {
            return new TimestampUpgradeResult.Failure("range timestamp is out of document bounds");
        }
        int lineNumber = document.getLineNumber(range.getStartOffset());
        return new TimestampUpgradeResult.Success(new LogicalLineTimestamp(lineNumber, upgradedRange));
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\t0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/actions/timestamps/LogicalLineTimestamp$Companion;", "", "<init>", "()V", "NAME", "", "KEY", "Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "Lcom/jetbrains/rdserver/actions/timestamps/LogicalLineTimestamp;", "Lcom/jetbrains/rd/ide/model/LogicalLineTimestampModel;", "getKEY", "()Lcom/jetbrains/rdserver/actions/ActionTimestampKey;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ActionTimestampKey<LogicalLineTimestamp, LogicalLineTimestampModel> getKEY() {
            return KEY;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

