/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rd.util.reactive.BoolPropertyExKt;
import com.jetbrains.rd.util.reactive.IViewable;
import com.jetbrains.rd.util.reactive.Property;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u000b\u001a\u00020\nJ\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u000fJ\"\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00032\u0012\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\r0\u0012J\u0016\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u00032\u0006\u0010\u0015\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupSuppressor;", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "suppressRequests", "", "isSuppressed", "Lcom/jetbrains/rd/util/reactive/Property;", "", "shouldSuppress", "onRelease", "", "action", "Lkotlin/Function0;", "onSuppress", "lt", "Lkotlin/Function1;", "suppress", "suppressLifetime", "reason", "", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendMarkupSuppressor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendMarkupSuppressor.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupSuppressor\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 Logger.kt\ncom/jetbrains/rd/platform/util/LoggerKt\n*L\n1#1,47:1\n67#2,4:48\n67#2,4:52\n13#2:57\n13#3:56\n*S KotlinDebug\n*F\n+ 1 BackendMarkupSuppressor.kt\ncom/jetbrains/rdserver/daemon/BackendMarkupSuppressor\n*L\n29#1:48,4\n37#1:52,4\n44#1:57\n44#1:56\n*E\n"})
public final class BackendMarkupSuppressor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lifetime lifetime;
    private int suppressRequests;
    @NotNull
    private Property<Boolean> isSuppressed;
    @NotNull
    private static final Logger logger;

    public BackendMarkupSuppressor(@NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this.lifetime = lifetime;
        this.isSuppressed = new Property((Object)false);
    }

    public final boolean shouldSuppress() {
        return (Boolean)this.isSuppressed.getValue();
    }

    public final void onRelease(@NotNull Function0<Unit> action) {
        Intrinsics.checkNotNullParameter(action, (String)"action");
        this.isSuppressed.getChange().advise(this.lifetime, arg_0 -> BackendMarkupSuppressor.onRelease$lambda$0(action, arg_0));
    }

    public final void onSuppress(@NotNull Lifetime lt, @NotNull Function1<? super Lifetime, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)lt, (String)"lt");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        BoolPropertyExKt.whenTrue((IViewable)((IViewable)this.isSuppressed), (Lifetime)lt, arg_0 -> BackendMarkupSuppressor.onSuppress$lambda$0(action, arg_0));
    }

    public final void suppress(@NotNull Lifetime suppressLifetime, @NotNull String reason) {
        Intrinsics.checkNotNullParameter((Object)suppressLifetime, (String)"suppressLifetime");
        Intrinsics.checkNotNullParameter((Object)reason, (String)"reason");
        if (RLifetimeKt.isNotAlive((Lifetime)suppressLifetime)) {
            return;
        }
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Starting suppression: " + reason);
        }
        int n = this.suppressRequests;
        this.suppressRequests = n + 1;
        if (this.suppressRequests > 0) {
            this.isSuppressed.set((Object)true);
        }
        RLifetimeKt.intersect((Lifetime)suppressLifetime, (Lifetime)this.lifetime).onTermination(() -> BackendMarkupSuppressor.suppress$lambda$1(this, reason));
    }

    private static final Unit onRelease$lambda$0(Function0 $action, boolean value) {
        if (!value) {
            $action.invoke();
        }
        return Unit.INSTANCE;
    }

    private static final Unit onSuppress$lambda$0(Function1 $action, Lifetime ltLt) {
        Intrinsics.checkNotNullParameter((Object)ltLt, (String)"ltLt");
        $action.invoke((Object)ltLt);
        return Unit.INSTANCE;
    }

    private static final Unit suppress$lambda$1(BackendMarkupSuppressor this$0, String $reason) {
        int n = this$0.suppressRequests;
        this$0.suppressRequests = n + -1;
        if (this$0.suppressRequests == 0) {
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Stopping suppression: " + $reason);
            }
            this$0.isSuppressed.set((Object)false);
        }
        return Unit.INSTANCE;
    }

    static {
        boolean $i$f$getLogger = false;
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendMarkupSuppressor.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendMarkupSuppressor.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/jetbrains/rdserver/daemon/BackendMarkupSuppressor$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

