/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.highlighters.breakpoints;

import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.xdebugger.ui.DebuggerColors;
import com.jetbrains.rd.ide.model.HighlighterModel;
import com.jetbrains.rdserver.daemon.BackendHighlighterModelCreator;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/daemon/highlighters/breakpoints/BreakpointProtocolHighlighterModelCreator;", "Lcom/jetbrains/rdserver/daemon/BackendHighlighterModelCreator;", "<init>", "()V", "accept", "", "highlighter", "Lcom/intellij/openapi/editor/ex/RangeHighlighterEx;", "contributor", "Lcom/jetbrains/rdserver/daemon/BackendMarkupModelContributor;", "createModel", "Lcom/jetbrains/rd/ide/model/HighlighterModel;", "intellij.platform.backend.split"})
public final class BreakpointProtocolHighlighterModelCreator
implements BackendHighlighterModelCreator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean accept(@NotNull RangeHighlighterEx highlighter, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        if (contributor.getAppSession().isOwner()) {
            return false;
        }
        TextAttributesKey attributesKey = DebuggerColors.BREAKPOINT_ATTRIBUTES;
        TextAttributes breakpointAttributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(attributesKey);
        if (Intrinsics.areEqual((Object)highlighter.getTextAttributesKey(), (Object)attributesKey)) return true;
        if (Intrinsics.areEqual((Object)highlighter.getTextAttributes(), (Object)breakpointAttributes)) return true;
        if (Intrinsics.areEqual((Object)highlighter.getUserData(DebuggerColors.BREAKPOINT_HIGHLIGHTER_KEY), (Object)true)) return true;
        GutterIconRenderer gutterIconRenderer = highlighter.getGutterIconRenderer();
        Object object = gutterIconRenderer;
        if (gutterIconRenderer == null) return false;
        Class<?> clazz = object.getClass();
        object = clazz;
        if (clazz == null) return false;
        String string = ((Class)object).getName();
        object = string;
        if (string == null) return false;
        if (!StringsKt.contains$default((CharSequence)((CharSequence)object), (CharSequence)"BreakpointGutterIconRenderer", (boolean)false, (int)2, null)) return false;
        return true;
    }

    @Override
    @Nullable
    public HighlighterModel createModel(@NotNull RangeHighlighterEx highlighter, @NotNull BackendMarkupModelContributor contributor) {
        Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
        Intrinsics.checkNotNullParameter((Object)contributor, (String)"contributor");
        return null;
    }
}

