/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.daemon.syntax;

import com.intellij.diff.tools.fragmented.UnifiedEditorHighlighter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.MarkupIterator;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.ex.RangeHighlighterEx;
import com.intellij.openapi.editor.ex.util.LexerEditorHighlighter;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.editor.impl.FilteringMarkupIterator;
import com.intellij.openapi.editor.impl.event.MarkupModelListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.editor.rd.LocalEditorSupportUtil;
import com.intellij.openapi.fileEditor.impl.text.AsyncEditorLoader;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.util.Key;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.rd.ide.model.TextControlId;
import com.jetbrains.rd.ide.model.TextControlModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.daemon.BackendEditorMarkupModelContributor;
import com.jetbrains.rdserver.daemon.BackendMarkupHost;
import com.jetbrains.rdserver.daemon.BackendMarkupModelContributorKt;
import com.jetbrains.rdserver.daemon.syntax.HighlightersDiffCalculatorKt;
import com.jetbrains.rdserver.daemon.syntax.LexerBasedSyntaxIterator;
import com.jetbrains.rdserver.daemon.syntax.MarkupBasedSyntaxIterator;
import com.jetbrains.rdserver.daemon.syntax.SyntaxHighlighterData;
import com.jetbrains.rdserver.editors.BackendEditorHostListener;
import java.beans.PropertyChangeEvent;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001:\u0002#$B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002J%\u0010\u0013\u001a\u00020\u00142\u000b\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\n2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0017\u001a\u00020\u00112\u0006\u0010\u0018\u001a\u00020\u0011H\u0002J&\u0010\u001d\u001a\u00020\b2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000e\u001a\u00020 2\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\b0\"H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\u0006\u001a\u0015\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u0007\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "KEY", "Lcom/intellij/openapi/util/Key;", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "updateSyntaxHighlighters", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "fragmentStart", "", "fragmentEnd", "createMarkupIterator", "Lcom/jetbrains/rdserver/daemon/syntax/MarkupBasedSyntaxIterator;", "markup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "start", "end", "createLexerIterator", "Lcom/jetbrains/rdserver/daemon/syntax/LexerBasedSyntaxIterator;", "lexerHighlighter", "Lcom/intellij/openapi/editor/highlighter/EditorHighlighter;", "performWhenLoaded", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "Lcom/intellij/openapi/editor/Editor;", "action", "Lkotlin/Function0;", "MyEditorHostListener", "MergeableUpdateSyntaxHighlightersTask", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nMarkupBasedLexerHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkupBasedLexerHighlighting.kt\ncom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n13#2:187\n*S KotlinDebug\n*F\n+ 1 MarkupBasedLexerHighlighting.kt\ncom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting\n*L\n41#1:187\n*E\n"})
public final class MarkupBasedLexerHighlighting {
    @NotNull
    public static final MarkupBasedLexerHighlighting INSTANCE = new MarkupBasedLexerHighlighting();
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final Key<Unit> KEY;

    private MarkupBasedLexerHighlighting() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void updateSyntaxHighlighters(ClientAppSession session, EditorImpl editor, int fragmentStart, int fragmentEnd) {
        Pair pair;
        EditorHighlighter editorHighlighter = editor.getHighlighter();
        Intrinsics.checkNotNullExpressionValue((Object)editorHighlighter, (String)"getHighlighter(...)");
        EditorHighlighter lexerHighlighter = editorHighlighter;
        if (!(lexerHighlighter instanceof LexerEditorHighlighter) && !(lexerHighlighter instanceof UnifiedEditorHighlighter)) {
            return;
        }
        int hStart = Math.max(fragmentStart - 1, 0);
        int hEnd = Math.min(fragmentEnd + 1, editor.getDocument().getTextLength());
        MarkupModelEx markupModelEx = editor.getMarkupModel();
        Intrinsics.checkNotNullExpressionValue((Object)markupModelEx, (String)"getMarkupModel(...)");
        MarkupModelEx editorMarkup = markupModelEx;
        MarkupBasedSyntaxIterator old = this.createMarkupIterator(editorMarkup, hStart, hEnd);
        int lStart = Math.max(fragmentStart - 2, 0);
        int lEnd = Math.min(fragmentEnd + 2, editor.getDocument().getTextLength());
        LexerBasedSyntaxIterator lexerBasedSyntaxIterator = this.createLexerIterator(lexerHighlighter, lStart, lEnd);
        try {
            pair = HighlightersDiffCalculatorKt.calculateDiff(old, lexerBasedSyntaxIterator);
        }
        finally {
            old.dispose();
            lexerBasedSyntaxIterator.dispose();
        }
        Pair pair2 = pair;
        List toRemove = (List)pair2.component1();
        List toAdd = (List)pair2.component2();
        BackendEditorMarkupModelContributor contributor = BackendMarkupHost.Companion.getInstance(session).getContributor((Editor)editor);
        BackendMarkupModelContributorKt.performInBulkIfPossible$default(contributor, toRemove, 0, arg_0 -> MarkupBasedLexerHighlighting.updateSyntaxHighlighters$lambda$0(editorMarkup, arg_0), 2, null);
        BackendMarkupModelContributorKt.performInBulkIfPossible$default(contributor, toAdd, 0, arg_0 -> MarkupBasedLexerHighlighting.updateSyntaxHighlighters$lambda$1(editorMarkup, arg_0), 2, null);
    }

    private final MarkupBasedSyntaxIterator createMarkupIterator(MarkupModelEx markup, int start, int end) {
        MarkupIterator markupIterator = markup.overlappingIterator(start, end);
        Intrinsics.checkNotNullExpressionValue((Object)markupIterator, (String)"overlappingIterator(...)");
        MarkupIterator overlappingIterator = markupIterator;
        FilteringMarkupIterator markupIterator2 = new FilteringMarkupIterator(overlappingIterator, arg_0 -> MarkupBasedLexerHighlighting.createMarkupIterator$lambda$1(MarkupBasedLexerHighlighting::createMarkupIterator$lambda$0, arg_0));
        return new MarkupBasedSyntaxIterator((MarkupIterator<RangeHighlighterEx>)((MarkupIterator)markupIterator2));
    }

    private final LexerBasedSyntaxIterator createLexerIterator(EditorHighlighter lexerHighlighter, int start, int end) {
        return new LexerBasedSyntaxIterator(lexerHighlighter, start, end);
    }

    private final void performWhenLoaded(Lifetime lifetime, Editor editor, Function0<Unit> action) {
        ApplicationManager.getApplication().invokeLater(() -> MarkupBasedLexerHighlighting.performWhenLoaded$lambda$0(editor, lifetime, action));
    }

    private static final Unit updateSyntaxHighlighters$lambda$1$0(SyntaxHighlighterData $it, RangeHighlighterEx ex) {
        Intrinsics.checkNotNull((Object)ex);
        HighlightersDiffCalculatorKt.setTextAttributesKeys((RangeHighlighter)ex, $it.getTextAttributesKeys());
        return Unit.INSTANCE;
    }

    private static final void updateSyntaxHighlighters$lambda$1$1(Function1 $tmp0, Object p0) {
        $tmp0.invoke(p0);
    }

    private static final Unit updateSyntaxHighlighters$lambda$0(MarkupModelEx $editorMarkup, RangeHighlighterEx it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $editorMarkup.removeHighlighter((RangeHighlighter)it);
        return Unit.INSTANCE;
    }

    private static final Unit updateSyntaxHighlighters$lambda$1(MarkupModelEx $editorMarkup, SyntaxHighlighterData it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        RangeHighlighterEx rangeHighlighterEx = $editorMarkup.addRangeHighlighterAndChangeAttributes((TextAttributesKey)ArraysKt.last((Object[])it.getTextAttributesKeys()), it.getStartOffset(), it.getEndOffset(), 1000, HighlighterTargetArea.EXACT_RANGE, false, arg_0 -> MarkupBasedLexerHighlighting.updateSyntaxHighlighters$lambda$1$1(arg_0 -> MarkupBasedLexerHighlighting.updateSyntaxHighlighters$lambda$1$0(it, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)rangeHighlighterEx, (String)"addRangeHighlighterAndChangeAttributes(...)");
        RangeHighlighterEx addedHighlighter = rangeHighlighterEx;
        addedHighlighter.putUserData(KEY, (Object)Unit.INSTANCE);
        return Unit.INSTANCE;
    }

    private static final boolean createMarkupIterator$lambda$0(RangeHighlighterEx it) {
        Intrinsics.checkNotNull((Object)it);
        return HighlightersDiffCalculatorKt.getTextAttributesKeys((RangeHighlighter)it) != null;
    }

    private static final boolean createMarkupIterator$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    private static final void performWhenLoaded$lambda$0$0(Editor $editor, Lifetime $lifetime, Function0 $action) {
        if ($editor.isDisposed() || RLifetimeKt.isNotAlive((Lifetime)$lifetime)) {
            return;
        }
        $action.invoke();
    }

    private static final void performWhenLoaded$lambda$0(Editor $editor, Lifetime $lifetime, Function0 $action) {
        AsyncEditorLoader.Companion.performWhenLoaded($editor, () -> MarkupBasedLexerHighlighting.performWhenLoaded$lambda$0$0($editor, $lifetime, $action));
    }

    public static final /* synthetic */ Key access$getKEY$p() {
        return KEY;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(MarkupBasedLexerHighlighting.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Key key = Key.create((String)"MarkupBasedLexerHighlighting_Key");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        KEY = key;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B/\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\t\u00a2\u0006\u0004\b\u000b\u0010\fJ\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u0010\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001f\u001a\u00020\u0001H\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u001a\u0010\n\u001a\u00020\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0014\"\u0004\b\u0018\u0010\u0016R\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001d\u00a8\u0006 "}, d2={"Lcom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting$MergeableUpdateSyntaxHighlightersTask;", "Lcom/intellij/util/ui/update/Update;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "editor", "Lcom/intellij/openapi/editor/impl/EditorImpl;", "start", "", "end", "<init>", "(Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/intellij/openapi/client/ClientAppSession;Lcom/intellij/openapi/editor/impl/EditorImpl;II)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getSession", "()Lcom/intellij/openapi/client/ClientAppSession;", "getEditor", "()Lcom/intellij/openapi/editor/impl/EditorImpl;", "getStart", "()I", "setStart", "(I)V", "getEnd", "setEnd", "run", "", "isExpired", "", "()Z", "canEat", "update", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nMarkupBasedLexerHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkupBasedLexerHighlighting.kt\ncom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting$MergeableUpdateSyntaxHighlightersTask\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n67#2,4:187\n67#2,4:191\n*S KotlinDebug\n*F\n+ 1 MarkupBasedLexerHighlighting.kt\ncom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting$MergeableUpdateSyntaxHighlightersTask\n*L\n166#1:187,4\n177#1:191,4\n*E\n"})
    private static final class MergeableUpdateSyntaxHighlightersTask
    extends Update {
        @NotNull
        private final Lifetime lifetime;
        @NotNull
        private final ClientAppSession session;
        @NotNull
        private final EditorImpl editor;
        private volatile int start;
        private volatile int end;

        public MergeableUpdateSyntaxHighlightersTask(@NotNull Lifetime lifetime, @NotNull ClientAppSession session, @NotNull EditorImpl editor, int start, int end) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            super(new Object(), false, 0, 6, null);
            this.lifetime = lifetime;
            this.session = session;
            this.editor = editor;
            this.start = start;
            this.end = end;
        }

        @NotNull
        public final Lifetime getLifetime() {
            return this.lifetime;
        }

        @NotNull
        public final ClientAppSession getSession() {
            return this.session;
        }

        @NotNull
        public final EditorImpl getEditor() {
            return this.editor;
        }

        public final int getStart() {
            return this.start;
        }

        public final void setStart(int n) {
            this.start = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        public void run() {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("update syntax highlighters (" + this.start + ", " + this.end + ")");
            }
            INSTANCE.updateSyntaxHighlighters(this.session, this.editor, this.start, this.end);
        }

        public boolean isExpired() {
            return RLifetimeKt.isNotAlive((Lifetime)this.lifetime) || this.editor.isDisposed();
        }

        public boolean canEat(@NotNull Update update2) {
            Intrinsics.checkNotNullParameter((Object)update2, (String)"update");
            if (update2 instanceof MergeableUpdateSyntaxHighlightersTask) {
                int newStart = Math.min(this.start, ((MergeableUpdateSyntaxHighlightersTask)update2).start);
                int newEnd = Math.max(this.end, ((MergeableUpdateSyntaxHighlightersTask)update2).end);
                Logger $this$trace$iv = LOG;
                boolean $i$f$trace = false;
                if ($this$trace$iv.isTraceEnabled()) {
                    Logger logger = $this$trace$iv;
                    boolean bl = false;
                    logger.trace("merge (" + this.start + "," + this.end + ")+(" + ((MergeableUpdateSyntaxHighlightersTask)update2).start + "," + ((MergeableUpdateSyntaxHighlightersTask)update2).end + ")->(" + newStart + "," + newEnd + ")");
                }
                this.start = newStart;
                this.end = newEnd;
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J:\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting$MyEditorHostListener;", "Lcom/jetbrains/rdserver/editors/BackendEditorHostListener;", "<init>", "()V", "editorBound", "", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "appSession", "Lcom/intellij/openapi/client/ClientAppSession;", "projectSession", "Lcom/intellij/openapi/client/ClientProjectSession;", "textControlId", "Lcom/jetbrains/rd/ide/model/TextControlId;", "editorModel", "Lcom/jetbrains/rd/ide/model/TextControlModel;", "editor", "Lcom/intellij/openapi/editor/Editor;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nMarkupBasedLexerHighlighting.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MarkupBasedLexerHighlighting.kt\ncom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting$MyEditorHostListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,186:1\n67#2,4:187\n*S KotlinDebug\n*F\n+ 1 MarkupBasedLexerHighlighting.kt\ncom/jetbrains/rdserver/daemon/syntax/MarkupBasedLexerHighlighting$MyEditorHostListener\n*L\n75#1:187,4\n*E\n"})
    public static final class MyEditorHostListener
    implements BackendEditorHostListener {
        @Override
        public void editorBound(@NotNull Lifetime lifetime, @NotNull ClientAppSession appSession, @Nullable ClientProjectSession projectSession, @NotNull TextControlId textControlId, @NotNull TextControlModel editorModel, @NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
            Intrinsics.checkNotNullParameter((Object)appSession, (String)"appSession");
            Intrinsics.checkNotNullParameter((Object)textControlId, (String)"textControlId");
            Intrinsics.checkNotNullParameter((Object)editorModel, (String)"editorModel");
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            if (!(editor instanceof EditorImpl)) {
                return;
            }
            if (appSession.isLocal()) {
                return;
            }
            if (LocalEditorSupportUtil.isLocalEditorSupport((Editor)editor)) {
                return;
            }
            Disposable disposable = LifetimeDisposableExKt.createNestedDisposable$default((Lifetime)lifetime, null, (int)1, null);
            MergingUpdateQueue mergeQueue = new MergingUpdateQueue("BackendEditorHostListener.MergingUpdateQueue", 200, true, null, disposable, null, true);
            INSTANCE.performWhenLoaded(lifetime, editor, (Function0<Unit>)() -> MyEditorHostListener.editorBound$lambda$0(editor, disposable, appSession, mergeQueue, lifetime));
        }

        private static final void editorBound$lambda$0$0(MergingUpdateQueue $mergeQueue, Lifetime $lifetime, ClientAppSession $appSession, Editor $editor, int fragmentStart, int fragmentEnd) {
            Logger $this$trace$iv = LOG;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("queue update (" + fragmentStart + ", " + fragmentEnd + ") and flush instantly in Highlighter Listener");
            }
            $mergeQueue.queue((Update)new MergeableUpdateSyntaxHighlightersTask($lifetime, $appSession, (EditorImpl)$editor, fragmentStart, fragmentEnd));
            $mergeQueue.flush();
        }

        private static final void editorBound$lambda$0$1(ClientAppSession $appSession, Editor $editor, PropertyChangeEvent evt) {
            if (Intrinsics.areEqual((Object)evt.getPropertyName(), (Object)"highlighter")) {
                INSTANCE.updateSyntaxHighlighters($appSession, (EditorImpl)$editor, 0, ((EditorImpl)$editor).getDocument().getTextLength());
            }
        }

        private static final Unit editorBound$lambda$0(Editor $editor, Disposable $disposable, ClientAppSession $appSession, MergingUpdateQueue $mergeQueue, Lifetime $lifetime) {
            ((EditorImpl)$editor).getMarkupModel().addMarkupModelListener($disposable, new MarkupModelListener($mergeQueue, $lifetime, $appSession, $editor){
                final /* synthetic */ MergingUpdateQueue $mergeQueue;
                final /* synthetic */ Lifetime $lifetime;
                final /* synthetic */ ClientAppSession $appSession;
                final /* synthetic */ Editor $editor;
                {
                    this.$mergeQueue = $mergeQueue;
                    this.$lifetime = $lifetime;
                    this.$appSession = $appSession;
                    this.$editor = $editor;
                }

                public void afterRemoved(RangeHighlighterEx highlighter) {
                    Intrinsics.checkNotNullParameter((Object)highlighter, (String)"highlighter");
                    if (highlighter.getUserData(MarkupBasedLexerHighlighting.access$getKEY$p()) != null) {
                        Logger $this$trace$iv = MarkupBasedLexerHighlighting.access$getLOG$p();
                        boolean $i$f$trace = false;
                        if ($this$trace$iv.isTraceEnabled()) {
                            Logger logger = $this$trace$iv;
                            boolean bl = false;
                            logger.trace("queue update (" + highlighter.getStartOffset() + ", " + highlighter.getEndOffset() + ") on before highlighter removed");
                        }
                        this.$mergeQueue.queue((Update)new MergeableUpdateSyntaxHighlightersTask(this.$lifetime, this.$appSession, (EditorImpl)this.$editor, highlighter.getStartOffset(), highlighter.getEndOffset()));
                    }
                }
            });
            ((EditorImpl)$editor).addHighlighterListener((arg_0, arg_1) -> MyEditorHostListener.editorBound$lambda$0$0($mergeQueue, $lifetime, $appSession, $editor, arg_0, arg_1), $disposable);
            ((EditorImpl)$editor).addPropertyChangeListener(arg_0 -> MyEditorHostListener.editorBound$lambda$0$1($appSession, $editor, arg_0), $disposable);
            INSTANCE.updateSyntaxHighlighters($appSession, (EditorImpl)$editor, 0, ((EditorImpl)$editor).getDocument().getTextLength());
            return Unit.INSTANCE;
        }
    }
}

