/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.debugger;

import com.intellij.openapi.application.CoroutinesKt;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.FileColorManager;
import com.intellij.util.ApplicationKt;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.ExpressionInfo;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.impl.frame.XStackFrameWithCustomBackgroundColor;
import com.jetbrains.codeWithMe.model.GetExpressionInfoAtOffsetArg;
import com.jetbrains.codeWithMe.model.SourcePositionModel;
import com.jetbrains.codeWithMe.model.StackFrameModel;
import com.jetbrains.codeWithMe.model.ValueModel;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.framework.RdTaskResult;
import com.jetbrains.rd.framework.impl.RdTask;
import com.jetbrains.rd.ide.model.ColoredTextContainerModel;
import com.jetbrains.rd.ide.model.EvaluateArgBase;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdTextRange;
import com.jetbrains.rd.ide.model.SourcePositionBase;
import com.jetbrains.rd.ide.model.ValueModelBase;
import com.jetbrains.rd.platform.codeWithMe.PlatformSplitBundle;
import com.jetbrains.rd.platform.util.RdTaskUtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.debugger.BackendDebuggerHost;
import com.jetbrains.rdserver.debugger.BackendDebuggerScopeHolder;
import com.jetbrains.rdserver.debugger.ClientColoredTextContainer;
import com.jetbrains.rdserver.debugger.ClientCompositeNodeKt;
import com.jetbrains.rdserver.debugger.EvaluateInterceptor;
import com.jetbrains.rdserver.debugger.SourcePositionUtilsKt;
import com.jetbrains.rdserver.debugger.StackFrameUtilsKt;
import com.jetbrains.rdserver.document.BackendDocumentHost;
import com.jetbrains.rdserver.permissions.ClientPermissionManager;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000<\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0007\u001a\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u0002\u001a'\u0010\u000e\u001a\u0004\u0018\u00010\u000f*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u00042\u000e\b\u0002\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011H\u0082\b\u00a8\u0006\u0013"}, d2={"createStackFrameModel", "Lcom/jetbrains/codeWithMe/model/StackFrameModel;", "Lcom/intellij/xdebugger/frame/XStackFrame;", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "process", "Lcom/intellij/xdebugger/XDebugProcess;", "stack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "getFrameBgColor", "Ljava/awt/Color;", "project", "Lcom/intellij/openapi/project/Project;", "stackFrame", "getEvaluatorIfAvailable", "Lcom/intellij/xdebugger/evaluation/XDebuggerEvaluator;", "blockIfNot", "Lkotlin/Function0;", "", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nStackFrameUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 StackFrameUtils.kt\ncom/jetbrains/rdserver/debugger/StackFrameUtilsKt\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,119:1\n112#1,7:120\n112#1,7:129\n1401#2,2:127\n*S KotlinDebug\n*F\n+ 1 StackFrameUtils.kt\ncom/jetbrains/rdserver/debugger/StackFrameUtilsKt\n*L\n47#1:120,7\n78#1:129,7\n69#1:127,2\n*E\n"})
public final class StackFrameUtilsKt {
    @RequiresEdt
    @NotNull
    public static final StackFrameModel createStackFrameModel(@NotNull XStackFrame $this$createStackFrameModel, @NotNull ClientProjectSession session, @NotNull XDebugProcess process2, @NotNull XExecutionStack stack) {
        ClientColoredTextContainer clientColoredTextContainer;
        Intrinsics.checkNotNullParameter((Object)$this$createStackFrameModel, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        ThreadingAssertions.assertEventDispatchThread();
        XStackFrame xStackFrame = $this$createStackFrameModel;
        int frameId = BackendDebuggerHost.Companion.getInstance(session).getOrCreateFrameId(stack, xStackFrame);
        XSourcePosition xSourcePosition = xStackFrame.getSourcePosition();
        SourcePositionModel sourcePosition = xSourcePosition != null ? SourcePositionUtilsKt.toModel(xSourcePosition, session.getAppSession()) : null;
        ClientColoredTextContainer $this$createStackFrameModel_u24lambda_u240 = clientColoredTextContainer = new ClientColoredTextContainer();
        boolean bl = false;
        xStackFrame.customizePresentation((ColoredTextContainer)$this$createStackFrameModel_u24lambda_u240);
        ColoredTextContainerModel presentation = clientColoredTextContainer.createModel(StackFrameUtilsKt.getFrameBgColor(session.getProject(), $this$createStackFrameModel));
        ClientColoredTextContainer $this$createStackFrameModel_u24lambda_u241 = clientColoredTextContainer = new StackFrameModel(frameId, presentation, (SourcePositionBase)sourcePosition);
        boolean bl2 = false;
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)$this$createStackFrameModel_u24lambda_u241.getComputeLocals()), null, null, (arg_0, arg_1) -> StackFrameUtilsKt.createStackFrameModel$lambda$1$0(xStackFrame, session, process2, arg_0, arg_1), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)$this$createStackFrameModel_u24lambda_u241.getEvaluateExpression()), null, null, (arg_0, arg_1) -> StackFrameUtilsKt.createStackFrameModel$lambda$1$1(xStackFrame, session, process2, arg_0, arg_1), (int)3, null);
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)$this$createStackFrameModel_u24lambda_u241.getGetExpressionInfoAtOffset()), null, null, (arg_0, arg_1) -> StackFrameUtilsKt.createStackFrameModel$lambda$1$2(xStackFrame, session, arg_0, arg_1), (int)3, null);
        return clientColoredTextContainer;
    }

    @Nullable
    public static final Color getFrameBgColor(@NotNull Project project, @NotNull XStackFrame stackFrame) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)stackFrame, (String)"stackFrame");
        if (stackFrame instanceof XStackFrameWithCustomBackgroundColor) {
            return ((XStackFrameWithCustomBackgroundColor)stackFrame).getBackgroundColor();
        }
        XSourcePosition xSourcePosition = stackFrame.getSourcePosition();
        if (xSourcePosition == null || (xSourcePosition = xSourcePosition.getFile()) == null) {
            return FileColorManager.getInstance((Project)project).getScopeColor("Non-Project Files");
        }
        XSourcePosition virtualFile = xSourcePosition;
        if (virtualFile.isValid()) {
            return FileColorManager.getInstance((Project)project).getFileColor((VirtualFile)virtualFile);
        }
        return null;
    }

    private static final XDebuggerEvaluator getEvaluatorIfAvailable(XStackFrame $this$getEvaluatorIfAvailable, ClientProjectSession session, Function0<Unit> blockIfNot) {
        boolean $i$f$getEvaluatorIfAvailable = false;
        ClientPermissionManager manager = ClientPermissionManager.Companion.getInstance(session);
        if (!manager.hasFileWriteAccess()) {
            blockIfNot.invoke();
            return null;
        }
        return $this$getEvaluatorIfAvailable.getEvaluator();
    }

    static /* synthetic */ XDebuggerEvaluator getEvaluatorIfAvailable$default(XStackFrame $this$getEvaluatorIfAvailable_u24default, ClientProjectSession session, Function0 blockIfNot, int n, Object object) {
        if ((n & 2) != 0) {
            blockIfNot = getEvaluatorIfAvailable.1.INSTANCE;
        }
        boolean $i$f$getEvaluatorIfAvailable = false;
        ClientPermissionManager manager = ClientPermissionManager.Companion.getInstance(session);
        if (!manager.hasFileWriteAccess()) {
            blockIfNot.invoke();
            return null;
        }
        return $this$getEvaluatorIfAvailable_u24default.getEvaluator();
    }

    private static final RdTextRange createStackFrameModel$lambda$1$2$1(ExpressionInfo info2) {
        ExpressionInfo expressionInfo = info2;
        return expressionInfo != null && (expressionInfo = expressionInfo.getTextRange()) != null ? ProtocolConversionsKt.toRdTextRange((TextRange)expressionInfo) : null;
    }

    private static final RdTextRange createStackFrameModel$lambda$1$2$2(Function1 $tmp0, Object p0) {
        return (RdTextRange)$tmp0.invoke(p0);
    }

    private static final RdTask createStackFrameModel$lambda$1$0(XStackFrame $xStackFrame, ClientProjectSession $session, XDebugProcess $process, Lifetime lifetime, Unit unit) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"<unused var>");
        return ClientCompositeNodeKt.computeChildrenAsync((XValueContainer)$xStackFrame, $session, $process);
    }

    /*
     * WARNING - void declaration
     */
    private static final RdTask createStackFrameModel$lambda$1$1(XStackFrame $xStackFrame, ClientProjectSession $session, XDebugProcess $process, Lifetime lifetime, EvaluateArgBase arguments) {
        Object object;
        XDebuggerEvaluator.XEvaluationCallback callback2;
        RdTask rdTask;
        XDebuggerEvaluator evaluator2;
        block5: {
            void $this$getEvaluatorIfAvailable$iv;
            Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
            Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
            XStackFrame xStackFrame = $xStackFrame;
            ClientProjectSession session$iv = $session;
            boolean $i$f$getEvaluatorIfAvailable = false;
            ClientPermissionManager manager$iv = ClientPermissionManager.Companion.getInstance(session$iv);
            if (!manager$iv.hasFileWriteAccess()) {
                boolean bl = false;
                return RdTask.Companion.faulted((Throwable)new Exception(PlatformSplitBundle.INSTANCE.message("debugger.evaluation.no.access", new Object[0])));
            }
            evaluator2 = $this$getEvaluatorIfAvailable$iv.getEvaluator();
            if (evaluator2 == null) {
                return RdTask.Companion.faulted((Throwable)new Exception("Evaluator is null"));
            }
            rdTask = new RdTask();
            callback2 = new XDebuggerEvaluator.XEvaluationCallback((RdTask<ValueModelBase>)rdTask, $session, $process, arguments){
                final /* synthetic */ RdTask<ValueModelBase> $rdTask;
                final /* synthetic */ ClientProjectSession $session;
                final /* synthetic */ XDebugProcess $process;
                final /* synthetic */ EvaluateArgBase $arguments;
                {
                    this.$rdTask = $rdTask;
                    this.$session = $session;
                    this.$process = $process;
                    this.$arguments = $arguments;
                }

                public void errorOccurred(String errorMessage) {
                    Intrinsics.checkNotNullParameter((Object)errorMessage, (String)"errorMessage");
                    ApplicationKt.getApplication().invokeLater(() -> createStackFrameModel.1.2.callback.1.errorOccurred$lambda$0(this.$rdTask, errorMessage));
                }

                public void evaluated(XValue result) {
                    Intrinsics.checkNotNullParameter((Object)result, (String)"result");
                    BuildersKt.launch$default((CoroutineScope)BackendDebuggerScopeHolder.Companion.getCoroutineScope(), (CoroutineContext)CoroutinesKt.getEDT((Dispatchers)Dispatchers.INSTANCE), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(result, this.$session, this.$process, this.$arguments, this.$rdTask, null){
                        int label;
                        final /* synthetic */ XValue $result;
                        final /* synthetic */ ClientProjectSession $session;
                        final /* synthetic */ XDebugProcess $process;
                        final /* synthetic */ EvaluateArgBase $arguments;
                        final /* synthetic */ RdTask<ValueModelBase> $rdTask;
                        {
                            this.$result = $result;
                            this.$session = $session;
                            this.$process = $process;
                            this.$arguments = $arguments;
                            this.$rdTask = $rdTask;
                            super(2, $completion);
                        }

                        /*
                         * Unable to fully structure code
                         */
                        public final Object invokeSuspend(Object $result) {
                            var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                            switch (this.label) {
                                case 0: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    this.label = 1;
                                    v0 = ClientCompositeNodeKt.createValueModel(this.$result, this.$session, this.$process, this.$arguments.getExpression(), (Continuation<? super ValueModel>)((Continuation)this));
                                    if (v0 == var3_2) {
                                        return var3_2;
                                    }
                                    ** GOTO lbl13
                                }
                                case 1: {
                                    ResultKt.throwOnFailure((Object)$result);
                                    v0 = $result;
lbl13:
                                    // 2 sources

                                    valueModel = (ValueModel)v0;
                                    this.$rdTask.set((Object)valueModel);
                                    return Unit.INSTANCE;
                                }
                            }
                            throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                        }

                        public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                            return (Continuation)new /* invalid duplicate definition of identical inner class */;
                        }

                        public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                            return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                        }
                    }), (int)2, null);
                }

                private static final void errorOccurred$lambda$0(RdTask $rdTask, String $errorMessage) {
                    $rdTask.getResult().set((Object)new RdTaskResult.Fault((Throwable)new Exception($errorMessage)));
                }
            };
            Object[] $this$firstOrNull$iv = EvaluateInterceptor.Companion.getEP().getExtensions();
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                EvaluateInterceptor it = (EvaluateInterceptor)element$iv;
                boolean bl = false;
                if (!it.isApplicable(arguments, evaluator2)) continue;
                object = element$iv;
                break block5;
            }
            object = null;
        }
        EvaluateInterceptor evalInterceptor = (EvaluateInterceptor)object;
        if (evalInterceptor != null) {
            evalInterceptor.evaluate(arguments, callback2, evaluator2, $session);
        } else {
            evaluator2.evaluate(arguments.getExpression(), callback2, null);
        }
        return rdTask;
    }

    /*
     * WARNING - void declaration
     */
    private static final RdTask createStackFrameModel$lambda$1$2(XStackFrame $xStackFrame, ClientProjectSession $session, Lifetime lifetime, GetExpressionInfoAtOffsetArg getExpressionInfoAtOffsetArg) {
        void $this$getEvaluatorIfAvailable$iv;
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)getExpressionInfoAtOffsetArg, (String)"<destruct>");
        RdDocumentId documentId = getExpressionInfoAtOffsetArg.component1();
        int offset = getExpressionInfoAtOffsetArg.component2();
        boolean sideEffectsAllowed = getExpressionInfoAtOffsetArg.component3();
        XStackFrame xStackFrame = $xStackFrame;
        ClientProjectSession session$iv = $session;
        boolean $i$f$getEvaluatorIfAvailable = false;
        ClientPermissionManager manager$iv = ClientPermissionManager.Companion.getInstance(session$iv);
        if (!manager$iv.hasFileWriteAccess()) {
            boolean bl = false;
            return RdTask.Companion.faulted((Throwable)new Exception(PlatformSplitBundle.INSTANCE.message("debugger.evaluation.no.access", new Object[0])));
        }
        XDebuggerEvaluator evaluator2 = $this$getEvaluatorIfAvailable$iv.getEvaluator();
        if (evaluator2 == null) {
            return RdTask.Companion.fromResult(null);
        }
        Document document = BackendDocumentHost.Companion.getInstance($session.getAppSession()).getDocument(documentId);
        Promise promise = evaluator2.getExpressionInfoAtOffsetAsync($session.getProject(), document, offset, sideEffectsAllowed).then(arg_0 -> StackFrameUtilsKt.createStackFrameModel$lambda$1$2$2(StackFrameUtilsKt::createStackFrameModel$lambda$1$2$1, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)promise, (String)"then(...)");
        return RdTaskUtilKt.toRdTask((Promise)promise);
    }
}

