/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.diagnostics;

import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import java.io.Closeable;
import java.io.File;
import java.io.RandomAccessFile;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u000fB\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\t\u001a\u00020\nJ\u0017\u0010\u000b\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0002\u00a2\u0006\u0002\u0010\u000eR\u0013\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/jetbrains/rdserver/diagnostics/BackendLogsReader;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "LOGS_READING_BATCH_SIZE", "", "readLogsFromTheEnd", "Lcom/jetbrains/rdserver/diagnostics/BackendLogsReader$LogData;", "readLogsFromPosBackwards", "pos", "", "(Ljava/lang/Long;)Lcom/jetbrains/rdserver/diagnostics/BackendLogsReader$LogData;", "LogData", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nBackendLogsReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendLogsReader.kt\ncom/jetbrains/rdserver/diagnostics/BackendLogsReader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,50:1\n3938#2:51\n4474#2,2:52\n2045#3,14:54\n*S KotlinDebug\n*F\n+ 1 BackendLogsReader.kt\ncom/jetbrains/rdserver/diagnostics/BackendLogsReader\n*L\n28#1:51\n28#1:52,2\n29#1:54,14\n*E\n"})
public final class BackendLogsReader {
    @NotNull
    public static final BackendLogsReader INSTANCE = new BackendLogsReader();
    @NotNull
    private static final Logger LOG;
    private static final int LOGS_READING_BATCH_SIZE = 2500;

    private BackendLogsReader() {
    }

    @NotNull
    public final LogData readLogsFromTheEnd() {
        return this.readLogsFromPosBackwards(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final LogData readLogsFromPosBackwards(Long pos) {
        Path logsDir = Path.of(PathManager.getLogPath(), new String[0]);
        try {
            File logFile;
            Object object = logsDir.toFile().listFiles();
            if (object != null) {
                Object v0;
                void $this$maxByOrNull$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv;
                File[] fileArray = object;
                boolean $i$f$filter = false;
                void var8_9 = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                int n = ((void)$this$filterTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void element$iv$iv;
                    void it = element$iv$iv = $this$filterTo$iv$iv[i];
                    boolean bl = false;
                    if (!it.isFile()) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$maxByOrNull = false;
                Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
                if (!iterator$iv.hasNext()) {
                    v0 = null;
                } else {
                    Object maxElem$iv = iterator$iv.next();
                    if (!iterator$iv.hasNext()) {
                        v0 = maxElem$iv;
                    } else {
                        File it = (File)maxElem$iv;
                        boolean bl = false;
                        long maxValue$iv = it.lastModified();
                        do {
                            Object e$iv = iterator$iv.next();
                            File it2 = (File)e$iv;
                            $i$a$-maxByOrNull-BackendLogsReader$readLogsFromPosBackwards$logFile$2 = false;
                            long v$iv = it2.lastModified();
                            if (maxValue$iv >= v$iv) continue;
                            maxElem$iv = e$iv;
                            maxValue$iv = v$iv;
                        } while (iterator$iv.hasNext());
                        v0 = maxElem$iv;
                    }
                }
                v1 = v0;
            } else {
                v1 = logFile = null;
            }
            if (logFile != null) {
                object = new RandomAccessFile(logFile, "r");
                Throwable throwable = null;
                try {
                    RandomAccessFile it = (RandomAccessFile)object;
                    boolean bl = false;
                    byte[] buffer = new byte[2500];
                    Long l = pos;
                    long realPos = RangesKt.coerceAtLeast((long)0L, (long)((l != null ? l.longValue() : it.length()) - (long)2500));
                    int size = RangesKt.coerceAtMost((int)((int)it.length()), (int)2500);
                    it.seek(realPos);
                    it.read(buffer, 0, size);
                    Charset charset = StandardCharsets.UTF_8;
                    Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
                    Charset charset2 = charset;
                    LogData logData = new LogData(realPos, new String(buffer, charset2));
                    return logData;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
                }
            }
            return new LogData(0L, "");
        }
        catch (Exception e) {
            LOG.error("Reading logs failed", (Throwable)e);
            return new LogData(0L, "");
        }
    }

    static {
        Logger logger = Logger.getInstance(BackendLogsReader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\t\u0010\f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\r\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0014\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0001H\u00d6\u0083\u0004J\n\u0010\u0012\u001a\u00020\u0013H\u00d6\u0081\u0004J\n\u0010\u0014\u001a\u00020\u0005H\u00d6\u0081\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/rdserver/diagnostics/BackendLogsReader$LogData;", "", "startingPos", "", "readText", "", "<init>", "(JLjava/lang/String;)V", "getStartingPos", "()J", "getReadText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.platform.backend.split"})
    public static final class LogData {
        private final long startingPos;
        @NotNull
        private final String readText;

        public LogData(long startingPos, @NotNull String readText) {
            Intrinsics.checkNotNullParameter((Object)readText, (String)"readText");
            this.startingPos = startingPos;
            this.readText = readText;
        }

        public final long getStartingPos() {
            return this.startingPos;
        }

        @NotNull
        public final String getReadText() {
            return this.readText;
        }

        public final long component1() {
            return this.startingPos;
        }

        @NotNull
        public final String component2() {
            return this.readText;
        }

        @NotNull
        public final LogData copy(long startingPos, @NotNull String readText) {
            Intrinsics.checkNotNullParameter((Object)readText, (String)"readText");
            return new LogData(startingPos, readText);
        }

        public static /* synthetic */ LogData copy$default(LogData logData, long l, String string, int n, Object object) {
            if ((n & 1) != 0) {
                l = logData.startingPos;
            }
            if ((n & 2) != 0) {
                string = logData.readText;
            }
            return logData.copy(l, string);
        }

        @NotNull
        public String toString() {
            return "LogData(startingPos=" + this.startingPos + ", readText=" + this.readText + ")";
        }

        public int hashCode() {
            int result = Long.hashCode(this.startingPos);
            result = result * 31 + this.readText.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof LogData)) {
                return false;
            }
            LogData logData = (LogData)other;
            if (this.startingPos != logData.startingPos) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.readText, (Object)logData.readText);
        }
    }
}

