/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.diagnostics;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.troubleshooting.TroubleInfoCollector;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.rdserver.editors.DocumentUtilKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\n\u0010\b\u001a\u00020\u0005H\u0096\u0080\u0004\u00a8\u0006\n"}, d2={"Lcom/jetbrains/rdserver/diagnostics/RemoteEditorsTroubleInfoCollector;", "Lcom/intellij/troubleshooting/TroubleInfoCollector;", "<init>", "()V", "collectInfo", "", "project", "Lcom/intellij/openapi/project/Project;", "toString", "Companion", "intellij.platform.backend.split"})
public final class RemoteEditorsTroubleInfoCollector
implements TroubleInfoCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public String collectInfo(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return Companion.collect(project);
    }

    @NotNull
    public String toString() {
        return "Remote Editors";
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u001c\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u00060\rj\u0002`\u000eH\u0002\u00a8\u0006\u000f"}, d2={"Lcom/jetbrains/rdserver/diagnostics/RemoteEditorsTroubleInfoCollector$Companion;", "", "<init>", "()V", "collect", "", "project", "Lcom/intellij/openapi/project/Project;", "appendEditorHighlightingInfo", "", "editor", "Lcom/intellij/openapi/editor/Editor;", "stringBuilder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "intellij.platform.backend.split"})
    @SourceDebugExtension(value={"SMAP\nRemoteEditorsTroubleInfoCollector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 RemoteEditorsTroubleInfoCollector.kt\ncom/jetbrains/rdserver/diagnostics/RemoteEditorsTroubleInfoCollector$Companion\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,80:1\n12033#2,10:81\n14060#2:91\n14061#2:93\n12043#2:94\n1#3:92\n1915#4,2:95\n*S KotlinDebug\n*F\n+ 1 RemoteEditorsTroubleInfoCollector.kt\ncom/jetbrains/rdserver/diagnostics/RemoteEditorsTroubleInfoCollector$Companion\n*L\n24#1:81,10\n24#1:91\n24#1:93\n24#1:94\n24#1:92\n62#1:95,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final String collect(@NotNull Project project) {
            void $this$mapNotNullTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FileEditor[] fileEditorArray = FileEditorManager.getInstance((Project)project).getAllEditors();
            Intrinsics.checkNotNullExpressionValue((Object)fileEditorArray, (String)"getAllEditors(...)");
            Object[] $this$mapNotNull$iv = fileEditorArray;
            boolean $i$f$mapNotNull = false;
            Object[] objectArray = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            int n = ((void)$this$forEach$iv$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                Editor it$iv$iv;
                void element$iv$iv$iv;
                void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                boolean bl = false;
                FileEditor it = (FileEditor)element$iv$iv;
                boolean bl2 = false;
                TextEditor textEditor = it instanceof TextEditor ? (TextEditor)it : null;
                if ((textEditor != null ? textEditor.getEditor() : null) == null) continue;
                it$iv$iv = it$iv$iv;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List allEditors = (List)destination$iv$iv;
            FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
            Intrinsics.checkNotNullExpressionValue((Object)fileDocumentManager, (String)"getInstance(...)");
            FileDocumentManager fileDocumentManager2 = fileDocumentManager;
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("=== Remote Editors ===").append('\n');
            stringBuilder.append("ALL EDITORS:").append('\n');
            for (Editor editor : allEditors) {
                VirtualFile file2;
                if (fileDocumentManager2.getFile(editor.getDocument()) == null) continue;
                stringBuilder.append("          |||" + file2.getName() + "|||").append('\n');
                StringBuilder stringBuilder2 = DocumentUtilKt.isLocal(editor) ? stringBuilder.append("PHYSICAL EDITOR").append('\n') : stringBuilder.append("PHANTOM EDITOR. CLIENT ID: " + DocumentUtilKt.clientId(editor)).append('\n');
                stringBuilder.append("Caret dump: ");
                StringBuilder stringBuilder3 = stringBuilder;
                CaretModel caretModel = editor.getCaretModel();
                CaretModelImpl caretModelImpl = caretModel instanceof CaretModelImpl ? (CaretModelImpl)caretModel : null;
                stringBuilder3.append(caretModelImpl != null ? caretModelImpl.dumpState() : null).append('\n');
                this.appendEditorHighlightingInfo(editor, stringBuilder);
                stringBuilder.append("\n=============================").append('\n');
            }
            String string = stringBuilder.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }

        private final void appendEditorHighlightingInfo(Editor editor, StringBuilder stringBuilder) {
            if (!UIUtil.isShowing((Component)editor.getComponent())) {
                return;
            }
            ActionsKt.runReadAction(() -> Companion.appendEditorHighlightingInfo$lambda$0(stringBuilder, editor));
        }

        private static final Object appendEditorHighlightingInfo$lambda$0(StringBuilder $stringBuilder, Editor $editor) {
            StringBuilder stringBuilder;
            $stringBuilder.append("\nMarkup for opened editor: ");
            try {
                List list = DocumentMarkupModel.getExistingMarkupModels((Document)$editor.getDocument());
                Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getExistingMarkupModels(...)");
                Iterable $this$forEach$iv = list;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    RangeHighlighter[] rangeHighlighterArray;
                    MarkupModel markup = (MarkupModel)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)markup.getAllHighlighters(), (String)"getAllHighlighters(...)");
                    for (RangeHighlighter rangeHighlighter : rangeHighlighterArray) {
                        Intrinsics.checkNotNull((Object)rangeHighlighter);
                        RangeHighlighter highlighter = rangeHighlighter;
                        if (highlighter.getErrorStripeTooltip() == null) continue;
                        Object object = highlighter.getErrorStripeTooltip();
                        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.intellij.codeInsight.daemon.impl.HighlightInfo");
                        HighlightInfo highlightingInfo = (HighlightInfo)object;
                        $stringBuilder.append(highlightingInfo.toStringCompact(false)).append('\n');
                    }
                }
                stringBuilder = Unit.INSTANCE;
            }
            catch (Exception e) {
                stringBuilder = $stringBuilder.append("Error while getting editor info " + e.getMessage());
            }
            return stringBuilder;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

