/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.document;

import com.intellij.openapi.client.ClientAppSession;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.jetbrains.rd.ide.model.RdDocumentId;
import com.jetbrains.rd.ide.model.RdDocumentIdWithFileId;
import com.jetbrains.rd.ide.model.RdDocumentModel;
import com.jetbrains.rd.ide.model.RdFileDocumentId;
import com.jetbrains.rd.ide.model.RdFileId;
import com.jetbrains.rd.ide.model.RdFileIdNew;
import com.jetbrains.rdserver.document.BackendDocumentProvider;
import com.jetbrains.rdserver.vfs.BackendVirtualFileSystemHostKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\"\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\u000e"}, d2={"Lcom/jetbrains/rdserver/document/BackendFileBasedDocumentProvider;", "Lcom/jetbrains/rdserver/document/BackendDocumentProvider;", "<init>", "()V", "accept", "", "session", "Lcom/intellij/openapi/client/ClientAppSession;", "documentId", "Lcom/jetbrains/rd/ide/model/RdDocumentId;", "documentModel", "Lcom/jetbrains/rd/ide/model/RdDocumentModel;", "document", "Lcom/intellij/openapi/editor/Document;", "intellij.platform.backend.split"})
public final class BackendFileBasedDocumentProvider
implements BackendDocumentProvider {
    @Override
    public boolean accept(@NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        return documentId instanceof RdDocumentIdWithFileId || documentId instanceof RdFileDocumentId;
    }

    @Override
    @Nullable
    public Document document(@NotNull ClientAppSession session, @NotNull RdDocumentId documentId, @NotNull RdDocumentModel documentModel) {
        RdFileId fileId;
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)documentId, (String)"documentId");
        Intrinsics.checkNotNullParameter((Object)documentModel, (String)"documentModel");
        String url = null;
        VirtualFile file2 = null;
        if (documentId instanceof RdDocumentIdWithFileId && (fileId = ((RdDocumentIdWithFileId)documentId).getFileId()) instanceof RdFileIdNew) {
            file2 = VirtualFileManager.getInstance().findFileById(((RdFileIdNew)fileId).getBackendId());
        }
        if (documentId instanceof RdFileDocumentId) {
            url = VirtualFileManager.constructUrl((String)((RdFileDocumentId)documentId).getProtocol(), (String)((RdFileDocumentId)documentId).getFilePath());
        }
        if (url != null) {
            file2 = VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
        }
        if (file2 == null) {
            return null;
        }
        RdFileId rdFileId = BackendVirtualFileSystemHostKt.bind(file2, session, true);
        if (rdFileId == null) {
            return null;
        }
        return FileDocumentManager.getInstance().getDocument(file2);
    }
}

