/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.adapter;

import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.ide.model.AbstractColor;
import com.jetbrains.rd.ide.model.LxAffineTransform;
import com.jetbrains.rd.ide.model.LxAliasingStateChange;
import com.jetbrains.rd.ide.model.LxBackgroundColorStateChange;
import com.jetbrains.rd.ide.model.LxClearStateCommand;
import com.jetbrains.rd.ide.model.LxClipStateChange;
import com.jetbrains.rd.ide.model.LxColorPaint;
import com.jetbrains.rd.ide.model.LxCompositeStateChange;
import com.jetbrains.rd.ide.model.LxDrawCommand;
import com.jetbrains.rd.ide.model.LxDrawOperation;
import com.jetbrains.rd.ide.model.LxFontStateChange;
import com.jetbrains.rd.ide.model.LxGradientPaint;
import com.jetbrains.rd.ide.model.LxGraphics;
import com.jetbrains.rd.ide.model.LxImage;
import com.jetbrains.rd.ide.model.LxLinearGradientPaint;
import com.jetbrains.rd.ide.model.LxPaint;
import com.jetbrains.rd.ide.model.LxPaintStateChange;
import com.jetbrains.rd.ide.model.LxPoint;
import com.jetbrains.rd.ide.model.LxRadialGradientPaint;
import com.jetbrains.rd.ide.model.LxRectShape;
import com.jetbrains.rd.ide.model.LxShape;
import com.jetbrains.rd.ide.model.LxStateChange;
import com.jetbrains.rd.ide.model.LxStrokeStateChange;
import com.jetbrains.rd.ide.model.LxTexturePaint;
import com.jetbrains.rd.ide.model.LxTransformStateChange;
import com.jetbrains.rd.platform.codeWithMe.lux.LuxImageCache;
import com.jetbrains.rd.platform.codeWithMe.lux.UtilKt;
import com.jetbrains.rd.platform.codeWithMe.lux.awt.LuxGraphicsState;
import com.jetbrains.rd.platform.colors.ColorHostKt;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.awt.graphics.LuxGraphics2D;
import com.jetbrains.rdserver.lux.awt.pipe.LuxGraphicsPipe;
import com.jetbrains.rdserver.lux.services.LuxHostConnection;
import com.jetbrains.rdserver.lux.services.LuxHostService;
import com.jetbrains.rdserver.lux.util.LuxFlushAwareAlarm;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 B2\u00020\u0001:\u0001BB\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0006\u0010\u0019\u001a\u00020\u001aJ\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010%\u001a\u00020\"2\u0006\u0010#\u001a\u00020$J\u000e\u0010&\u001a\u00020\"2\u0006\u0010\u001f\u001a\u00020 J\u000e\u0010'\u001a\u00020\"2\u0006\u0010(\u001a\u00020)J@\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020\u00162\b\u0010-\u001a\u0004\u0018\u00010$2\u0006\u0010.\u001a\u00020\u001c2\u0006\u0010/\u001a\u00020\u001c2\u0006\u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001c2\u0006\u00102\u001a\u000203J\u0016\u00104\u001a\u00020\"2\u0006\u00105\u001a\u00020\u00122\u0006\u00106\u001a\u000207J\u0006\u00108\u001a\u00020\"J\u0006\u00109\u001a\u00020\"J\u0006\u0010:\u001a\u00020\"J\u001a\u0010;\u001a\b\u0012\u0004\u0012\u00020=0<*\u00020\u00102\u0006\u0010>\u001a\u00020\u0010H\u0002J\f\u0010?\u001a\u00020@*\u00020AH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0015\u001a\u00020\u0016\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006C"}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter;", "", "connection", "Lcom/jetbrains/rdserver/lux/services/LuxHostConnection;", "componentAdapter", "Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "model", "Lcom/jetbrains/rd/ide/model/LxGraphics;", "<init>", "(Lcom/jetbrains/rdserver/lux/services/LuxHostConnection;Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;Lcom/jetbrains/rd/ide/model/LxGraphics;)V", "getConnection", "()Lcom/jetbrains/rdserver/lux/services/LuxHostConnection;", "drawOperations", "", "Lcom/jetbrains/rd/ide/model/LxDrawOperation;", "lastGraphicsState", "Lcom/jetbrains/rd/platform/codeWithMe/lux/awt/LuxGraphicsState;", "graphics", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxGraphics2D;", "flushAwareAlarm", "Lcom/jetbrains/rdserver/lux/util/LuxFlushAwareAlarm;", "backBuffer", "Ljava/awt/Image;", "getBackBuffer", "()Ljava/awt/Image;", "createGraphics", "Ljava/awt/Graphics2D;", "drawOperationsCollected", "", "getFontMetrics", "Ljava/awt/FontMetrics;", "font", "Ljava/awt/Font;", "setColor", "", "color", "Ljava/awt/Color;", "setBackground", "setFont", "setGraphicsConfiguration", "gc", "Ljava/awt/GraphicsConfiguration;", "cache", "Lcom/jetbrains/rd/ide/model/LxImage;", "img", "bgColor", "sx", "sy", "width", "height", "allowIncrementalCoding", "", "queue", "lg", "command", "Lcom/jetbrains/rd/ide/model/LxDrawCommand;", "flush", "clear", "dispose", "produceDiffFrom", "", "Lcom/jetbrains/rd/ide/model/LxStateChange;", "other", "toLx", "Lcom/jetbrains/rd/ide/model/LxPaint;", "Ljava/awt/Paint;", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxGraphicsAdapter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxGraphicsAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,161:1\n67#2,4:162\n13#2:178\n11705#3:166\n12052#3,3:167\n11705#3:172\n12052#3,3:173\n37#4,2:170\n37#4,2:176\n*S KotlinDebug\n*F\n+ 1 LuxGraphicsAdapter.kt\ncom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter\n*L\n85#1:162,4\n29#1:178\n148#1:166\n148#1:167,3\n151#1:172\n151#1:173,3\n148#1:170,2\n151#1:176,2\n*E\n"})
public final class LuxGraphicsAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LuxHostConnection connection;
    @NotNull
    private final LuxComponentAdapter componentAdapter;
    @NotNull
    private final LxGraphics model;
    @NotNull
    private final List<LxDrawOperation> drawOperations;
    @NotNull
    private final LuxGraphicsState lastGraphicsState;
    @NotNull
    private final LuxGraphics2D graphics;
    @NotNull
    private final LuxFlushAwareAlarm flushAwareAlarm;
    @NotNull
    private final Image backBuffer;
    @NotNull
    private static final Logger logger;

    public LuxGraphicsAdapter(@NotNull LuxHostConnection connection, @NotNull LuxComponentAdapter componentAdapter, @NotNull LxGraphics model2) {
        Intrinsics.checkNotNullParameter((Object)((Object)connection), (String)"connection");
        Intrinsics.checkNotNullParameter((Object)componentAdapter, (String)"componentAdapter");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        this.connection = connection;
        this.componentAdapter = componentAdapter;
        this.model = model2;
        this.drawOperations = new ArrayList();
        this.lastGraphicsState = new LuxGraphicsState();
        this.graphics = LuxGraphics2D.Companion.create(this.componentAdapter.getWindow(), new LuxGraphicsPipe(this));
        this.flushAwareAlarm = new LuxFlushAwareAlarm(this.componentAdapter);
        this.backBuffer = new Image(this){
            final /* synthetic */ LuxGraphicsAdapter this$0;
            {
                this.this$0 = $receiver;
            }

            public int getWidth(ImageObserver observer) {
                return LuxGraphicsAdapter.access$getComponentAdapter$p(this.this$0).getWindow().getWidth();
            }

            public int getHeight(ImageObserver observer) {
                return LuxGraphicsAdapter.access$getComponentAdapter$p(this.this$0).getWindow().getHeight();
            }

            public Void getSource() {
                return null;
            }

            public Graphics2D getGraphics() {
                return this.this$0.createGraphics();
            }

            public Void getProperty(String name, ImageObserver observer) {
                return null;
            }
        };
    }

    @NotNull
    public final LuxHostConnection getConnection() {
        return this.connection;
    }

    @NotNull
    public final Image getBackBuffer() {
        return this.backBuffer;
    }

    @NotNull
    public final Graphics2D createGraphics() {
        Graphics graphics = this.graphics.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        return (Graphics2D)graphics;
    }

    public final int drawOperationsCollected() {
        return this.drawOperations.size();
    }

    @NotNull
    public final FontMetrics getFontMetrics(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        return this.graphics.getFontMetrics(font);
    }

    public final void setColor(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.graphics.setColor(color);
    }

    public final void setBackground(@NotNull Color color) {
        Intrinsics.checkNotNullParameter((Object)color, (String)"color");
        this.graphics.setBackground(color);
    }

    public final void setFont(@NotNull Font font) {
        Intrinsics.checkNotNullParameter((Object)font, (String)"font");
        this.graphics.setFont(font);
    }

    public final void setGraphicsConfiguration(@NotNull GraphicsConfiguration gc) {
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        this.graphics.setDeviceConfiguration(gc);
    }

    @NotNull
    public final LxImage cache(@NotNull Image img, @Nullable Color bgColor, int sx, int sy, int width, int height, boolean allowIncrementalCoding) {
        Intrinsics.checkNotNullParameter((Object)img, (String)"img");
        return LuxGraphicsAdapter.Companion.getImageCache().cache(this.componentAdapter.getLuxId(), img, bgColor, sx, sy, width, height, allowIncrementalCoding);
    }

    public final void queue(@NotNull LuxGraphics2D lg, @NotNull LxDrawCommand command) {
        Intrinsics.checkNotNullParameter((Object)lg, (String)"lg");
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        LuxGraphicsState state = lg.getState();
        List<LxStateChange> diff = this.produceDiffFrom(state, this.lastGraphicsState);
        state.copyInto(this.lastGraphicsState);
        LxDrawOperation operation = new LxDrawOperation(command, diff);
        this.drawOperations.add(operation);
    }

    public final void flush() {
        if (!((Collection)this.drawOperations).isEmpty()) {
            this.model.getDrawOperations().fire(this.drawOperations);
            Logger $this$trace$iv = logger;
            boolean $i$f$trace = false;
            if ($this$trace$iv.isTraceEnabled()) {
                Logger logger = $this$trace$iv;
                boolean bl = false;
                logger.trace("Flushed " + this.drawOperations.size() + " draw commands");
            }
            this.drawOperations.clear();
        }
        this.flushAwareAlarm.notifyFlush();
    }

    public final void clear() {
        this.drawOperations.clear();
        new LuxGraphicsState().copyInto(this.lastGraphicsState);
        this.drawOperations.add(new LxDrawOperation((LxDrawCommand)new LxClearStateCommand(), CollectionsKt.emptyList()));
    }

    public final void dispose() {
        this.graphics.dispose();
        LuxGraphicsAdapter.Companion.getImageCache().clear(this.componentAdapter.getLuxId());
    }

    private final List<LxStateChange> produceDiffFrom(LuxGraphicsState $this$produceDiffFrom, LuxGraphicsState other) {
        List result = new ArrayList();
        if (!Intrinsics.areEqual((Object)other.getBackgroundColor(), (Object)$this$produceDiffFrom.getBackgroundColor())) {
            result.add(new LxBackgroundColorStateChange(ColorHostKt.toModel((Color)$this$produceDiffFrom.getBackgroundColor())));
        }
        if (!Intrinsics.areEqual((Object)other.getTransform(), (Object)$this$produceDiffFrom.getTransform())) {
            result.add(new LxTransformStateChange(UtilKt.toLx((AffineTransform)$this$produceDiffFrom.getTransform())));
        }
        if (!Intrinsics.areEqual((Object)other.getUserClip(), (Object)$this$produceDiffFrom.getUserClip())) {
            Shape shape = $this$produceDiffFrom.getUserClip();
            result.add(new LxClipStateChange((LxShape)(shape != null ? UtilKt.toLx((Shape)shape, null) : null)));
        }
        if (!Intrinsics.areEqual((Object)other.getComposite(), (Object)$this$produceDiffFrom.getComposite())) {
            result.add(new LxCompositeStateChange(UtilKt.toLx((Composite)$this$produceDiffFrom.getComposite())));
        }
        if (!Intrinsics.areEqual((Object)other.getStroke(), (Object)$this$produceDiffFrom.getStroke())) {
            result.add(new LxStrokeStateChange(UtilKt.toLx((Stroke)$this$produceDiffFrom.getStroke())));
        }
        if (!Intrinsics.areEqual((Object)other.getPaint(), (Object)$this$produceDiffFrom.getPaint())) {
            result.add(new LxPaintStateChange(this.toLx($this$produceDiffFrom.getPaint())));
        }
        if (!Intrinsics.areEqual((Object)$this$produceDiffFrom.getFont(), (Object)other.getFont())) {
            Font font = $this$produceDiffFrom.getFont();
            Intrinsics.checkNotNull((Object)font);
            result.add(new LxFontStateChange(UtilKt.toLx((Font)font)));
        }
        if ($this$produceDiffFrom.getFractionalMetrics() != other.getFractionalMetrics() || $this$produceDiffFrom.getTextAliasing() != other.getTextAliasing()) {
            result.add(new LxAliasingStateChange($this$produceDiffFrom.getFractionalMetrics(), $this$produceDiffFrom.getTextAliasing()));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private final LxPaint toLx(Paint $this$toLx) {
        LxPaint lxPaint;
        Paint paint = $this$toLx;
        if (paint instanceof Color) {
            lxPaint = (LxPaint)new LxColorPaint(ColorHostKt.toModel((Color)((Color)$this$toLx)));
        } else if (paint instanceof GradientPaint) {
            Color color = ((GradientPaint)$this$toLx).getColor1();
            Intrinsics.checkNotNullExpressionValue((Object)color, (String)"getColor1(...)");
            AbstractColor abstractColor = ColorHostKt.toModel((Color)color);
            Color color2 = ((GradientPaint)$this$toLx).getColor2();
            Intrinsics.checkNotNullExpressionValue((Object)color2, (String)"getColor2(...)");
            AbstractColor abstractColor2 = ColorHostKt.toModel((Color)color2);
            Point2D point2D = ((GradientPaint)$this$toLx).getPoint1();
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"getPoint1(...)");
            LxPoint lxPoint = UtilKt.toLx((Point2D)point2D);
            Point2D point2D2 = ((GradientPaint)$this$toLx).getPoint2();
            Intrinsics.checkNotNullExpressionValue((Object)point2D2, (String)"getPoint2(...)");
            lxPaint = (LxPaint)new LxGradientPaint(abstractColor, abstractColor2, lxPoint, UtilKt.toLx((Point2D)point2D2), ((GradientPaint)$this$toLx).isCyclic());
        } else if (paint instanceof LinearGradientPaint) {
            Collection<AbstractColor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Point2D point2D = ((LinearGradientPaint)$this$toLx).getStartPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"getStartPoint(...)");
            LxPoint lxPoint = UtilKt.toLx((Point2D)point2D);
            Point2D point2D3 = ((LinearGradientPaint)$this$toLx).getEndPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point2D3, (String)"getEndPoint(...)");
            LxPoint lxPoint2 = UtilKt.toLx((Point2D)point2D3);
            Color[] colorArray = ((LinearGradientPaint)$this$toLx).getColors();
            Intrinsics.checkNotNullExpressionValue((Object)colorArray, (String)"getColors(...)");
            Object[] objectArray = colorArray;
            LxPoint lxPoint3 = lxPoint2;
            LxPoint lxPoint4 = lxPoint;
            boolean $i$f$map = false;
            void var5_12 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Color color = (Color)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ColorHostKt.toModel((Color)it));
            }
            collection = (List)destination$iv$iv;
            Collection $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            float[] fArray = ((LinearGradientPaint)$this$toLx).getFractions();
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"getFractions(...)");
            AffineTransform affineTransform = ((LinearGradientPaint)$this$toLx).getTransform();
            Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
            int n = ((LinearGradientPaint)$this$toLx).getColorSpace().ordinal();
            int n2 = ((LinearGradientPaint)$this$toLx).getCycleMethod().ordinal();
            LxAffineTransform lxAffineTransform = UtilKt.toLx((AffineTransform)affineTransform);
            float[] fArray2 = fArray;
            AbstractColor[] abstractColorArray = thisCollection$iv.toArray(new AbstractColor[0]);
            LxPoint lxPoint5 = lxPoint3;
            LxPoint lxPoint6 = lxPoint4;
            lxPaint = (LxPaint)new LxLinearGradientPaint(lxPoint6, lxPoint5, abstractColorArray, fArray2, lxAffineTransform, n2, n);
        } else if (paint instanceof RadialGradientPaint) {
            Collection<AbstractColor> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Point2D point2D = ((RadialGradientPaint)$this$toLx).getCenterPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point2D, (String)"getCenterPoint(...)");
            LxPoint lxPoint = UtilKt.toLx((Point2D)point2D);
            Point2D point2D4 = ((RadialGradientPaint)$this$toLx).getFocusPoint();
            Intrinsics.checkNotNullExpressionValue((Object)point2D4, (String)"getFocusPoint(...)");
            LxPoint lxPoint7 = UtilKt.toLx((Point2D)point2D4);
            float f = ((RadialGradientPaint)$this$toLx).getRadius();
            Color[] colorArray = ((RadialGradientPaint)$this$toLx).getColors();
            Intrinsics.checkNotNullExpressionValue((Object)colorArray, (String)"getColors(...)");
            Object $this$toTypedArray$iv = colorArray;
            float f2 = f;
            LxPoint lxPoint8 = lxPoint7;
            LxPoint lxPoint9 = lxPoint;
            boolean $i$f$map = false;
            Object thisCollection$iv = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
            boolean $i$f$mapTo = false;
            for (void item$iv$iv : $this$mapTo$iv$iv) {
                Color it = (Color)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNull((Object)it);
                collection.add(ColorHostKt.toModel((Color)it));
            }
            collection = (List)destination$iv$iv;
            $this$toTypedArray$iv = collection;
            boolean $i$f$toTypedArray = false;
            thisCollection$iv = $this$toTypedArray$iv;
            float[] fArray = ((RadialGradientPaint)$this$toLx).getFractions();
            Intrinsics.checkNotNullExpressionValue((Object)fArray, (String)"getFractions(...)");
            AffineTransform affineTransform = ((RadialGradientPaint)$this$toLx).getTransform();
            Intrinsics.checkNotNullExpressionValue((Object)affineTransform, (String)"getTransform(...)");
            int n = ((RadialGradientPaint)$this$toLx).getColorSpace().ordinal();
            int n3 = ((RadialGradientPaint)$this$toLx).getCycleMethod().ordinal();
            LxAffineTransform lxAffineTransform = UtilKt.toLx((AffineTransform)affineTransform);
            float[] fArray3 = fArray;
            AbstractColor[] abstractColorArray = thisCollection$iv.toArray(new AbstractColor[0]);
            float f3 = f2;
            LxPoint lxPoint10 = lxPoint8;
            LxPoint lxPoint11 = lxPoint9;
            lxPaint = (LxPaint)new LxRadialGradientPaint(lxPoint11, lxPoint10, f3, abstractColorArray, fArray3, lxAffineTransform, n3, n);
        } else if (paint instanceof TexturePaint) {
            BufferedImage bufferedImage = ((TexturePaint)$this$toLx).getImage();
            Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"getImage(...)");
            LxImage lxImage = this.cache(bufferedImage, null, 0, 0, ((TexturePaint)$this$toLx).getImage().getWidth(), ((TexturePaint)$this$toLx).getImage().getHeight(), false);
            lxPaint = (LxPaint)new LxTexturePaint(lxImage, new LxRectShape(((TexturePaint)$this$toLx).getAnchorRect().getX(), ((TexturePaint)$this$toLx).getAnchorRect().getY(), ((TexturePaint)$this$toLx).getAnchorRect().getWidth(), ((TexturePaint)$this$toLx).getAnchorRect().getHeight()));
        } else {
            throw new IllegalStateException(("Unknown paint class: " + $this$toLx.getClass().getSimpleName()).toString());
        }
        return lxPaint;
    }

    public static final /* synthetic */ LuxComponentAdapter access$getComponentAdapter$p(LuxGraphicsAdapter $this) {
        return $this.componentAdapter;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LuxGraphicsAdapter.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LuxGraphicsAdapter.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\t8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/lux/adapter/LuxGraphicsAdapter$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "imageCache", "Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Backend;", "getImageCache", "()Lcom/jetbrains/rd/platform/codeWithMe/lux/LuxImageCache$Backend;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        private final LuxImageCache.Backend getImageCache() {
            return LuxHostService.Companion.getInstance().getImageCache();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

