/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.lux.awt.peer;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.platform.impl.toolkit.IdeToolkit;
import com.intellij.util.ui.ImageUtil;
import com.jetbrains.rdserver.lux.adapter.LuxComponentAdapter;
import com.jetbrains.rdserver.lux.awt.graphics.LuxVolatileImage;
import java.awt.AWTEvent;
import java.awt.BufferCapabilities;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.PaintEvent;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.awt.peer.ComponentPeer;
import java.awt.peer.ContainerPeer;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import sun.awt.KeyboardFocusManagerPeerImpl;
import sun.java2d.pipe.Region;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00d8\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0002\b&\u0018\u0000 g2\u00020\u0001:\u0001gB\u0011\b\u0004\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\f\u001a\u00020\rH\u0016J\b\u0010\u000e\u001a\u00020\rH\u0016J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\rH\u0016J\u0010\u0010\u0012\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\rH\u0016J\u0010\u0010\u0014\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J0\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001aH\u0016J\u0010\u0010\u001f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020 H\u0016J\u0012\u0010!\u001a\u00020\u00102\b\u0010\u0013\u001a\u0004\u0018\u00010\"H\u0016J\u0010\u0010#\u001a\n %*\u0004\u0018\u00010$0$H\u0016J\u0010\u0010&\u001a\n %*\u0004\u0018\u00010'0'H\u0016J\u0010\u0010(\u001a\n %*\u0004\u0018\u00010'0'H\u0016J\b\u0010)\u001a\u00020*H\u0016J\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020\u0010H\u0016J\u0014\u0010.\u001a\u0004\u0018\u00010/2\b\u00100\u001a\u0004\u0018\u000101H\u0016J\u0012\u00102\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0012\u00105\u001a\u00020\u00102\b\u00103\u001a\u0004\u0018\u000104H\u0016J\u0012\u00106\u001a\u00020\u00102\b\u00107\u001a\u0004\u0018\u000101H\u0016J\b\u00108\u001a\u00020\u0010H\u0016J0\u00109\u001a\u00020\r2\u0006\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\r2\u0006\u0010=\u001a\u00020\r2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0016J\b\u0010B\u001a\u00020\rH\u0016J\u001d\u0010C\u001a\u00070D\u00a2\u0006\u0002\bE2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\u0018\u0010F\u001a\u00020G2\u0006\u0010\u001c\u001a\u00020\u001a2\u0006\u0010\u001d\u001a\u00020\u001aH\u0016J\b\u0010H\u001a\u00020IH\u0016J\b\u0010J\u001a\u00020\rH\u0016J\b\u0010K\u001a\u00020LH\u0016J2\u0010M\u001a\u00020\u00102\u0006\u0010N\u001a\u00020\u001a2\u0006\u0010O\u001a\u00020\u001a2\u0006\u0010P\u001a\u00020\u001a2\u0006\u0010Q\u001a\u00020\u001a2\b\u0010R\u001a\u0004\u0018\u00010SH\u0016J\u001a\u0010T\u001a\u00020\u00102\u0006\u0010U\u001a\u00020\u001a2\b\u0010V\u001a\u0004\u0018\u00010WH\u0016J\b\u0010X\u001a\u00020\u0010H\u0016J\u0012\u0010Y\u001a\u00020\u00102\b\u0010Z\u001a\u0004\u0018\u00010[H\u0016J\b\u0010\\\u001a\u00020\rH\u0016J\b\u0010]\u001a\u00020\u0010H\u0016J\u0012\u0010^\u001a\u00020\u00102\b\u0010_\u001a\u0004\u0018\u00010`H\u0016J\u0012\u0010a\u001a\u00020\u00102\b\u0010b\u001a\u0004\u0018\u00010\u0001H\u0016J\u0012\u0010c\u001a\u00020\r2\b\u0010d\u001a\u0004\u0018\u00010IH\u0016J\n\u0010e\u001a\u00020fH\u0096\u0080\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00a8\u0006h"}, d2={"Lcom/jetbrains/rdserver/lux/awt/peer/LuxComponentPeer;", "Ljava/awt/peer/ComponentPeer;", "adapter", "Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "<init>", "(Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;)V", "getAdapter", "()Lcom/jetbrains/rdserver/lux/adapter/LuxComponentAdapter;", "disposable", "Lcom/intellij/openapi/Disposable;", "getDisposable", "()Lcom/intellij/openapi/Disposable;", "isObscured", "", "canDetermineObscurity", "setVisible", "", "v", "setEnabled", "e", "paint", "g", "Ljava/awt/Graphics;", "print", "setBounds", "x", "", "y", "width", "height", "op", "handleEvent", "Ljava/awt/AWTEvent;", "coalescePaintEvent", "Ljava/awt/event/PaintEvent;", "getLocationOnScreen", "Ljava/awt/Point;", "kotlin.jvm.PlatformType", "getPreferredSize", "Ljava/awt/Dimension;", "getMinimumSize", "getColorModel", "Ljava/awt/image/ColorModel;", "getGraphics", "Ljava/awt/Graphics2D;", "dispose", "getFontMetrics", "Ljava/awt/FontMetrics;", "font", "Ljava/awt/Font;", "setForeground", "c", "Ljava/awt/Color;", "setBackground", "setFont", "f", "updateCursorImmediately", "requestFocus", "lightweightChild", "Ljava/awt/Component;", "temporary", "focusedWindowChangeAllowed", "time", "", "cause", "Ljava/awt/event/FocusEvent$Cause;", "isFocusable", "createImage", "Ljava/awt/image/BufferedImage;", "Lorg/jetbrains/annotations/NotNull;", "createVolatileImage", "Lcom/jetbrains/rdserver/lux/awt/graphics/LuxVolatileImage;", "getGraphicsConfiguration", "Ljava/awt/GraphicsConfiguration;", "handlesWheelScrolling", "getBackBuffer", "Ljava/awt/Image;", "flip", "x1", "y1", "x2", "y2", "flipAction", "Ljava/awt/BufferCapabilities$FlipContents;", "createBuffers", "numBuffers", "caps", "Ljava/awt/BufferCapabilities;", "destroyBuffers", "reparent", "newContainer", "Ljava/awt/peer/ContainerPeer;", "isReparentSupported", "layout", "applyShape", "shape", "Lsun/java2d/pipe/Region;", "setZOrder", "above", "updateGraphicsData", "gc", "toString", "", "Companion", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nLuxComponentPeer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LuxComponentPeer.kt\ncom/jetbrains/rdserver/lux/awt/peer/LuxComponentPeer\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,129:1\n67#2,4:130\n13#2:134\n*S KotlinDebug\n*F\n+ 1 LuxComponentPeer.kt\ncom/jetbrains/rdserver/lux/awt/peer/LuxComponentPeer\n*L\n31#1:130,4\n27#1:134\n*E\n"})
public abstract class LuxComponentPeer
implements ComponentPeer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LuxComponentAdapter adapter;
    @NotNull
    private static final Logger logger;

    protected LuxComponentPeer(@NotNull LuxComponentAdapter adapter) {
        Intrinsics.checkNotNullParameter((Object)adapter, (String)"adapter");
        this.adapter = adapter;
        Logger $this$trace$iv = logger;
        boolean $i$f$trace = false;
        if ($this$trace$iv.isTraceEnabled()) {
            Logger logger = $this$trace$iv;
            boolean bl = false;
            logger.trace("Creating " + this);
        }
    }

    @NotNull
    public final LuxComponentAdapter getAdapter() {
        return this.adapter;
    }

    @NotNull
    public final Disposable getDisposable() {
        return this.adapter.getDisposable();
    }

    @Override
    public boolean isObscured() {
        return false;
    }

    @Override
    public boolean canDetermineObscurity() {
        return false;
    }

    @Override
    public void setVisible(boolean v) {
        this.adapter.setVisible(v);
    }

    @Override
    public void setEnabled(boolean e) {
    }

    @Override
    public void paint(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.adapter.paint(g);
    }

    @Override
    public void print(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        this.adapter.print(g);
    }

    @Override
    public void setBounds(int x, int y, int width, int height, int op) {
    }

    @Override
    public void handleEvent(@NotNull AWTEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (e instanceof PaintEvent) {
            this.adapter.repaint();
        }
    }

    @Override
    public void coalescePaintEvent(@Nullable PaintEvent e) {
    }

    @Override
    public Point getLocationOnScreen() {
        return this.adapter.getLocationOnScreen();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public Dimension getMinimumSize() {
        return this.adapter.getMinimumSize();
    }

    @Override
    @NotNull
    public ColorModel getColorModel() {
        return this.adapter.getColorModel();
    }

    @Override
    @NotNull
    public Graphics2D getGraphics() {
        return this.adapter.getGraphics();
    }

    @Override
    public void dispose() {
        this.adapter.dispose();
    }

    @Override
    @Nullable
    public FontMetrics getFontMetrics(@Nullable Font font) {
        if (font == null) {
            return null;
        }
        return this.adapter.getFontMetrics(font);
    }

    @Override
    public void setForeground(@Nullable Color c) {
        if (c == null) {
            return;
        }
        this.adapter.setForeground(c);
    }

    @Override
    public void setBackground(@Nullable Color c) {
        if (c == null) {
            return;
        }
        this.adapter.setBackground(c);
    }

    @Override
    public void setFont(@Nullable Font f) {
        if (f == null) {
            return;
        }
        this.adapter.setFont(f);
    }

    @Override
    public void updateCursorImmediately() {
        this.adapter.updateCursor();
    }

    @Override
    public boolean requestFocus(@NotNull Component lightweightChild, boolean temporary, boolean focusedWindowChangeAllowed, long time, @NotNull FocusEvent.Cause cause) {
        Intrinsics.checkNotNullParameter((Object)lightweightChild, (String)"lightweightChild");
        Intrinsics.checkNotNullParameter((Object)((Object)cause), (String)"cause");
        if (Registry.Companion.is("lux.focus.old.logic")) {
            return this.adapter.requestFocus(lightweightChild, temporary, focusedWindowChangeAllowed, time, cause);
        }
        Window window = this.adapter.getWindow();
        int result = KeyboardFocusManagerPeerImpl.shouldNativelyFocusHeavyweight((Component)window, (Component)lightweightChild, (boolean)temporary, (boolean)focusedWindowChangeAllowed, (long)time, (FocusEvent.Cause)cause, (boolean)true);
        switch (result) {
            case 2: {
                Component currentFocusOwner = IdeToolkit.Companion.getInstance().getKeyboardFocusManagerPeer().getCurrentFocusOwner();
                return KeyboardFocusManagerPeerImpl.deliverFocus((Component)lightweightChild, (Component)window, (boolean)true, (FocusEvent.Cause)cause, (Component)currentFocusOwner);
            }
            case 1: {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isFocusable() {
        return false;
    }

    @Override
    @NotNull
    public BufferedImage createImage(int width, int height) {
        BufferedImage bufferedImage = ImageUtil.createImage((GraphicsConfiguration)this.getGraphicsConfiguration(), (int)width, (int)height, (int)1);
        Intrinsics.checkNotNullExpressionValue((Object)bufferedImage, (String)"createImage(...)");
        return bufferedImage;
    }

    @Override
    @NotNull
    public LuxVolatileImage createVolatileImage(int width, int height) {
        return new LuxVolatileImage(this.getGraphicsConfiguration(), width, height, 1);
    }

    @Override
    @NotNull
    public GraphicsConfiguration getGraphicsConfiguration() {
        GraphicsConfiguration graphicsConfiguration = this.adapter.getGraphicsConfiguration();
        Intrinsics.checkNotNullExpressionValue((Object)graphicsConfiguration, (String)"getGraphicsConfiguration(...)");
        return graphicsConfiguration;
    }

    @Override
    public boolean handlesWheelScrolling() {
        return false;
    }

    @Override
    @NotNull
    public Image getBackBuffer() {
        return this.adapter.getImageProxy();
    }

    @Override
    public void flip(int x1, int y1, int x2, int y2, @Nullable BufferCapabilities.FlipContents flipAction) {
        this.adapter.flush();
    }

    @Override
    public void createBuffers(int numBuffers, @Nullable BufferCapabilities caps) {
    }

    @Override
    public void destroyBuffers() {
    }

    @Override
    public void reparent(@Nullable ContainerPeer newContainer) {
    }

    @Override
    public boolean isReparentSupported() {
        return false;
    }

    @Override
    public void layout() {
    }

    @Override
    public void applyShape(@Nullable Region shape) {
    }

    @Override
    public void setZOrder(@Nullable ComponentPeer above) {
    }

    @Override
    public boolean updateGraphicsData(@Nullable GraphicsConfiguration gc) {
        return this.adapter.setGraphicsConfiguration(gc);
    }

    @NotNull
    public String toString() {
        String string = this.getClass().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String[] stringArray = new String[]{"."};
        return CollectionsKt.last((List)StringsKt.split$default((CharSequence)string, (String[])stringArray, (boolean)false, (int)0, (int)6, null)) + "(adapter=" + this.adapter + ")";
    }

    @NotNull
    protected static final Logger getLogger() {
        return Companion.getLogger();
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(LuxComponentPeer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LuxComponentPeer.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0004\u001a\u00020\u00058\u0004X\u0085\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0003\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/jetbrains/rdserver/lux/awt/peer/LuxComponentPeer$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger$annotations", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        protected final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        protected static /* synthetic */ void getLogger$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

