/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.portForwarding;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.registry.RegistryValue;
import com.intellij.openapi.util.registry.RegistryValueListener;
import com.intellij.remoteDev.OsRegistryConfigProvider;
import com.jetbrains.codeWithMe.model.PortForwardingModel;
import com.jetbrains.rd.util.lifetime.Lifetime;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020&\u0012\u0004\u0012\u00020!0%J\u001d\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0000\u00a2\u0006\u0002\b,R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0016R\u001a\u0010\u0019\u001a\u00020\u00078FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001a\u0010\u0003\u001a\u0004\b\u001b\u0010\u0016R\u0011\u0010\u001c\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0016R\u0011\u0010\u001e\u001a\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u0016\u00a8\u0006-"}, d2={"Lcom/jetbrains/rdserver/portForwarding/PortForwardingConfiguration;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "_frontendAllowPersistReversePorts", "", "OS_REGISTRY_PROVIDER_CONFIG_NAME", "", "PORT_FORWARDING_ENABLED_REGISTRY_KEY", "PORT_FORWARDING_STORE_DIRECT_ENABLED_DEPRECATED_KEY", "PORT_FORWARDING_STORE_DIRECT_ENABLED_KEY", "PORT_FORWARDING_STORE_REVERSE_ENABLED_KEY", "osRegistryConfigProvider", "Lcom/intellij/remoteDev/OsRegistryConfigProvider;", "validPortsRange", "Lkotlin/ranges/IntRange;", "getValidPortsRange", "()Lkotlin/ranges/IntRange;", "portForwardingInRegistryProviderEnabled", "getPortForwardingInRegistryProviderEnabled", "()Z", "portForwardingRegistryEnabled", "getPortForwardingRegistryEnabled", "allowPersistingForwardedPorts", "getAllowPersistingForwardedPorts$annotations", "getAllowPersistingForwardedPorts", "allowPersistingDirectPorts", "getAllowPersistingDirectPorts", "allowPersistingReversePorts", "getAllowPersistingReversePorts", "addPortForwardingEnabledRegistryChangeListener", "", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "action", "Lkotlin/Function1;", "Lcom/intellij/openapi/util/registry/RegistryValue;", "addPersistReverseForwardedPortFrontendConfigListener", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "model", "Lcom/jetbrains/codeWithMe/model/PortForwardingModel;", "addPersistReverseForwardedPortFrontendConfigListener$intellij_platform_backend_split", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nPortForwardingConfiguration.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PortForwardingConfiguration.kt\ncom/jetbrains/rdserver/portForwarding/PortForwardingConfiguration\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,128:1\n60#2,5:129\n60#2,5:134\n60#2,5:139\n60#2,5:144\n60#2,5:149\n23#2:154\n*S KotlinDebug\n*F\n+ 1 PortForwardingConfiguration.kt\ncom/jetbrains/rdserver/portForwarding/PortForwardingConfiguration\n*L\n55#1:129,5\n62#1:134,5\n77#1:139,5\n87#1:144,5\n101#1:149,5\n16#1:154\n*E\n"})
public final class PortForwardingConfiguration {
    @NotNull
    public static final PortForwardingConfiguration INSTANCE;
    @NotNull
    private static final Logger logger;
    private static boolean _frontendAllowPersistReversePorts;
    @NotNull
    private static final String OS_REGISTRY_PROVIDER_CONFIG_NAME = "portForwarding";
    @NotNull
    private static final String PORT_FORWARDING_ENABLED_REGISTRY_KEY = "codeWithMe.portForwarding.enabled";
    @NotNull
    private static final String PORT_FORWARDING_STORE_DIRECT_ENABLED_DEPRECATED_KEY = "portForwarding.storeState";
    @NotNull
    private static final String PORT_FORWARDING_STORE_DIRECT_ENABLED_KEY = "portForwarding.store.direct.enabled";
    @NotNull
    private static final String PORT_FORWARDING_STORE_REVERSE_ENABLED_KEY = "portForwarding.store.reverse.enabled";
    @NotNull
    private static final OsRegistryConfigProvider osRegistryConfigProvider;
    @NotNull
    private static final IntRange validPortsRange;

    private PortForwardingConfiguration() {
    }

    @NotNull
    public final IntRange getValidPortsRange() {
        return validPortsRange;
    }

    public final boolean getPortForwardingInRegistryProviderEnabled() {
        OsRegistryConfigProvider.OsRegistrySystemSetting osRegistrySystemSetting = osRegistryConfigProvider.get("enabled");
        if (osRegistrySystemSetting == null) {
            return true;
        }
        OsRegistryConfigProvider.OsRegistrySystemSetting valueFromSystemRegistry = osRegistrySystemSetting;
        boolean isEnabled = Intrinsics.areEqual((Object)StringsKt.toBooleanStrictOrNull((String)((String)valueFromSystemRegistry.getValue())), (Object)true);
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Is Port Forwarding enabled in OS registry config provider: " + isEnabled, t$iv);
        }
        return isEnabled;
    }

    public final boolean getPortForwardingRegistryEnabled() {
        boolean isEnabled = Registry.Companion.is(PORT_FORWARDING_ENABLED_REGISTRY_KEY);
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Is Port Forwarding enabled in registry: " + isEnabled, t$iv);
        }
        return isEnabled;
    }

    public final boolean getAllowPersistingForwardedPorts() {
        boolean isPortsPersistingEnabled = Registry.Companion.is(PORT_FORWARDING_STORE_DIRECT_ENABLED_DEPRECATED_KEY);
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Persisting Direct Ports enabled (old registry key: 'portForwarding.storeState'): " + isPortsPersistingEnabled, t$iv);
        }
        return isPortsPersistingEnabled;
    }

    @Deprecated(message="Schedule for removal in 2025.1. Please use allowPersistingDirectPorts property", replaceWith=@ReplaceWith(expression="com.jetbrains.rdserver.portForwarding.PortForwardingConfiguration.getAllowPersistingDirectPorts", imports={}))
    public static /* synthetic */ void getAllowPersistingForwardedPorts$annotations() {
    }

    public final boolean getAllowPersistingDirectPorts() {
        boolean isPortsPersistingEnabled = Registry.Companion.is(PORT_FORWARDING_STORE_DIRECT_ENABLED_KEY);
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Persisting Direct Ports enabled: " + isPortsPersistingEnabled, t$iv);
        }
        return isPortsPersistingEnabled || this.getAllowPersistingForwardedPorts();
    }

    public final boolean getAllowPersistingReversePorts() {
        boolean isReversePortsPersistingEnabled = Registry.Companion.is(PORT_FORWARDING_STORE_REVERSE_ENABLED_KEY);
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("Persisting Reverse Ports enabled: " + isReversePortsPersistingEnabled, t$iv);
        }
        return isReversePortsPersistingEnabled && _frontendAllowPersistReversePorts;
    }

    public final void addPortForwardingEnabledRegistryChangeListener(@NotNull CoroutineScope coroutineScope, @NotNull Function1<? super RegistryValue, Unit> action) {
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter(action, (String)"action");
        RegistryValueListener listener2 = new RegistryValueListener(action){
            final /* synthetic */ Function1<RegistryValue, Unit> $action;
            {
                this.$action = $action;
            }

            public void afterValueChanged(RegistryValue value) {
                Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                PortForwardingConfiguration.access$getLogger$p().info("Port Forwarding registry value has been changed. Enabled: " + value.asBoolean());
                this.$action.invoke((Object)value);
            }
        };
        Registry.Companion.get(PORT_FORWARDING_ENABLED_REGISTRY_KEY).addListener(listener2, coroutineScope);
    }

    public final void addPersistReverseForwardedPortFrontendConfigListener$intellij_platform_backend_split(@NotNull Lifetime lifetime, @NotNull PortForwardingModel model2) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        model2.getAllowPersistReversePorts().advise(lifetime, PortForwardingConfiguration::addPersistReverseForwardedPortFrontendConfigListener$lambda$0);
    }

    private static final Unit addPersistReverseForwardedPortFrontendConfigListener$lambda$0(boolean enabled) {
        _frontendAllowPersistReversePorts = enabled;
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        PortForwardingConfiguration $this$thisLogger$iv = INSTANCE = new PortForwardingConfiguration();
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(PortForwardingConfiguration.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        PortForwardingConfiguration.logger = logger;
        osRegistryConfigProvider = new OsRegistryConfigProvider(OS_REGISTRY_PROVIDER_CONFIG_NAME);
        validPortsRange = new IntRange(1, 65535);
    }
}

