/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.startup;

import com.intellij.openapi.diagnostic.Logger;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0004H\u0002\u001a\u0018\u0010\r\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0004H\u0002\"\u0013\u0010\u0000\u001a\u00070\u0001\u00a2\u0006\u0002\b\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "generateIdeaProject", "", "solutionDirectory", "virtualSolution", "", "generateImlFile", "", "file", "Ljava/io/File;", "contentRoot", "generateModulesXml", "imlFile", "intellij.platform.backend.split"})
public final class IdeaProjectGeneratorKt {
    @NotNull
    private static final Logger LOG;

    @NotNull
    public static final String generateIdeaProject(@NotNull String solutionDirectory, boolean virtualSolution) {
        File dotIdea;
        Intrinsics.checkNotNullParameter((Object)solutionDirectory, (String)"solutionDirectory");
        LOG.info("Requested IDEA project in directory " + solutionDirectory + ", virtual solution=" + virtualSolution);
        File solutionFile = new File(solutionDirectory);
        if (virtualSolution && (dotIdea = new File(solutionFile, ".idea")).exists()) {
            LOG.info("Found existing .idea in " + solutionFile);
            String string = solutionFile.getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            return string;
        }
        File ideaBackendDir = new File(solutionFile, ".idea/.idea-backend");
        String imlFileName = FilesKt.getNameWithoutExtension((File)solutionFile) + ".iml";
        File imlPath = new File(ideaBackendDir, imlFileName);
        File dotIdea2 = new File(ideaBackendDir, ".idea");
        File modulesXmlPath = new File(dotIdea2, "modules.xml");
        if (!imlPath.exists() || !modulesXmlPath.exists()) {
            LOG.info("Generating new .idea in " + ideaBackendDir);
            ideaBackendDir.mkdirs();
            IdeaProjectGeneratorKt.generateImlFile(imlPath, solutionDirectory);
            dotIdea2.mkdirs();
            IdeaProjectGeneratorKt.generateModulesXml(modulesXmlPath, imlFileName);
        } else {
            LOG.info("Found existing .idea in " + ideaBackendDir);
        }
        String string = ideaBackendDir.getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        return string;
    }

    private static final void generateImlFile(File file2, String contentRoot) {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<module type=\"JAVA_MODULE\" version=\"4\">\n  <component name=\"NewModuleRootManager\" inherit-compiler-output=\"true\">\n    <exclude-output />\n    <content url=\"file:///" + contentRoot + "\">\n      <sourceFolder url=\"file:///" + contentRoot + "\" isTestSource=\"false\" />\n    </content>\n    <orderEntry type=\"inheritedJdk\" />\n    <orderEntry type=\"sourceFolder\" forTests=\"false\" />\n  </component>\n</module>";
        FilesKt.writeText$default((File)file2, (String)content, null, (int)2, null);
    }

    private static final void generateModulesXml(File file2, String imlFile) {
        String content = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<project version=\"4\">\n  <component name=\"ProjectModuleManager\">\n    <modules>\n      <module fileurl=\"file://$PROJECT_DIR$/" + imlFile + "\" filepath=\"$PROJECT_DIR$/" + imlFile + "\" />\n    </modules>\n  </component>\n</project>";
        FilesKt.writeText$default((File)file2, (String)content, null, (int)2, null);
    }

    static {
        Logger logger = Logger.getInstance((String)"com.jetbrains.rdserver.startup");
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }
}

