/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.toolWindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.ide.ui.ShowingContainer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.client.ClientSessionsManager;
import com.intellij.openapi.client.ClientSessionsUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.rd.LifetimeDisposableExKt;
import com.intellij.openapi.wm.RegisterToolWindowTask;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.toolWindow.InternalDecoratorImpl;
import com.intellij.toolWindow.ToolWindowEventSource;
import com.intellij.toolWindow.ToolWindowProperty;
import com.intellij.ui.viewModel.extraction.ToolWindowExtractorMode;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.ui.EDT;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.ide.model.uiautomation.BeToolWindowState;
import com.jetbrains.rd.ide.model.RdActiveToolWindow;
import com.jetbrains.rd.ide.model.RdContentTabName;
import com.jetbrains.rd.platform.codeWithMe.toolWindow.ActiveToolWindowTracker;
import com.jetbrains.rd.platform.codeWithMe.toolWindow.ActiveToolWindowTrackerKt;
import com.jetbrains.rd.platform.codeWithMe.toolWindow.RdToolWindowUtilsKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rd.util.reactive.Property;
import com.jetbrains.rdserver.toolWindow.BackendToolWindow;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowHost;
import com.jetbrains.rdserver.toolWindow.BackendToolWindowModeProvider;
import com.jetbrains.rdserver.unattendedHost.UtilKt;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u00ae\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0007\u0018\u0000 S2\u00020\u0001:\u0002STB\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\u0015\u001a\u00020\u0016H\u0000\u00a2\u0006\u0002\b\u0017J\u001e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u001b\u001a\u00020\u001c2\b\u0010\u001d\u001a\u0004\u0018\u00010\u001eJ\u0010\u0010\u001f\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020\u001aJ\u0012\u0010$\u001a\u0004\u0018\u00010\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u001cJ\u0014\u0010&\u001a\u0004\u0018\u00010\u000f2\b\u0010%\u001a\u0004\u0018\u00010\u001cH\u0016J\u0010\u0010'\u001a\u00020\u000f2\u0006\u0010(\u001a\u00020)H\u0016J\u0010\u0010*\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001cH\u0016J\u0010\u0010+\u001a\u00020\u00142\u0006\u0010,\u001a\u00020\u000fH\u0016J\u0010\u0010-\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001cH\u0002J\u000e\u0010.\u001a\u00020\u00142\u0006\u0010%\u001a\u00020\u001cJ\u001a\u0010/\u001a\u0002002\b\u0010%\u001a\u0004\u0018\u00010\u001c2\u0006\u0010 \u001a\u00020\u001aH\u0002J,\u00101\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001c2\b\u00102\u001a\u0004\u0018\u0001032\u0006\u00104\u001a\u00020\u00142\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u0010\u00107\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001cH\u0016J2\u00108\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001c2\u0006\u00109\u001a\u00020\u00142\u0006\u0010:\u001a\u00020\u00142\u0006\u0010;\u001a\u00020\u00142\b\u00105\u001a\u0004\u0018\u000106H\u0016J\u001d\u0010<\u001a\u00020\u00162\u0006\u0010,\u001a\u00020=2\u0006\u0010>\u001a\u00020?H\u0000\u00a2\u0006\u0002\b@J,\u0010A\u001a\u00020\u00162\u0006\u0010%\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001a2\u0012\u0010B\u001a\u000e\u0012\u0004\u0012\u00020?\u0012\u0004\u0012\u00020?0CH\u0002J\u0018\u0010D\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010E\u001a\u00020FH\u0016J\u0010\u0010G\u001a\u00020\u00162\u0006\u00105\u001a\u00020HH\u0016J\u001a\u0010I\u001a\u00020\u00162\u0006\u0010J\u001a\u00020K2\b\u0010,\u001a\u0004\u0018\u00010\u000fH\u0014J\u001a\u0010N\u001a\u00020\u00162\u0006\u0010J\u001a\u00020K2\b\u0010,\u001a\u0004\u0018\u00010\u000fH\u0002J\u0010\u0010O\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0010\u0010P\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u000fH\u0002J\u0016\u0010Q\u001a\u00020\u00162\u0006\u0010,\u001a\u00020\u000f2\u0006\u0010R\u001a\u00020\u0014R\u0016\u0010\b\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u00060\fR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u00100\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0011\u001a\u0004\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010!\u001a\u0004\u0018\u00010\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0014\u0010L\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\u00a8\u0006U"}, d2={"Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager;", "Lcom/intellij/openapi/wm/impl/ToolWindowManagerImpl;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "activeToolWindow", "Lcom/jetbrains/rd/util/reactive/Property;", "Lcom/jetbrains/rd/ide/model/RdActiveToolWindow;", "clientsTracker", "Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager$ActiveClientsTracker;", "forcedShowingToolWindows", "", "Lcom/intellij/openapi/wm/ToolWindow;", "", "showingContainer", "Lcom/intellij/ide/ui/ShowingContainer;", "processingActivation", "", "updateActiveClients", "", "updateActiveClients$intellij_platform_backend_split", "getActiveClients", "", "Lcom/intellij/openapi/client/ClientProjectSession;", "toolWindowId", "", "contentName", "Lcom/jetbrains/rd/ide/model/RdContentTabName;", "getActiveWindowId", "session", "activeToolWindowId", "getActiveToolWindowId", "()Ljava/lang/String;", "getHostToolWindow", "id", "getToolWindow", "registerToolWindow", "task", "Lcom/intellij/openapi/wm/RegisterToolWindowTask;", "unregisterToolWindow", "shouldUpdateToolWindowContent", "toolWindow", "hasClientToolWindows", "isActiveToolWindow", "getBackendToolWindowMode", "Lcom/intellij/ui/viewModel/extraction/ToolWindowExtractorMode;", "activateToolWindow", "runnable", "Ljava/lang/Runnable;", "autoFocusContents", "source", "Lcom/intellij/toolWindow/ToolWindowEventSource;", "showToolWindow", "hideToolWindow", "hideSide", "moveFocus", "removeFromStripe", "syncProjectedStealingHostState", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "state", "Lcom/jetbrains/ide/model/uiautomation/BeToolWindowState;", "syncProjectedStealingHostState$intellij_platform_backend_split", "updateBackendToolwindowState", "stateMap", "Lkotlin/Function1;", "toolWindowPropertyChanged", "property", "Lcom/intellij/toolWindow/ToolWindowProperty;", "movedOrResized", "Lcom/intellij/toolWindow/InternalDecoratorImpl;", "fireStateChanged", "changeType", "Lcom/intellij/openapi/wm/ex/ToolWindowManagerListener$ToolWindowManagerEventType;", "isEditorComponentActive", "()Z", "ensureShowingIfNeeded", "ensureShowing", "stopForcedShowing", "forceShowing", "enabled", "Companion", "ActiveClientsTracker", "intellij.platform.backend.split"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nBackendServerToolWindowManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BackendServerToolWindowManager.kt\ncom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 Reenterability.kt\ncom/jetbrains/rd/platform/util/ReenterabilityKt\n+ 5 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 6 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,454:1\n507#2,7:455\n777#3:462\n873#3,2:463\n1807#3,3:465\n1915#3,2:477\n777#3:484\n873#3,2:485\n1915#3,2:487\n1915#3,2:489\n19#4,9:468\n60#5,5:479\n13#5:492\n1#6:491\n*S KotlinDebug\n*F\n+ 1 BackendServerToolWindowManager.kt\ncom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager\n*L\n85#1:455,7\n87#1:462\n87#1:463,2\n210#1:465,3\n322#1:477,2\n358#1:484\n358#1:485,2\n358#1:487,2\n363#1:489,2\n282#1:468,9\n355#1:479,5\n45#1:492\n*E\n"})
public final class BackendServerToolWindowManager
extends ToolWindowManagerImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Property<RdActiveToolWindow> activeToolWindow;
    @NotNull
    private final ActiveClientsTracker clientsTracker;
    @NotNull
    private final Map<ToolWindow, Integer> forcedShowingToolWindows;
    @Nullable
    private ShowingContainer showingContainer;
    private boolean processingActivation;
    @NotNull
    private static final Logger logger;

    public BackendServerToolWindowManager(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        super(project, coroutineScope);
        this.activeToolWindow = new Property(null);
        this.forcedShowingToolWindows = new LinkedHashMap();
        Lifetime lifetime = LifetimeDisposableExKt.createLifetime((Disposable)((Disposable)this));
        this.clientsTracker = new ActiveClientsTracker(project, coroutineScope);
        if (!project.isDefault()) {
            this.invokeLater(() -> BackendServerToolWindowManager._init_$lambda$0(project, this, lifetime));
        }
        SimpleMessageBusConnection simpleMessageBusConnection = project.getMessageBus().connect(coroutineScope);
        Topic topic = ToolWindowManagerListener.TOPIC;
        Intrinsics.checkNotNullExpressionValue((Object)topic, (String)"TOPIC");
        simpleMessageBusConnection.subscribe(topic, (Object)new ToolWindowManagerListener(){

            public void toolWindowUnregistered(String id, ToolWindow toolWindow) {
                Intrinsics.checkNotNullParameter((Object)id, (String)"id");
                Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
                this.stopForcedShowing(toolWindow);
            }
        });
    }

    public final void updateActiveClients$intellij_platform_backend_split() {
        this.clientsTracker.updateActiveClients();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ClientProjectSession> getActiveClients(@NotNull String toolWindowId, @Nullable RdContentTabName contentName) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)toolWindowId, (String)"toolWindowId");
        Map<ClientProjectSession, RdActiveToolWindow> $this$filterValues$iv = this.clientsTracker.getActiveClients();
        boolean $i$f$filterValues = false;
        Object result$iv = new LinkedHashMap();
        for (Map.Entry<ClientProjectSession, RdActiveToolWindow> entry$iv : $this$filterValues$iv.entrySet()) {
            RdActiveToolWindow it = entry$iv.getValue();
            boolean bl = false;
            if (!ActiveToolWindowTrackerKt.matchesTab((RdActiveToolWindow)it, (String)toolWindowId, (RdContentTabName)contentName)) continue;
            ((HashMap)result$iv).put(entry$iv.getKey(), entry$iv.getValue());
        }
        Iterable $this$filter$iv = ((Map)result$iv).keySet();
        boolean $i$f$filter = false;
        result$iv = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ClientProjectSession it = (ClientProjectSession)element$iv$iv;
            boolean bl = false;
            if (!(!it.isLocal())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @Nullable
    public final String getActiveWindowId(@NotNull ClientProjectSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        RdActiveToolWindow rdActiveToolWindow = this.clientsTracker.getActiveClients().get(session);
        return rdActiveToolWindow != null ? rdActiveToolWindow.getToolWindowId() : null;
    }

    @Nullable
    public String getActiveToolWindowId() {
        ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this.getProject(), ClientId.Companion.getCurrent());
        if (clientProjectSession == null) {
            return null;
        }
        ClientProjectSession session = clientProjectSession;
        if (session.isLocal()) {
            return super.getActiveToolWindowId();
        }
        if (session.isDisposed()) {
            return null;
        }
        String string = BackendToolWindowHost.Companion.getInstance(session).getActiveToolWindowId();
        if (string == null) {
            string = this.getActiveWindowId(session);
        }
        return string;
    }

    @Nullable
    public final ToolWindow getHostToolWindow(@Nullable String id) {
        return super.getToolWindow(id);
    }

    @Nullable
    public ToolWindow getToolWindow(@Nullable String id) {
        ClientProjectSession clientProjectSession = ClientSessionsManager.Companion.getProjectSession(this.getProject(), ClientId.Companion.getCurrent());
        if (clientProjectSession == null) {
            return null;
        }
        ClientProjectSession session = clientProjectSession;
        if (session.isLocal()) {
            return super.getToolWindow(id);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getBackendToolWindowMode(id, session).ordinal()]) {
            case 1: {
                return null;
            }
            case 2: {
                return super.getToolWindow(id);
            }
            case 3: 
            case 4: 
            case 5: {
                return super.getToolWindow(id);
            }
            case 6: 
            case 7: {
                return BackendToolWindowHost.Companion.getInstance(session).getToolWindow(id);
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    @NotNull
    public ToolWindow registerToolWindow(@NotNull RegisterToolWindowTask task2) {
        Intrinsics.checkNotNullParameter((Object)task2, (String)"task");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.getProject());
        if (session.isLocal()) {
            return super.registerToolWindow(task2);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getBackendToolWindowMode(task2.getId(), session).ordinal()]) {
            case 1: {
                throw new IllegalStateException(("Can't register client toolwindow " + task2.getId()).toString());
            }
            case 2: {
                return super.registerToolWindow(task2);
            }
            case 3: 
            case 4: 
            case 5: {
                return super.registerToolWindow(task2);
            }
            case 6: 
            case 7: {
                return BackendToolWindowHost.Companion.getInstance(session).registerClientToolWindow(task2.getData());
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    public void unregisterToolWindow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.getProject());
        if (session.isLocal()) {
            super.unregisterToolWindow(id);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getBackendToolWindowMode(id, session).ordinal()]) {
            case 1: {
                throw new IllegalStateException(("Can't unregister client toolwindow " + id).toString());
            }
            case 2: {
                super.unregisterToolWindow(id);
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                super.unregisterToolWindow(id);
                break;
            }
            case 6: 
            case 7: {
                BackendToolWindowHost.Companion.getInstance(session).unregisterToolWindow(id);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldUpdateToolWindowContent(@NotNull ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        switch (WhenMappings.$EnumSwitchMapping$0[this.getBackendToolWindowMode(toolWindow.getId(), ClientSessionsUtil.getCurrentSession((Project)this.getProject())).ordinal()]) {
            case 1: {
                return super.shouldUpdateToolWindowContent(toolWindow);
            }
            case 2: {
                return super.shouldUpdateToolWindowContent(toolWindow);
            }
            case 3: 
            case 4: 
            case 5: {
                if (super.shouldUpdateToolWindowContent(toolWindow)) return true;
                String string = toolWindow.getId();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                if (!this.hasClientToolWindows(string)) return false;
                return true;
            }
            case 6: 
            case 7: {
                if (super.shouldUpdateToolWindowContent(toolWindow)) return true;
                if (!(toolWindow instanceof BackendToolWindow)) return false;
                return true;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final boolean hasClientToolWindows(String id) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = BackendToolWindowHost.Companion.getAllInstances(this.getProject());
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    BackendToolWindowHost windowHost = (BackendToolWindowHost)((Object)element$iv);
                    boolean bl2 = false;
                    if (!(windowHost.getToolWindow(id) != null)) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isActiveToolWindow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.getProject());
        if (session.isLocal()) {
            return Intrinsics.areEqual((Object)this.getActiveToolWindowId(), (Object)id);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.getBackendToolWindowMode(id, session).ordinal()]) {
            case 1: {
                return false;
            }
            case 2: {
                return Intrinsics.areEqual((Object)this.getActiveToolWindowId(), (Object)id);
            }
            case 3: 
            case 4: 
            case 5: {
                return Intrinsics.areEqual((Object)this.getActiveToolWindowId(), (Object)id) || BackendToolWindowHost.Companion.getInstance(session).getToolWindowState(id) == BeToolWindowState.ActiveAndFocused;
            }
            case 6: 
            case 7: {
                return BackendToolWindowHost.Companion.getInstance(session).getToolWindowState(id) == BeToolWindowState.ActiveAndFocused;
            }
        }
        throw new NoWhenBranchMatchedException();
    }

    private final ToolWindowExtractorMode getBackendToolWindowMode(String id, ClientProjectSession session) {
        return BackendToolWindowModeProvider.INSTANCE.getBackendToolWindowMode(id, session);
    }

    public void activateToolWindow(@NotNull String id, @Nullable Runnable runnable, boolean autoFocusContents, @Nullable ToolWindowEventSource source) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.getProject());
        if (session.isOwner()) {
            super.activateToolWindow(id, runnable, autoFocusContents, source);
        }
        this.updateBackendToolwindowState(id, session, (Function1<? super BeToolWindowState, ? extends BeToolWindowState>)((Function1)BackendServerToolWindowManager::activateToolWindow$lambda$0));
        if (runnable != null && !session.isOwner()) {
            ApplicationManager.getApplication().invokeLater(runnable, this.getProject().getDisposed());
        }
    }

    public void showToolWindow(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.getProject());
        if (session.isLocal()) {
            super.showToolWindow(id);
        }
        this.updateBackendToolwindowState(id, session, (Function1<? super BeToolWindowState, ? extends BeToolWindowState>)((Function1)BackendServerToolWindowManager::showToolWindow$lambda$0));
    }

    public void hideToolWindow(@NotNull String id, boolean hideSide, boolean moveFocus, boolean removeFromStripe, @Nullable ToolWindowEventSource source) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.getProject());
        if (session.isLocal()) {
            super.hideToolWindow(id, hideSide, moveFocus, removeFromStripe, source);
        }
        this.updateBackendToolwindowState(id, session, (Function1<? super BeToolWindowState, ? extends BeToolWindowState>)((Function1)BackendServerToolWindowManager::hideToolWindow$lambda$0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void syncProjectedStealingHostState$intellij_platform_backend_split(@NotNull ToolWindowEx toolWindow, @NotNull BeToolWindowState state) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        KMutableProperty0 flag$iv = (KMutableProperty0)new MutablePropertyReference0Impl((Object)this){

            public Object get() {
                return BackendServerToolWindowManager.access$getProcessingActivation$p((BackendServerToolWindowManager)((Object)this.receiver));
            }

            public void set(Object value) {
                BackendServerToolWindowManager.access$setProcessingActivation$p((BackendServerToolWindowManager)((Object)this.receiver), (Boolean)value);
            }
        };
        boolean $i$f$noReenter = false;
        if (!((Boolean)flag$iv.get()).booleanValue()) {
            flag$iv.set((Object)true);
            try {
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$1[state.ordinal()]) {
                    case 2: {
                        String string = toolWindow.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        super.activateToolWindow(string, null, false, null);
                        break;
                    }
                    case 3: {
                        String string = toolWindow.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        super.showToolWindow(string);
                        break;
                    }
                    case 1: {
                        String string = toolWindow.getId();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
                        super.hideToolWindow(string, false, true, false, null);
                        break;
                    }
                    default: {
                        throw new NoWhenBranchMatchedException();
                    }
                }
            }
            finally {
                flag$iv.set((Object)false);
            }
        }
    }

    private final void updateBackendToolwindowState(String id, ClientProjectSession session, Function1<? super BeToolWindowState, ? extends BeToolWindowState> stateMap) {
        ClientProjectSession clientProjectSession;
        if (session.isLocal()) {
            clientProjectSession = UtilKt.getControllerSessionOrNull(this.getProject());
            if (clientProjectSession == null) {
                return;
            }
        } else {
            switch (WhenMappings.$EnumSwitchMapping$0[this.getBackendToolWindowMode(id, session).ordinal()]) {
                case 1: 
                case 2: {
                    return;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: {
                    BackendToolWindowHost toolWindowHost = BackendToolWindowHost.Companion.getInstance(session);
                    BeToolWindowState oldState = toolWindowHost.getToolWindowState(id);
                    BeToolWindowState newState = (BeToolWindowState)stateMap.invoke((Object)oldState);
                    toolWindowHost.setToolWindowState(id, newState);
                    return;
                }
            }
            throw new NoWhenBranchMatchedException();
        }
        ClientProjectSession controllerSession = clientProjectSession;
        this.updateBackendToolwindowState(id, controllerSession, stateMap);
    }

    public void toolWindowPropertyChanged(@NotNull ToolWindow toolWindow, @NotNull ToolWindowProperty property) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        Intrinsics.checkNotNullParameter((Object)property, (String)"property");
        if (toolWindow instanceof BackendToolWindow) {
            BackendToolWindowHost.Companion.getInstance(((BackendToolWindow)toolWindow).getSession()).updateToolWindow(toolWindow);
        } else {
            super.toolWindowPropertyChanged(toolWindow, property);
            Iterable $this$forEach$iv = BackendToolWindowHost.Companion.getAllInstances(this.getProject());
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                BackendToolWindowHost windowHost = (BackendToolWindowHost)((Object)element$iv);
                boolean bl = false;
                if (!this.getBackendToolWindowMode(toolWindow.getId(), windowHost.getSession()).isMirrorLike()) continue;
                windowHost.updateToolWindow(toolWindow);
            }
        }
    }

    public void movedOrResized(@NotNull InternalDecoratorImpl source) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        ShowingContainer showingContainer = this.showingContainer;
        boolean bl = showingContainer != null ? showingContainer.isAttached((Component)source) : false;
        if (bl) {
            return;
        }
        super.movedOrResized(source);
    }

    protected void fireStateChanged(@NotNull ToolWindowManagerListener.ToolWindowManagerEventType changeType, @Nullable ToolWindow toolWindow) {
        Intrinsics.checkNotNullParameter((Object)changeType, (String)"changeType");
        super.fireStateChanged(changeType, toolWindow);
        this.ensureShowingIfNeeded(changeType, toolWindow);
    }

    public boolean isEditorComponentActive() {
        ClientProjectSession session = ClientSessionsUtil.getCurrentSession((Project)this.getProject());
        if (session.isLocal()) {
            return super.isEditorComponentActive();
        }
        return BackendToolWindowHost.Companion.getInstance(session).getActive() == null;
    }

    /*
     * WARNING - void declaration
     */
    private final void ensureShowingIfNeeded(ToolWindowManagerListener.ToolWindowManagerEventType changeType, ToolWindow toolWindow) {
        Logger $this$debug_u24default$iv = logger;
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            Logger logger = $this$debug_u24default$iv;
            boolean bl = false;
            ToolWindow toolWindow2 = toolWindow;
            logger.debug("Updating showing status on " + changeType + " event for tool window " + (toolWindow2 != null ? toolWindow2.getId() : null), t$iv);
        }
        switch (WhenMappings.$EnumSwitchMapping$2[changeType.ordinal()]) {
            case 1: 
            case 2: 
            case 3: {
                void $this$forEach$iv;
                void $this$filterTo$iv$iv;
                Iterable $this$filter$iv = this.forcedShowingToolWindows.keySet();
                boolean $i$f$filter = false;
                Iterable iterable = $this$filter$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterTo = false;
                for (Object element$iv$iv : $this$filterTo$iv$iv) {
                    ToolWindow it = (ToolWindow)element$iv$iv;
                    boolean bl = false;
                    if (!(toolWindow == null || Intrinsics.areEqual((Object)toolWindow, (Object)it))) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                $this$filter$iv = (List)destination$iv$iv;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ToolWindow p0 = (ToolWindow)element$iv;
                    boolean bl = false;
                    this.ensureShowing(p0);
                }
                break;
            }
            case 4: 
            case 5: {
                Iterable $this$forEach$iv = this.forcedShowingToolWindows.keySet();
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    ToolWindow p0 = (ToolWindow)element$iv;
                    boolean bl = false;
                    this.ensureShowing(p0);
                }
                break;
            }
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private final void ensureShowing(ToolWindow toolWindow) {
        toolWindow.getContentManager();
        Intrinsics.checkNotNull((Object)toolWindow, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowEx");
        InternalDecorator internalDecorator = ((ToolWindowEx)toolWindow).getDecorator();
        Intrinsics.checkNotNullExpressionValue((Object)internalDecorator, (String)"getDecorator(...)");
        InternalDecorator component = internalDecorator;
        if (!component.isShowing()) {
            ShowingContainer container;
            if (component.getParent() != null) {
                JBIterable jBIterable = UIUtil.uiParents((Component)((Component)component), (boolean)true).map(arg_0 -> BackendServerToolWindowManager.ensureShowing$lambda$1(BackendServerToolWindowManager::ensureShowing$lambda$0, arg_0));
                Intrinsics.checkNotNullExpressionValue((Object)jBIterable, (String)"map(...)");
                String parentChain = CollectionsKt.joinToString$default((Iterable)((Iterable)jBIterable), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null);
                logger.error("Tool window decorator is already installed in components hierarchy: " + toolWindow + " (" + ((ToolWindowEx)toolWindow).getId() + ", " + ((ToolWindowEx)toolWindow).getInternalType() + "), parent chain:\n" + parentChain);
                return;
            }
            ShowingContainer showingContainer = this.showingContainer;
            if (showingContainer == null) {
                ShowingContainer showingContainer2;
                ShowingContainer it = showingContainer2 = ShowingContainer.Companion.getInstance(this.getProject());
                boolean bl = false;
                this.showingContainer = it;
                showingContainer = showingContainer2;
            }
            if ((container = showingContainer) == null) {
                logger.warn("Couldn't obtain ShowingContainer instance for " + this.getProject());
            } else {
                container.add((Component)component);
            }
        }
    }

    private final void stopForcedShowing(ToolWindow toolWindow) {
        block1: {
            if (this.forcedShowingToolWindows.remove(toolWindow) == null) break block1;
            ShowingContainer showingContainer = this.showingContainer;
            if (showingContainer != null) {
                Intrinsics.checkNotNull((Object)toolWindow, (String)"null cannot be cast to non-null type com.intellij.openapi.wm.ex.ToolWindowEx");
                showingContainer.remove((Component)((ToolWindowEx)toolWindow).getDecorator());
            }
        }
    }

    public final void forceShowing(@NotNull ToolWindow toolWindow, boolean enabled) {
        Intrinsics.checkNotNullParameter((Object)toolWindow, (String)"toolWindow");
        EDT.assertIsEdt();
        Integer count = this.forcedShowingToolWindows.get(toolWindow);
        if (enabled) {
            if (count == null) {
                this.ensureShowing(toolWindow);
            }
        } else {
            Integer n = count;
            int n2 = 1;
            if (n != null && n == n2) {
                this.stopForcedShowing(toolWindow);
            }
        }
        Integer n = count;
        int newCount = (n != null ? n : 0) + (enabled ? 1 : -1);
        if (newCount > 0) {
            this.forcedShowingToolWindows.put(toolWindow, newCount);
        } else {
            this.forcedShowingToolWindows.remove(toolWindow);
        }
    }

    private static final Unit lambda$0$0(BackendServerToolWindowManager this$0, Lifetime lifetime, RdActiveToolWindow rdActiveToolWindow) {
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"<unused var>");
        this$0.clientsTracker.updateActiveClients();
        return Unit.INSTANCE;
    }

    private static final void _init_$lambda$0(Project $project, BackendServerToolWindowManager this$0, Lifetime $lifetime) {
        ActiveToolWindowTracker tracker = new ActiveToolWindowTracker($project, (IProperty)this$0.activeToolWindow, $lifetime);
        tracker.updateActiveContent();
        this$0.activeToolWindow.view($lifetime, (arg_0, arg_1) -> BackendServerToolWindowManager.lambda$0$0(this$0, arg_0, arg_1));
    }

    private static final BeToolWindowState activateToolWindow$lambda$0(BeToolWindowState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BeToolWindowState.ActiveAndFocused;
    }

    private static final BeToolWindowState showToolWindow$lambda$0(BeToolWindowState oldState) {
        Intrinsics.checkNotNullParameter((Object)oldState, (String)"oldState");
        return WhenMappings.$EnumSwitchMapping$1[oldState.ordinal()] == 1 ? BeToolWindowState.Active : oldState;
    }

    private static final BeToolWindowState hideToolWindow$lambda$0(BeToolWindowState it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return BeToolWindowState.Hidden;
    }

    private static final String ensureShowing$lambda$0(Component it) {
        return Reflection.getOrCreateKotlinClass(it.getClass()).getSimpleName() + "(" + it + ")";
    }

    private static final String ensureShowing$lambda$1(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final BackendServerToolWindowManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    public static final /* synthetic */ boolean access$getProcessingActivation$p(BackendServerToolWindowManager $this) {
        return $this.processingActivation;
    }

    public static final /* synthetic */ void access$setProcessingActivation$p(BackendServerToolWindowManager $this, boolean bl) {
        $this.processingActivation = bl;
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(BackendServerToolWindowManager.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        BackendServerToolWindowManager.logger = logger;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\b\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0006\u0010\u0010\u001a\u00020\u0011J\b\u0010\u0012\u001a\u00020\u0011H\u0002J;\u0010\u0013\u001a\u00020\u0011\"\u0004\b\u0000\u0010\u0014\"\u0004\b\u0001\u0010\u0015*\u000e\u0012\u0004\u0012\u0002H\u0014\u0012\u0004\u0012\u0002H\u00150\u000b2\u0006\u0010\u0016\u001a\u0002H\u00142\b\u0010\u0017\u001a\u0004\u0018\u0001H\u0015H\u0002\u00a2\u0006\u0002\u0010\u0018R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\n\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\r0\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0019"}, d2={"Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager$ActiveClientsTracker;", "", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager;Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "updateQueue", "Lcom/intellij/util/ui/update/MergingUpdateQueue;", "activeClients", "", "Lcom/intellij/openapi/client/ClientProjectSession;", "Lcom/jetbrains/rd/ide/model/RdActiveToolWindow;", "getActiveClients", "()Ljava/util/Map;", "updateActiveClients", "", "doUpdateActiveClients", "putNotNull", "K", "V", "key", "value", "(Ljava/util/Map;Ljava/lang/Object;Ljava/lang/Object;)V", "intellij.platform.backend.split"})
    public final class ActiveClientsTracker {
        @NotNull
        private final Project project;
        @NotNull
        private final MergingUpdateQueue updateQueue;
        @NotNull
        private final Map<ClientProjectSession, RdActiveToolWindow> activeClients;

        public ActiveClientsTracker(@NotNull Project project, CoroutineScope coroutineScope) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
            this.project = project;
            this.updateQueue = MergingUpdateQueue.Companion.edtMergingUpdateQueue$default((MergingUpdateQueue.Companion)MergingUpdateQueue.Companion, (String)"ActiveClientsTracker", (int)500, (CoroutineScope)coroutineScope, null, (int)8, null);
            this.activeClients = new LinkedHashMap();
        }

        @NotNull
        public final Map<ClientProjectSession, RdActiveToolWindow> getActiveClients() {
            return this.activeClients;
        }

        public final void updateActiveClients() {
            this.updateQueue.queue(Update.Companion.create((Object)"update", () -> ActiveClientsTracker.updateActiveClients$lambda$0(this)));
        }

        private final void doUpdateActiveClients() {
            Map result = new LinkedHashMap();
            this.putNotNull(result, CollectionsKt.first((List)ClientSessionsUtil.sessions((Project)this.project, (ClientKind)ClientKind.LOCAL)), BackendServerToolWindowManager.this.activeToolWindow.getValue());
            for (BackendToolWindowHost windowHost : BackendToolWindowHost.Companion.getAllInstances(this.project)) {
                this.putNotNull(result, windowHost.getSession(), windowHost.getActive());
            }
            if (!Intrinsics.areEqual(this.activeClients, (Object)result)) {
                this.activeClients.clear();
                this.activeClients.putAll(result);
                for (BackendToolWindowHost windowHost : BackendToolWindowHost.Companion.getAllInstances(this.project)) {
                    windowHost.setActiveClients(result);
                }
                RdToolWindowUtilsKt.updateAllToolWindowTabs((Project)this.project);
            }
        }

        private final <K, V> void putNotNull(Map<K, V> $this$putNotNull, K key, V value) {
            if (value != null) {
                $this$putNotNull.put(key, value);
            }
        }

        private static final void updateActiveClients$lambda$0(ActiveClientsTracker this$0) {
            this$0.doUpdateActiveClients();
        }
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager$Companion;", "", "<init>", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "getLogger", "()Lcom/intellij/openapi/diagnostic/Logger;", "getInstance", "Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.backend.split"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Logger getLogger() {
            return logger;
        }

        @JvmStatic
        @NotNull
        public final BackendServerToolWindowManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(project);
            Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.toolWindow.BackendServerToolWindowManager");
            return (BackendServerToolWindowManager)toolWindowManager;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[ToolWindowExtractorMode.values().length];
            try {
                nArray[ToolWindowExtractorMode.DISABLE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowExtractorMode.FALLBACK.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowExtractorMode.MIRROR.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowExtractorMode.PROJECTOR_STEALING.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowExtractorMode.UNSUPPORTED.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowExtractorMode.PER_CLIENT.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowExtractorMode.PROJECTOR_INSTANCING.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[BeToolWindowState.values().length];
            try {
                nArray[BeToolWindowState.Hidden.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeToolWindowState.ActiveAndFocused.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeToolWindowState.Active.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[ToolWindowManagerListener.ToolWindowManagerEventType.values().length];
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.HideToolWindow.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetLayout.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.ToolWindowUnavailable.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.ActivateToolWindow.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.ShowToolWindow.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.RegisterToolWindow.ordinal()] = 6;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetContentUiType.ordinal()] = 7;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetShowStripeButton.ordinal()] = 8;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetSideTool.ordinal()] = 9;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetSideToolAndAnchor.ordinal()] = 10;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetToolWindowAnchor.ordinal()] = 11;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetToolWindowAutoHide.ordinal()] = 12;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetToolWindowType.ordinal()] = 13;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SetVisibleOnLargeStripe.ordinal()] = 14;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.UnregisterToolWindow.ordinal()] = 15;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.ToolWindowAvailable.ordinal()] = 16;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.MovedOrResized.ordinal()] = 17;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.MoreButtonUpdated.ordinal()] = 18;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.ShowNames.ordinal()] = 19;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ToolWindowManagerListener.ToolWindowManagerEventType.SideCustomWidth.ordinal()] = 20;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

