/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.toolWindow;

import com.intellij.codeWithMe.ClientId;
import com.intellij.codeWithMe.ClientIdKt;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientProjectSession;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowContentUiType;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ToolWindowType;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.impl.InternalDecorator;
import com.intellij.openapi.wm.impl.ToolWindowManagerImpl;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.CoroutineScopeKt;
import com.intellij.util.ui.ComponentWithEmptyText;
import com.intellij.util.ui.StatusText;
import com.jetbrains.ide.model.uiautomation.BePosition;
import com.jetbrains.ide.model.uiautomation.BeToolWindow;
import com.jetbrains.ide.model.uiautomation.BeToolWindowState;
import com.jetbrains.rd.ide.model.IconModel;
import com.jetbrains.rd.ide.toolWindows.UtilsKt;
import com.jetbrains.rd.ui.icons.UtilKt;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.reactive.IOptProperty;
import com.jetbrains.rd.util.reactive.InterfacesKt;
import com.jetbrains.rdserver.toolWindow.BackendContentManager;
import com.jetbrains.rdserver.toolWindow.BackendServerToolWindowManager;
import com.jetbrains.rdserver.toolWindow.BackendToolwindowHeaderDecorator;
import java.awt.Rectangle;
import java.awt.event.InputEvent;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0088\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0004\b\f\u0010\rJ\r\u0010+\u001a\u00020,H\u0000\u00a2\u0006\u0002\b-J\r\u0010.\u001a\u00020,H\u0000\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020\u0003H\u0016J\b\u00101\u001a\u00020\u0015H\u0016J\b\u00102\u001a\u000203H\u0016J\b\u00104\u001a\u00020\u001bH\u0016J\b\u00105\u001a\u000206H\u0016J\b\u00107\u001a\u000208H\u0016J\n\u00109\u001a\u0004\u0018\u000108H\u0016J\b\u0010:\u001a\u00020;H\u0016J\b\u0010<\u001a\u00020=H\u0016J\n\u0010>\u001a\u0004\u0018\u00010?H\u0016J\b\u0010@\u001a\u00020AH\u0016J\u001a\u0010B\u001a\u00020,2\u0006\u0010C\u001a\u00020A2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\b\u0010F\u001a\u00020\u001bH\u0016J\b\u0010G\u001a\u00020\u001bH\u0016J\u001a\u0010H\u001a\u00020,2\u0006\u0010I\u001a\u00020\u001b2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010J\u001a\u00020K2\u0006\u0010L\u001a\u00020MH\u0016J\b\u0010N\u001a\u00020\u001bH\u0016J\b\u0010O\u001a\u00020\u001bH\u0016J\"\u0010P\u001a\u00020,2\b\u0010D\u001a\u0004\u0018\u00010E2\u0006\u0010Q\u001a\u00020\u001b2\u0006\u0010R\u001a\u00020\u001bH\u0016J\u0012\u0010S\u001a\u00020,2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0012\u0010T\u001a\u00020,2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\b\u0010U\u001a\u00020,H\u0016J\b\u0010V\u001a\u00020\u001bH\u0016J\u0010\u0010W\u001a\u00020,2\u0006\u0010X\u001a\u00020\u001bH\u0016J\b\u0010Y\u001a\u00020ZH\u0016J\u001a\u0010[\u001a\u00020,2\u0006\u0010\\\u001a\u00020Z2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\b\u0010]\u001a\u00020ZH\u0016J\n\u0010^\u001a\u0004\u0018\u00010\u001dH\u0016J\u0010\u0010_\u001a\u00020,2\u0006\u0010`\u001a\u00020\u001dH\u0016J\b\u0010a\u001a\u0004\u0018\u00010\u001fJ\n\u0010b\u001a\u0004\u0018\u00010\u0003H\u0016J\u0012\u0010c\u001a\u00020,2\b\u0010d\u001a\u0004\u0018\u00010\u0003H\u0016J\b\u0010e\u001a\u00020\u0003H\u0016J\u000e\u0010f\u001a\b\u0012\u0004\u0012\u00020\u00030gH\u0016J\u0010\u0010h\u001a\u00020,2\u0006\u0010d\u001a\u00020\u0003H\u0016J\u0016\u0010i\u001a\u00020,2\f\u0010d\u001a\b\u0012\u0004\u0012\u00020\u00030gH\u0016J\b\u0010j\u001a\u00020\u001bH\u0016J\u0010\u0010k\u001a\u00020,2\u0006\u0010X\u001a\u00020\u001bH\u0016J\u001a\u0010k\u001a\u00020,2\u0006\u0010X\u001a\u00020\u001b2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u001a\u0010l\u001a\u00020,2\u0006\u0010\\\u001a\u00020m2\b\u0010D\u001a\u0004\u0018\u00010EH\u0016J\u0010\u0010n\u001a\u00020,2\u0006\u0010\\\u001a\u00020mH\u0016J\b\u0010o\u001a\u00020mH\u0016J\u0010\u0010p\u001a\u00020,2\u0006\u0010q\u001a\u000208H\u0016J\u0010\u0010r\u001a\u00020,2\u0006\u0010s\u001a\u00020tH\u0016J&\u0010u\u001a\u00020,2\b\u0010C\u001a\u0004\u0018\u00010A2\b\u0010\\\u001a\u0004\u0018\u00010Z2\b\u0010v\u001a\u0004\u0018\u00010wH\u0016J\u0010\u0010x\u001a\u00020,2\u0006\u0010y\u001a\u00020\u001bH\u0016J\b\u0010z\u001a\u00020\u001bH\u0016J\u0010\u0010{\u001a\u00020,2\u0006\u0010X\u001a\u00020\u001bH\u0016J\u0010\u0010|\u001a\u00020,2\u0006\u0010}\u001a\u00020~H\u0016J\u0017\u0010\u007f\u001a\u00020,2\r\u0010\u0080\u0001\u001a\b\u0012\u0004\u0012\u00020&0%H\u0016J\u0012\u0010\u0081\u0001\u001a\u00020,2\u0007\u0010X\u001a\u00030\u0082\u0001H\u0016J\u0012\u0010\u0083\u0001\u001a\u00020,2\u0007\u0010X\u001a\u00030\u0082\u0001H\u0016J\u0013\u0010\u0084\u0001\u001a\u00020,2\b\u0010\"\u001a\u0004\u0018\u00010#H\u0016J%\u0010\u0089\u0001\u001a\u00020,2\u0014\u0010\u0080\u0001\u001a\u000b\u0012\u0006\b\u0001\u0012\u00020&0\u008a\u0001\"\u00020&H\u0016\u00a2\u0006\u0003\u0010\u008b\u0001J\u0019\u0010\u008c\u0001\u001a\u00020,2\u000e\u0010\u0080\u0001\u001a\t\u0012\u0004\u0012\u00020&0\u008d\u0001H\u0016J\u0013\u0010\u008e\u0001\u001a\u00020,2\b\u0010D\u001a\u0004\u0018\u00010EH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001e\u001a\u0004\u0018\u00010\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010 \u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010!\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\"\u001a\u0004\u0018\u00010#X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\"\u0010$\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010%X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0018\u0010\u0085\u0001\u001a\u00030\u0086\u0001X\u0080\u0004\u00a2\u0006\n\n\u0000\u001a\u0006\b\u0087\u0001\u0010\u0088\u0001\u00a8\u0006\u008f\u0001"}, d2={"Lcom/jetbrains/rdserver/toolWindow/BackendToolWindow;", "Lcom/intellij/openapi/wm/ex/ToolWindowEx;", "_id", "", "session", "Lcom/intellij/openapi/client/ClientProjectSession;", "_model", "Lcom/jetbrains/ide/model/uiautomation/BeToolWindow;", "toolWindowFactory", "Lcom/intellij/openapi/wm/ToolWindowFactory;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "<init>", "(Ljava/lang/String;Lcom/intellij/openapi/client/ClientProjectSession;Lcom/jetbrains/ide/model/uiautomation/BeToolWindow;Lcom/intellij/openapi/wm/ToolWindowFactory;Lcom/jetbrains/rd/util/lifetime/Lifetime;)V", "getSession", "()Lcom/intellij/openapi/client/ClientProjectSession;", "toolWindowManager", "Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager;", "getToolWindowManager", "()Lcom/jetbrains/rdserver/toolWindow/BackendServerToolWindowManager;", "_disposable", "Lcom/intellij/openapi/Disposable;", "_contentManager", "Lcom/jetbrains/rdserver/toolWindow/BackendContentManager;", "_decorator", "Lcom/jetbrains/rdserver/toolWindow/BackendToolwindowHeaderDecorator;", "_available", "", "_icon", "Ljavax/swing/Icon;", "_iconModel", "Lcom/jetbrains/rd/ide/model/IconModel;", "_initialized", "_contentCreated", "additionalGearActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "titleActions", "", "Lcom/intellij/openapi/actionSystem/AnAction;", "getTitleActions$intellij_platform_backend_split", "()Ljava/util/List;", "setTitleActions$intellij_platform_backend_split", "(Ljava/util/List;)V", "init", "", "init$intellij_platform_backend_split", "createContentIfNeeded", "createContentIfNeeded$intellij_platform_backend_split", "getId", "getDisposable", "getProject", "Lcom/intellij/openapi/project/Project;", "isDisposed", "getComponent", "Ljavax/swing/JComponent;", "getContentManager", "Lcom/intellij/ui/content/ContentManager;", "getContentManagerIfCreated", "getDecorator", "Lcom/intellij/openapi/wm/impl/InternalDecorator;", "getDecoration", "Lcom/intellij/openapi/wm/ex/ToolWindowEx$ToolWindowDecoration;", "getEmptyText", "Lcom/intellij/util/ui/StatusText;", "getAnchor", "Lcom/intellij/openapi/wm/ToolWindowAnchor;", "setAnchor", "anchor", "runnable", "Ljava/lang/Runnable;", "canCloseContents", "isSplitMode", "setSplitMode", "split", "getReady", "Lcom/intellij/openapi/util/ActionCallback;", "requestor", "", "isVisible", "isActive", "activate", "autoFocusContents", "forced", "show", "hide", "remove", "isAutoHide", "setAutoHide", "value", "getType", "Lcom/intellij/openapi/wm/ToolWindowType;", "setType", "type", "getInternalType", "getIcon", "setIcon", "icon", "getIconModel", "getTitle", "setTitle", "title", "getStripeTitle", "getStripeTitleProvider", "Ljava/util/function/Supplier;", "setStripeTitle", "setStripeTitleProvider", "isAvailable", "setAvailable", "setContentUiType", "Lcom/intellij/openapi/wm/ToolWindowContentUiType;", "setDefaultContentUiType", "getContentUiType", "installWatcher", "contentManager", "addContentManagerListener", "listener", "Lcom/intellij/ui/content/ContentManagerListener;", "setDefaultState", "floatingBounds", "Ljava/awt/Rectangle;", "setToHideOnEmptyContent", "hideOnEmpty", "isShowStripeButton", "setShowStripeButton", "showContentPopup", "inputEvent", "Ljava/awt/event/InputEvent;", "setTitleActions", "actions", "stretchWidth", "", "stretchHeight", "setAdditionalGearActions", "westActionGroup", "Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "getWestActionGroup$intellij_platform_backend_split", "()Lcom/intellij/openapi/actionSystem/DefaultActionGroup;", "setTabActions", "", "([Lcom/intellij/openapi/actionSystem/AnAction;)V", "setTabDoubleClickActions", "", "callLater", "intellij.platform.backend.split"})
public final class BackendToolWindow
implements ToolWindowEx {
    @NotNull
    private final String _id;
    @NotNull
    private final ClientProjectSession session;
    @NotNull
    private final BeToolWindow _model;
    @Nullable
    private final ToolWindowFactory toolWindowFactory;
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Disposable _disposable;
    @NotNull
    private final BackendContentManager _contentManager;
    @NotNull
    private final BackendToolwindowHeaderDecorator _decorator;
    private boolean _available;
    @Nullable
    private Icon _icon;
    @Nullable
    private IconModel _iconModel;
    private boolean _initialized;
    private boolean _contentCreated;
    @Nullable
    private ActionGroup additionalGearActions;
    @Nullable
    private List<? extends AnAction> titleActions;
    @NotNull
    private final DefaultActionGroup westActionGroup;

    public BackendToolWindow(@NotNull String _id, @NotNull ClientProjectSession session, @NotNull BeToolWindow _model, @Nullable ToolWindowFactory toolWindowFactory, @NotNull Lifetime lifetime) {
        Intrinsics.checkNotNullParameter((Object)_id, (String)"_id");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)_model, (String)"_model");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        this._id = _id;
        this.session = session;
        this._model = _model;
        this.toolWindowFactory = toolWindowFactory;
        this.lifetime = lifetime;
        Disposable disposable = Disposer.newDisposable();
        Intrinsics.checkNotNullExpressionValue((Object)disposable, (String)"newDisposable(...)");
        this._disposable = disposable;
        this._contentManager = new BackendContentManager(this);
        this._decorator = new BackendToolwindowHeaderDecorator(this);
        this._available = true;
        Disposer.register((Disposable)this._disposable, (Disposable)((Disposable)this._contentManager));
        this._decorator.add(this.getComponent());
        this.westActionGroup = new DefaultActionGroup();
    }

    @NotNull
    public final ClientProjectSession getSession() {
        return this.session;
    }

    private final BackendServerToolWindowManager getToolWindowManager() {
        ToolWindowManager toolWindowManager = ToolWindowManager.Companion.getInstance(this.getProject());
        Intrinsics.checkNotNull((Object)toolWindowManager, (String)"null cannot be cast to non-null type com.jetbrains.rdserver.toolWindow.BackendServerToolWindowManager");
        return (BackendServerToolWindowManager)toolWindowManager;
    }

    @Nullable
    public final List<AnAction> getTitleActions$intellij_platform_backend_split() {
        return this.titleActions;
    }

    public final void setTitleActions$intellij_platform_backend_split(@Nullable List<? extends AnAction> list) {
        this.titleActions = list;
    }

    public final void init$intellij_platform_backend_split() {
        if (this._initialized) {
            return;
        }
        this._initialized = true;
        if (this.toolWindowFactory != null) {
            ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendToolWindow.init$lambda$0(this));
        }
    }

    public final void createContentIfNeeded$intellij_platform_backend_split() {
        if (this._contentCreated) {
            return;
        }
        this._contentCreated = true;
        if (this.toolWindowFactory != null) {
            ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendToolWindow.createContentIfNeeded$lambda$0(this));
        }
    }

    @NotNull
    public String getId() {
        return this._id;
    }

    @NotNull
    public Disposable getDisposable() {
        return this._disposable;
    }

    @NotNull
    public Project getProject() {
        return this.session.getProject();
    }

    public boolean isDisposed() {
        return Disposer.isDisposed((Disposable)this._disposable);
    }

    @NotNull
    public JComponent getComponent() {
        JComponent jComponent = this._contentManager.getComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getComponent(...)");
        return jComponent;
    }

    @NotNull
    public ContentManager getContentManager() {
        this.createContentIfNeeded$intellij_platform_backend_split();
        return (ContentManager)this._contentManager;
    }

    @Nullable
    public ContentManager getContentManagerIfCreated() {
        return this._contentCreated ? (ContentManager)this._contentManager : null;
    }

    @NotNull
    public InternalDecorator getDecorator() {
        return this._decorator;
    }

    @NotNull
    public ToolWindowEx.ToolWindowDecoration getDecoration() {
        return new ToolWindowEx.ToolWindowDecoration(this._icon, this.additionalGearActions);
    }

    @Nullable
    public StatusText getEmptyText() {
        JComponent jComponent = this.getContentManager().getComponent();
        Intrinsics.checkNotNull((Object)jComponent, (String)"null cannot be cast to non-null type com.intellij.util.ui.ComponentWithEmptyText");
        return ((ComponentWithEmptyText)jComponent).getEmptyText();
    }

    @NotNull
    public ToolWindowAnchor getAnchor() {
        return UtilsKt.toIdeaAnchor((BePosition)this._model.getPosition());
    }

    public void setAnchor(@NotNull ToolWindowAnchor anchor, @Nullable Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)anchor, (String)"anchor");
    }

    public boolean canCloseContents() {
        return this._model.getCanCloseContents();
    }

    public boolean isSplitMode() {
        return this._model.getSideTool();
    }

    public void setSplitMode(boolean split, @Nullable Runnable runnable) {
    }

    @NotNull
    public ActionCallback getReady(@NotNull Object requestor) {
        Intrinsics.checkNotNullParameter((Object)requestor, (String)"requestor");
        ActionCallback actionCallback = ActionCallback.DONE;
        Intrinsics.checkNotNullExpressionValue((Object)actionCallback, (String)"DONE");
        return actionCallback;
    }

    public boolean isVisible() {
        return InterfacesKt.valueOrDefault((IOptProperty)this._model.getState(), (Object)BeToolWindowState.Hidden) != BeToolWindowState.Hidden;
    }

    public boolean isActive() {
        return this.isVisible() && (Boolean)ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendToolWindow.isActive$lambda$0(this)) != false;
    }

    public void activate(@Nullable Runnable runnable, boolean autoFocusContents, boolean forced) {
        ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendToolWindow.activate$lambda$0(this, runnable, autoFocusContents));
    }

    public void show(@Nullable Runnable runnable) {
        ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendToolWindow.show$lambda$0(this));
        this.callLater(runnable);
    }

    public void hide(@Nullable Runnable runnable) {
        ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendToolWindow.hide$lambda$0(this));
        this.callLater(runnable);
    }

    public void remove() {
        ClientId.Companion.withClientId(this.session.getClientId(), () -> BackendToolWindow.remove$lambda$0(this));
    }

    public boolean isAutoHide() {
        return false;
    }

    public void setAutoHide(boolean value) {
    }

    @NotNull
    public ToolWindowType getType() {
        return ToolWindowType.DOCKED;
    }

    public void setType(@NotNull ToolWindowType type, @Nullable Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
    }

    @NotNull
    public ToolWindowType getInternalType() {
        return ToolWindowType.DOCKED;
    }

    @Nullable
    public Icon getIcon() {
        return this._icon;
    }

    public void setIcon(@NotNull Icon icon2) {
        Intrinsics.checkNotNullParameter((Object)icon2, (String)"icon");
        if (!Intrinsics.areEqual((Object)icon2, (Object)this._icon)) {
            this._icon = icon2;
            this._iconModel = null;
        }
    }

    @Nullable
    public final IconModel getIconModel() {
        if (this._iconModel == null && this._icon != null) {
            Icon icon2 = this._icon;
            this._iconModel = icon2 != null ? UtilKt.toModel((Icon)icon2) : null;
        }
        return this._iconModel;
    }

    @Nullable
    public String getTitle() {
        Content content = this.getContentManager().getSelectedContent();
        return content != null ? content.getDisplayName() : null;
    }

    public void setTitle(@Nullable String title) {
    }

    @NotNull
    public String getStripeTitle() {
        return (String)this._model.getTitle().getText().getValue();
    }

    @NotNull
    public Supplier<String> getStripeTitleProvider() {
        return () -> BackendToolWindow.getStripeTitleProvider$lambda$0(this);
    }

    public void setStripeTitle(@NotNull String title) {
        Intrinsics.checkNotNullParameter((Object)title, (String)"title");
    }

    public void setStripeTitleProvider(@NotNull Supplier<String> title) {
        Intrinsics.checkNotNullParameter(title, (String)"title");
    }

    public boolean isAvailable() {
        return this._available;
    }

    public void setAvailable(boolean value) {
        this.setAvailable(value, null);
    }

    public void setAvailable(boolean value, @Nullable Runnable runnable) {
        if (this._available != value) {
            this._available = value;
            if (!value) {
                this.getToolWindowManager().hideToolWindow(this.getId(), false);
            }
        }
        this.callLater(runnable);
    }

    public void setContentUiType(@NotNull ToolWindowContentUiType type, @Nullable Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
    }

    public void setDefaultContentUiType(@NotNull ToolWindowContentUiType type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
    }

    @NotNull
    public ToolWindowContentUiType getContentUiType() {
        ToolWindowContentUiType toolWindowContentUiType = ToolWindowContentUiType.TABBED;
        Intrinsics.checkNotNullExpressionValue((Object)toolWindowContentUiType, (String)"TABBED");
        return toolWindowContentUiType;
    }

    public void installWatcher(@NotNull ContentManager contentManager) {
        Intrinsics.checkNotNullParameter((Object)contentManager, (String)"contentManager");
        ContentManagerWatcher.watchContentManager((ToolWindow)((ToolWindow)this), (ContentManager)contentManager);
    }

    public void addContentManagerListener(@NotNull ContentManagerListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this._contentManager.addContentManagerListener(listener2);
    }

    public void setDefaultState(@Nullable ToolWindowAnchor anchor, @Nullable ToolWindowType type, @Nullable Rectangle floatingBounds) {
    }

    public void setToHideOnEmptyContent(boolean hideOnEmpty) {
    }

    public boolean isShowStripeButton() {
        ToolWindow toolWindow = this.getToolWindowManager().getHostToolWindow(this.getId());
        return toolWindow != null ? toolWindow.isShowStripeButton() : true;
    }

    public void setShowStripeButton(boolean value) {
    }

    public void showContentPopup(@NotNull InputEvent inputEvent) {
        Intrinsics.checkNotNullParameter((Object)inputEvent, (String)"inputEvent");
    }

    public void setTitleActions(@NotNull List<? extends AnAction> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
        this.titleActions = actions;
    }

    public void stretchWidth(int value) {
    }

    public void stretchHeight(int value) {
    }

    public void setAdditionalGearActions(@Nullable ActionGroup additionalGearActions) {
        this.additionalGearActions = additionalGearActions;
    }

    @NotNull
    public final DefaultActionGroup getWestActionGroup$intellij_platform_backend_split() {
        return this.westActionGroup;
    }

    public void setTabActions(AnAction ... actions) {
        Intrinsics.checkNotNullParameter((Object)actions, (String)"actions");
        this.westActionGroup.removeAll();
        this.westActionGroup.addAll(Arrays.copyOf(actions, actions.length));
    }

    public void setTabDoubleClickActions(@NotNull List<AnAction> actions) {
        Intrinsics.checkNotNullParameter(actions, (String)"actions");
    }

    private final void callLater(Runnable runnable) {
        if (runnable != null) {
            ApplicationManager.getApplication().invokeLater(runnable);
        }
    }

    private static final Unit init$lambda$0(BackendToolWindow this$0) {
        this$0.setAvailable(this$0.toolWindowFactory.shouldBeAvailable(this$0.getProject()));
        this$0.toolWindowFactory.init((ToolWindow)this$0);
        CoroutineScopeKt.cancelOnDispose((Job)BuildersKt.launch$default((CoroutineScope)this$0.lifetime.getCoroutineScope(), (CoroutineContext)((CoroutineContext)ClientIdKt.asContextElement((ClientId)this$0.session.getClientId())), null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this$0, null){
            int label;
            final /* synthetic */ BackendToolWindow this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = BackendToolWindow.access$getToolWindowFactory$p(this.this$0).manage((ToolWindow)this.this$0, (ToolWindowManager)BackendToolWindow.access$getToolWindowManager(this.this$0), (Continuation)this);
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)2, null), (Disposable)this$0.getDisposable());
        return Unit.INSTANCE;
    }

    private static final Unit createContentIfNeeded$lambda$0(BackendToolWindow this$0) {
        this$0.toolWindowFactory.createToolWindowContent(this$0.getProject(), (ToolWindow)this$0);
        return Unit.INSTANCE;
    }

    private static final boolean isActive$lambda$0(BackendToolWindow this$0) {
        return this$0.getToolWindowManager().isActiveToolWindow(this$0.getId());
    }

    private static final Unit activate$lambda$0(BackendToolWindow this$0, Runnable $runnable, boolean $autoFocusContents) {
        ToolWindowManagerImpl.activateToolWindow$default((ToolWindowManagerImpl)this$0.getToolWindowManager(), (String)this$0.getId(), (Runnable)$runnable, (boolean)$autoFocusContents, null, (int)8, null);
        return Unit.INSTANCE;
    }

    private static final Unit show$lambda$0(BackendToolWindow this$0) {
        this$0.getToolWindowManager().showToolWindow(this$0.getId());
        return Unit.INSTANCE;
    }

    private static final Unit hide$lambda$0(BackendToolWindow this$0) {
        this$0.getToolWindowManager().hideToolWindow(this$0.getId(), false);
        return Unit.INSTANCE;
    }

    private static final Unit remove$lambda$0(BackendToolWindow this$0) {
        this$0.getToolWindowManager().unregisterToolWindow(this$0.getId());
        return Unit.INSTANCE;
    }

    private static final String getStripeTitleProvider$lambda$0(BackendToolWindow this$0) {
        return this$0.getStripeTitle();
    }

    public static final /* synthetic */ ToolWindowFactory access$getToolWindowFactory$p(BackendToolWindow $this) {
        return $this.toolWindowFactory;
    }

    public static final /* synthetic */ BackendServerToolWindowManager access$getToolWindowManager(BackendToolWindow $this) {
        return $this.getToolWindowManager();
    }
}

