/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.toolWindow;

import com.intellij.openapi.wm.impl.content.SingleContentSupplier;
import com.intellij.ui.tabs.TabInfo;
import com.intellij.ui.tabs.TabsListener;
import com.jetbrains.ide.model.uiautomation.SingleContentSupplierTabsModel;
import com.jetbrains.ide.model.uiautomation.TabInfoModel;
import com.jetbrains.rd.framework.IRdEndpoint;
import com.jetbrains.rd.util.reactive.IProperty;
import com.jetbrains.rdserver.toolWindow.SingleContentSupplierUtilsKt;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\b\u0002\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\n2\b\u0010\u000f\u001a\u0004\u0018\u00010\nH\u0016J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\nH\u0016J\b\u0010\u0012\u001a\u00020\rH\u0016J\b\u0010\u0013\u001a\u00020\rH\u0002J\u0010\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0015\u001a\u00020\nH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lcom/jetbrains/rdserver/toolWindow/SupplierTabsListener;", "Lcom/intellij/ui/tabs/TabsListener;", "supplier", "Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;", "tabsModel", "Lcom/jetbrains/ide/model/uiautomation/SingleContentSupplierTabsModel;", "<init>", "(Lcom/intellij/openapi/wm/impl/content/SingleContentSupplier;Lcom/jetbrains/ide/model/uiautomation/SingleContentSupplierTabsModel;)V", "infoToModel", "", "Lcom/intellij/ui/tabs/TabInfo;", "Lcom/jetbrains/ide/model/uiautomation/TabInfoModel;", "selectionChanged", "", "oldSelection", "newSelection", "tabRemoved", "tabToRemove", "tabsMoved", "updateTabs", "removeTab", "tabInfo", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nSingleContentSupplierUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SingleContentSupplierUtils.kt\ncom/jetbrains/rdserver/toolWindow/SupplierTabsListener\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,124:1\n1#2:125\n*E\n"})
final class SupplierTabsListener
implements TabsListener {
    @NotNull
    private final SingleContentSupplier supplier;
    @NotNull
    private final SingleContentSupplierTabsModel tabsModel;
    @NotNull
    private final Map<TabInfo, TabInfoModel> infoToModel;

    public SupplierTabsListener(@NotNull SingleContentSupplier supplier, @NotNull SingleContentSupplierTabsModel tabsModel) {
        Intrinsics.checkNotNullParameter((Object)supplier, (String)"supplier");
        Intrinsics.checkNotNullParameter((Object)tabsModel, (String)"tabsModel");
        this.supplier = supplier;
        this.tabsModel = tabsModel;
        this.infoToModel = new LinkedHashMap();
        this.tabsModel.getTabs().clear();
        this.updateTabs();
        IRdEndpoint.DefaultImpls.set$default((IRdEndpoint)((IRdEndpoint)this.tabsModel.getRequestFocusChange()), null, null, arg_0 -> SupplierTabsListener._init_$lambda$0(this, arg_0), (int)3, null);
    }

    /*
     * WARNING - void declaration
     */
    public void selectionChanged(@Nullable TabInfo oldSelection, @Nullable TabInfo newSelection) {
        TabInfoModel tabInfoModel;
        this.updateTabs();
        IProperty iProperty = this.tabsModel.getSelectedTab();
        TabInfo tabInfo = newSelection;
        if (tabInfo != null) {
            void it;
            TabInfo tabInfo2 = tabInfo;
            IProperty iProperty2 = iProperty;
            boolean bl = false;
            tabInfoModel = this.infoToModel.get(it);
            iProperty = iProperty2;
        } else {
            tabInfoModel = null;
        }
        iProperty.set(tabInfoModel);
    }

    public void tabRemoved(@NotNull TabInfo tabToRemove) {
        Intrinsics.checkNotNullParameter((Object)tabToRemove, (String)"tabToRemove");
        this.removeTab(tabToRemove);
    }

    public void tabsMoved() {
    }

    private final void updateTabs() {
        Set unprocessedEntries = CollectionsKt.toMutableSet((Iterable)this.infoToModel.keySet());
        List list = this.supplier.getTabs().getTabs();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getTabs(...)");
        List allTabInfos = list;
        int n = allTabInfos.size();
        for (int tabIndex = 0; tabIndex < n; ++tabIndex) {
            TabInfo tabInfo = (TabInfo)allTabInfos.get(tabIndex);
            if (!this.infoToModel.containsKey(tabInfo)) {
                Intrinsics.checkNotNull((Object)tabInfo);
                TabInfoModel supplierTabModel = SingleContentSupplierUtilsKt.access$createSupplierTab(tabInfo);
                this.infoToModel.put(tabInfo, supplierTabModel);
                this.tabsModel.getTabs().add(tabIndex, (Object)supplierTabModel);
            }
            unprocessedEntries.remove(tabInfo);
        }
        for (TabInfo missingTab : unprocessedEntries) {
            this.removeTab(missingTab);
        }
    }

    private final void removeTab(TabInfo tabInfo) {
        block0: {
            TabInfoModel tabInfoModel = this.infoToModel.remove(tabInfo);
            if (tabInfoModel == null) break block0;
            TabInfoModel it = tabInfoModel;
            boolean bl = false;
            this.tabsModel.getTabs().remove((Object)it);
        }
    }

    private static final Unit _init_$lambda$0(SupplierTabsListener this$0, TabInfoModel supplierTab) {
        for (Map.Entry<TabInfo, TabInfoModel> pair : this$0.infoToModel.entrySet()) {
            if (!Intrinsics.areEqual((Object)pair.getValue(), (Object)supplierTab)) continue;
            this$0.supplier.getTabs().select(pair.getKey(), true);
            break;
        }
        return Unit.INSTANCE;
    }
}

