/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters;

import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.diagnostic.Logger;
import com.jetbrains.rd.util.lifetime.Lifetime;
import com.jetbrains.rd.util.lifetime.LifetimeDefinition;
import com.jetbrains.rd.util.lifetime.RLifetimeKt;
import com.jetbrains.rdserver.ui.converters.ComponentChildrenTracker;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001BB\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012!\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\u0004\b\r\u0010\u000eJ\b\u0010\u0016\u001a\u00020\fH\u0002J\b\u0010\u0017\u001a\u00020\fH\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R,\u0010\b\u001a\u001d\u0012\u0013\u0012\u00110\u0005\u00a2\u0006\f\b\n\u0012\b\b\u000b\u0012\u0004\b\b(\u0004\u0012\u0004\u0012\u00020\f0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/jetbrains/rdserver/ui/converters/ComponentChildrenTracker;", "", "component", "Ljava/awt/Container;", "lifetime", "Lcom/jetbrains/rd/util/lifetime/Lifetime;", "initialBuilderLifetime", "Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;", "builder", "Lkotlin/Function1;", "Lkotlin/ParameterName;", "name", "", "<init>", "(Ljava/awt/Container;Lcom/jetbrains/rd/util/lifetime/Lifetime;Lcom/jetbrains/rd/util/lifetime/LifetimeDefinition;Lkotlin/jvm/functions/Function1;)V", "getLifetime", "()Lcom/jetbrains/rd/util/lifetime/Lifetime;", "getBuilder", "()Lkotlin/jvm/functions/Function1;", "updateScheduled", "", "builderLifetime", "scheduleRebuild", "rebuildComponent", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nJPanelConverter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JPanelConverter.kt\ncom/jetbrains/rdserver/ui/converters/ComponentChildrenTracker\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,772:1\n13#2:773\n14060#3,2:774\n14060#3,2:776\n*S KotlinDebug\n*F\n+ 1 JPanelConverter.kt\ncom/jetbrains/rdserver/ui/converters/ComponentChildrenTracker\n*L\n764#1:773\n736#1:774,2\n740#1:776,2\n*E\n"})
final class ComponentChildrenTracker {
    @NotNull
    private final Lifetime lifetime;
    @NotNull
    private final Function1<Lifetime, Unit> builder;
    private boolean updateScheduled;
    @NotNull
    private LifetimeDefinition builderLifetime;

    public ComponentChildrenTracker(@NotNull Container component, @NotNull Lifetime lifetime, @NotNull LifetimeDefinition initialBuilderLifetime, @NotNull Function1<? super Lifetime, Unit> builder) {
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)lifetime, (String)"lifetime");
        Intrinsics.checkNotNullParameter((Object)initialBuilderLifetime, (String)"initialBuilderLifetime");
        Intrinsics.checkNotNullParameter(builder, (String)"builder");
        this.lifetime = lifetime;
        this.builder = builder;
        this.builderLifetime = initialBuilderLifetime;
        ComponentAdapter childComponentListener2 = new ComponentAdapter(this){
            final /* synthetic */ ComponentChildrenTracker this$0;
            {
                this.this$0 = $receiver;
            }

            public void componentShown(ComponentEvent e) {
                ComponentChildrenTracker.access$scheduleRebuild(this.this$0);
            }

            public void componentHidden(ComponentEvent e) {
                ComponentChildrenTracker.access$scheduleRebuild(this.this$0);
            }
        };
        ContainerListener containerListener2 = new ContainerListener(childComponentListener2, this){
            final /* synthetic */ childComponentListener.1 $childComponentListener;
            final /* synthetic */ ComponentChildrenTracker this$0;
            {
                this.$childComponentListener = $childComponentListener;
                this.this$0 = $receiver;
            }

            public void componentAdded(ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component child = e.getChild();
                if (child instanceof JComponent && ((JComponent)child).getClientProperty("BE_CONTROLS_SUBSTITUTED_MARKER") != null) {
                    return;
                }
                Component component = child;
                if (component != null) {
                    component.addComponentListener(this.$childComponentListener);
                }
                ComponentChildrenTracker.access$scheduleRebuild(this.this$0);
            }

            public void componentRemoved(ContainerEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                Component child = e.getChild();
                if (child instanceof JComponent && ((JComponent)child).getClientProperty("BE_CONTROLS_SUBSTITUTED_MARKER") != null) {
                    return;
                }
                Component component = child;
                if (component != null) {
                    component.removeComponentListener(this.$childComponentListener);
                }
                ComponentChildrenTracker.access$scheduleRebuild(this.this$0);
            }
        };
        this.lifetime.bracketIfAlive(() -> ComponentChildrenTracker._init_$lambda$0(component, containerListener2, childComponentListener2), () -> ComponentChildrenTracker._init_$lambda$1(component, containerListener2, childComponentListener2));
    }

    @NotNull
    public final Lifetime getLifetime() {
        return this.lifetime;
    }

    @NotNull
    public final Function1<Lifetime, Unit> getBuilder() {
        return this.builder;
    }

    private final void scheduleRebuild() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        if (this.updateScheduled) {
            return;
        }
        this.updateScheduled = true;
        ActionsKt.invokeLater$default(null, () -> ComponentChildrenTracker.scheduleRebuild$lambda$0(this), (int)1, null);
    }

    private final void rebuildComponent() {
        if (RLifetimeKt.isNotAlive((Lifetime)this.lifetime)) {
            return;
        }
        LifetimeDefinition oldLifetime = this.builderLifetime;
        try {
            oldLifetime.terminate(true);
        }
        catch (Throwable t) {
            boolean $i$f$logger = false;
            Logger logger = Logger.getInstance(ComponentChildrenTracker.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
            logger.error(t);
        }
        this.builderLifetime = this.lifetime.createNested();
        this.builder.invoke((Object)this.builderLifetime);
    }

    private static final Unit _init_$lambda$0(Container $component, containerListener.1 $containerListener, childComponentListener.1 $childComponentListener) {
        $component.addContainerListener($containerListener);
        Component[] componentArray = $component.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            it.addComponentListener($childComponentListener);
        }
        return Unit.INSTANCE;
    }

    private static final Unit _init_$lambda$1(Container $component, containerListener.1 $containerListener, childComponentListener.1 $childComponentListener) {
        $component.removeContainerListener($containerListener);
        Component[] componentArray = $component.getComponents();
        Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
        Object[] $this$forEach$iv = componentArray;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Component it = (Component)element$iv;
            boolean bl = false;
            it.removeComponentListener($childComponentListener);
        }
        return Unit.INSTANCE;
    }

    private static final Unit scheduleRebuild$lambda$0(ComponentChildrenTracker this$0) {
        this$0.updateScheduled = false;
        this$0.rebuildComponent();
        return Unit.INSTANCE;
    }

    public static final /* synthetic */ void access$scheduleRebuild(ComponentChildrenTracker $this) {
        $this.scheduleRebuild();
    }
}

