/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.rdserver.ui.converters.utils;

import com.intellij.codeInsight.codeVision.ui.popup.layouter.RectangleUtilsKt;
import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.editor.impl.EditorComponentImpl;
import com.intellij.ui.ClickListener;
import com.intellij.ui.border.IdeaTitledBorder;
import com.intellij.ui.border.NamedBorder;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.ide.model.uiautomation.BeAbstractBorder;
import com.jetbrains.ide.model.uiautomation.BeAbstractText;
import com.jetbrains.ide.model.uiautomation.BeControl;
import com.jetbrains.ide.model.uiautomation.BeLabel;
import com.jetbrains.ide.model.uiautomation.BeMargin;
import com.jetbrains.ide.model.uiautomation.BeRichText;
import com.jetbrains.ide.model.uiautomation.BeTitledBorder;
import com.jetbrains.ide.model.uiautomation.ControlVisibility;
import com.jetbrains.rd.ui.bedsl.dsl.BeDslStyleKt;
import com.jetbrains.rd.ui.bedsl.dsl.util.BeMarginsBuilder;
import com.jetbrains.rd.ui.bedsl.util.BeUtil;
import com.jetbrains.rdserver.ProtocolConversionsKt;
import com.jetbrains.rdserver.options.BackendRemoteSettingsHost;
import com.jetbrains.rdserver.ui.converters.BeConversionContext;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.plaf.UIResource;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001c\u0010\u0004\u001a\u00020\u0005*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nJ\u0014\u0010\u000b\u001a\u00020\n*\u00020\f2\b\b\u0002\u0010\t\u001a\u00020\nJ\n\u0010\r\u001a\u00020\u000e*\u00020\u000fJ\u0012\u0010\u0010\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0011\u001a\u00020\u000fJ\n\u0010\u0012\u001a\u00020\u0013*\u00020\u000fJ\n\u0010\u0014\u001a\u00020\u0015*\u00020\u0016J\u0014\u0010\u0017\u001a\u00020\u000e*\u00020\f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u001a\u0010\u001a\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J\f\u0010\u001b\u001a\u00020\u000e*\u00020\u0019H\u0002J\u001a\u0010\u001c\u001a\u00020\u0006*\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019J3\u0010\u001d\u001a\u00020\u0005*\u00020\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00162\n\b\u0002\u0010 \u001a\u0004\u0018\u00010!2\b\b\u0002\u0010\"\u001a\u00020#H\u0000\u00a2\u0006\u0002\b$J \u0010%\u001a\u00020\u0016*\u00020\u001e2\n\b\u0001\u0010\u001f\u001a\u0004\u0018\u00010\u00162\u0006\u0010\"\u001a\u00020#H\u0002J\u0015\u0010&\u001a\u0004\u0018\u00010!*\u0004\u0018\u00010!H\u0000\u00a2\u0006\u0002\b'J\u0011\u0010(\u001a\u00020\u0016*\u00020\u0006H\u0000\u00a2\u0006\u0002\b)J#\u0010*\u001a\u00020\u0005*\u00020\b2\u0006\u0010+\u001a\u00020#2\b\u0010,\u001a\u0004\u0018\u00010-H\u0000\u00a2\u0006\u0002\b.J\u0017\u0010/\u001a\u00020\u000e2\b\u0010\u0007\u001a\u0004\u0018\u00010\fH\u0000\u00a2\u0006\u0002\b0J\u0015\u00101\u001a\u00020\u000e2\u0006\u00102\u001a\u000203H\u0000\u00a2\u0006\u0002\b4\u00a8\u00065"}, d2={"Lcom/jetbrains/rdserver/ui/converters/utils/ComponentConverterUtil;", "", "<init>", "()V", "initDefaultProperties", "", "Lcom/jetbrains/ide/model/uiautomation/BeControl;", "component", "Ljavax/swing/JComponent;", "invisibleState", "Lcom/jetbrains/ide/model/uiautomation/ControlVisibility;", "getControlVisibility", "Ljava/awt/Component;", "isEmpty", "", "Ljava/awt/Insets;", "withMargin", "insets", "toBeMargin", "Lcom/jetbrains/ide/model/uiautomation/BeMargin;", "toBeLabel", "Lcom/jetbrains/ide/model/uiautomation/BeLabel;", "", "doNotConvertBorder", "conversionContext", "Lcom/jetbrains/rdserver/ui/converters/BeConversionContext;", "withBorder", "shouldConvertSizeConstraints", "withSizeConstraints", "setTextFrom", "Lcom/jetbrains/ide/model/uiautomation/BeAbstractText;", "text", "currentForeground", "Ljava/awt/Color;", "mnemonicIndex", "", "setTextFrom$intellij_platform_backend_split", "processMnemonic", "getCustomForeground", "getCustomForeground$intellij_platform_backend_split", "getControlOrDataId", "getControlOrDataId$intellij_platform_backend_split", "sendSyntheticClick", "clickCount", "bounds", "Ljava/awt/Rectangle;", "sendSyntheticClick$intellij_platform_backend_split", "isComponentInModalWindowLikeContext", "isComponentInModalWindowLikeContext$intellij_platform_backend_split", "isWindowOrItsAncestorModal", "window", "Ljava/awt/Window;", "isWindowOrItsAncestorModal$intellij_platform_backend_split", "intellij.platform.backend.split"})
@SourceDebugExtension(value={"SMAP\nComponentConverterUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ComponentConverterUtil.kt\ncom/jetbrains/rdserver/ui/converters/utils/ComponentConverterUtil\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 KtUtils.kt\ncom/intellij/util/KotlinUtils\n*L\n1#1,190:1\n1#2:191\n34#3:192\n*S KotlinDebug\n*F\n+ 1 ComponentConverterUtil.kt\ncom/jetbrains/rdserver/ui/converters/utils/ComponentConverterUtil\n*L\n147#1:192\n*E\n"})
public final class ComponentConverterUtil {
    @NotNull
    public static final ComponentConverterUtil INSTANCE = new ComponentConverterUtil();

    private ComponentConverterUtil() {
    }

    public final void initDefaultProperties(@NotNull BeControl $this$initDefaultProperties, @NotNull JComponent component, @NotNull ControlVisibility invisibleState) {
        Intrinsics.checkNotNullParameter((Object)$this$initDefaultProperties, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)invisibleState, (String)"invisibleState");
        $this$initDefaultProperties.getVisible().set((Object)this.getControlVisibility(component, invisibleState));
        $this$initDefaultProperties.getEnabled().set((Object)component.isEnabled());
        $this$initDefaultProperties.getFocusable().set((Object)component.isFocusable());
        $this$initDefaultProperties.getTooltip().set((Object)component.getToolTipText());
    }

    public static /* synthetic */ void initDefaultProperties$default(ComponentConverterUtil componentConverterUtil, BeControl beControl, JComponent jComponent, ControlVisibility controlVisibility, int n, Object object) {
        if ((n & 2) != 0) {
            controlVisibility = ControlVisibility.Hidden;
        }
        componentConverterUtil.initDefaultProperties(beControl, jComponent, controlVisibility);
    }

    @NotNull
    public final ControlVisibility getControlVisibility(@NotNull Component $this$getControlVisibility, @NotNull ControlVisibility invisibleState) {
        Intrinsics.checkNotNullParameter((Object)$this$getControlVisibility, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)invisibleState, (String)"invisibleState");
        return $this$getControlVisibility.isVisible() ? ControlVisibility.Visible : invisibleState;
    }

    public static /* synthetic */ ControlVisibility getControlVisibility$default(ComponentConverterUtil componentConverterUtil, Component component, ControlVisibility controlVisibility, int n, Object object) {
        if ((n & 1) != 0) {
            controlVisibility = ControlVisibility.Hidden;
        }
        return componentConverterUtil.getControlVisibility(component, controlVisibility);
    }

    public final boolean isEmpty(@NotNull Insets $this$isEmpty) {
        Intrinsics.checkNotNullParameter((Object)$this$isEmpty, (String)"<this>");
        return $this$isEmpty.left == 0 && $this$isEmpty.top == 0 && $this$isEmpty.right == 0 && $this$isEmpty.bottom == 0;
    }

    @NotNull
    public final BeControl withMargin(@NotNull BeControl $this$withMargin, @NotNull Insets insets) {
        Intrinsics.checkNotNullParameter((Object)$this$withMargin, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)insets, (String)"insets");
        if (this.isEmpty(insets)) {
            return $this$withMargin;
        }
        return BeDslStyleKt.withMargin((BeControl)$this$withMargin, (BeMargin)(insets instanceof JBInsets ? BeMarginsBuilder.Companion.margin(BeUtil.Companion.descale(insets.left), BeUtil.Companion.descale(insets.top), BeUtil.Companion.descale(insets.right), BeUtil.Companion.descale(insets.bottom)) : BeMarginsBuilder.Companion.margin(insets.left, insets.top, insets.right, insets.bottom)));
    }

    @NotNull
    public final BeMargin toBeMargin(@NotNull Insets $this$toBeMargin) {
        Intrinsics.checkNotNullParameter((Object)$this$toBeMargin, (String)"<this>");
        return BeMarginsBuilder.Companion.margin($this$toBeMargin.left, $this$toBeMargin.top, $this$toBeMargin.right, $this$toBeMargin.bottom);
    }

    @NotNull
    public final BeLabel toBeLabel(@NotNull String $this$toBeLabel) {
        BeLabel beLabel;
        Intrinsics.checkNotNullParameter((Object)$this$toBeLabel, (String)"<this>");
        BeLabel it = beLabel = new BeLabel(false);
        boolean bl = false;
        it.getText().set((Object)$this$toBeLabel);
        return beLabel;
    }

    private final boolean doNotConvertBorder(Component $this$doNotConvertBorder, BeConversionContext conversionContext) {
        Component component = $this$doNotConvertBorder;
        if (component instanceof ActionToolbar) {
            return true;
        }
        if (component instanceof EditorComponentImpl) {
            return true;
        }
        if (component instanceof JTree) {
            return conversionContext == BeConversionContext.SCROLL_PANE;
        }
        return !$this$doNotConvertBorder.isVisible() && conversionContext == BeConversionContext.TREE_GRID;
    }

    @NotNull
    public final BeControl withBorder(@NotNull BeControl $this$withBorder, @NotNull JComponent component, @NotNull BeConversionContext conversionContext) {
        BeControl beControl;
        Intrinsics.checkNotNullParameter((Object)$this$withBorder, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)conversionContext), (String)"conversionContext");
        if (this.doNotConvertBorder(component, conversionContext)) {
            return $this$withBorder;
        }
        Border border = component.getBorder();
        if (border == null) {
            return $this$withBorder;
        }
        Border border2 = border;
        Border border3 = border2;
        if (border3 instanceof IdeaTitledBorder) {
            String string = ((IdeaTitledBorder)border2).getTitle();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getTitle(...)");
            int n = ((IdeaTitledBorder)border2).getInsideInsets().left;
            Insets insets = ((IdeaTitledBorder)border2).getOutsideInsets();
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getOutsideInsets(...)");
            beControl = BeDslStyleKt.withBorder((BeControl)$this$withBorder, (BeAbstractBorder)((BeAbstractBorder)new BeTitledBorder(string, n, this.toBeMargin(insets))));
        } else if (border3 instanceof NamedBorder) {
            if (Intrinsics.areEqual((Object)((NamedBorder)border2).getName(), (Object)JBUI.CurrentTheme.StatusBar.Widget.borderName()) || Intrinsics.areEqual((Object)((NamedBorder)border2).getName(), (Object)JBUI.CurrentTheme.StatusBar.Widget.iconBorderName())) {
                beControl = $this$withBorder;
            } else {
                Insets insets = border2.getBorderInsets(component);
                Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getBorderInsets(...)");
                beControl = this.withMargin($this$withBorder, insets);
            }
        } else {
            Insets insets = border2.getBorderInsets(component);
            Intrinsics.checkNotNullExpressionValue((Object)insets, (String)"getBorderInsets(...)");
            beControl = this.withMargin($this$withBorder, insets);
        }
        return beControl;
    }

    private final boolean shouldConvertSizeConstraints(BeConversionContext $this$shouldConvertSizeConstraints) {
        return switch (WhenMappings.$EnumSwitchMapping$0[$this$shouldConvertSizeConstraints.ordinal()]) {
            case 1 -> true;
            case 2 -> true;
            default -> false;
        };
    }

    @NotNull
    public final BeControl withSizeConstraints(@NotNull BeControl $this$withSizeConstraints, @NotNull JComponent component, @NotNull BeConversionContext conversionContext) {
        Intrinsics.checkNotNullParameter((Object)$this$withSizeConstraints, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        Intrinsics.checkNotNullParameter((Object)((Object)conversionContext), (String)"conversionContext");
        if (!this.shouldConvertSizeConstraints(conversionContext)) {
            return $this$withSizeConstraints;
        }
        BeControl control = $this$withSizeConstraints;
        if (component.isPreferredSizeSet()) {
            Dimension dimension = component.getPreferredSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getPreferredSize(...)");
            if (ComponentConverterUtil.withSizeConstraints$isNotEmpty(dimension)) {
                control = BeDslStyleKt.withPreferredSize((BeControl)control, (int)component.getPreferredSize().width, (int)component.getPreferredSize().height);
            }
        }
        if (component.isMaximumSizeSet()) {
            Dimension dimension = component.getMaximumSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMaximumSize(...)");
            if (ComponentConverterUtil.withSizeConstraints$isNotEmpty(dimension)) {
                control = BeDslStyleKt.withMaxSize((BeControl)control, (int)component.getMaximumSize().width, (int)component.getMaximumSize().height);
            }
        }
        if (component.isMinimumSizeSet()) {
            Dimension dimension = component.getMinimumSize();
            Intrinsics.checkNotNullExpressionValue((Object)dimension, (String)"getMinimumSize(...)");
            if (ComponentConverterUtil.withSizeConstraints$isNotEmpty(dimension)) {
                control = BeDslStyleKt.withMinSize((BeControl)control, (int)component.getMinimumSize().width, (int)component.getMinimumSize().height);
            }
        }
        return control;
    }

    public final void setTextFrom$intellij_platform_backend_split(@NotNull BeAbstractText $this$setTextFrom, @Nls @Nullable String text, @Nullable Color currentForeground, int mnemonicIndex) {
        Intrinsics.checkNotNullParameter((Object)$this$setTextFrom, (String)"<this>");
        String plainText = this.processMnemonic($this$setTextFrom, text, mnemonicIndex);
        BeAbstractText beAbstractText = $this$setTextFrom;
        if (beAbstractText instanceof BeRichText) {
            ((BeRichText)$this$setTextFrom).getText().set((Object)ProtocolConversionsKt.toRichText(plainText, this.getCustomForeground$intellij_platform_backend_split(currentForeground)));
        } else if (beAbstractText instanceof BeLabel) {
            ((BeLabel)$this$setTextFrom).getText().set((Object)plainText);
        }
    }

    public static /* synthetic */ void setTextFrom$intellij_platform_backend_split$default(ComponentConverterUtil componentConverterUtil, BeAbstractText beAbstractText, String string, Color color, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            color = null;
        }
        if ((n2 & 4) != 0) {
            n = -1;
        }
        componentConverterUtil.setTextFrom$intellij_platform_backend_split(beAbstractText, string, color, n);
    }

    private final String processMnemonic(BeAbstractText $this$processMnemonic, @Nls String text, int mnemonicIndex) {
        String string;
        String proposedText;
        String string2 = text;
        if (string2 == null) {
            string2 = "";
        }
        if (StringsKt.startsWith((String)(proposedText = string2), (String)"<html>", (boolean)true)) {
            return proposedText;
        }
        int m22 = mnemonicIndex;
        boolean bl = false;
        int index = m22 < 0 ? UIUtil.getDisplayMnemonicIndex((String)proposedText) : m22;
        String m22 = proposedText;
        boolean condition$iv = mnemonicIndex >= 0;
        boolean $i$f$applyIf = false;
        if (condition$iv) {
            void $this$processMnemonic_u24lambda_u241 = $this$applyIf$iv;
            boolean bl2 = false;
            String string3 = UIUtil.removeMnemonic((String)proposedText);
            string = string3;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"removeMnemonic(...)");
        } else {
            string = $this$applyIf$iv;
        }
        void plainText = string;
        $this$processMnemonic.getShortcutIndex().set((Object)index);
        return plainText;
    }

    @Nullable
    public final Color getCustomForeground$intellij_platform_backend_split(@Nullable Color $this$getCustomForeground) {
        Color color = $this$getCustomForeground;
        if (color instanceof UIResource) {
            return null;
        }
        return color;
    }

    @NotNull
    public final String getControlOrDataId$intellij_platform_backend_split(@NotNull BeControl $this$getControlOrDataId) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$getControlOrDataId, (String)"<this>");
        CharSequence charSequence = (CharSequence)$this$getControlOrDataId.getControlId().getValue();
        if (charSequence.length() == 0) {
            boolean bl = false;
            object = (Integer)$this$getControlOrDataId.getDataId().getValueOrNull();
            if (object == null || (object = String.valueOf((Integer)object)) == null) {
                object = "";
            }
        } else {
            object = charSequence;
        }
        return (String)object;
    }

    public final void sendSyntheticClick$intellij_platform_backend_split(@NotNull JComponent $this$sendSyntheticClick, int clickCount, @Nullable Rectangle bounds) {
        Intrinsics.checkNotNullParameter((Object)$this$sendSyntheticClick, (String)"<this>");
        Cloneable cloneable = bounds;
        if (cloneable == null || (cloneable = RectangleUtilsKt.getCenter((Rectangle)cloneable)) == null) {
            cloneable = new Point();
        }
        Cloneable point = cloneable;
        ClickListener.SyntheticClickEvent inputEvent = new ClickListener.SyntheticClickEvent((Component)$this$sendSyntheticClick, System.currentTimeMillis(), 1024, ((Point)point).x, ((Point)point).y, clickCount, false, 1);
        IdeEventQueue.Companion.getInstance().dispatchEvent((AWTEvent)inputEvent);
    }

    public final boolean isComponentInModalWindowLikeContext$intellij_platform_backend_split(@Nullable Component component) {
        boolean bl;
        if (component == null) {
            return false;
        }
        Window window = SwingUtilities.getWindowAncestor(component);
        if (window != null) {
            Object object;
            Object object2;
            Window windowAncestor = window;
            boolean bl2 = false;
            bl = INSTANCE.isWindowOrItsAncestorModal$intellij_platform_backend_split(windowAncestor) || ((object2 = windowAncestor instanceof RootPaneContainer ? (RootPaneContainer)((Object)windowAncestor) : null) != null && (object2 = object2.getRootPane()) != null ? Intrinsics.areEqual((Object)((JComponent)object2).getClientProperty(BackendRemoteSettingsHost.Companion.getSETTINGS_HOST_WINDOW_KEY()), (Object)true) : false) || ((object = windowAncestor instanceof RootPaneContainer ? (RootPaneContainer)((Object)windowAncestor) : null) != null && (object = object.getRootPane()) != null ? ((JComponent)object).getClientProperty("ComponentInModalWindowLikeContext") : null) != null;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean isWindowOrItsAncestorModal$intellij_platform_backend_split(@NotNull Window window) {
        Intrinsics.checkNotNullParameter((Object)window, (String)"window");
        if (window instanceof Dialog) {
            if (((Dialog)window).isModal()) return true;
        }
        Window window2 = window.getOwner();
        if (window2 == null) return false;
        Window it = window2;
        boolean bl = false;
        boolean bl2 = INSTANCE.isWindowOrItsAncestorModal$intellij_platform_backend_split(it);
        if (!bl2) return false;
        return true;
    }

    private static final boolean withSizeConstraints$isNotEmpty(Dimension $this$withSizeConstraints_u24isNotEmpty) {
        return $this$withSizeConstraints_u24isNotEmpty.width > 0 && $this$withSizeConstraints_u24isNotEmpty.height > 0;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[BeConversionContext.values().length];
            try {
                nArray[BeConversionContext.POPUP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[BeConversionContext.TREE_GRID.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

