/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.dom.model.completion.insert;

import com.intellij.codeInsight.completion.InsertHandler;
import com.intellij.codeInsight.completion.InsertionContext;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.dom.DependencyConflictId;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.generate.GenerateDependencyProvider;
import org.jetbrains.idea.maven.dom.generate.GenerateManagedDependencyAction;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.dom.model.completion.insert.MavenDependencyInsertionTrackerKt;
import org.jetbrains.idea.maven.onlinecompletion.model.MavenRepositoryArtifactInfo;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0000\u0018\u0000 \n2\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0001\nB\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/insert/MavenTopLevelDependencyInsertionHandler;", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "<init>", "()V", "handleInsert", "", "context", "Lcom/intellij/codeInsight/completion/InsertionContext;", "item", "Companion", "intellij.maven"})
public final class MavenTopLevelDependencyInsertionHandler
implements InsertHandler<LookupElement> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final InsertHandler<LookupElement> INSTANCE = new MavenTopLevelDependencyInsertionHandler();

    public void handleInsert(@NotNull InsertionContext context2, @NotNull LookupElement item) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)item, (String)"item");
        if (TemplateManager.getInstance((Project)context2.getProject()).getActiveTemplate(context2.getEditor()) != null) {
            return;
        }
        Object object = item.getObject();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getObject(...)");
        Object obj = object;
        if (!(obj instanceof MavenRepositoryArtifactInfo)) {
            return;
        }
        PsiFile psiFile = context2.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getFile(...)");
        PsiFile contextFile = psiFile;
        if (!(contextFile instanceof XmlFile)) {
            return;
        }
        Project project = context2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        MavenDomProjectModel model = MavenDomUtil.getMavenDomModel(contextFile, MavenDomProjectModel.class);
        if (model == null) {
            return;
        }
        Map<DependencyConflictId, MavenDomDependency> map = GenerateManagedDependencyAction.collectManagingDependencies(model);
        Intrinsics.checkNotNullExpressionValue(map, (String)"collectManagingDependencies(...)");
        Map<DependencyConflictId, MavenDomDependency> managedDependencies = map;
        PsiElement element = contextFile.findElementAt(context2.getStartOffset());
        if (!(element instanceof XmlText) && (element = PsiTreeUtil.getParentOfType((PsiElement)element, XmlText.class)) == null) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        Editor editor = context2.getEditor();
        Intrinsics.checkNotNullExpressionValue((Object)editor, (String)"getEditor(...)");
        MavenDomDependency dependency = GenerateDependencyProvider.Companion.createDependency(model, editor, managedDependencies, CollectionsKt.listOf((Object)obj));
        ((XmlText)element).delete();
        if (dependency != null && dependency.getXmlTag() != null) {
            CaretModel caretModel = context2.getEditor().getCaretModel();
            XmlTag xmlTag = dependency.getXmlTag();
            Intrinsics.checkNotNull((Object)xmlTag);
            caretModel.moveToOffset(xmlTag.getTextOffset());
        }
        context2.commitDocument();
        MavenDependencyInsertionTrackerKt.logMavenDependencyInsertion(context2, item, (MavenRepositoryArtifactInfo)obj);
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lorg/jetbrains/idea/maven/dom/model/completion/insert/MavenTopLevelDependencyInsertionHandler$Companion;", "", "<init>", "()V", "INSTANCE", "Lcom/intellij/codeInsight/completion/InsertHandler;", "Lcom/intellij/codeInsight/lookup/LookupElement;", "getINSTANCE", "()Lcom/intellij/codeInsight/completion/InsertHandler;", "intellij.maven"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final InsertHandler<LookupElement> getINSTANCE() {
            return INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

