/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.VersionComparatorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.execution.MavenRunConfiguration;
import org.jetbrains.idea.maven.execution.MavenRunConfigurationType;
import org.jetbrains.idea.maven.execution.MavenRunnerParameters;
import org.jetbrains.idea.maven.execution.RunnerBundle;
import org.jetbrains.idea.maven.execution.build.DelegateBuildRunner;
import org.jetbrains.idea.maven.externalSystemIntegration.output.MavenParsingContext;
import org.jetbrains.idea.maven.project.MavenGeneralSettings;
import org.jetbrains.idea.maven.project.MavenHomeType;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.StaticResolvedMavenHomeType;
import org.jetbrains.idea.maven.server.MavenDistribution;
import org.jetbrains.idea.maven.server.MavenDistributionsCache;
import org.jetbrains.idea.maven.utils.MavenUtil;

public class MavenResumeAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(MavenResumeAction.class);
    private static final Set<String> PARAMS_DISABLING_RESUME = ContainerUtil.newHashSet((Object[])new String[]{"-rf", "-resume-from", "-pl", "-projects", "-am", "-also-make", "-amd", "-also-make-dependents"});
    public static final int STATE_INITIAL = 0;
    public static final int STATE_READING_PROJECT_LIST = 1;
    public static final int STATE_READING_PROJECT_LIST_OLD_MAVEN = 5;
    public static final int STATE_WAIT_FOR_BUILD = 2;
    public static final int STATE_WAIT_FOR______ = 3;
    public static final int STATE_WTF = -1;
    private final ProgramRunner myRunner;
    private final ExecutionEnvironment myEnvironment;
    private final MavenParsingContext myContext;
    private int myState = 0;
    private int myBuildingProjectIndex = 0;
    private final List<String> myMavenProjectNames = new ArrayList<String>();
    private String myResumeFromModuleName;
    private String myResumeModuleId;
    private String myMavenVersion;

    public MavenResumeAction(ProcessHandler processHandler, ProgramRunner runner, ExecutionEnvironment environment, MavenParsingContext context2) {
        super(RunnerBundle.message("maven.resume.from.title", new Object[0]), null, AllIcons.RunConfigurations.RerunFailedTests);
        this.myRunner = runner;
        this.myEnvironment = environment;
        this.myContext = context2;
        MavenRunConfiguration runConfiguration = (MavenRunConfiguration)environment.getRunProfile();
        this.myMavenVersion = MavenResumeAction.getMavenVersion(runConfiguration);
        if (VersionComparatorUtil.compare((String)this.myMavenVersion, (String)"3.5.3") < 0 || context2 == null) {
            processHandler.addProcessListener((ProcessListener)new LegacyMavenResumeProcessAdapter(runConfiguration));
        } else {
            processHandler.addProcessListener((ProcessListener)new MavenSpyResumeProcessAdapter(runConfiguration));
        }
    }

    private static String getMavenVersion(MavenRunConfiguration runConfiguration) {
        MavenGeneralSettings generalSettings = runConfiguration.getGeneralSettings();
        if (generalSettings == null) {
            MavenDistribution maven = MavenDistributionsCache.getInstance(runConfiguration.getProject()).getMavenDistribution(runConfiguration.getRunnerParameters().getWorkingDirPath());
            return maven.getVersion();
        }
        MavenHomeType type = generalSettings.getMavenHomeType();
        if (type instanceof StaticResolvedMavenHomeType) {
            StaticResolvedMavenHomeType st = (StaticResolvedMavenHomeType)type;
            return MavenUtil.getMavenVersion(st);
        }
        return MavenDistributionsCache.getInstance(runConfiguration.getProject()).getMavenDistribution(runConfiguration.getRunnerParameters().getWorkingDirPath()).getVersion();
    }

    private static boolean hasResumeFromParameter(MavenRunnerParameters parameters) {
        List<String> goals = parameters.getGoals();
        return goals.size() > 2 && "-rf".equals(goals.get(goals.size() - 2));
    }

    @Nullable
    private MavenProject findProjectByName(@NotNull String projectName) {
        if (projectName == null) {
            MavenResumeAction.$$$reportNull$$$0(0);
        }
        List<MavenProject> projects2 = MavenProjectsManager.getInstance(this.myEnvironment.getProject()).getProjects();
        MavenProject candidate = null;
        for (MavenProject mavenProject : projects2) {
            if (!projectName.equals(mavenProject.getName())) continue;
            if (candidate == null) {
                candidate = mavenProject;
                continue;
            }
            return null;
        }
        if (candidate != null) {
            return candidate;
        }
        for (MavenProject mavenProject : projects2) {
            String id = mavenProject.getMavenId().getGroupId() + ":" + mavenProject.getMavenId().getArtifactId() + ":" + mavenProject.getPackaging();
            if (!projectName.contains(id)) continue;
            if (candidate == null) {
                candidate = mavenProject;
                continue;
            }
            return null;
        }
        if (candidate != null) {
            return candidate;
        }
        for (MavenProject mavenProject : projects2) {
            if (!projectName.equals(mavenProject.getMavenId().getArtifactId())) continue;
            if (candidate == null) {
                candidate = mavenProject;
                continue;
            }
            return null;
        }
        return candidate;
    }

    public static boolean isApplicable(@NotNull MavenRunConfiguration runConfiguration) {
        if (runConfiguration == null) {
            MavenResumeAction.$$$reportNull$$$0(1);
        }
        return MavenResumeAction.isApplicable(runConfiguration.getProject(), null, runConfiguration);
    }

    public static boolean isApplicable(@NotNull Project project, @Nullable JavaParameters javaParameters, @NotNull MavenRunConfiguration runConfiguration) {
        ArrayList<String> paramsToCheck;
        if (project == null) {
            MavenResumeAction.$$$reportNull$$$0(2);
        }
        if (runConfiguration == null) {
            MavenResumeAction.$$$reportNull$$$0(3);
        }
        if (MavenResumeAction.hasResumeFromParameter(runConfiguration.getRunnerParameters())) {
            MavenRunConfiguration clonedRunConf = runConfiguration.clone();
            ArrayList<String> clonedGoals = new ArrayList<String>(clonedRunConf.getRunnerParameters().getGoals());
            clonedGoals.remove(clonedGoals.size() - 1);
            clonedGoals.remove(clonedGoals.size() - 1);
            clonedRunConf.getRunnerParameters().setGoals(clonedGoals);
            try {
                javaParameters = clonedRunConf.createJavaParameters(project);
            }
            catch (ExecutionException e) {
                return false;
            }
        }
        if (javaParameters != null) {
            paramsToCheck = javaParameters.getProgramParametersList().getList();
        } else {
            paramsToCheck = new ArrayList<String>(runConfiguration.getRunnerParameters().getGoals());
            paramsToCheck.addAll(runConfiguration.getRunnerParameters().getOptions());
        }
        for (String params : paramsToCheck) {
            if (!PARAMS_DISABLING_RESUME.contains(params)) continue;
            return false;
        }
        return true;
    }

    private static void log(String message) {
        if (ApplicationManager.getApplication().isInternal()) {
            LOG.error(message, (Throwable)new Exception());
        } else {
            LOG.warn(message, (Throwable)new Exception());
        }
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenResumeAction.$$$reportNull$$$0(4);
        }
        if (this.myResumeFromModuleName != null && this.myResumeModuleId != null) {
            e.getPresentation().setEnabled(true);
            e.getPresentation().setText(RunnerBundle.message("maven.resume.from.template", this.myResumeFromModuleName));
        } else {
            e.getPresentation().setEnabled(false);
        }
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
        if (actionUpdateThread == null) {
            MavenResumeAction.$$$reportNull$$$0(5);
        }
        return actionUpdateThread;
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            MavenResumeAction.$$$reportNull$$$0(6);
        }
        Project project = this.myEnvironment.getProject();
        MavenRunConfiguration runConfiguration = ((MavenRunConfiguration)this.myEnvironment.getRunProfile()).clone();
        ArrayList<String> goals = new ArrayList<String>(runConfiguration.getRunnerParameters().getGoals());
        if (goals.size() > 2 && "-rf".equals(goals.get(goals.size() - 2))) {
            goals.set(goals.size() - 1, this.myResumeModuleId);
        } else {
            goals.add("-rf");
            goals.add(this.myResumeModuleId);
        }
        runConfiguration.getRunnerParameters().setGoals(goals);
        MavenRunConfigurationType.runConfiguration(runConfiguration.getProject(), runConfiguration.getRunnerParameters(), runConfiguration.getGeneralSettings(), runConfiguration.getRunnerSettings(), null, this.myRunner instanceof DelegateBuildRunner);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectName";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runConfiguration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/execution/MavenResumeAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenResumeAction";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findProjectByName";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isApplicable";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "update";
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "actionPerformed";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5 -> new IllegalStateException(string);
        };
    }

    private class LegacyMavenResumeProcessAdapter
    extends ProcessAdapter {
        private final MavenRunConfiguration myRunConfiguration;

        LegacyMavenResumeProcessAdapter(MavenRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                LegacyMavenResumeProcessAdapter.$$$reportNull$$$0(0);
            }
            if (MavenResumeAction.this.myState == -1) {
                return;
            }
            if (event.getExitCode() == 0 && MavenResumeAction.this.myBuildingProjectIndex != MavenResumeAction.this.myMavenProjectNames.size()) {
                MavenResumeAction.log(String.format("Build was success, but not all project was build. Project build order: %s, build index: %d", MavenResumeAction.this.myMavenProjectNames, MavenResumeAction.this.myBuildingProjectIndex));
            }
            if (event.getExitCode() == 1 && MavenResumeAction.this.myBuildingProjectIndex > 0) {
                if (MavenResumeAction.this.myBuildingProjectIndex == 1 && !MavenResumeAction.hasResumeFromParameter(this.myRunConfiguration.getRunnerParameters())) {
                    return;
                }
                MavenResumeAction.this.myResumeFromModuleName = MavenResumeAction.this.myMavenProjectNames.get(MavenResumeAction.this.myBuildingProjectIndex - 1);
                MavenProject mavenProject = MavenResumeAction.this.findProjectByName(MavenResumeAction.this.myResumeFromModuleName);
                if (mavenProject != null) {
                    MavenResumeAction.this.myResumeModuleId = mavenProject.getMavenId().getGroupId() + ":" + mavenProject.getMavenId().getArtifactId();
                }
            }
        }

        public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
            if (event == null) {
                LegacyMavenResumeProcessAdapter.$$$reportNull$$$0(1);
            }
            if (outputType == null) {
                LegacyMavenResumeProcessAdapter.$$$reportNull$$$0(2);
            }
            if (outputType != ProcessOutputTypes.STDOUT) {
                return;
            }
            String text = event.getText().trim();
            if (text.isEmpty()) {
                return;
            }
            String textWithoutInfo = "";
            if (text.startsWith("[INFO] ")) {
                textWithoutInfo = text.substring("[INFO] ".length()).trim();
            }
            switch (MavenResumeAction.this.myState) {
                case 0: {
                    if (textWithoutInfo.equals("Reactor build order:")) {
                        MavenResumeAction.this.myState = 5;
                        break;
                    }
                    if (!textWithoutInfo.equals("Reactor Build Order:")) break;
                    MavenResumeAction.this.myState = 1;
                    break;
                }
                case 1: {
                    if (textWithoutInfo.equals("------------------------------------------------------------------------")) {
                        MavenResumeAction.this.myState = 2;
                        break;
                    }
                    if (!textWithoutInfo.isEmpty()) {
                        MavenResumeAction.this.myMavenProjectNames.add(textWithoutInfo);
                        break;
                    }
                    if (MavenResumeAction.this.myMavenProjectNames.isEmpty()) break;
                    MavenResumeAction.this.myState = 3;
                    break;
                }
                case 5: {
                    if (textWithoutInfo.isEmpty()) break;
                    if (text.startsWith("[INFO]   ")) {
                        MavenResumeAction.this.myMavenProjectNames.add(textWithoutInfo);
                        break;
                    }
                    MavenResumeAction.this.myState = 2;
                    break;
                }
                case 2: {
                    if (textWithoutInfo.startsWith("Building ")) {
                        String projectName = textWithoutInfo.substring("Building ".length());
                        if (MavenResumeAction.this.myBuildingProjectIndex >= MavenResumeAction.this.myMavenProjectNames.size() || !projectName.startsWith(MavenResumeAction.this.myMavenProjectNames.get(MavenResumeAction.this.myBuildingProjectIndex))) {
                            MavenResumeAction.this.myState = -1;
                            MavenResumeAction.log(String.format("Invalid project building order. Defined order: %s, error index: %d, invalid line: %s", MavenResumeAction.this.myMavenProjectNames, MavenResumeAction.this.myBuildingProjectIndex, text));
                            break;
                        }
                        ++MavenResumeAction.this.myBuildingProjectIndex;
                    }
                    MavenResumeAction.this.myState = 3;
                    break;
                }
                case 3: {
                    if (!textWithoutInfo.equals("------------------------------------------------------------------------")) break;
                    MavenResumeAction.this.myState = 2;
                    break;
                }
                case -1: {
                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "outputType";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/execution/MavenResumeAction$LegacyMavenResumeProcessAdapter";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processTerminated";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "onTextAvailable";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MavenSpyResumeProcessAdapter
    extends ProcessAdapter {
        private final MavenRunConfiguration myRunConfiguration;

        MavenSpyResumeProcessAdapter(MavenRunConfiguration runConfiguration) {
            this.myRunConfiguration = runConfiguration;
        }

        public void processTerminated(@NotNull ProcessEvent event) {
            if (event == null) {
                MavenSpyResumeProcessAdapter.$$$reportNull$$$0(0);
            }
            MavenResumeAction.this.myContext.getStartedProjects();
            if (event.getExitCode() == 0 && !MavenResumeAction.this.myContext.getStartedProjects().isEmpty() && MavenResumeAction.this.myContext.getProjectsInReactor().size() != MavenResumeAction.this.myContext.getStartedProjects().size()) {
                MavenResumeAction.log(String.format("Build was success, but not all project was build. Project build order: %s, built projects: %s", MavenResumeAction.this.myContext.getProjectsInReactor(), MavenResumeAction.this.myContext.getStartedProjects()));
            }
            if (event.getExitCode() != 0) {
                if (MavenResumeAction.this.myContext.getStartedProjects().isEmpty()) {
                    return;
                }
                if (MavenResumeAction.this.myContext.getStartedProjects().size() == 1 && !MavenResumeAction.hasResumeFromParameter(this.myRunConfiguration.getRunnerParameters())) {
                    return;
                }
                MavenResumeAction.this.myResumeModuleId = MavenResumeAction.this.myContext.getStartedProjects().get(MavenResumeAction.this.myContext.getStartedProjects().size() - 1);
                String[] splitted = MavenResumeAction.this.myResumeModuleId.split(":");
                MavenResumeAction.this.myResumeFromModuleName = splitted.length < 2 ? MavenResumeAction.this.myResumeModuleId : splitted[1];
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "org/jetbrains/idea/maven/execution/MavenResumeAction$MavenSpyResumeProcessAdapter", "processTerminated"));
        }
    }
}

