/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.tasks;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAwareRunnable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.DisposableWrapperList;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.update.MergingQueueUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectChanges;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.tasks.MavenKeymapExtension;
import org.jetbrains.idea.maven.utils.MavenMergingUpdateQueue;
import org.jetbrains.idea.maven.utils.MavenUtil;

public final class MavenShortcutsManager
implements Disposable {
    private final Project myProject;
    static final String ACTION_ID_PREFIX = "Maven_";
    private final AtomicBoolean isInitialized;
    private final DisposableWrapperList<Listener> myListeners;

    @NotNull
    public static MavenShortcutsManager getInstance(Project project) {
        MavenShortcutsManager mavenShortcutsManager = (MavenShortcutsManager)project.getService(MavenShortcutsManager.class);
        if (mavenShortcutsManager == null) {
            MavenShortcutsManager.$$$reportNull$$$0(0);
        }
        return mavenShortcutsManager;
    }

    @Nullable
    public static MavenShortcutsManager getInstanceIfCreated(@NotNull Project project) {
        if (project == null) {
            MavenShortcutsManager.$$$reportNull$$$0(1);
        }
        return (MavenShortcutsManager)project.getServiceIfCreated(MavenShortcutsManager.class);
    }

    public MavenShortcutsManager(@NotNull Project project) {
        if (project == null) {
            MavenShortcutsManager.$$$reportNull$$$0(2);
        }
        this.isInitialized = new AtomicBoolean();
        this.myListeners = new DisposableWrapperList();
        this.myProject = project;
        if (MavenUtil.isMavenUnitTestModeEnabled() || ApplicationManager.getApplication().isHeadlessEnvironment()) {
            return;
        }
        MavenUtil.runWhenInitialized(this.myProject, (Runnable)((DumbAwareRunnable)() -> this.doInit(project)));
    }

    @VisibleForTesting
    public void doInit(@NotNull Project project) {
        if (project == null) {
            MavenShortcutsManager.$$$reportNull$$$0(3);
        }
        if (this.isInitialized.getAndSet(true)) {
            return;
        }
        MyProjectsTreeListener listener2 = new MyProjectsTreeListener();
        MavenProjectsManager mavenProjectManager = MavenProjectsManager.getInstance(project);
        mavenProjectManager.addManagerListener(listener2, this);
        mavenProjectManager.addProjectsTreeListener(listener2, this);
        MessageBusConnection busConnection = ApplicationManager.getApplication().getMessageBus().connect((Disposable)this);
        busConnection.subscribe(KeymapManagerListener.TOPIC, (Object)new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                MavenShortcutsManager.this.fireShortcutsUpdated();
            }

            public void shortcutsChanged(@NotNull Keymap keymap, @NonNls @NotNull Collection<String> actionIds, boolean fromSettings) {
                if (keymap == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (actionIds == null) {
                    1.$$$reportNull$$$0(1);
                }
                MavenShortcutsManager.this.fireShortcutsUpdated();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[0] = "keymap";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[0] = "actionIds";
                        break;
                    }
                }
                objectArray[1] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager$1";
                objectArray[2] = "shortcutsChanged";
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    public void dispose() {
        if (!this.isInitialized.getAndSet(false)) {
            return;
        }
        MavenKeymapExtension.clearActions(this.myProject);
        this.myListeners.clear();
    }

    @NotNull
    public String getActionId(@Nullable String projectPath, @Nullable String goal) {
        StringBuilder result = new StringBuilder(ACTION_ID_PREFIX);
        result.append(this.myProject.getLocationHash());
        if (projectPath != null) {
            String portablePath = FileUtil.toSystemIndependentName((String)projectPath);
            result.append(Path.of(portablePath, new String[0]).getParent().getFileName());
            result.append(Integer.toHexString(portablePath.hashCode()));
            if (goal != null) {
                result.append(goal);
            }
        }
        String string = result.toString();
        if (string == null) {
            MavenShortcutsManager.$$$reportNull$$$0(4);
        }
        return string;
    }

    public String getDescription(MavenProject project, String goal) {
        Shortcut[] shortcuts = this.getShortcuts(project, goal);
        if (shortcuts.length == 0) {
            return "";
        }
        return KeymapUtil.getShortcutsText((Shortcut[])shortcuts);
    }

    boolean hasShortcuts() {
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        return ContainerUtil.exists((Object[])activeKeymap.getActionIds(), id -> id.startsWith(ACTION_ID_PREFIX));
    }

    boolean hasShortcuts(MavenProject project, String goal) {
        return this.getShortcuts(project, goal).length > 0;
    }

    private Shortcut @NotNull [] getShortcuts(MavenProject project, String goal) {
        String actionId = this.getActionId(project.getPath(), goal);
        Keymap activeKeymap = KeymapManager.getInstance().getActiveKeymap();
        Shortcut[] shortcutArray = activeKeymap.getShortcuts(actionId);
        if (shortcutArray == null) {
            MavenShortcutsManager.$$$reportNull$$$0(5);
        }
        return shortcutArray;
    }

    private void fireShortcutsUpdated() {
        for (Listener listener2 : this.myListeners) {
            listener2.shortcutsUpdated();
        }
    }

    public void addListener(@NotNull Listener l, @NotNull Disposable disposable) {
        if (l == null) {
            MavenShortcutsManager.$$$reportNull$$$0(6);
        }
        if (disposable == null) {
            MavenShortcutsManager.$$$reportNull$$$0(7);
        }
        this.myListeners.add((Object)l, disposable);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 6, 7 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "l";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "disposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getShortcuts";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstanceIfCreated";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doInit";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 6, 7 -> new IllegalArgumentException(string);
        };
    }

    private final class MyProjectsTreeListener
    implements MavenProjectsManager.Listener,
    MavenProjectsTree.Listener {
        private final Map<MavenProject, Boolean> mySheduledProjects = new HashMap<MavenProject, Boolean>();
        private final MergingUpdateQueue myUpdateQueue = new MavenMergingUpdateQueue("MavenShortcutsManager: Keymap Update", 500, true, MavenShortcutsManager.this).usePassThroughInUnitTestMode();

        private MyProjectsTreeListener() {
        }

        @Override
        public void activated() {
            this.scheduleKeymapUpdate(MavenProjectsManager.getInstance(MavenShortcutsManager.this.myProject).getNonIgnoredProjects(), true);
        }

        @Override
        public void projectsIgnoredStateChanged(@NotNull List<MavenProject> ignored, @NotNull List<MavenProject> unignored, boolean fromImport) {
            if (ignored == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(0);
            }
            if (unignored == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(1);
            }
            this.scheduleKeymapUpdate(unignored, true);
            this.scheduleKeymapUpdate(ignored, false);
        }

        @Override
        public void projectsUpdated(@NotNull List<? extends Pair<MavenProject, MavenProjectChanges>> updated, @NotNull List<MavenProject> deleted) {
            if (updated == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(2);
            }
            if (deleted == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(3);
            }
            this.scheduleKeymapUpdate(MavenUtil.collectFirsts(updated), true);
            this.scheduleKeymapUpdate(deleted, false);
        }

        @Override
        public void projectResolved(@NotNull Pair<MavenProject, MavenProjectChanges> projectWithChanges) {
            if (projectWithChanges == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(4);
            }
            this.scheduleKeymapUpdate(Collections.singletonList((MavenProject)projectWithChanges.first), true);
        }

        @Override
        public void pluginsResolved(@NotNull MavenProject project) {
            if (project == null) {
                MyProjectsTreeListener.$$$reportNull$$$0(5);
            }
            this.scheduleKeymapUpdate(Collections.singletonList(project), true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void scheduleKeymapUpdate(List<MavenProject> mavenProjects, boolean forUpdate) {
            Map<MavenProject, Boolean> map = this.mySheduledProjects;
            synchronized (map) {
                for (MavenProject each : mavenProjects) {
                    this.mySheduledProjects.put(each, forUpdate);
                }
            }
            MergingQueueUtil.queueTracked((MergingUpdateQueue)this.myUpdateQueue, (Update)new Update(MavenShortcutsManager.this){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    List<MavenProject> projectToDelete;
                    List<MavenProject> projectToUpdate;
                    Map<MavenProject, Boolean> map = MyProjectsTreeListener.this.mySheduledProjects;
                    synchronized (map) {
                        projectToUpdate = MyProjectsTreeListener.this.selectScheduledProjects(true);
                        projectToDelete = MyProjectsTreeListener.this.selectScheduledProjects(false);
                        MyProjectsTreeListener.this.mySheduledProjects.clear();
                    }
                    if (!MavenShortcutsManager.this.myProject.isDisposed()) {
                        MavenKeymapExtension.clearActions(MavenShortcutsManager.this.myProject, projectToDelete);
                        MavenKeymapExtension.updateActions(MavenShortcutsManager.this.myProject, projectToUpdate);
                    }
                }
            });
        }

        private List<MavenProject> selectScheduledProjects(boolean forUpdate) {
            return ContainerUtil.mapNotNull(this.mySheduledProjects.entrySet(), eachEntry -> forUpdate == (Boolean)eachEntry.getValue() ? (MavenProject)eachEntry.getKey() : null);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unignored";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "updated";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "deleted";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "projectWithChanges";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
            }
            objectArray2[1] = "org/jetbrains/idea/maven/tasks/MavenShortcutsManager$MyProjectsTreeListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsIgnoredStateChanged";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectsUpdated";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "projectResolved";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "pluginsResolved";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    @FunctionalInterface
    public static interface Listener {
        public void shortcutsUpdated();
    }
}

