/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.db2.generator.producers;

import com.intellij.database.dialects.base.generator.ScriptingContext;
import com.intellij.database.dialects.base.generator.producers.CreateProducer;
import com.intellij.database.dialects.base.generator.producers.CreateTable;
import com.intellij.database.dialects.base.generator.producers.ProducerUtilsKt;
import com.intellij.database.dialects.db2.generator.producers.Db2TableProducersKt;
import com.intellij.database.dialects.db2.model.Db2Index;
import com.intellij.database.dialects.db2.model.Db2Table;
import com.intellij.database.dialects.db2.model.Db2TableColumn;
import com.intellij.database.dialects.db2.model.properties.Db2RctCheck;
import com.intellij.database.dialects.db2.model.properties.Db2TableClustering;
import com.intellij.database.model.basic.BasicTable;
import com.intellij.database.model.meta.BasicMetaId;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\b\u0010\u000e\u001a\u00020\tH\u0014J\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0010\u0010\u0012\u001a\u00020\t*\u00060\u0013R\u00020\u0004H\u0002\u00a8\u0006\u0014"}, d2={"Lcom/intellij/database/dialects/db2/generator/producers/Db2CreateTable;", "Lcom/intellij/database/dialects/base/generator/producers/CreateTable;", "Lcom/intellij/database/dialects/db2/model/Db2Table;", "context", "Lcom/intellij/database/dialects/base/generator/ScriptingContext;", "element", "<init>", "(Lcom/intellij/database/dialects/base/generator/ScriptingContext;Lcom/intellij/database/dialects/db2/model/Db2Table;)V", "produceComment", "", "exists", "", "comment", "", "produceFooter", "isConditional", "id", "Lcom/intellij/database/model/meta/BasicMetaId;", "produceOrganizeByClause", "Lcom/intellij/database/dialects/base/generator/ScriptingContext$NewCodingAdapter;", "intellij.database.dialects.db2"})
@SourceDebugExtension(value={"SMAP\nDb2TableProducers.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Db2TableProducers.kt\ncom/intellij/database/dialects/db2/generator/producers/Db2CreateTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,161:1\n1642#2,10:162\n1915#2:172\n1916#2:174\n1652#2:175\n1#3:173\n1#3:176\n*S KotlinDebug\n*F\n+ 1 Db2TableProducers.kt\ncom/intellij/database/dialects/db2/generator/producers/Db2CreateTable\n*L\n95#1:162,10\n95#1:172\n95#1:174\n95#1:175\n95#1:173\n*E\n"})
public final class Db2CreateTable
extends CreateTable<Db2Table> {
    public Db2CreateTable(@NotNull ScriptingContext context, @NotNull Db2Table element) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        super(context, (BasicTable)element);
    }

    public void produceComment(boolean exists, @Nullable String comment) {
        ProducerUtilsKt.commentStatement$default((CreateProducer)((CreateProducer)this), (String)"table", (String)comment, null, (int)4, null);
    }

    protected void produceFooter() {
        this.sqlClause(arg_0 -> Db2CreateTable.produceFooter$lambda$0(this, arg_0));
    }

    public boolean isConditional(@NotNull BasicMetaId id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        BasicMetaId basicMetaId = id;
        return Intrinsics.areEqual((Object)basicMetaId, Db2Table.CLUSTERING_INDEX_NAMES) ? true : (Intrinsics.areEqual((Object)basicMetaId, Db2Table.PAGE_FREE_PERCENTAGE) ? true : (Intrinsics.areEqual((Object)basicMetaId, Db2Table.RCT_CHECK) ? true : super.isConditional(id)));
    }

    /*
     * WARNING - void declaration
     */
    private final void produceOrganizeByClause(ScriptingContext.NewCodingAdapter $this$produceOrganizeByClause) {
        void $this$mapNotNullTo$iv$iv;
        if (((Db2Table)this.getElement()).isColumnOrganized()) {
            $this$produceOrganizeByClause.unaryPlus((CharSequence)"organize by column");
            return;
        }
        Db2TableClustering db2TableClustering = ((Db2Table)this.getElement()).getClustering();
        if (db2TableClustering == null) {
            return;
        }
        Db2TableClustering clustering = db2TableClustering;
        $this$produceOrganizeByClause.unaryPlus((CharSequence)"organize by");
        List<String> list = ((Db2Table)this.getElement()).getClusteringIndexNames();
        Intrinsics.checkNotNullExpressionValue(list, (String)"getClusteringIndexNames(...)");
        Iterable $this$mapNotNull$iv = list;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            Db2Index it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            String it = (String)element$iv$iv;
            boolean bl2 = false;
            if ((Db2Index)((Db2Table)this.getElement()).getIndices().get(it) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        List clusteringIndices = (List)destination$iv$iv;
        switch (WhenMappings.$EnumSwitchMapping$1[clustering.ordinal()]) {
            case 1: {
                ScriptingContext.NewCodingAdapter newCodingAdapter = $this$produceOrganizeByClause.unaryPlus((CharSequence)"insert time");
                break;
            }
            case 2: {
                ScriptingContext.NewCodingAdapter newCodingAdapter = $this$produceOrganizeByClause.unaryPlus((CharSequence)CollectionsKt.joinToString$default((Iterable)clusteringIndices, null, (CharSequence)"dimensions (", (CharSequence)")", (int)0, null, Db2CreateTable::produceOrganizeByClause$lambda$1, (int)25, null));
                break;
            }
            case 3: {
                Object object = (Db2Index)CollectionsKt.singleOrNull((List)clusteringIndices);
                if (object == null || (object = object.getColNames()) == null) {
                    object = CollectionsKt.emptyList();
                }
                Object clusteringColumnNames = object;
                $this$produceOrganizeByClause.unaryPlus((CharSequence)CollectionsKt.joinToString$default((Iterable)((Iterable)clusteringColumnNames), null, (CharSequence)"key sequence (", (CharSequence)")", (int)0, null, arg_0 -> Db2CreateTable.produceOrganizeByClause$lambda$2(this, arg_0), (int)25, null));
                Db2RctCheck db2RctCheck = ((Db2Table)this.getElement()).getRCTCheck();
                switch (db2RctCheck == null ? -1 : WhenMappings.$EnumSwitchMapping$0[db2RctCheck.ordinal()]) {
                    case 1: {
                        Unit unit = $this$produceOrganizeByClause.unaryPlus((CharSequence)"disallow overflow");
                        break;
                    }
                    case 2: {
                        Unit unit = $this$produceOrganizeByClause.unaryPlus((CharSequence)"allow overflow");
                        break;
                    }
                    default: {
                        Unit unit = Unit.INSTANCE;
                    }
                }
                if (((Db2Table)this.getElement()).getPageFreePercentage() > 0) {
                    $this$produceOrganizeByClause.unaryPlus((CharSequence)("pctfree " + ((Db2Table)this.getElement()).getPageFreePercentage()));
                }
                ScriptingContext.NewCodingAdapter newCodingAdapter = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
    }

    private static final Unit produceFooter$lambda$0(Db2CreateTable this$0, ScriptingContext.NewCodingAdapter $this$sqlClause) {
        Intrinsics.checkNotNullParameter((Object)$this$sqlClause, (String)"$this$sqlClause");
        Db2TableProducersKt.access$produceDistributeByClause($this$sqlClause, (Db2Table)this$0.getElement());
        this$0.produceOrganizeByClause($this$sqlClause);
        return Unit.INSTANCE;
    }

    private static final CharSequence produceOrganizeByClause$lambda$1(Db2Index index) {
        Intrinsics.checkNotNullParameter((Object)index, (String)"index");
        List list = index.getColNames();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getColNames(...)");
        List colNames = list;
        String string = (String)CollectionsKt.singleOrNull((List)colNames);
        return string != null ? (CharSequence)string : (CharSequence)CollectionsKt.joinToString$default((Iterable)colNames, null, (CharSequence)"(", (CharSequence)")", (int)0, null, null, (int)57, null);
    }

    private static final CharSequence produceOrganizeByClause$lambda$2(Db2CreateTable this$0, String columnName) {
        Object object;
        Object lowerBound;
        block10: {
            block9: {
                Db2TableColumn column;
                block8: {
                    Object object2;
                    block7: {
                        BigInteger bigInteger;
                        Db2TableColumn db2TableColumn = (Db2TableColumn)((Db2Table)this$0.getElement()).getColumns().get(columnName);
                        if (db2TableColumn == null) {
                            return "???";
                        }
                        column = db2TableColumn;
                        object2 = column.getRCTLowerBound();
                        if (object2 == null) break block7;
                        BigInteger it = bigInteger = object2;
                        boolean bl = false;
                        object2 = !Intrinsics.areEqual((Object)it, (Object)BigInteger.ONE) ? bigInteger : null;
                        if (object2 == null) break block7;
                        Object it2 = object2;
                        boolean bl2 = false;
                        String string = " starting from " + (BigInteger)it2;
                        object2 = string;
                        if (string != null) break block8;
                    }
                    object2 = lowerBound = "";
                }
                if ((object = column.getRCTUpperBound()) == null) break block9;
                BigInteger it = object;
                boolean bl = false;
                String string = " ending at " + it;
                object = string;
                if (string != null) break block10;
            }
            object = "";
        }
        Object upperBound = object;
        return columnName + (String)lowerBound + (String)upperBound;
    }

    @Metadata(mv={2, 3, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Db2RctCheck.values().length];
            try {
                nArray[Db2RctCheck.DISALLOW_OVERFLOW.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Db2RctCheck.ALLOW_OVERFLOW.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[Db2TableClustering.values().length];
            try {
                nArray[Db2TableClustering.BY_INSERT_TIME.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Db2TableClustering.BY_DIMENSIONS.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[Db2TableClustering.BY_RANGE.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

