/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects.derby.model;

import com.intellij.database.DatabaseBundle;
import com.intellij.database.dataSource.DataSourceConfigurable;
import com.intellij.database.dataSource.DatabaseDriver;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dataSource.url.JdbcUrlParser;
import com.intellij.database.dataSource.url.JdbcUrlParserUtil;
import com.intellij.database.dataSource.url.StatelessJdbcUrlParser;
import com.intellij.database.dataSource.url.template.UrlEditorModel;
import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.database.dataSource.validation.DatabaseConfigValidator;
import com.intellij.database.dataSource.validation.FixWithProgress;
import com.intellij.database.dialects.derby.model.DerbyConfigValidator;
import com.intellij.database.view.ui.ActualConfigInfoProvider;
import com.intellij.database.view.ui.DatabaseConfigEditor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.NioPathUtil;
import com.intellij.util.Consumer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00020\u0006H\u0016J2\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00022\u000e\u0010\f\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000e0\r2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/intellij/database/dialects/derby/model/DerbyConfigValidator;", "Lcom/intellij/database/dataSource/validation/DatabaseConfigValidator;", "Lcom/intellij/database/dataSource/LocalDataSource;", "<init>", "()V", "getTargetClass", "Ljava/lang/Class;", "collectProblems", "", "project", "Lcom/intellij/openapi/project/Project;", "target", "problems", "Lcom/intellij/util/Consumer;", "Lcom/intellij/database/dataSource/validation/DataSourceProblem;", "configInfoProvider", "Lcom/intellij/database/view/ui/ActualConfigInfoProvider;", "intellij.database.dialects.derby.ex"})
@SourceDebugExtension(value={"SMAP\nDerbyConfigValidator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DerbyConfigValidator.kt\ncom/intellij/database/dialects/derby/model/DerbyConfigValidator\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,65:1\n1#2:66\n*E\n"})
public final class DerbyConfigValidator
extends DatabaseConfigValidator<LocalDataSource> {
    @NotNull
    public Class<LocalDataSource> getTargetClass() {
        return LocalDataSource.class;
    }

    public void collectProblems(@NotNull Project project, @NotNull LocalDataSource target, @NotNull Consumer<? super DataSourceProblem> problems, @Nullable ActualConfigInfoProvider configInfoProvider) {
        JdbcUrlParser jdbcUrlParser;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(problems, (String)"problems");
        if (!target.getDbms().isDerby()) {
            return;
        }
        String string = target.getUrl();
        if (string == null) {
            return;
        }
        String url = string;
        DatabaseDriver databaseDriver = target.getDatabaseDriver();
        if (databaseDriver == null) {
            return;
        }
        DatabaseDriver driver = databaseDriver;
        StatelessJdbcUrlParser statelessJdbcUrlParser = JdbcUrlParserUtil.select((Collection)driver.getJDBCUrlParsers(), (String)url);
        if (statelessJdbcUrlParser == null) {
            return;
        }
        StatelessJdbcUrlParser parser = statelessJdbcUrlParser;
        JdbcUrlParser $this$collectProblems_u24lambda_u240 = jdbcUrlParser = parser.createStateful();
        boolean bl = false;
        $this$collectProblems_u24lambda_u240.setUrlText(url);
        JdbcUrlParser jdbcUrlParser2 = jdbcUrlParser;
        Intrinsics.checkNotNullExpressionValue((Object)jdbcUrlParser2, (String)"apply(...)");
        JdbcUrlParser sparser = jdbcUrlParser2;
        Object object = sparser.getParameter("path");
        if (object == null || (object = NioPathUtil.toNioPathOrNull((String)object)) == null) {
            return;
        }
        Object path = object;
        String string2 = sparser.getParameter("create database");
        if (string2 == null) {
            return;
        }
        boolean createFlag = Boolean.parseBoolean(string2);
        if (createFlag) {
            LinkOption[] linkOptionArray = new LinkOption[]{};
            if (Files.exists((Path)path, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
                String string3 = DatabaseBundle.message((String)"derby.existing.path.fix.create.flag", (Object[])new Object[0]);
                DataSourceProblem hint2 = new DataSourceProblem((Object)this, null, DataSourceProblem.Level.WARNING, new DataSourceProblem.HyperText(DatabaseBundle.message((String)"derby.notification.title", (Object[])new Object[0]), DatabaseBundle.message((String)"derby.existing.path.notification.description", (Object[])new Object[0]), DatabaseBundle.message((String)"derby.existing.path.notification.description", (Object[])new Object[0]), new Object[0]), new FixWithProgress(target, string3){
                    final /* synthetic */ LocalDataSource $target;
                    {
                        this.$target = $target;
                        super($super_call_param$1);
                    }

                    public void run(ProgressIndicator indicator, DatabaseConfigEditor editor) {
                        Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                        ApplicationManager.getApplication().invokeAndWait(() -> collectProblems.hint.1.run$lambda$0(editor, this.$target));
                    }

                    private static final void run$lambda$0(DatabaseConfigEditor $editor, LocalDataSource $target) {
                        if ($editor == null) {
                            return;
                        }
                        DataSourceConfigurable dataSourceConfigurable = (DataSourceConfigurable)$editor.getConfigurable((Object)$target, true, DataSourceConfigurable.class);
                        if (dataSourceConfigurable == null) {
                            return;
                        }
                        DataSourceConfigurable configurable = dataSourceConfigurable;
                        UrlEditorModel urlEditorModel = configurable.getUrlEditor().getEditorModel();
                        Intrinsics.checkNotNullExpressionValue((Object)urlEditorModel, (String)"getEditorModel(...)");
                        UrlEditorModel model = urlEditorModel;
                        model.setParameter("create database", "");
                        model.commit((Object)true);
                        $editor.onDataSourceUpdated($target);
                    }
                });
                problems.consume((Object)hint2);
            }
        }
    }
}

