/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.snowflake.refactoring;

import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.sql.dialects.snowflake.SFlakeDialect;
import com.intellij.sql.psi.SqlCodeFragment;
import com.intellij.sql.psi.SqlCompositeElementTypes;
import com.intellij.sql.psi.impl.SqlPsiUtilKt;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionHelper;
import com.intellij.sql.refactoring.extractFunction.SqlExtractFunctionInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u000b\u001a\u0004\u0018\u00010\u00062\b\u0010\f\u001a\u0004\u0018\u00010\u0006H\u0016J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00062\u0006\u0010\f\u001a\u00020\u00062\u0006\u0010\u000e\u001a\u00020\u0006H\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u0010\u0015\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0014R\u0018\u0010\u0004\u001a\u00020\u0005*\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0007R\u0014\u0010\b\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0016"}, d2={"Lcom/intellij/sql/dialects/snowflake/refactoring/SFlakeExtractFunctionHelper;", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionHelper;", "<init>", "()V", "isInjectedExpression", "", "Lcom/intellij/psi/PsiElement;", "(Lcom/intellij/psi/PsiElement;)Z", "supportsTableFunctions", "getSupportsTableFunctions", "()Z", "findTopmostBlock", "element", "findAnchor", "container", "generateBody", "", "builder", "Lcom/intellij/database/util/DdlBuilder;", "functionInfo", "Lcom/intellij/sql/refactoring/extractFunction/SqlExtractFunctionInfo;", "generateTableCallExpression", "intellij.database.dialects.snowflake"})
public final class SFlakeExtractFunctionHelper
extends SqlExtractFunctionHelper {
    @NotNull
    public static final SFlakeExtractFunctionHelper INSTANCE = new SFlakeExtractFunctionHelper();

    private SFlakeExtractFunctionHelper() {
    }

    private final boolean isInjectedExpression(PsiElement $this$isInjectedExpression) {
        PsiFile file = $this$isInjectedExpression.getContainingFile();
        return file instanceof SqlCodeFragment && Intrinsics.areEqual((Object)((SqlCodeFragment)file).getElementType(), (Object)SqlCompositeElementTypes.SQL_EVALUABLE_EXPRESSION);
    }

    public boolean getSupportsTableFunctions() {
        return true;
    }

    @Nullable
    public PsiElement findTopmostBlock(@Nullable PsiElement element) {
        PsiElement psiElement = element;
        if (psiElement == null || (psiElement = psiElement.getContainingFile()) == null) {
            return null;
        }
        PsiElement containingFile = psiElement;
        if (this.isInjectedExpression(element)) {
            PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)containingFile.getProject()).getInjectionHost(containingFile);
            if (psiLanguageInjectionHost == null) {
                return null;
            }
            PsiLanguageInjectionHost host = psiLanguageInjectionHost;
            return SqlPsiUtilKt.getSqlDialect((PsiElement)((PsiElement)host)) instanceof SFlakeDialect ? this.findTopmostBlock((PsiElement)host) : null;
        }
        return containingFile;
    }

    @Nullable
    public PsiElement findAnchor(@NotNull PsiElement element, @NotNull PsiElement container) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)container, (String)"container");
        if (!this.isInjectedExpression(element)) {
            return super.findAnchor(element, container);
        }
        PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
        if (psiLanguageInjectionHost == null) {
            return null;
        }
        PsiLanguageInjectionHost host = psiLanguageInjectionHost;
        return this.findAnchor((PsiElement)host, container);
    }

    public void generateBody(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        DdlBuilder $this$generateBody_u24lambda_u240 = builder;
        boolean bl = false;
        $this$generateBody_u24lambda_u240.keyword("as ");
        $this$generateBody_u24lambda_u240.symbol("'");
        if (functionInfo.getCodeInfo().isTableFunction() && !functionInfo.getCodeInfo().isQuery()) {
            $this$generateBody_u24lambda_u240.keyword("select ").symbol("*").keyword(" from ");
        }
        $this$generateBody_u24lambda_u240.plain(StringUtil.escapeChar((String)functionInfo.getSubstitutedExpression().getText(), (char)'\''));
        $this$generateBody_u24lambda_u240.symbol("'");
    }

    protected void generateTableCallExpression(@NotNull DdlBuilder builder, @NotNull SqlExtractFunctionInfo functionInfo) {
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)functionInfo, (String)"functionInfo");
        builder.keyword("table");
        builder.symbol("(");
        this.generateCallExpression(builder, functionInfo);
        builder.symbol(")");
    }
}

