/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.internal.statistic.beans.MetricEvent;
import com.intellij.internal.statistic.beans.MetricEventUtilKt;
import com.intellij.internal.statistic.eventLog.EventLogGroup;
import com.intellij.internal.statistic.eventLog.events.EventField;
import com.intellij.internal.statistic.eventLog.events.EventFields;
import com.intellij.internal.statistic.eventLog.events.EventId1;
import com.intellij.internal.statistic.eventLog.events.EventPair;
import com.intellij.internal.statistic.eventLog.events.StringEventField;
import com.intellij.internal.statistic.eventLog.events.VarargEventId;
import com.intellij.internal.statistic.service.fus.collectors.ApplicationUsagesCollector;
import com.intellij.refactoring.JavaRefactoringSettings;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@NonNls
public final class JavaRefactoringUsageCollector
extends ApplicationUsagesCollector {
    private static final EventLogGroup GROUP = new EventLogGroup("java.refactoring.settings", 7);
    private static final VarargEventId RENAME_SEARCH_IN_COMMENTS_FOR_FIELD = GROUP.registerVarargEvent("rename.search.in.comments.for.field", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_IN_COMMENTS_FOR_METHOD = GROUP.registerVarargEvent("rename.search.in.comments.for.method", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_IN_COMMENTS_FOR_CLASS = GROUP.registerVarargEvent("rename.search.in.comments.for.class", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE = GROUP.registerVarargEvent("rename.search.in.comments.for.package", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE = GROUP.registerVarargEvent("rename.search.in.comments.for.variable", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_FOR_TEXT_FOR_FIELD = GROUP.registerVarargEvent("rename.search.for.text.for.field", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_FOR_TEXT_FOR_METHOD = GROUP.registerVarargEvent("rename.search.for.text.for.method", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_FOR_TEXT_FOR_CLASS = GROUP.registerVarargEvent("rename.search.for.text.for.class", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE = GROUP.registerVarargEvent("rename.search.for.text.for.package", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE = GROUP.registerVarargEvent("rename.search.for.text.for.variable", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_AUTO_INHERITORS = GROUP.registerVarargEvent("rename.auto.inheritors", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_AUTO_OVERLOADS = GROUP.registerVarargEvent("rename.auto.overloads", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_AUTO_TESTS = GROUP.registerVarargEvent("rename.auto.tests", new EventField[]{EventFields.Enabled});
    private static final VarargEventId RENAME_AUTO_VARIABLES = GROUP.registerVarargEvent("rename.auto.variables", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INTRODUCE_LOCAL_CREATE_FINALS = GROUP.registerVarargEvent("introduce.local.create.finals", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INTRODUCE_LOCAL_USE_VAR = GROUP.registerVarargEvent("introduce.local.use.var", new EventField[]{EventFields.Enabled});
    private static final VarargEventId MOVE_SEARCH_IN_COMMENTS = GROUP.registerVarargEvent("move.search.in.comments", new EventField[]{EventFields.Enabled});
    private static final VarargEventId MOVE_SEARCH_FOR_TEXT = GROUP.registerVarargEvent("move.search.for.text", new EventField[]{EventFields.Enabled});
    private static final VarargEventId ENCAPSULATE_FIELDS_USE_ACCESSORS = GROUP.registerVarargEvent("encapsulate.fields.use.accessors", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INTRODUCE_PARAMETER_DELETE_LOCAL = GROUP.registerVarargEvent("introduce.parameter.delete.local", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INTRODUCE_PARAMETER_USE_INITIALIZER = GROUP.registerVarargEvent("introduce.parameter.use.initializer", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INTRODUCE_PARAMETER_CREATE_FINALS = GROUP.registerVarargEvent("introduce.parameter.create.finals", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INTRODUCE_CONSTANT_REPLACE_ALL = GROUP.registerVarargEvent("introduce.constant.replace.all", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_METHOD_THIS_ONLY_CHOICE = GROUP.registerVarargEvent("inline.method.this.only.choice", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_METHOD_ALL_AND_KEEP_CHOICE = GROUP.registerVarargEvent("inline.method.all.and.keep.choice", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_SUPER_CLASS_THIS_ONLY_CHOICE = GROUP.registerVarargEvent("inline.super.class.this.only.choice", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_FIELD_THIS_ONLY_CHOICE = GROUP.registerVarargEvent("inline.field.this.only.choice", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_FIELD_ALL_AND_KEEP_CHOICE = GROUP.registerVarargEvent("inline.field.all.and.keep.choice", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_LOCAL_THIS_ONLY_CHOICE = GROUP.registerVarargEvent("inline.local.this.only.choice", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INHERITANCE_TO_DELEGATION_DELEGATE_OTHER = GROUP.registerVarargEvent("inheritance.to.delegation.delegate.other", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_CLASS_SEARCH_IN_COMMENTS = GROUP.registerVarargEvent("inline.class.search.in.comments", new EventField[]{EventFields.Enabled});
    private static final VarargEventId INLINE_CLASS_SEARCH_IN_NON_JAVA = GROUP.registerVarargEvent("inline.class.search.in.non.java", new EventField[]{EventFields.Enabled});
    private static final EventId1<String> INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS = GROUP.registerEvent("introduce.parameter.replace.fields.with.getters", (EventField)EventFields.String((String)"replace_fields_with_getters", List.of("none", "inaccessible", "all", "unknown")));
    private static final StringEventField VISIBILITY = EventFields.String((String)"visibility", List.of("public", "protected", "packageLocal", "private", "EscalateVisible", "unknown"));
    private static final VarargEventId INTRODUCE_FIELD_VISIBILITY = GROUP.registerVarargEvent("introduce.field.visibility", new EventField[]{VISIBILITY});
    private static final VarargEventId INTRODUCE_CONSTANT_VISIBILITY = GROUP.registerVarargEvent("introduce.constant.visibility", new EventField[]{VISIBILITY});
    private static final StringEventField JAVADOC = EventFields.String((String)"javadoc", List.of("as_is", "copy", "move", "unknown"));
    private static final VarargEventId EXTRACT_INTERFACE_JAVADOC = GROUP.registerVarargEvent("extract.interface.javadoc", new EventField[]{JAVADOC});
    private static final VarargEventId EXTRACT_SUPERCLASS_JAVADOC = GROUP.registerVarargEvent("extract.superclass.javadoc", new EventField[]{JAVADOC});
    private static final VarargEventId PULL_UP_MEMBERS_JAVADOC = GROUP.registerVarargEvent("pull.up.members.javadoc", new EventField[]{JAVADOC});

    public EventLogGroup getGroup() {
        return GROUP;
    }

    @NotNull
    public Set<MetricEvent> getMetrics() {
        HashSet<MetricEvent> result = new HashSet<MetricEvent>();
        JavaRefactoringSettings settings = JavaRefactoringSettings.getInstance();
        JavaRefactoringSettings defaultSettings = new JavaRefactoringSettings();
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_FIELD, (VarargEventId)RENAME_SEARCH_IN_COMMENTS_FOR_FIELD);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_METHOD, (VarargEventId)RENAME_SEARCH_IN_COMMENTS_FOR_METHOD);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_CLASS, (VarargEventId)RENAME_SEARCH_IN_COMMENTS_FOR_CLASS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE, (VarargEventId)RENAME_SEARCH_IN_COMMENTS_FOR_PACKAGE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE, (VarargEventId)RENAME_SEARCH_IN_COMMENTS_FOR_VARIABLE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_FIELD, (VarargEventId)RENAME_SEARCH_FOR_TEXT_FOR_FIELD);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_METHOD, (VarargEventId)RENAME_SEARCH_FOR_TEXT_FOR_METHOD);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_CLASS, (VarargEventId)RENAME_SEARCH_FOR_TEXT_FOR_CLASS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE, (VarargEventId)RENAME_SEARCH_FOR_TEXT_FOR_PACKAGE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE, (VarargEventId)RENAME_SEARCH_FOR_TEXT_FOR_VARIABLE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_INHERITORS, (VarargEventId)RENAME_AUTO_INHERITORS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_OVERLOADS, (VarargEventId)RENAME_AUTO_OVERLOADS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_TESTS, (VarargEventId)RENAME_AUTO_TESTS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.RENAME_VARIABLES, (VarargEventId)RENAME_AUTO_VARIABLES);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_LOCAL_CREATE_FINALS, (VarargEventId)INTRODUCE_LOCAL_CREATE_FINALS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_LOCAL_CREATE_VAR_TYPE, (VarargEventId)INTRODUCE_LOCAL_USE_VAR);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.MOVE_SEARCH_IN_COMMENTS, (VarargEventId)MOVE_SEARCH_IN_COMMENTS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.MOVE_SEARCH_FOR_TEXT, (VarargEventId)MOVE_SEARCH_FOR_TEXT);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.ENCAPSULATE_FIELDS_USE_ACCESSORS_WHEN_ACCESSIBLE, (VarargEventId)ENCAPSULATE_FIELDS_USE_ACCESSORS);
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getReplaceGettersOption(s.INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS), javadoc -> INTRODUCE_PARAMETER_REPLACE_FIELDS_WITH_GETTERS.metric(javadoc));
        JavaRefactoringUsageCollector.addJavadoc(result, settings, defaultSettings, EXTRACT_INTERFACE_JAVADOC, s -> s.EXTRACT_INTERFACE_JAVADOC);
        JavaRefactoringUsageCollector.addJavadoc(result, settings, defaultSettings, EXTRACT_SUPERCLASS_JAVADOC, s -> s.EXTRACT_SUPERCLASS_JAVADOC);
        JavaRefactoringUsageCollector.addJavadoc(result, settings, defaultSettings, PULL_UP_MEMBERS_JAVADOC, s -> s.PULL_UP_MEMBERS_JAVADOC);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_PARAMETER_DELETE_LOCAL_VARIABLE, (VarargEventId)INTRODUCE_PARAMETER_DELETE_LOCAL);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_PARAMETER_USE_INITIALIZER, (VarargEventId)INTRODUCE_PARAMETER_USE_INITIALIZER);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_PARAMETER_CREATE_FINALS, (VarargEventId)INTRODUCE_PARAMETER_CREATE_FINALS);
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getVisibility(s.INTRODUCE_FIELD_VISIBILITY), javadoc -> INTRODUCE_FIELD_VISIBILITY.metric(new EventPair[]{VISIBILITY.with(javadoc)}));
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getVisibility(s.INTRODUCE_CONSTANT_VISIBILITY), javadoc -> INTRODUCE_CONSTANT_VISIBILITY.metric(new EventPair[]{VISIBILITY.with(javadoc)}));
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INTRODUCE_CONSTANT_REPLACE_ALL, (VarargEventId)INTRODUCE_CONSTANT_REPLACE_ALL);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_METHOD_THIS, (VarargEventId)INLINE_METHOD_THIS_ONLY_CHOICE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_METHOD_KEEP, (VarargEventId)INLINE_METHOD_ALL_AND_KEEP_CHOICE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_SUPER_CLASS_THIS, (VarargEventId)INLINE_SUPER_CLASS_THIS_ONLY_CHOICE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_FIELD_THIS, (VarargEventId)INLINE_FIELD_THIS_ONLY_CHOICE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_FIELD_KEEP, (VarargEventId)INLINE_FIELD_ALL_AND_KEEP_CHOICE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_LOCAL_THIS, (VarargEventId)INLINE_LOCAL_THIS_ONLY_CHOICE);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INHERITANCE_TO_DELEGATION_DELEGATE_OTHER, (VarargEventId)INHERITANCE_TO_DELEGATION_DELEGATE_OTHER);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_CLASS_SEARCH_IN_COMMENTS, (VarargEventId)INLINE_CLASS_SEARCH_IN_COMMENTS);
        MetricEventUtilKt.addBoolIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> s.INLINE_CLASS_SEARCH_IN_NON_JAVA, (VarargEventId)INLINE_CLASS_SEARCH_IN_NON_JAVA);
        HashSet<MetricEvent> hashSet = result;
        if (hashSet == null) {
            JavaRefactoringUsageCollector.$$$reportNull$$$0(0);
        }
        return hashSet;
    }

    private static void addJavadoc(Set<MetricEvent> result, JavaRefactoringSettings settings, JavaRefactoringSettings defaultSettings, VarargEventId eventId, Function<JavaRefactoringSettings, Integer> javadocOption) {
        MetricEventUtilKt.addMetricIfDiffers(result, (Object)settings, (Object)defaultSettings, s -> JavaRefactoringUsageCollector.getJavadocOption((Integer)javadocOption.apply((JavaRefactoringSettings)s)), javadoc -> eventId.metric(new EventPair[]{JAVADOC.with(javadoc)}));
    }

    private static String getVisibility(String visibility) {
        return "public".equals(visibility) || "private".equals(visibility) || "protected".equals(visibility) || "packageLocal".equals(visibility) || "EscalateVisible".equals(visibility) ? visibility : "unknown";
    }

    private static String getJavadocOption(int javadoc) {
        return switch (javadoc) {
            case 0 -> "as is";
            case 2 -> "copy";
            case 1 -> "move";
            default -> "unknown";
        };
    }

    private static String getReplaceGettersOption(int getters) {
        return switch (getters) {
            case 0 -> "none";
            case 1 -> "inaccessible";
            case 2 -> "all";
            default -> "unknown";
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/JavaRefactoringUsageCollector", "getMetrics"));
    }
}

