/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.OptimizeImportsTask;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Unmodifiable;

public final class OptimizeImportsRefactoringHelper
implements RefactoringHelper<Set<PsiJavaFile>> {
    private static Set<PsiJavaFile> prepareOperation(UsageInfo @NotNull [] usages) {
        if (usages == null) {
            OptimizeImportsRefactoringHelper.$$$reportNull$$$0(0);
        }
        HashSet<PsiJavaFile> javaFiles = new HashSet<PsiJavaFile>();
        for (UsageInfo usage : usages) {
            PsiFile file;
            if (usage.isNonCodeUsage || !((file = usage.getFile()) instanceof PsiJavaFile)) continue;
            javaFiles.add((PsiJavaFile)file);
        }
        return javaFiles;
    }

    public @Unmodifiable Set<PsiJavaFile> prepareOperation(UsageInfo @NotNull [] usages, @NotNull @NotNull List<? extends @NotNull PsiElement> elements) {
        if (elements == null) {
            OptimizeImportsRefactoringHelper.$$$reportNull$$$0(1);
        }
        if (usages == null) {
            OptimizeImportsRefactoringHelper.$$$reportNull$$$0(2);
        }
        Set movedFiles = ContainerUtil.map2SetNotNull(elements, e -> (PsiJavaFile)ObjectUtils.tryCast((Object)e.getContainingFile(), PsiJavaFile.class));
        return ContainerUtil.union((Set)movedFiles, OptimizeImportsRefactoringHelper.prepareOperation(usages));
    }

    public void performOperation(@NotNull Project project, Set<PsiJavaFile> javaFiles) {
        if (project == null) {
            OptimizeImportsRefactoringHelper.$$$reportNull$$$0(3);
        }
        if (javaFiles.isEmpty()) {
            return;
        }
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(() -> PsiDocumentManager.getInstance((Project)project).commitAllDocuments());
        ProgressManager progressManager = ProgressManager.getInstance();
        DumbService.getInstance((Project)project).completeJustSubmittedTasks();
        ArrayList redundants = new ArrayList();
        Runnable findRedundantImports = () -> {
            JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
            ProgressIndicator progressIndicator = progressManager.getProgressIndicator();
            if (progressIndicator != null) {
                progressIndicator.setIndeterminate(false);
            }
            SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
            int i = 0;
            int fileCount = javaFiles.size();
            for (PsiJavaFile file : javaFiles) {
                double fraction = (double)i++ / (double)fileCount;
                ReadAction.run(() -> {
                    Collection perFile;
                    if (!file.isValid()) {
                        return;
                    }
                    VirtualFile virtualFile = file.getVirtualFile();
                    if (virtualFile == null) {
                        return;
                    }
                    if (progressIndicator != null) {
                        progressIndicator.setText2(virtualFile.getPresentableUrl());
                        progressIndicator.setFraction(fraction);
                    }
                    if ((perFile = styleManager.findRedundantImports(file)) == null) {
                        return;
                    }
                    for (PsiImportStatementBase redundant : perFile) {
                        redundants.add(pointerManager.createSmartPsiElementPointer((PsiElement)redundant));
                    }
                });
            }
        };
        String title = JavaRefactoringBundle.message((String)"removing.redundant.imports.progress.title", (Object[])new Object[0]);
        if (!progressManager.runProcessWithProgressSynchronously(findRedundantImports, title, false, project)) {
            return;
        }
        if (redundants.isEmpty()) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(() -> {
            SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, title, false);
            progressTask.setMinIterationTime(200L);
            progressTask.setTask((SequentialTask)new OptimizeImportsTask(progressTask, redundants));
            progressManager.run((Task)progressTask);
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "usages";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/OptimizeImportsRefactoringHelper";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "prepareOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "performOperation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

