/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiFunctionalExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.refactoring.changeSignature.CallReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureUsageProvider;
import com.intellij.refactoring.changeSignature.FunctionalInterfaceChangedUsageInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfoConverters;
import com.intellij.refactoring.changeSignature.JavaChangeInfoImpl;
import com.intellij.refactoring.changeSignature.MethodCallUsageInfo;
import com.intellij.refactoring.changeSignature.MethodReferenceUsageInfo;
import com.intellij.refactoring.changeSignature.OverriderUsageInfo;
import com.intellij.refactoring.changeSignature.PsiCallReference;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.refactoring.util.usageInfo.DefaultConstructorImplicitUsageInfo;
import com.intellij.refactoring.util.usageInfo.NoConstructorClassUsageInfo;
import com.intellij.usageView.UsageInfo;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class JavaChangeSignatureUsageProvider
implements ChangeSignatureUsageProvider {
    private static final Logger LOG = Logger.getInstance(JavaChangeSignatureUsageProvider.class);

    @Nullable
    public UsageInfo createOverrideUsageInfo(@NotNull ChangeInfo changeInfo, @NotNull PsiElement overrider, @NotNull PsiElement method, boolean isOriginalOverrider, boolean modifyArgs, boolean modifyExceptions, List<? super UsageInfo> result) {
        if (changeInfo == null) {
            JavaChangeSignatureUsageProvider.$$$reportNull$$$0(0);
        }
        if (overrider == null) {
            JavaChangeSignatureUsageProvider.$$$reportNull$$$0(1);
        }
        if (method == null) {
            JavaChangeSignatureUsageProvider.$$$reportNull$$$0(2);
        }
        if (!(method instanceof PsiMethod)) {
            JavaChangeInfo javaChangeInfo = JavaChangeInfoConverters.getJavaChangeInfo((ChangeInfo)changeInfo, (UsageInfo)new UsageInfo(overrider));
            if (javaChangeInfo == null) {
                return null;
            }
            method = javaChangeInfo.getMethod();
        }
        if (overrider instanceof PsiFunctionalExpression) {
            return new FunctionalInterfaceChangedUsageInfo(overrider, (PsiMethod)method);
        }
        LOG.assertTrue(overrider instanceof PsiMethod);
        return new OverriderUsageInfo((PsiMethod)overrider, (PsiMethod)method, isOriginalOverrider, modifyArgs, modifyExceptions);
    }

    @Nullable
    public UsageInfo createUsageInfo(@NotNull ChangeInfo changeInfo, @NotNull PsiReference reference, @NotNull PsiElement m, boolean isToModifyArgs, boolean isToThrowExceptions) {
        boolean isToCatchExceptions;
        JavaChangeInfo javaChangeInfo;
        if (changeInfo == null) {
            JavaChangeSignatureUsageProvider.$$$reportNull$$$0(3);
        }
        if (reference == null) {
            JavaChangeSignatureUsageProvider.$$$reportNull$$$0(4);
        }
        if (m == null) {
            JavaChangeSignatureUsageProvider.$$$reportNull$$$0(5);
        }
        if ((javaChangeInfo = JavaChangeInfoConverters.getJavaChangeInfo((ChangeInfo)changeInfo, (UsageInfo)new UsageInfo(reference))) == null) {
            return null;
        }
        PsiMethod method = javaChangeInfo.getMethod();
        if (m instanceof PsiMethod) {
            method = (PsiMethod)m;
        }
        PsiElement element = reference.getElement();
        boolean bl = isToCatchExceptions = isToThrowExceptions && JavaChangeSignatureUsageProvider.needToCatchExceptions(javaChangeInfo, RefactoringUtil.getEnclosingMethod(element));
        if (!isToCatchExceptions && RefactoringUtil.isMethodUsage(element)) {
            PsiExpressionList list = RefactoringUtil.getArgumentListByMethodReference(element);
            if (list == null || !method.isVarArgs() && list.getExpressionCount() != method.getParameterList().getParametersCount()) {
                return null;
            }
            if (method.isVarArgs() && reference instanceof PsiReferenceExpression && !((PsiReferenceExpression)reference).advancedResolve(true).isValidResult()) {
                return null;
            }
        }
        if (RefactoringUtil.isMethodUsage(element)) {
            return new MethodCallUsageInfo(element, isToModifyArgs, isToCatchExceptions);
        }
        if (element instanceof PsiDocTagValue) {
            return new UsageInfo(element);
        }
        if (element instanceof PsiMethod && ((PsiMethod)element).isConstructor()) {
            return new DefaultConstructorImplicitUsageInfo((PsiMethod)element, ((PsiMethod)element).getContainingClass(), method);
        }
        if (element instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)element;
            LOG.assertTrue(method.isConstructor());
            if (javaChangeInfo instanceof JavaChangeInfoImpl) {
                UsageInfo info = JavaChangeSignatureUsageProvider.shouldPropagateToNonPhysicalMethod(method, psiClass, ((JavaChangeInfoImpl)javaChangeInfo).propagateParametersMethods);
                if (info != null) {
                    return info;
                }
                info = JavaChangeSignatureUsageProvider.shouldPropagateToNonPhysicalMethod(method, psiClass, ((JavaChangeInfoImpl)javaChangeInfo).propagateExceptionsMethods);
                if (info != null) {
                    return info;
                }
            }
            return new NoConstructorClassUsageInfo(psiClass);
        }
        if (reference instanceof PsiCallReference) {
            return new CallReferenceUsageInfo((PsiCallReference)reference);
        }
        if (element instanceof PsiMethodReferenceExpression && MethodReferenceUsageInfo.needToExpand(javaChangeInfo)) {
            return new MethodReferenceUsageInfo(element, isToModifyArgs, isToCatchExceptions);
        }
        if (method.isConstructor() && element.getParent() instanceof PsiTypeElement) {
            return null;
        }
        return new MoveRenameUsageInfo(element, reference, (PsiElement)method);
    }

    private static UsageInfo shouldPropagateToNonPhysicalMethod(PsiMethod method, PsiClass containingClass, Set<? extends PsiMethod> propagateMethods) {
        for (PsiMethod psiMethod : propagateMethods) {
            if (psiMethod.isPhysical() || !Comparing.strEqual((String)psiMethod.getName(), (String)containingClass.getName())) continue;
            return new DefaultConstructorImplicitUsageInfo(psiMethod, containingClass, method);
        }
        return null;
    }

    private static boolean needToCatchExceptions(JavaChangeInfo changeInfo, PsiMethod caller) {
        if (changeInfo instanceof JavaChangeInfoImpl) {
            return changeInfo.isExceptionSetOrOrderChanged() && !((JavaChangeInfoImpl)changeInfo).propagateExceptionsMethods.contains(caller);
        }
        return changeInfo.isExceptionSetOrOrderChanged();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "changeInfo";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "overrider";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reference";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "m";
                break;
            }
        }
        objectArray2[1] = "com/intellij/refactoring/changeSignature/JavaChangeSignatureUsageProvider";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createOverrideUsageInfo";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createUsageInfo";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

