/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethod.newImpl;

import com.intellij.codeInsight.ExceptionUtil;
import com.intellij.codeInsight.Nullability;
import com.intellij.codeInspection.dataFlow.DfaNullability;
import com.intellij.codeInspection.dataFlow.StandardDataFlowRunner;
import com.intellij.codeInspection.dataFlow.interpreter.RunnerResult;
import com.intellij.codeInspection.dataFlow.java.JavaDfaListener;
import com.intellij.codeInspection.dataFlow.lang.DfaListener;
import com.intellij.codeInspection.dataFlow.memory.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.types.DfType;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.java.refactoring.JavaRefactoringBundle;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypes;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiYieldStatement;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.BranchingInstruction;
import com.intellij.psi.controlFlow.ConditionalThrowToInstruction;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowOptions;
import com.intellij.psi.controlFlow.ControlFlowPolicy;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.GoToInstruction;
import com.intellij.psi.controlFlow.Instruction;
import com.intellij.psi.controlFlow.LocalsControlFlowPolicy;
import com.intellij.psi.controlFlow.ReturnInstruction;
import com.intellij.psi.controlFlow.ThrowToInstruction;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.extractMethod.newImpl.CodeFragmentAnalyzer;
import com.intellij.refactoring.extractMethod.newImpl.ExitDescription;
import com.intellij.refactoring.extractMethod.newImpl.ExternalReference;
import com.intellij.refactoring.extractMethod.newImpl.ExtractException;
import com.intellij.refactoring.extractMethod.newImpl.ExtractMethodHelper;
import com.intellij.refactoring.extractMethod.newImpl.MemberUsage;
import com.intellij.refactoring.util.classMembers.ClassMemberReferencesVisitor;
import com.siyeh.ig.psiutils.VariableAccessUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 62\u00020\u0001:\u00016B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010\u000f\u001a\u00020\fH\u0002J\u001e\u0010\u0010\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u0002J\u0016\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00120\u00032\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0003J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003J\u001e\u0010\u0018\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u00032\u0006\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u001a\u001a\u00020\u0004J\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003J\f\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003J\u0006\u0010\u001d\u001a\u00020\u001eJ\u0006\u0010\u001f\u001a\u00020 J\f\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003J\"\u0010\"\u001a\b\u0012\u0004\u0012\u00020#0\u00032\u0006\u0010$\u001a\u00020%2\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003J\u0010\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020'H\u0002J\u0010\u0010)\u001a\u00020\u001e2\u0006\u0010(\u001a\u00020'H\u0002J\u0010\u0010*\u001a\u00020\u001e2\u0006\u0010+\u001a\u00020'H\u0002J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020'0\u0003H\u0002J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020'0\u0003H\u0002J\f\u0010.\u001a\b\u0012\u0004\u0012\u00020/0\u0003J\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u00140\u0003J\u0010\u00101\u001a\u00020\u001e2\u0006\u00102\u001a\u000203H\u0002J\u0013\u00104\u001a\u00020\u001e2\b\u00105\u001a\u0004\u0018\u00010\u0004H\u0086\u0002R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0013\u0010\t\u001a\u00070\u0004\u00a2\u0006\u0002\b\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00067"}, d2={"Lcom/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer;", "", "elements", "", "Lcom/intellij/psi/PsiElement;", "<init>", "(Ljava/util/List;)V", "getElements", "()Ljava/util/List;", "codeFragment", "Lorg/jetbrains/annotations/NotNull;", "flow", "Lcom/intellij/psi/controlFlow/ControlFlow;", "flowRange", "Lkotlin/ranges/IntRange;", "createControlFlow", "findFlowRange", "findVariableReferences", "Lcom/intellij/psi/PsiReferenceExpression;", "variable", "Lcom/intellij/psi/PsiVariable;", "findExternalReferences", "Lcom/intellij/refactoring/extractMethod/newImpl/ExternalReference;", "findUsedVariablesAfter", "findOuterLocals", "sourceClassMember", "targetClassMember", "findOutputVariables", "findUndeclaredVariables", "hasObservableThrowExit", "", "findExitDescription", "Lcom/intellij/refactoring/extractMethod/newImpl/ExitDescription;", "findExposedLocalDeclarations", "findInstanceMemberUsages", "Lcom/intellij/refactoring/extractMethod/newImpl/MemberUsage;", "targetClass", "Lcom/intellij/psi/PsiClass;", "lastGotoPointFrom", "", "instructionOffset", "isNonLocalJump", "isInstructionReachable", "offset", "findDefaultExits", "findExitPoints", "findThrownExceptions", "Lcom/intellij/psi/PsiClassType;", "findWrittenVariables", "isExitInside", "statement", "Lcom/intellij/psi/PsiStatement;", "contains", "element", "Companion", "intellij.java.impl.refactorings"})
@SourceDebugExtension(value={"SMAP\nCodeFragmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentAnalyzer.kt\ncom/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n*L\n1#1,316:1\n1#2:317\n1391#3:318\n1480#3,5:319\n832#3:324\n862#3,2:325\n1586#3:327\n1661#3,3:328\n1068#3:331\n1786#3,3:332\n1586#3:335\n1661#3,3:336\n832#3:339\n862#3,2:340\n832#3:344\n862#3,2:345\n1915#3,2:347\n1915#3,2:349\n832#3:351\n862#3,2:352\n1586#3:354\n1661#3,3:355\n1586#3:358\n1661#3,3:359\n37#4,2:342\n37#4,2:362\n*S KotlinDebug\n*F\n+ 1 CodeFragmentAnalyzer.kt\ncom/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer\n*L\n93#1:318\n93#1:319,5\n98#1:324\n98#1:325,2\n99#1:327\n99#1:328,3\n100#1:331\n117#1:332,3\n119#1:335\n119#1:336,3\n129#1:339\n129#1:340,2\n142#1:344\n142#1:345,2\n155#1:347,2\n174#1:349,2\n212#1:351\n212#1:352,2\n225#1:354\n225#1:355,3\n229#1:358\n229#1:359,3\n135#1:342,2\n233#1:362,2\n*E\n"})
public final class CodeFragmentAnalyzer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<PsiElement> elements;
    @NotNull
    private final PsiElement codeFragment;
    @NotNull
    private final ControlFlow flow;
    @NotNull
    private final IntRange flowRange;

    public CodeFragmentAnalyzer(@NotNull List<? extends PsiElement> elements) {
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        this.elements = elements;
        if (!(!((Collection)this.elements).isEmpty())) {
            String string = "Failed requirement.";
            throw new IllegalArgumentException(string.toString());
        }
        PsiElement psiElement = ControlFlowUtil.findCodeFragment((PsiElement)((PsiElement)CollectionsKt.first(this.elements)));
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findCodeFragment(...)");
        this.codeFragment = psiElement;
        this.flow = this.createControlFlow();
        this.flowRange = this.findFlowRange(this.flow, this.elements);
    }

    @NotNull
    public final List<PsiElement> getElements() {
        return this.elements;
    }

    private final ControlFlow createControlFlow() {
        try {
            PsiElement fragmentToAnalyze = this.codeFragment;
            LocalsControlFlowPolicy flowPolicy = new LocalsControlFlowPolicy(fragmentToAnalyze);
            ControlFlow controlFlow = ControlFlowFactory.getControlFlow((PsiElement)fragmentToAnalyze, (ControlFlowPolicy)((ControlFlowPolicy)flowPolicy), (ControlFlowOptions)ControlFlowOptions.NO_CONST_EVALUATE);
            Intrinsics.checkNotNullExpressionValue((Object)controlFlow, (String)"getControlFlow(...)");
            return controlFlow;
        }
        catch (AnalysisCanceledException e) {
            String string = JavaRefactoringBundle.message((String)"extract.method.control.flow.analysis.failed", (Object[])new Object[0]);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
            PsiElement psiElement = e.getErrorElement();
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"getErrorElement(...)");
            throw new ExtractException(string, psiElement);
        }
    }

    private final IntRange findFlowRange(ControlFlow flow, List<? extends PsiElement> elements) {
        Object v2;
        PsiElement firstElementInFlow;
        Object object;
        block5: {
            Object object2;
            Object object3;
            Object object4;
            List normalizedElements;
            block4: {
                PsiParenthesizedExpression expression;
                Object object5 = CollectionsKt.singleOrNull(elements);
                PsiParenthesizedExpression psiParenthesizedExpression = expression = object5 instanceof PsiParenthesizedExpression ? (PsiParenthesizedExpression)object5 : null;
                normalizedElements = psiParenthesizedExpression != null ? CollectionsKt.listOfNotNull((Object)PsiUtil.skipParenthesizedExprDown((PsiExpression)((PsiExpression)psiParenthesizedExpression))) : elements;
                object = normalizedElements;
                object4 = object.iterator();
                while (object4.hasNext()) {
                    object3 = object4.next();
                    PsiElement element = (PsiElement)object3;
                    boolean bl = false;
                    if (!(flow.getStartOffset(element) >= 0)) continue;
                    object2 = object3;
                    break block4;
                }
                object2 = null;
            }
            firstElementInFlow = (PsiElement)object2;
            object4 = normalizedElements;
            object3 = object4.listIterator(object4.size());
            while (object3.hasPrevious()) {
                Object e = object3.previous();
                PsiElement element = (PsiElement)e;
                boolean bl = false;
                if (!(flow.getEndOffset(element) >= 0)) continue;
                v2 = e;
                break block5;
            }
            v2 = null;
        }
        PsiElement lastElementInFlow = v2;
        if (firstElementInFlow == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        if (lastElementInFlow == null) {
            object = "Required value was null.";
            throw new IllegalArgumentException(object.toString());
        }
        return new IntRange(flow.getStartOffset(firstElementInFlow), flow.getEndOffset(lastElementInFlow));
    }

    /*
     * WARNING - void declaration
     */
    private final List<PsiReferenceExpression> findVariableReferences(PsiVariable variable) {
        void $this$flatMapTo$iv$iv;
        Iterable $this$flatMap$iv = this.elements;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            PsiElement it = (PsiElement)element$iv$iv;
            boolean bl = false;
            List list = VariableAccessUtils.getVariableReferences((PsiVariable)variable, (PsiElement)it);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getVariableReferences(...)");
            Iterable list$iv$iv = list;
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<ExternalReference> findExternalReferences() {
        void $this$mapTo$iv$iv;
        PsiVariable variable;
        Iterable $this$filterNotTo$iv$iv;
        List list = ControlFlowUtil.getInputVariables((ControlFlow)this.flow, (int)this.flowRange.getFirst(), (int)this.flowRange.getLast());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInputVariables(...)");
        Iterable $this$filterNot$iv = list;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            variable = (PsiVariable)element$iv$iv;
            boolean bl = false;
            if (this.contains((PsiElement)variable)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterNotTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            variable = (PsiVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)variable);
            collection.add(new ExternalReference(variable, this.findVariableReferences(variable)));
        }
        Iterable $this$sortedBy$iv = (List)destination$iv$iv;
        boolean $i$f$sortedBy = false;
        return CollectionsKt.sortedWith((Iterable)$this$sortedBy$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                int n;
                boolean bl;
                Iterator<T> iterator;
                int n2;
                ExternalReference externalReference = (ExternalReference)a;
                boolean bl2 = false;
                if (externalReference.getVariable() instanceof PsiParameter) {
                    n2 = ((PsiParameter)externalReference.getVariable()).getTextRange().getStartOffset();
                } else {
                    iterator = ((Iterable)externalReference.getReferences()).iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    PsiReferenceExpression reference22 = (PsiReferenceExpression)iterator.next();
                    bl = false;
                    int reference22 = reference22.getTextRange().getStartOffset();
                    while (iterator.hasNext()) {
                        PsiReferenceExpression reference32 = (PsiReferenceExpression)iterator.next();
                        $i$a$-minOf-CodeFragmentAnalyzer$findExternalReferences$3$1 = false;
                        int reference32 = reference32.getTextRange().getStartOffset();
                        if (reference22 <= reference32) continue;
                        reference22 = reference32;
                    }
                    n2 = reference22;
                }
                externalReference = (ExternalReference)b;
                Comparable comparable = Integer.valueOf(n2);
                bl2 = false;
                if (externalReference.getVariable() instanceof PsiParameter) {
                    n = ((PsiParameter)externalReference.getVariable()).getTextRange().getStartOffset();
                } else {
                    iterator = ((Iterable)externalReference.getReferences()).iterator();
                    if (!iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    PsiReferenceExpression reference = (PsiReferenceExpression)iterator.next();
                    bl = false;
                    int n3 = reference.getTextRange().getStartOffset();
                    while (iterator.hasNext()) {
                        PsiReferenceExpression reference2 = (PsiReferenceExpression)iterator.next();
                        $i$a$-minOf-CodeFragmentAnalyzer$findExternalReferences$3$1 = false;
                        int n4 = reference2.getTextRange().getStartOffset();
                        if (n3 <= n4) continue;
                        n3 = n4;
                    }
                    n = n3;
                }
                return ComparisonsKt.compareValues((Comparable)comparable, (Comparable)Integer.valueOf(n));
            }
        });
    }

    @NotNull
    public final List<PsiVariable> findUsedVariablesAfter() {
        List list = ControlFlowUtil.getUsedVariables((ControlFlow)this.flow, (int)this.flowRange.getLast(), (int)this.flow.getSize());
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getUsedVariables(...)");
        return list;
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final List<ExternalReference> findOuterLocals(@NotNull PsiElement sourceClassMember, @NotNull PsiElement targetClassMember) {
        void $this$mapTo$iv$iv;
        boolean canBeExtracted;
        List outerVariables;
        block6: {
            void $this$all$iv;
            Intrinsics.checkNotNullParameter((Object)sourceClassMember, (String)"sourceClassMember");
            Intrinsics.checkNotNullParameter((Object)targetClassMember, (String)"targetClassMember");
            if (Intrinsics.areEqual((Object)sourceClassMember, (Object)targetClassMember)) {
                return CollectionsKt.emptyList();
            }
            outerVariables = new ArrayList();
            Iterable iterable = this.elements;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                v0 = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    PsiElement element = (PsiElement)element$iv;
                    boolean bl = false;
                    if (ControlFlowUtil.collectOuterLocals((List)outerVariables, (PsiElement)element, (PsiElement)sourceClassMember, (PsiElement)targetClassMember)) continue;
                    v0 = false;
                    break block6;
                }
                v0 = canBeExtracted = true;
            }
        }
        if (!canBeExtracted) {
            return null;
        }
        Iterable $this$map$iv = outerVariables;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void variable;
            PsiVariable psiVariable = (PsiVariable)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new ExternalReference((PsiVariable)variable, this.findVariableReferences((PsiVariable)variable)));
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<PsiVariable> findOutputVariables() {
        PsiVariable[] psiVariableArray = ControlFlowUtil.getOutputVariables((ControlFlow)this.flow, (int)this.flowRange.getFirst(), (int)this.flowRange.getLast(), (int[])CollectionsKt.toIntArray((Collection)this.findExitPoints()));
        Intrinsics.checkNotNullExpressionValue((Object)psiVariableArray, (String)"getOutputVariables(...)");
        return ArraysKt.distinct((Object[])psiVariableArray);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<PsiVariable> findUndeclaredVariables() {
        void $this$filterNotTo$iv$iv;
        Collection collection = ControlFlowUtil.getWrittenVariables((ControlFlow)this.flow, (int)this.flowRange.getFirst(), (int)this.flowRange.getLast(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getWrittenVariables(...)");
        Iterable $this$filterNot$iv = collection;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PsiVariable variable = (PsiVariable)element$iv$iv;
            boolean bl = false;
            if (new TextRange(((PsiElement)CollectionsKt.first(this.elements)).getTextRange().getStartOffset(), ((PsiElement)CollectionsKt.last(this.elements)).getTextRange().getEndOffset()).contains(variable.getTextRange())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    public final boolean hasObservableThrowExit() {
        Collection $this$toTypedArray$iv = this.elements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return ControlFlowUtil.hasObservableThrowExitPoints((ControlFlow)this.flow, (int)this.flowRange.getFirst(), (int)this.flowRange.getLast(), (PsiElement[])thisCollection$iv.toArray(new PsiElement[0]), (PsiElement)this.codeFragment);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ExitDescription findExitDescription() {
        void $this$filterNotTo$iv$iv;
        Intrinsics.checkNotNullExpressionValue((Object)ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES, (String)"DEFAULT_EXIT_STATEMENTS_CLASSES");
        Class[] exitStatements = (Class[])ArraysKt.plus((Object[])ControlFlowUtil.DEFAULT_EXIT_STATEMENTS_CLASSES, PsiYieldStatement.class);
        Collection collection = ControlFlowUtil.findExitPointsAndStatements((ControlFlow)this.flow, (int)this.flowRange.getFirst(), (int)this.flowRange.getLast(), (IntList)((IntList)new IntArrayList()), (Class[])Arrays.copyOf(exitStatements, exitStatements.length));
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"findExitPointsAndStatements(...)");
        Iterable $this$filterNot$iv = collection;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            PsiStatement statement = (PsiStatement)element$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)statement);
            if (this.isExitInside(statement)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List statements = (List)destination$iv$iv;
        List<Integer> exitPoints = this.findExitPoints();
        Integer n = (Integer)CollectionsKt.singleOrNull(exitPoints);
        int n2 = this.lastGotoPointFrom(this.flowRange.getLast());
        boolean isNormalExit = n != null && n == n2;
        return new ExitDescription(statements, Math.max(1, exitPoints.size()), isNormalExit);
    }

    @NotNull
    public final List<PsiVariable> findExposedLocalDeclarations() {
        HashSet<PsiVariable> declaredVariables = new HashSet<PsiVariable>();
        JavaRecursiveElementWalkingVisitor visitor2 = new JavaRecursiveElementWalkingVisitor(declaredVariables){
            final /* synthetic */ HashSet<PsiVariable> $declaredVariables;
            {
                this.$declaredVariables = $declaredVariables;
            }

            /*
             * WARNING - void declaration
             */
            public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                void $this$filterIsInstanceTo$iv$iv;
                Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                Collection collection = this.$declaredVariables;
                PsiElement[] psiElementArray = statement.getDeclaredElements();
                Intrinsics.checkNotNullExpressionValue((Object)psiElementArray, (String)"getDeclaredElements(...)");
                Object[] $this$filterIsInstance$iv = psiElementArray;
                boolean $i$f$filterIsInstance = false;
                Object[] objectArray = $this$filterIsInstance$iv;
                Collection destination$iv$iv = new ArrayList<E>();
                boolean $i$f$filterIsInstanceTo = false;
                for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                    if (!(element$iv$iv instanceof PsiVariable)) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                Iterable iterable = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
            }
        };
        Iterable $this$forEach$iv = this.elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.accept((PsiElementVisitor)visitor2);
        }
        Collection collection = ControlFlowUtil.getWrittenVariables((ControlFlow)this.flow, (int)this.flowRange.getLast(), (int)this.flow.getSize(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getWrittenVariables(...)");
        Set externallyWrittenVariables = CollectionsKt.toSet((Iterable)collection);
        return CollectionsKt.toList((Iterable)CollectionsKt.intersect((Iterable)declaredVariables, (Iterable)externallyWrittenVariables));
    }

    @NotNull
    public final List<MemberUsage> findInstanceMemberUsages(@NotNull PsiClass targetClass, @NotNull List<? extends PsiElement> elements) {
        Intrinsics.checkNotNullParameter((Object)targetClass, (String)"targetClass");
        Intrinsics.checkNotNullParameter(elements, (String)"elements");
        ArrayList<MemberUsage> usedFields = new ArrayList<MemberUsage>();
        ClassMemberReferencesVisitor visitor2 = new ClassMemberReferencesVisitor(targetClass, usedFields){
            final /* synthetic */ PsiClass $targetClass;
            final /* synthetic */ ArrayList<MemberUsage> $usedFields;
            {
                this.$targetClass = $targetClass;
                this.$usedFields = $usedFields;
                super($targetClass);
            }

            protected void visitClassMemberReferenceElement(PsiMember classMember, PsiJavaCodeReferenceElement classMemberReference) {
                Intrinsics.checkNotNullParameter((Object)classMember, (String)"classMember");
                Intrinsics.checkNotNullParameter((Object)classMemberReference, (String)"classMemberReference");
                PsiExpression expression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)classMemberReference), PsiExpression.class, (boolean)false);
                if (expression != null && !classMember.hasModifierProperty("static")) {
                    ((Collection)this.$usedFields).add(new MemberUsage(classMember, expression));
                }
            }

            public void visitThisExpression(PsiThisExpression expression) {
                Intrinsics.checkNotNullParameter((Object)expression, (String)"expression");
                ((Collection)this.$usedFields).add(new MemberUsage((PsiMember)this.$targetClass, (PsiExpression)expression));
            }
        };
        Iterable $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            PsiElement it = (PsiElement)element$iv;
            boolean bl = false;
            it.accept((PsiElementVisitor)visitor2);
        }
        return CollectionsKt.distinct((Iterable)usedFields);
    }

    private final int lastGotoPointFrom(int instructionOffset) {
        if (instructionOffset >= this.flow.getSize()) {
            return instructionOffset;
        }
        Instruction instruction = (Instruction)this.flow.getInstructions().get(instructionOffset);
        PsiElement psiElement = this.flow.getElement(instructionOffset);
        PsiStatement statement = psiElement instanceof PsiStatement ? (PsiStatement)psiElement : null;
        return instruction instanceof GoToInstruction && statement != null && ExtractMethodHelper.INSTANCE.getReturnedExpression(statement) == null ? this.lastGotoPointFrom(((GoToInstruction)instruction).offset) : instructionOffset;
    }

    private final boolean isNonLocalJump(int instructionOffset) {
        boolean bl;
        Instruction instruction = (Instruction)this.flow.getInstructions().get(instructionOffset);
        if (instruction instanceof ThrowToInstruction || instruction instanceof ConditionalThrowToInstruction || instruction instanceof ReturnInstruction) {
            bl = false;
        } else if (instruction instanceof GoToInstruction) {
            int n = this.flowRange.getFirst();
            int n2 = this.flowRange.getLast();
            int n3 = ((GoToInstruction)instruction).offset;
            boolean bl2 = n <= n3 ? n3 < n2 : false;
            bl = !bl2;
        } else if (instruction instanceof BranchingInstruction) {
            int n = this.flowRange.getFirst();
            int n4 = this.flowRange.getLast();
            int n5 = ((BranchingInstruction)instruction).offset;
            boolean bl3 = n <= n5 ? n5 < n4 : false;
            bl = !bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    private final boolean isInstructionReachable(int offset) {
        return offset == this.flowRange.getFirst() || ControlFlowUtil.isInstructionReachable((ControlFlow)this.flow, (int)offset, (int)this.flowRange.getFirst());
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> findDefaultExits() {
        void $this$filterNotTo$iv$iv;
        List list;
        Instruction lastInstruction = (Instruction)this.flow.getInstructions().get(this.flowRange.getLast() - 1);
        if (!this.isInstructionReachable(this.flowRange.getLast() - 1)) {
            return CollectionsKt.emptyList();
        }
        Instruction instruction = lastInstruction;
        if (instruction instanceof ThrowToInstruction) {
            list = CollectionsKt.emptyList();
        } else if (instruction instanceof GoToInstruction) {
            list = CollectionsKt.listOf((Object)((GoToInstruction)lastInstruction).offset);
        } else if (instruction instanceof ConditionalThrowToInstruction) {
            list = CollectionsKt.listOf((Object)this.flowRange.getLast());
        } else if (instruction instanceof BranchingInstruction) {
            Object[] objectArray = new Integer[]{((BranchingInstruction)lastInstruction).offset, this.flowRange.getLast()};
            list = CollectionsKt.listOf((Object[])objectArray);
        } else {
            list = CollectionsKt.listOf((Object)this.flowRange.getLast());
        }
        List defaultExits = list;
        Iterable $this$filterNot$iv = defaultExits;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            int it = ((Number)element$iv$iv).intValue();
            boolean bl = false;
            int n = this.flowRange.getFirst();
            if (it < this.flowRange.getLast() ? n <= it : false) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final List<Integer> findExitPoints() {
        void $this$mapTo$iv$iv;
        int n;
        Collection collection;
        void $this$mapTo$iv$iv2;
        if (this.flowRange.getFirst() == this.flowRange.getLast()) {
            return CollectionsKt.listOf((Object)this.flowRange.getLast());
        }
        List gotoInstructions = SequencesKt.toList((Sequence)SequencesKt.distinctBy((Sequence)SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)((Iterable)RangesKt.until((int)this.flowRange.getFirst(), (int)this.flowRange.getLast()))), arg_0 -> CodeFragmentAnalyzer.findExitPoints$lambda$0(this, arg_0)), arg_0 -> CodeFragmentAnalyzer.findExitPoints$lambda$1(this, arg_0)));
        Iterable $this$map$iv = gotoInstructions;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void offset;
            int n2 = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv;
            n = 0;
            Object e = this.flow.getInstructions().get((int)offset);
            Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.intellij.psi.controlFlow.BranchingInstruction");
            collection.add(((BranchingInstruction)e).offset);
        }
        Set jumpPoints = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
        Set allExitPoints = SetsKt.plus((Set)jumpPoints, (Iterable)this.findDefaultExits());
        Iterable $this$map$iv2 = allExitPoints;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            n = ((Number)item$iv$iv).intValue();
            collection = destination$iv$iv2;
            boolean bl = false;
            collection.add(this.lastGotoPointFrom((int)it));
        }
        return CollectionsKt.distinct((Iterable)((List)destination$iv$iv2));
    }

    @NotNull
    public final List<PsiClassType> findThrownExceptions() {
        Collection $this$toTypedArray$iv = this.elements;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        PsiElement[] psiElementArray = thisCollection$iv.toArray(new PsiElement[0]);
        List list = ExceptionUtil.getThrownCheckedExceptions((PsiElement[])Arrays.copyOf(psiElementArray, psiElementArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getThrownCheckedExceptions(...)");
        return list;
    }

    @NotNull
    public final List<PsiVariable> findWrittenVariables() {
        Collection collection = ControlFlowUtil.getWrittenVariables((ControlFlow)this.flow, (int)this.flowRange.getFirst(), (int)this.flowRange.getLast(), (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"getWrittenVariables(...)");
        return CollectionsKt.toList((Iterable)collection);
    }

    private final boolean isExitInside(PsiStatement statement) {
        PsiStatement psiStatement = statement;
        return psiStatement instanceof PsiBreakStatement ? this.contains((PsiElement)((PsiBreakStatement)statement).findExitedStatement()) : (psiStatement instanceof PsiContinueStatement ? this.contains((PsiElement)((PsiContinueStatement)statement).findContinuedStatement()) : (psiStatement instanceof PsiReturnStatement ? false : false));
    }

    public final boolean contains(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        TextRange textRange = new TextRange(((PsiElement)CollectionsKt.first(this.elements)).getTextRange().getStartOffset(), ((PsiElement)CollectionsKt.last(this.elements)).getTextRange().getEndOffset());
        return textRange.contains(element.getTextRange());
    }

    private static final boolean findExitPoints$lambda$0(CodeFragmentAnalyzer this$0, int offset) {
        return this$0.isNonLocalJump(offset) && this$0.isInstructionReachable(offset);
    }

    private static final int findExitPoints$lambda$1(CodeFragmentAnalyzer this$0, int offset) {
        Object e = this$0.flow.getInstructions().get(offset);
        Intrinsics.checkNotNull(e, (String)"null cannot be cast to non-null type com.intellij.psi.controlFlow.BranchingInstruction");
        return ((BranchingInstruction)e).offset;
    }

    @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\u0004\u001a\u00020\u00052\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fJ\u0016\u0010\r\u001a\u0004\u0018\u00010\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0007\u00a8\u0006\u0010"}, d2={"Lcom/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer$Companion;", "", "<init>", "()V", "inferNullability", "Lcom/intellij/codeInsight/Nullability;", "expressionGroup", "", "Lcom/intellij/psi/PsiExpression;", "place", "Lcom/intellij/psi/PsiElement;", "probeExpression", "", "createAnalyzer", "Lcom/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer;", "elements", "intellij.java.impl.refactorings"})
    @SourceDebugExtension(value={"SMAP\nCodeFragmentAnalyzer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 CodeFragmentAnalyzer.kt\ncom/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,316:1\n1586#2:317\n1661#2,3:318\n1807#2,3:321\n1786#2,3:324\n1786#2,3:327\n*S KotlinDebug\n*F\n+ 1 CodeFragmentAnalyzer.kt\ncom/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer$Companion\n*L\n259#1:317\n259#1:318,3\n260#1:321,3\n261#1:324,3\n262#1:327,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Nullability inferNullability(@NotNull List<? extends PsiExpression> expressionGroup) {
            Nullability nullability;
            boolean bl;
            HashSet expressionSet;
            block18: {
                boolean bl2;
                boolean $i$f$all;
                Iterable $this$all$iv;
                block17: {
                    boolean bl3;
                    List types;
                    block16: {
                        Iterator $this$mapTo$iv$iv;
                        Intrinsics.checkNotNullParameter(expressionGroup, (String)"expressionGroup");
                        expressionSet = CollectionsKt.toHashSet((Iterable)expressionGroup);
                        if (expressionSet.isEmpty()) {
                            return Nullability.UNKNOWN;
                        }
                        Iterable $this$map$iv = expressionSet;
                        boolean $i$f$map = false;
                        Iterable iterable = $this$map$iv;
                        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                        boolean $i$f$mapTo = false;
                        Iterator iterator = $this$mapTo$iv$iv.iterator();
                        while (iterator.hasNext()) {
                            void expression;
                            Object item$iv$iv = iterator.next();
                            PsiExpression psiExpression = (PsiExpression)item$iv$iv;
                            Collection collection = destination$iv$iv;
                            boolean bl4 = false;
                            collection.add(expression.getType());
                        }
                        types = (List)destination$iv$iv;
                        Iterable $this$any$iv = types;
                        boolean $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl3 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                PsiType type = (PsiType)element$iv;
                                boolean bl5 = false;
                                if (!Intrinsics.areEqual((Object)type, (Object)PsiTypes.nullType())) continue;
                                bl3 = true;
                                break block16;
                            }
                            bl3 = false;
                        }
                    }
                    if (bl3) {
                        return Nullability.NULLABLE;
                    }
                    $this$all$iv = types;
                    $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl2 = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PsiType type = (PsiType)element$iv;
                            boolean bl6 = false;
                            if (type instanceof PsiPrimitiveType) continue;
                            bl2 = false;
                            break block17;
                        }
                        bl2 = true;
                    }
                }
                if (bl2) {
                    return Nullability.NOT_NULL;
                }
                $this$all$iv = expressionSet;
                $i$f$all = false;
                if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                    bl = true;
                } else {
                    for (Object element$iv : $this$all$iv) {
                        PsiExpression expression = (PsiExpression)element$iv;
                        boolean bl7 = false;
                        if (expression instanceof PsiLiteralExpression) continue;
                        bl = false;
                        break block18;
                    }
                    bl = true;
                }
            }
            if (bl) {
                return Nullability.NOT_NULL;
            }
            PsiElement psiElement = ControlFlowUtil.findCodeFragment((PsiElement)((PsiElement)CollectionsKt.first((Iterable)expressionSet)));
            Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"findCodeFragment(...)");
            PsiElement fragmentToAnalyze = psiElement;
            StandardDataFlowRunner dfaRunner = new StandardDataFlowRunner(fragmentToAnalyze.getProject());
            Ref.ObjectRef nullability2 = new Ref.ObjectRef();
            nullability2.element = DfaNullability.NOT_NULL;
            @Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u0000%\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u0000\b\n\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"com/intellij/refactoring/extractMethod/newImpl/CodeFragmentAnalyzer$Companion$inferNullability$Listener", "Lcom/intellij/codeInspection/dataFlow/java/JavaDfaListener;", "<init>", "(Ljava/util/HashSet;Lkotlin/jvm/internal/Ref$ObjectRef;)V", "beforeExpressionPush", "", "value", "Lcom/intellij/codeInspection/dataFlow/value/DfaValue;", "expr", "Lcom/intellij/psi/PsiExpression;", "state", "Lcom/intellij/codeInspection/dataFlow/memory/DfaMemoryState;", "intellij.java.impl.refactorings"})
            public final class Listener
            implements JavaDfaListener {
                final /* synthetic */ HashSet<PsiExpression> $expressionSet;
                final /* synthetic */ Ref.ObjectRef<DfaNullability> $nullability;

                public Listener(HashSet<PsiExpression> $expressionSet, Ref.ObjectRef<DfaNullability> $nullability) {
                    this.$expressionSet = $expressionSet;
                    this.$nullability = $nullability;
                }

                public void beforeExpressionPush(DfaValue value, PsiExpression expr, DfaMemoryState state) {
                    Intrinsics.checkNotNullParameter((Object)value, (String)"value");
                    Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                    Intrinsics.checkNotNullParameter((Object)state, (String)"state");
                    if (this.$expressionSet.contains(expr)) {
                        DfaNullability dfaNullability = DfaNullability.fromDfType((DfType)state.getDfType(value));
                        Intrinsics.checkNotNullExpressionValue((Object)dfaNullability, (String)"fromDfType(...)");
                        DfaNullability expressionNullability = dfaNullability;
                        DfaNullability dfaNullability2 = ((DfaNullability)this.$nullability.element).unite(expressionNullability);
                        Intrinsics.checkNotNullExpressionValue((Object)dfaNullability2, (String)"unite(...)");
                        this.$nullability.element = dfaNullability2;
                    }
                }
            }
            RunnerResult runnerResult = dfaRunner.analyzeMethod(fragmentToAnalyze, (DfaListener)new Listener(expressionSet, (Ref.ObjectRef<DfaNullability>)nullability2));
            Intrinsics.checkNotNullExpressionValue((Object)runnerResult, (String)"analyzeMethod(...)");
            RunnerResult runnerState = runnerResult;
            if (runnerState == RunnerResult.OK) {
                Nullability nullability3 = DfaNullability.toNullability((DfaNullability)((DfaNullability)nullability2.element));
                Intrinsics.checkNotNull((Object)nullability3);
                nullability = nullability3;
            } else {
                nullability = Nullability.UNKNOWN;
            }
            return nullability;
        }

        @NotNull
        public final Nullability inferNullability(@NotNull PsiElement place, @Nullable String probeExpression) {
            PsiCodeBlock psiCodeBlock;
            Intrinsics.checkNotNullParameter((Object)place, (String)"place");
            if (probeExpression == null) {
                return Nullability.UNKNOWN;
            }
            PsiElementFactory factory = PsiElementFactory.getInstance((Project)place.getProject());
            Class[] classArray = new Class[]{PsiClass.class};
            PsiClass psiClass = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)place, (Class[])classArray);
            if (psiClass == null) {
                return Nullability.UNKNOWN;
            }
            PsiClass context = psiClass;
            PsiElement psiElement = context.getContainingFile().copy();
            Intrinsics.checkNotNull((Object)psiElement, (String)"null cannot be cast to non-null type com.intellij.psi.PsiFile");
            PsiFile copyFile = (PsiFile)psiElement;
            PsiElement copyPlace = PsiTreeUtil.findSameElementInCopy((PsiElement)place, (PsiFile)copyFile);
            PsiStatement psiStatement = factory.createStatementFromText("return " + probeExpression + ";", null);
            Intrinsics.checkNotNullExpressionValue((Object)psiStatement, (String)"createStatementFromText(...)");
            PsiStatement probeStatement = psiStatement;
            PsiElement parent = copyPlace.getParent();
            if (parent instanceof PsiCodeBlock) {
                PsiElement psiElement2 = copyPlace.getParent();
                Intrinsics.checkNotNull((Object)psiElement2, (String)"null cannot be cast to non-null type com.intellij.psi.PsiCodeBlock");
                psiCodeBlock = (PsiCodeBlock)psiElement2;
            } else {
                PsiElement psiElement3 = copyPlace.getParent().replace((PsiElement)factory.createCodeBlock());
                Intrinsics.checkNotNull((Object)psiElement3, (String)"null cannot be cast to non-null type com.intellij.psi.PsiCodeBlock");
                PsiCodeBlock block = (PsiCodeBlock)psiElement3;
                block.add(copyPlace);
                psiCodeBlock = block;
            }
            PsiCodeBlock codeBlock = psiCodeBlock;
            PsiElement psiElement4 = codeBlock.add((PsiElement)probeStatement);
            Intrinsics.checkNotNull((Object)psiElement4, (String)"null cannot be cast to non-null type com.intellij.psi.PsiReturnStatement");
            PsiReturnStatement artificialReturn = (PsiReturnStatement)psiElement4;
            PsiExpression psiExpression = artificialReturn.getReturnValue();
            if (psiExpression == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            PsiExpression artificialExpression = psiExpression;
            return this.inferNullability(CollectionsKt.listOf((Object)artificialExpression));
        }

        @Nullable
        public final CodeFragmentAnalyzer createAnalyzer(@NotNull List<? extends PsiElement> elements) {
            CodeFragmentAnalyzer codeFragmentAnalyzer;
            Intrinsics.checkNotNullParameter(elements, (String)"elements");
            try {
                codeFragmentAnalyzer = new CodeFragmentAnalyzer(elements);
            }
            catch (ExtractException e) {
                codeFragmentAnalyzer = null;
            }
            return codeFragmentAnalyzer;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

